
/* CONV1.C
 * converts single characters
 * CONV1 (to) (from) < (inputname) > (outputname)
 */

#include <stdio.h>
#include "mytypes.h"

INT main(INT argc, UCHAR *argv[])
{
  if (argc!=3)
  {
    printf("Character-Conversion in Textfiles              \n"
	   "CONV1 (to) (from)  > (outputname) < (inputname)\n"
	   "to  : new character                            \n"
	   "from: character to be substituted              \n"
	   "outputname: filename to be created             \n"
	   "inputname : file to be converted               \n");
    return 1;
  }

  UCHAR to=argv[1][0];
  UCHAR from=argv[2][0];

  INT key;
  do
  {
    key=getchar();
    if ((key&0xff)==from)
    {
      putchar(to);
    }
    else
      putchar(key);
  }
  while (key!=EOF);
  return 0;
}

/* CONV1.C END */
