{//////////////////////////////////////////////////////////////////////////}
{                                                                          }
{   Dateiname        : ADCDAC  .PAS                                        }
{   Status           : PROGRAM                                             }
{   Zweck            : Dieses Programm dient zum Austesten von ADC und     }
{                      DAC der Messwerterfassungskarte MetraByte DAS-16F.  }                                         }
{                                                                          }
{   Datum            : 20.08.1991                                          }
{   Version          : 1.10                                                }
{   Autor            : Markus Seidl                                        }
{   Letzte Aenderung : 26.08.1991                                          }
{                                                                          }
{   Testumgebung     : Turbo Pascal Compiler 5.5                           }
{                      Kingtech AT-286 12MHz, BIOS : Phoenix               }
{                                                                          }
{   COPYRIGHT        : (c) 1991, Markus Seidl, A-2372 Giesshuebl           }
{                      Alle Rechte vorbehalten.                            }
{                                                                          }
{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

PROGRAM adcdac;              { Name des Programms }

USES                         { benoetigte Units }
     CRT,                    { wg. der Funktionen ReadKey und KeyPressed }
     GRAPH,                  { wg. Darstellung im Grafikmodus }
     DAS16F;                 { wg. Steuerung der ADC-Karte DAS-16F }

{*** DEKLARATIONSBEREICH **************************************************}
CONST                        { Tastaturcodes }
       F1  = #59;
       F2  = #60;
       CR  = #13;
       ESC = #27;

VAR
       GraphDriver,         { Variable enthaelt aktuellen Grafiktreiber }
       GraphMode,           { Variable enthaelt aktuellen Grafikmodus }
       GraphError : INTEGER;

       eingabe    : CHAR;

                            { Variablen zur Steuerung der ADC-Karte DAS-16F}
       basis_adr,           { Basisadr. des DAS-16F Boards (dec. 255-1008) }
       board_num,           { Boardnummer (0-3) }
       inter_level,         { Interrupt-Level (2-7) }
       dma_level,           { DMA-Level (1 oder 3) }
       messeingang,         { A/D-Kanal# (0-7 Differentialeingang) }
       messausgang,         { D/A-Kanal# (0,1) }
       datenwert : INTEGER; { enthaelt ueber ADC einzulesenden bzw. ueber }
                            { DAC auszugebenden Datenwert                 }

{--------------------------------------------------------------------------}

PROCEDURE Logo;
{-gibt den Programmtitel sowie die Hauptmenueleiste im Grafikmodus am      }
{ Bildschirm aus.                                                          }

BEGIN
     ClearDevice;                              { Bildschirm loeschen }

     SetTextStyle(TriplexFont, HorizDir, 7);
     SetTextJustify(CenterText, CenterText);
     SetColor(LightCyan);
     MoveTo(GetMaxX div 2, 40);
     OutText('ADC-DAC-Test');                  { Programmtitel ausgeben }
     SetTextStyle(DefaultFont, HorizDir, 1);
     MoveRel(0, 70);
     OutText('erarbeitet von DI. Othmar Fischer und Markus Seidl');

     SetTextJustify(LeftText, CenterText);     { Hauptmenueleiste ausgeben }
     SetColor(LightGreen);
     MoveTo(0, GetMaxY-10);
     OutText('F1-Konfiguration          ');
     OutText('F2-Starten der Messung          ');
     OutText('ESC-Programm beenden');

END; {* Logo *}

{--------------------------------------------------------------------------}

PROCEDURE Kanalnr_einlesen(VAR kanal : INTEGER;
                               Maxnr : BYTE);
{-liest von der Tastatur eine Kanalnummer im Bereich 0 bis Maxnr ein und   }
{ speichert diese in der Variablen kanal ab.                               }

VAR
     taste,
     maxnrchar   : CHAR;
     kanalstring : STRING;
     err_code    : INTEGER;

BEGIN
     maxnrchar := Chr(Ord('0') + Maxnr);
     SetTextJustify(RightText, CenterText);
     SetColor(Yellow);
     Str(kanal, kanalstring);
     OutText(kanalstring);                      { aktuelle Kanal# ausgeben }

     REPEAT
        taste := ReadKey;
        IF taste IN ['0'..maxnrchar] THEN
        BEGIN                                   { neue Kanal# ausgeben }
           Bar(GetX-20, GetY-10, GetX, GetY+10);
           OutText(taste);
           Val(taste, kanal, err_code);
        END;
     UNTIL taste = CR;            { Einlesen der Kanal# mit RETURN beenden }

END; {* Kanalnr_einlesen *}

{--------------------------------------------------------------------------}

PROCEDURE Konfigurieren;
{- liest Ein- und Ausgangskanalnummer von der Tastatur ein und speichert   }
{  diese in den globalen Variablen messeingang und messausgang ab.         }

BEGIN
     SetFillStyle(SolidFill, Black);
     Bar(0, GetMaxY-20, GetMaxX, GetMaxY);
     SetTextJustify(CenterText, CenterText);
     SetColor(LightGreen);
     MoveTo(GetMaxX div 2, GetMaxY - 10);
     OutText('RETURN - Eingabe bestaetigen');   { Bedienhilfe ausgeben }

     SetTextStyle (TriplexFont, HorizDir, 3);

     SetTextJustify(LeftText, CenterText);
     SetColor(LightGray);
     MoveTo(GetMaxX div 2 - 128, GetMaxY div 2);
     OutText('Eingangskanal [0-7] :  ');
     kanalnr_einlesen(messeingang, 7);          { Eingangskanal# einlesen }

     SetTextJustify(LeftText, CenterText);
     SetColor(LightGray);
     MoveTo(GetMaxX div 2 - 128, GetMaxY div 2 + 40);
     OutText('Ausgangskanal [0-1] :  ');
     kanalnr_einlesen(messausgang, 1);          { Ausgangskanal# einlesen }

     SetTextStyle(DefaultFont, HorizDir, 1);

END; {* Konfigurieren *}

{--------------------------------------------------------------------------}

PROCEDURE Messen;
{-liest in einer Schleife vom Eingangskanal des ADC den Datenwert in die   }
{ Variable datenwert ein und gibt diesen Wert am Ausgangskanal des DAC aus.}

VAR
     taste : CHAR;

BEGIN
     SetFillStyle(SolidFill, Black);
     Bar(0, GetMaxY-20, GetMaxX, GetMaxY);
     SetTextJustify(CenterText, CenterText);
     SetColor(LightGreen);
     MoveTo(GetMaxX div 2, 340);
     OutText('Beliebige Taste - Messung beenden');  { Bedienhilfe ausgeben }

     SetFillStyle(SolidFill, White);
     Bar(150, (GetMaxY div 2)-20, GetMaxX-150, (GetMaxY div 2)+30);
     SetTextJustify(CenterText, CenterText);
     SetTextStyle(TriplexFont, HorizDir, 4);
     SetColor(LightRed);
     MoveTo(GetMaxX div 2, GetMaxY div 2);
     OutText('Messung laeuft');                     { Messanzeige ausgeben }

     REPEAT     { - Messschleife - }

        aimp(board_num, messeingang, datenwert);
        aout(board_num, messausgang, datenwert);

     UNTIL KeyPressed;

     taste := ReadKey;

END; {* Messen *}

{*** Hauptprogramm ********************************************************}

{-initialisiert das Grafikpaket und das DAS-16F Board und verwaltet das    }
{ Hauptmenue.                                                              }

BEGIN
    GraphDriver := Detect;                    { Grafiktreiber auswaehlen }
    InitGraph(GraphDriver, GraphMode, '');    { Grafikpaket initialisieren }
    GraphError := GraphResult;
    IF GraphError <> grOk THEN
    BEGIN
         Writeln('Grafik-Fehler: ', GraphErrorMsg(GraphError));
         Writeln('Programm abgebrochen...');
         Exit;
    END;

    board_num := 1;                         { DAS-16F Board initialisieren }
    inter_level := 7;
    dma_level := 1;
    basis_adr := $0300;
    messeingang := 0;
    messausgang := 0;
    board_init(board_num, basis_adr, inter_level, dma_level);

    Logo;                                   { Programmlogo ausgeben }

    REPEAT    { - Hauptmenue - }

       eingabe := ReadKey;
       IF eingabe = #0 THEN
       BEGIN
          eingabe := ReadKey;
          CASE eingabe OF
             F1 : Konfigurieren;
             F2 : Messen;
          END;
       END;
       IF eingabe IN [F1, F2] THEN
          Logo;

    UNTIL eingabe = ESC;                    { Exit zu DOS mit Esc-Taste }

    CloseGraph;
END.

{*** ADCDAC ***************************************************************}
