//     (C) Copyright Microsoft Corp. 1991.  All rights reserved.
//
//     You have a royalty-free right to use, modify, reproduce and 
//     distribute the Sample Files (and/or any modified version) in 
//     any way you find useful, provided that you agree that 
//     Microsoft has no warranty obligations or liability for any 
//     Sample Application Files which are modified. 


/****************************************************************************

    MODULE    : PLAYWAV.C

    PURPOSE   : Calls into the DLL sndply.  Demonstrates that MCI functions
		can be called from a DLL.

    FUNCTIONS :  About
		 PlayWaveInit
		 PlayWavWinProc
		 WinMain


    COMMENTS  : This program implements playing wavefiles using the DLL
		sndply.

    HISTORY   :

****************************************************************************/

#include "windows.h"
#include "playwav.h"

char szAppName[10];
char szAbout[10];
char szMessage[15];
int MessageLength;


FARPROC lpprocAbout;
HANDLE hLibrary;

WORD wGlobalDeviceID;


static HANDLE hInst;
FARPROC lpprocAbout;

long FAR PASCAL PlayWavWndProc(HWND, unsigned, WORD, LONG);

 /****************************************************************************

    FUNCTION  :  About( HWND, unsigned, WORD, LONG )

    PURPOSE   :  This function processes Dialog Box messages associated with
		 the about dialog box.

    COMMENTS  :


    HISTORY   :

****************************************************************************/


BOOL FAR PASCAL About( hDlg, message, wParam, lParam )
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    if (message == WM_COMMAND) {
        EndDialog( hDlg, TRUE );
        return TRUE;
        }
    else if (message == WM_INITDIALOG)
        return TRUE;
    else return FALSE;
}


void PlayWavPaint( hDC )
HDC hDC;
{
    TextOut( hDC,
             (short)10,
             (short)10,
	     (LPSTR)"laser.wav",
	     (short)9);
}


/* Procedure called when the application is loaded for the first time */

BOOL PlayWavInit( hInstance )
HANDLE hInstance;
{
    PWNDCLASS	pplaywavClass;

    /* Load strings from resource */
    LoadString( hInstance, IDSNAME, (LPSTR)szAppName, 10 );
    LoadString( hInstance, IDSABOUT, (LPSTR)szAbout, 10 );
    MessageLength = LoadString( hInstance, IDSTITLE, (LPSTR)szMessage, 15 );

    pplaywavClass = (PWNDCLASS)LocalAlloc( LPTR, sizeof(WNDCLASS) );

    pplaywavClass->hCursor	  = LoadCursor( NULL, IDC_ARROW );
    pplaywavClass->hIcon	  = LoadIcon( hInstance, MAKEINTRESOURCE(PLAYWAVICON) );
    pplaywavClass->lpszMenuName	= (LPSTR)"TheMenu";
    pplaywavClass->lpszClassName  = (LPSTR)szAppName;
    pplaywavClass->hbrBackground  = (HBRUSH)GetStockObject( WHITE_BRUSH );
    pplaywavClass->hInstance	  = hInstance;
    pplaywavClass->style	  = CS_HREDRAW | CS_VREDRAW;
    pplaywavClass->lpfnWndProc	  = PlayWavWndProc;

    if (!RegisterClass( (LPWNDCLASS)pplaywavClass ) )
        /* Initialization failed.
         * Windows will automatically deallocate all allocated memory.
         */
        return FALSE;

    LocalFree( (HANDLE)pplaywavClass );
    return TRUE;        /* Initialization succeeded */
}


int PASCAL WinMain( hInstance, hPrevInstance, lpszCmdLine, cmdShow )
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{
    MSG   msg;
    HWND  hWnd;
    HMENU hMenu;
    HMENU hMyMenu;

    if (!hPrevInstance) {
        /* Call initialization procedure if this is the first instance */
	if (!PlayWavInit( hInstance ))
            return FALSE;
        }
    else {
        /* Copy data from previous instance */
        GetInstanceData( hPrevInstance, (PSTR)szAppName, 10 );
        GetInstanceData( hPrevInstance, (PSTR)szAbout, 10 );
        GetInstanceData( hPrevInstance, (PSTR)szMessage, 15 );
        GetInstanceData( hPrevInstance, (PSTR)&MessageLength, sizeof(int) );
        }

    hWnd = CreateWindow((LPSTR)szAppName,
                        (LPSTR)szMessage,
                        WS_TILEDWINDOW,
                        0,    /*  x - ignored for tiled windows */
                        0,    /*  y - ignored for tiled windows */
			200,	/* cx - ignored for tiled windows */
			200,	/* cy - ignored for tiled windows */
                        (HWND)NULL,        /* no parent */
                        (HMENU)NULL,       /* use class menu */
                        (HANDLE)hInstance, /* handle to window instance */
                        (LPSTR)NULL        /* no params to pass on */
                        );

    /* Save instance handle for DialogBox */
    hInst = hInstance;

    /* Bind callback function with module instance */
    lpprocAbout = MakeProcInstance( (FARPROC)About, hInstance );

    /* Insert "About..." into system menu */
    hMenu = GetSystemMenu(hWnd, FALSE);
    ChangeMenu(hMenu, 0, NULL, 999, MF_APPEND | MF_SEPARATOR);
    ChangeMenu(hMenu, 0, (LPSTR)szAbout, IDSABOUT, MF_APPEND | MF_STRING);


   /* Grey menu item Close Device since there isn't a device to close. */
   /* Make sure Open Device is enabled.*/

   hMyMenu=GetMenu(hWnd);
   ModifyMenu(hMyMenu, IDM_OPEN_DEVICE, MF_BYCOMMAND | MF_ENABLED,IDM_OPEN_DEVICE,"&Open WaveAudio Device");
   ModifyMenu(hMyMenu, IDM_CLOSE_DEVICE, MF_BYCOMMAND | MF_GRAYED,IDM_CLOSE_DEVICE,"&Close WaveAudio Device");


    /* Make window visible according to the way the app is activated */
    ShowWindow( hWnd, cmdShow );
    UpdateWindow( hWnd );

    /* Polling messages from event queue */
    while (GetMessage((LPMSG)&msg, NULL, 0, 0)) {
        TranslateMessage((LPMSG)&msg);
        DispatchMessage((LPMSG)&msg);
        }

    return (int)msg.wParam;
}

 /****************************************************************************

    FUNCTION  :  PlayWavWndProc( HWND, unsigned, WORD, LONG)

    PURPOSE   :  This is the main PlayWavWnd procedure.  This function
		 calls into the DLL plysnd.

    COMMENTS  :


    HISTORY   :

****************************************************************************/

/* Procedures which make up the window class. */
long FAR PASCAL PlayWavWndProc( hWnd, message, wParam, lParam )
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
    PAINTSTRUCT ps;
    HMENU hMyMenu;

    FARPROC lpfnOpenWaveDevice;
    FARPROC lpfnPlayAndCloseWave;
    FARPROC lpfnCloseWaveDevice;
    FARPROC lpfnOpenPlayCloseWave;
    FARPROC lpfnSndPlaySnd;
    BOOL bReturn;


    switch (message)
    {
    case WM_SYSCOMMAND:
        switch (wParam)
	{

        case IDSABOUT:
            DialogBox( hInst, MAKEINTRESOURCE(ABOUTBOX), hWnd, lpprocAbout );
	    break;

        default:
	    return DefWindowProc( hWnd, message, wParam, lParam );

        }
	break;

    case WM_COMMAND:
	switch(wParam)
	     {
	     case IDM_OPEN_DEVICE:

       /****************************************************************
	When the user selects open device the device is opened through the
	function OpenWaveDevice which is contained in the DLL plysnd.
	The function returns a Device ID which is used to identify the
	WaveAudio driver.  In this example we demonstrate how you can
	speed up MCI by opening the waveaudio device first and then
	using this ID to open individual wave files.  Please see the
	actual function declaration header for complete details.
	****************************************************************/


		 hLibrary = LoadLibrary((LPSTR)"plysnd.dll");

		 if (hLibrary >= 32)
		      {

		       lpfnOpenWaveDevice = GetProcAddress(hLibrary, MAKEINTRESOURCE(2));

		       wGlobalDeviceID = (*lpfnOpenWaveDevice) (hWnd);

		       FreeLibrary(hLibrary);
		      }

		 /* grey menu item first */
		 /* enable second */

		 if (wGlobalDeviceID)
		      {
		       hMyMenu=GetMenu(hWnd);

		       ModifyMenu(hMyMenu, IDM_OPEN_DEVICE, MF_BYCOMMAND | MF_GRAYED,IDM_OPEN_DEVICE,"&Open WaveAudio Device");
		       ModifyMenu(hMyMenu, IDM_CLOSE_DEVICE, MF_BYCOMMAND | MF_ENABLED,IDM_CLOSE_DEVICE,"&Close WaveAudio Device");
		      }

	     break;

	     case IDM_PLAY:

       /****************************************************************
	When the user selects play, the element is opened and played through
	the function PlayAndCloseWave which is contained in the DLL plysnd.
	The function is passed a Device ID which is used to identify the
	global "waveaudio" driver.  In this example we demonstrate how you can
	speed up MCI by opening the waveaudio device first and then
	using this ID to open individual wave files.  Please see the
	actual function declaration header for complete details.
	****************************************************************/

		 hLibrary = LoadLibrary((LPSTR)"plysnd.dll");

		 if (hLibrary >= 32)
		      {

		       lpfnPlayAndCloseWave = GetProcAddress(hLibrary, MAKEINTRESOURCE(3));

			(*lpfnPlayAndCloseWave) (hWnd,wGlobalDeviceID,(LPSTR)"laser.wav");

		       FreeLibrary(hLibrary);
		      }

	     break;

       /****************************************************************
	When the user selects Close, the element is Closed through
	the function CloseWaveDevice which is contained in the DLL plysnd.
	The function is passed a Device ID which is used to identify the
	global "waveaudio" driver.  In this example we demonstrate how you can
	speed up MCI by opening the waveaudio device first and then
	using this ID to open individual wave files.  Please see the
	actual function declaration header for complete details.
	****************************************************************/


	     case IDM_CLOSE_DEVICE:
		MessageBox(NULL,"Close WaveAudio Device","Menu Item",MB_OK);


		hLibrary = LoadLibrary((LPSTR)"plysnd.dll");

		if (hLibrary >= 32)
		     {

		      lpfnCloseWaveDevice = GetProcAddress(hLibrary, MAKEINTRESOURCE(4));

		      bReturn = (*lpfnCloseWaveDevice) (hWnd,wGlobalDeviceID);

		      FreeLibrary(hLibrary);

		       /* grey menu item first */
		       /* enable second */

		      if (bReturn)
			    {
			     hMyMenu=GetMenu(hWnd);

			     ModifyMenu(hMyMenu, IDM_OPEN_DEVICE, MF_BYCOMMAND | MF_ENABLED,IDM_OPEN_DEVICE,"&Open WaveAudio Device");
			     ModifyMenu(hMyMenu, IDM_CLOSE_DEVICE, MF_BYCOMMAND | MF_GRAYED,IDM_CLOSE_DEVICE,"&Close WaveAudio Device");
			    }

		      }

	     break;


	/****************************************************************
	When the user selects Open Device and Play, the element is opened
	through the function OpenPlayCloseWave which is contained in the
	DLL plysnd.  The function is passed the name of a wave file.
	This is different than the previous functions since it never
	specifically opens a global "waveaudio" driver.	In this example
	we demonstrate the speed difference between opening the global driver
	"waveaudio" and opening the element (implicitly opening the global
	"waveuaudio" driver.  If you are playing multiple wavefiles this
	method is much slower than the previous method of opening the global
	device first and then opening the element using that ID value.
	****************************************************************/


	     case IDM_OPEN_DEVICE_PLAY:

		 hLibrary = LoadLibrary((LPSTR)"plysnd.dll");

		 if (hLibrary >= 32)
		      {

		       lpfnOpenPlayCloseWave = GetProcAddress(hLibrary, MAKEINTRESOURCE(5));

		       (*lpfnOpenPlayCloseWave) (hWnd,(LPSTR)"laser.wav");

		       FreeLibrary(hLibrary);
		      }

	     break;


	/****************************************************************
	When the user selects SoundPlaySound, the element is opened
	through the function SndPlaySnd which is contained in the
	DLL plysnd.  The function is passed the name of a wave file and
	calls the MCI function sndPlaySound.  This is the easiest way
	to play a wavefile.  The drawback is that the entire wavefile is
	loaded into memory before it is played.  Therefore the size of
	the wavefile you can play is limited by physical memory.
	****************************************************************/

	     case IDM_SND_PLAY_SND:

		 hLibrary = LoadLibrary((LPSTR)"plysnd.dll");

		 if (hLibrary >= 32)
		      {

		       lpfnSndPlaySnd = GetProcAddress(hLibrary, MAKEINTRESOURCE(6));

		       (*lpfnSndPlaySnd) (hWnd,(LPSTR)"laser.wav");

		       FreeLibrary(hLibrary);
		      }

	     break;

	     case ID_HELP:
		if(!WinHelp(hWnd,"help.hlp",HELP_INDEX,0))
		      MessageBox(GetFocus(),"Help Not Found","ERROR",MB_OK);
		break;

	     }
	 break;



    case WM_DESTROY:
        PostQuitMessage( 0 );
        break;

    case WM_PAINT:
        BeginPaint( hWnd, (LPPAINTSTRUCT)&ps );
	PlayWavPaint( ps.hdc );
        EndPaint( hWnd, (LPPAINTSTRUCT)&ps );
        break;

    default:
        return DefWindowProc( hWnd, message, wParam, lParam );
        break;
    }
    return(0L);
}
