// AD.CPP

#include <dos.h>
#include <ctype.h>
#include <bios.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#ifdef __ZTC__
#include <int.h>
#endif

#include "ad.h"

/*************************/
/* Variablendefinitionen */
/*************************/

INT        AD_chan=0;
INT        DA_chan=0;
KARTE      karte;
RESOLUTION resolution;
ERROR      error;
SWITCH     conversion;
SWITCH     sample;
SWITCH     hysterese;
SWITCH     time_constant;
SWITCH     wait;
METHOD     method;
static CHAR int_status;
volatile BOOL taste=FALSE;

/*********************************/
/* Gerteabhngige Programmteile */
/*********************************/

static const INT adda_non_clr = ADDA_NON+3;
static const INT adda_non_chi = ADDA_NON+4;
static const INT adda_non_clo = ADDA_NON+5;
static const INT adda_non_chn = ADDA_NON+0;
static const INT adda_non_lo  = ADDA_NON+1;
static const INT adda_non_hi  = ADDA_NON+2;
static const INT adda_non_dlo = ADDA_NON+6;
static const INT adda_non_dhi = ADDA_NON+7;

static const INT adda_pcl_ct0 = ADDA_NON+0;
static const INT adda_pcl_ct1 = ADDA_NON+1;
static const INT adda_pcl_ct2 = ADDA_NON+2;
static const INT adda_pcl_ctc = ADDA_NON+3;
static const INT adda_pcl_adl = ADDA_NON+4;
static const INT adda_pcl_adh = ADDA_NON+5;
static const INT adda_pcl_d1l = ADDA_NON+4;
static const INT adda_pcl_d1h = ADDA_NON+5;
static const INT adda_pcl_dil = ADDA_NON+6;
static const INT adda_pcl_dih = ADDA_NON+7;
static const INT adda_pcl_d2l = ADDA_NON+6;
static const INT adda_pcl_d2h = ADDA_NON+7;
static const INT adda_pcl_cli = ADDA_NON+8;
static const INT adda_pcl_chn = ADDA_NON+10;
static const INT adda_pcl_ctl = ADDA_NON+11;
static const INT adda_pcl_adt = ADDA_NON+12;
static const INT adda_pcl_dol = ADDA_NON+13;
static const INT adda_pcl_doh = ADDA_NON+14;

#pragma warn -rvl

INT ad(INT channel)
{
  switch (karte)
  {
  case AD_NONAME:
    outp(adda_non_clr,0); // AD-Wandler lschen
    outp(adda_non_chn,channel); //Kanal anwhlen
    for (INT i=1; i<8; i++) inp(adda_non_clo);
    for (i=1; i<8; i++) inp(adda_non_chi);
    return ((inp(adda_non_hi) & 0x000f) << 8) | 
            inp(adda_non_lo);
  case AD_PCLAB812:
    UINT dh,dl;
    outp(adda_pcl_chn,channel);
    outp(adda_pcl_adt,0);          /* SOFTWARE TRIG      */
    do
    {
      dh=inportb(adda_pcl_adh);    /* READ HIGH BYTE DATA*/
    }
    while (dh>15);
    dl=inportb(adda_pcl_adl);      /* READ LOW BYTE DATA */
    return (dh*256+dl-2048);
  }
}

#pragma warn +rvl

VOID da(INT channel, INT value)
{
  switch (karte)
  {
  case AD_NONAME:
    outp(adda_non_dlo, value & 0x00ff);
    outp(adda_non_dhi, (value & 0x0f00)>>8);
    return;
  case AD_PCLAB812:
    switch (channel % 2)
    {
    case 0:
      outp(adda_pcl_d1l, value & 0x00ff);
      outp(adda_pcl_d1h, (value & 0x0f00)>>8);
      return;
    case 1:
      outp(adda_pcl_d2l, value & 0x00ff);
      outp(adda_pcl_d2h, (value & 0x0f00)>>8);
      return;
    }
  }
}

VOID ad_init(VOID)
{ // aktuellen Interruptstatus merken
  int_status=(CHAR)inp(0x21); 
}

/**********************/
/* Interrupt-Routinen */
/**********************/

#ifdef __BORLANDC__
  VOID interrupt (*isr_key_old)(...);
#endif

VOID ad_interrupt_intercept()
{
    // nur Tastatur kann Ausgabe beenden
#ifdef __ZTC__
    int_intercept(9,isr_key,1000); 
#endif
#ifdef __BORLANDC__
    disable();
    isr_key_old=getvect(9);
    setvect(9,isr_key);
    enable();
#endif
}

VOID ad_interrupt_restore(VOID)
{
  // ab jetzt gelten die normalen Interrupts
  outp(0x21,(INT)int_status); // Interrupts einschalten
#ifdef __ZTC__
  int_restore(9);
#endif
#ifdef __BORLANDC__
  disable();
  setvect(9,isr_key_old);
  enable();
#endif
}

/******************************/
/* Interrupt-Service-Routinen */
/******************************/

#ifdef __ZTC__
  extern "C" INT isr_key(struct INT_DATA *id)
#endif
#ifdef __BORLANDC__
  VOID interrupt isr_key(...)
#endif
  {
    taste=TRUE;            // Jemand hat eine Taste gedrckt
    outp(0x21,int_status); // Standard-Interrupt-Belegung
#ifdef __ZTC__
    int_on();              // Interrupts wieder mglich
    return 0;              // weiter in der Interruptkette
#endif
#ifdef __BORLANDC__
    enable();
    isr_key_old();
#endif
  }

/**********************************/
/* Simulation der Umsetzverfahren */
/**********************************/
// alle Verfahren werden durch Endlosschleifen
// simuliert, die durch einen Tastendruck
// abgebrochen werden knnen.

// ***************************************************
// kalib
// ***************************************************
// bertrgt den Analogwert des Ad-Wandlers
// in den DA-Wandler mit voller Genauigkeit

VOID kalib(VOID)  // KALIBRIEREN
{
  for (;;)
  {
    da(DA_chan,ad(AD_chan));
    if (taste) return;
  }
}

// ***************************************************
// paral    PARALLELVERFAHREN
// ***************************************************
// bernimmt den Mewert vom AD-Wandler und reduziert
// die Auflsung auf einen durch 'resolution'
// vorgegebenen Wert
// 'error' demonstriert verschiedenartiges Fehlerverhalten

VOID paral(VOID)  // PARALLELVERFAHREN
{
  INT maske=0;
  INT i = resolution;
  while (i--) { maske <<= 1; maske++; }
  maske <<= (12-resolution);
  maske |= 0xf000;

  switch (error)
  {
    case ERR_1:
      for(;;)
      {
        da(DA_chan,ad(AD_chan)&maske);
        if (taste) return;
      }
    case ERR1:
      for(;;)
      {
        da(DA_chan,ad(AD_chan)|~maske);
        if (taste) return;
      }
    case ERR12:
      for(;;)
      {
        da(DA_chan,(ad(0)-3+((~maske+1)/2))&maske);
        if (taste) return;
      }
  }
}

// ***************************************************
// zaehl    ZHLVERFAHREN
// ***************************************************
// bernimmt den Mewert vom AD-Wandler und reduziert
// die Auflsung auf einen durch 'resolution'
// vorgegebenen Wert
// 'error' demonstriert verschiedenartiges Fehlerverhalten

VOID zaehl(VOID)  // ZAEHLVERFAHREN
{
  INT i=resolution;
  INT inc=0x0800; while (--i) inc >>= 1; // Zhlintervall
  INT mw;

  for(;;)
  { INT mess=ad(0);
    for (INT zaehl=0; zaehl<mess; zaehl+=inc)
    { if (conversion) da(DA_chan,zaehl);
      if (!sample) mess=ad(0);
      if (taste) return;
    }
    da(DA_chan,zaehl);
    mw=zaehl;
    if (time_constant==0) // konstante Mezeit
    { // Maximale Mezeit abwarten
      for(INT zaehl=mw; zaehl<0x0fff; zaehl+=inc)
      {
        da(DA_chan,mw); // immer dasselbe ausgeben 
        if (!sample) mess=ad(0); // ebenfalls Zeitausgleich
        if (taste) return;
      }
    }
  }
}

// ***************************************************
// nachl    NACHLAUFVERFAHREN
// ***************************************************
// Sonderform des Zhlverfahrens, bei dem statt Abbruch
// des Zhlvorgangs eine Umkehr der Zhlrichtung
// erfolgt. Besonderheit: Schwanken der letzte Stelle
// Option: Hysterese schaltet das Schwanken aus

VOID nachl(VOID)  // NACHLAUFVERFAHREN
{
  INT mess;
  INT inc;
  INT i;
  INT zaehl;

  i=resolution;
  // Zhlintervall
  inc=0x0800; while (i--) inc >>= 1;

  zaehl=0;
  for(;;)
  { 
    da(DA_chan,zaehl); mess=ad(0);
    if (zaehl<mess) 
    {
      zaehl+=inc; 
      if ((hysterese==1) && (zaehl>=mess)) zaehl-=inc;
      if (zaehl>0x0fff) zaehl=0x0fff;
    }
    else
    { 
      zaehl-=inc; 
      if ((hysterese==1) && (zaehl<=mess)) zaehl+=inc;
      if (zaehl<0) zaehl=0;
    }
    if (taste) return;
  }
}

// ***************************************************
// rampe    DUAL-SLOPE-VERFAHREN
// ***************************************************
// Dargestellt wird der Integrationsvorgang am Integrator
// Strspannungen werden deutlich eliminiert. 
// Achtung: Die Welligkeit der Integration ist Frequenz-
// abhngig. Kleinere Frequenz->grerer Fehler

VOID rampe(VOID) // ZWEI-RAMPEN-VERFAHREN
{
  // Schrittzahl fr Aufintegration
  // j=resolution; schritte=1;
  // while (resolution-1) {schritte<<=1; resolution--;}
  INT schritte=256;
  // Schrittweite bei Abintegration
  // inc=0x0800; while (i--) inc >>= 1;
  INT inc=1024;

  for (;;)
  {
    // AUFINTEGRATION
    INT i=schritte; LONG zaehler=0;
    while (i)
    { 
      i--;
      INT mess=ad(0);
      zaehler+=(LONG)mess;
      da(DA_chan,(INT)(zaehler/schritte));
      if (taste) return;
    }
    // ABINTEGRATION
    while (zaehler>0)
    { 
      da(DA_chan,(INT)(zaehler/schritte));
      zaehler -= (LONG)inc;
      if (taste) return;
    }
  }
}

// ***************************************************
// waege    SUKZESSIVE APPROXIMATION
// ***************************************************
// Dargestellt wird die Spannung am Vergleicher, man
// sieht den zweischrittigen Wgevorgang.
// Optionen: Ausschalten des Wgevorgangs, Ausschalten
// des Samplers, Kleine Verzgerung nach der Umsetzung
// Zwecks deutlicherer Darstellung und einfacherer
// Triggerung.
VOID waege(VOID)  // WAEGEVERFAHREN
{
  INT waege=0;
  INT gewicht=0x0800;
  INT mess;

  for(;;)
  { 
    waege=0; gewicht=0x0800;
    if (conversion) da(DA_chan,0); // zuerst 0 ausgeben
    for (INT pos=12; pos>(12-resolution); pos--)
    { // phase 1, Schtzung
      if (sample)
      {
        if (pos==12) mess=ad(0); else ad(0);
      }
      else
        mess=ad(0);
      waege=waege+gewicht;
      if (conversion) da(DA_chan,waege);
      // phase 2, Vergleich
      if (sample) ad(0); else mess=ad(0);
      if (waege>mess) waege=waege-gewicht;
      if (conversion) da(DA_chan,waege);
      gewicht >>= 1;
    }
    if (!conversion) da(DA_chan,waege);
    ad(0); // Zeitausgleich
    if (wait) {ad(0); ad(0); ad(0); ad(0); ad(0); }
    if (taste) return;
  }
}

// AD.C END
