#ifndef __AD_H
#define __AD_H

typedef unsigned long ULONG;
typedef unsigned int  UINT;
typedef unsigned char UCHAR;
typedef long          LONG;
typedef int           INT;
typedef char          CHAR;
typedef float         FLOAT;
typedef double        DOUBLE;
typedef void          VOID;

enum BOOL
{
  FALSE=0,
  TRUE=1
};

enum KARTE { AD_NONAME, AD_PCLAB812 };
#define ADDA_NON 0x278
#define ADDA_PCL 0x220

enum SWITCH     { ON=TRUE, OFF=FALSE };
enum RESOLUTION { BIT2=2,BIT3,BIT4,BIT5,BIT6,BIT7,BIT8 };
enum METHOD     { PARALLEL=1,SUCCESSIVE,COUNT,
                  SERVO,DUALSLOPE,CALIBRATE };
enum ERROR      { ERR1=1, ERR_1=-1, ERR12=0 };

extern INT        AD_chan;
extern INT        DA_chan;
extern RESOLUTION resolution;
extern METHOD     method;
extern ERROR      error;
extern SWITCH     conversion;
extern SWITCH     sample;
extern SWITCH     hysterese;
extern SWITCH     time_constant;
extern SWITCH     wait;
extern volatile
       BOOL       taste;

VOID ad_init(VOID);
VOID ad_interrupt_intercept();
VOID ad_interrupt_restore(VOID);

#ifdef __ZTC__
extern "C" INT isr_key(struct INT_DATA *id);
#endif
#ifdef __BORLANDC__
  VOID interrupt isr_key(...);
#endif

INT  ad(INT channel);
VOID da(INT channel, INT value);
VOID paral(VOID);
VOID zaehl(VOID);
VOID nachl(VOID);
VOID rampe(VOID);
VOID kalib(VOID);
VOID waege(VOID);

#endif // __AD_H