// ADC.CPP

// Testen des AD-Wandler-Simulators 
// mit einem einfachen Menprogramm
#include <mem.h>
#include <dos.h>
#include <bios.h>
#include <ctype.h>
#include <conio.h>
#include <stdio.h>

#include "ad.cpp"

VOID display_ADstatus(VOID);
VOID display_text(CHAR *filename);

VOID main(INT argc)
{
  CHAR c;

  if (argc>1) karte = AD_PCLAB812;
  else karte = AD_NONAME;
  resolution = BIT5;
  error = ERR12;
  conversion = ON;
  sample = ON;
  hysterese = OFF;
  time_constant = ON;
  wait = ON;
  method = CALIBRATE;
  ad_init();

  clrscr();
  gotoxy(1,1);
  display_text("ADC.MNU");

  for (;;)
  {
    gotoxy(1,25);
    display_ADstatus();

    outp(0x21,~0x02); // Tastatur-Interrupt einschalten
    taste=FALSE;      // auf nchsten Tastendruck warten
    ad_interrupt_intercept();
    switch (method)
    {
    case PARALLEL:   paral(); break;
    case SUCCESSIVE: waege(); break;
    case COUNT:      zaehl(); break;
    case SERVO:      nachl(); break;
    case DUALSLOPE:  rampe(); break;
    case CALIBRATE:  kalib(); break;
    }
    ad_interrupt_restore();
    taste=FALSE;
    // aus den vorstehenden Verfahren kann nur
    // durch Tastendruck ausgestiegen werden; 
    // die Taste wird wie folgt ausgewertet:
    outp(0x61,inp(0x61)|0x80);  // Tastatur loeschen
    outp(0x61,inp(0x61)&~0x80);
    c=(CHAR)bioskey(0);
    for (INT i=0; i<0x7fff; i++) {} // pause
    while (bioskey(1)) bioskey(0);

    switch (toupper(c))
    {
      case '9': error=ERR_1; break;
      case '1': error=ERR1; break;
      case '0': error=ERR12; break;
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8': resolution=(RESOLUTION)(c-'0'); break;
      case 'P': method=PARALLEL;break;
      case 'K': method=CALIBRATE;break;
      case 'W': method=SUCCESSIVE;break;
      case 'Z': method=COUNT;break;
      case 'N': method=SERVO;break;
      case 'R': method=DUALSLOPE;break;
      case 'H': hysterese=(SWITCH)(!hysterese);break;
      case 'O': time_constant=(SWITCH)(!time_constant);
                break;
      case 'V': wait=(SWITCH)(!wait); break;
      case 'U': conversion=(SWITCH)(!conversion); break;
      case 'S': sample=(SWITCH)(!sample); break;
      case 27 : return;
    }
  }
}

// ***************************************************
// display_ADstatus
// ***************************************************
// Wertet den aktuellen Zustand der Zustandsparameter
// des ADC-Simulators aus und gibt ihn in Kurzform
// an der aktuellen Bildschirmpostion aus.
VOID display_ADstatus(VOID)
{
  switch (method)
  {
  case PARALLEL:   cprintf("P"); break;
  case CALIBRATE:  cprintf("K"); break;
  case SUCCESSIVE: cprintf("W"); break;
  case COUNT:      cprintf("Z"); break;
  case SERVO:      cprintf("N"); break;
  case DUALSLOPE:  cprintf("R"); break;
  }
  cprintf(" "); cprintf("%i",resolution);
  if (time_constant) cprintf(" O"); else cprintf(" o");
  if (hysterese)     cprintf(" H"); else cprintf(" h");
  if (wait)          cprintf(" V"); else cprintf(" v");
  if (conversion)    cprintf(" U"); else cprintf(" u");
  if (sample)        cprintf(" S"); else cprintf(" s");
  switch (error)
  {
  case ERR1:  cprintf(" +1"); break;
  case ERR_1: cprintf(" -1"); break;
  case ERR12: cprintf(" "); break;
  }

  switch (karte)
  {
  case AD_NONAME:   cprintf(" NONAME 12-Bit"); break;
  case AD_PCLAB812: cprintf(" PCLAB812 12-Bit"); break;
  }
}

// ***************************************************
// display_text
// ***************************************************
// liest ein Datei filename und schreibt sie auf die
// aktuelle Bildposition unter Beibehaltung
// der Spaltenposition fr folgende Zeilen
// Wenn die Datei nicht existiert, 
// wird das Programm verlassen
VOID display_text(CHAR *filename)
{
  #define BUFLEN 5000
  CHAR buffer[BUFLEN];
  memset(buffer,0,BUFLEN);
  FILE *text;
  INT len;
  INT startcol = wherex();

  text = fopen(filename,"r");
  if (text==NULL)
  {
    cprintf("No File\n");
    exit(1);
  }
  fread(buffer,BUFLEN-1,1,text);
  CHAR *tp = &buffer[0];
  INT count = 0;
  while (*tp)
  {
    switch (*tp)
    {
    case 0x0a:
      gotoxy(startcol,wherey()+1);
      break;
    case 0x0d:
      gotoxy(startcol,wherey());
      break;
    case 0x09:
      cprintf("        ");
      break;
    default:
      cprintf("%c",*tp);
    }
    count++;
    tp++;
  }
  fclose(text);
}

// ADC.CPP