/* LAP31RX.CPP */
/* LAP-LINK Parallel-Kabel Empfangsprogramm */
#undef DEBUG
#include <string.h>
#include <io.hpp>
#include "\mylib\source\io.cpp"
#include <iodef.h>
#include <fcntl.h>
#include <io.h>
#include <sys\stat.h>

#define MAXLEN 32000
#define SYNC 0x5
#define NIB_RX(v) (((v)>>3)&0xf)
#define NIB_TX(v) ((v)&0xf)
IOBYTE_IO tx(PC_LPT2,FALSE);      // Daten
IOBYTE_IN rx(PC_LPT2+1,FALSE);
IOBIT_IO ndac(4,PC_LPT2,0,FALSE); // Handshake
IOBIT_IN ndav(7,PC_LPT2+1,FALSE);
UINT len;
CHAR buffer[MAXLEN];
CHAR Dateiname[] = "LAP.BIN";

BOOL check_break()
{ if (kbhit()) return TRUE;
  else return FALSE;
}

BOOL rcve_nibble(UCHAR& received)
{ ndac=1;
  do
  { if (check_break()) return FALSE;
#ifdef DEBUG
    cout << '1';
#endif
  }
  while (ndav()==1);
  received = NIB_RX(rx());
  tx=received;    // zurcksenden
  ndac=0;
  do
  { if (check_break()) return FALSE;
#ifdef DEBUG
    cout << '0';
#endif
  }
  while (ndav()==0);
  ndac=1;
  return TRUE;
}

BOOL rcve_byte(UCHAR& received)
{ UCHAR low,high;
  if (rcve_nibble(low))
  { if (rcve_nibble(high))
    { received=low+high*16;
      return TRUE;
    }
  }
  return FALSE;
}

BOOL rcve_int(UINT& received)
{ UCHAR low,high;
  if (rcve_byte(low))
  { if (rcve_byte(high)) // higher Byte
    { received=low+high*256;
      return TRUE;
    }
  }
  return FALSE;
}

INT main(VOID)
{ cout << "Empfangen ber LAP-LINK-Kabel an LPT2\n";
  cout << "=====================================\n";
  cout << "Tastendruck beendet bertragung" << endl;
  cout << "Synchronisation\n";
  UCHAR sync;
  if (rcve_nibble(sync)==FALSE)
  { cout << "Fehler bei der Synchronisation\n";
    return EXIT_FAILURE;
  }
  if (sync!=SYNC)
  { cout << "Fehler bei der Synchronisation\n";
    return EXIT_FAILURE;
  }
  cout << "Lngenfeld\n";
  if (rcve_int(len)==FALSE)
  { cout << "Fehler beim Lngenbyte\n";
    return EXIT_FAILURE;
  }
  if (len==0)
  { cout << "Lnge 0\n";
    return EXIT_FAILURE;
  }
  cout << "Daten\n";
  for (INT i=0; i<len; i++)
  { if (rcve_byte((UCHAR)buffer[i])==FALSE)
    { cout << "Fehler beim Datenbytenr.: " << i << endl;
      return EXIT_FAILURE;
    }
    cout << i << ' ';
  }
  cout << "bertragung erfolgreich beendet\n";
  cout << "Datei LAP.BIN wird angelegt\n";
  int handle;
  _fmode = O_BINARY;
  handle = creat(Dateiname, S_IWRITE);
  write(handle,buffer,len);
  close(handle);
  return EXIT_SUCCESS;
}
