; LAP-LINK Parallel-Kabel Empfangsprogramm
; entspricht LAP31RX.CPP
CSeg	SEGMENT PARA PUBLIC 'Code'
	ASSUME CS:CSeg,DS:CSeg,ES:CSeg,SS:CSeg
	.8086
SYNC    EQU     5
LPT     EQU     378h       ; oder 3bch, oder 278h

	ORG 100h

lap31rxa:
	CALL rcve_nibble
	CMP AL,SYNC
	MOV DX,OFFSET txt_nosync
	JNZ return

	CALL rcve_int
	OR AX,AX
	MOV DX,OFFSET txt_nolen
	JZ return
	MOV  CX,AX
	PUSH AX            ; length -------1

	; receive_data
	MOV DI,OFFSET buffer
rcve_data_1:
	CALL rcve_byte
	MOV [DI],AL
	INC DI
	LOOP rcve_data_1

	; open file
	MOV CX,0           ; read/write mode
	MOV DX,OFFSET filename
	MOV AH,3ch         ; create file
	INT 21h
	MOV DX,OFFSET txt_create
	JC return

	POP CX             ; length -------1
	PUSH AX            ; handle -------2

	MOV DX,OFFSET buffer
	MOV AH,40h         ; write
	INT 21H
	MOV DX,OFFSET txt_write
	JC return

	POP BX             ; handle -------2
	MOV AH,3eh         ; close
	INT 21h
	MOV DX,OFFSET txt_close
	JC return

	MOV DX,OFFSET txt_dataend
return:
	MOV AH,9
	INT 21H
	MOV AX,4c00h
	INT 21h

; ************************************************
; check_break
; ENTRY    : none
; EXIT     : RETURNS or EXIT to DOS if ESC-KEY
; DESTROYS : none
; ************************************************
check_break:
	PUSH AX
	PUSHF
	MOV AH,1
	INT 16h
	JNZ finish
	POPF
	POP AX
	RET
finish:
	MOV DX,OFFSET txt_break
	JMP return

; ************************************************
; rcve_nibble
; ===========
; ENTRY    : none
; EXIT     : nibble in AL
; DESTROYS : none
; CALLS    : none
; REMARKS  : dac,dav negative logic
; ************************************************
rcve_nibble:
	PUSH DX
	PUSH CX
	MOV DX,LPT
	IN AL,DX
	OR AL,00010000B
	OUT DX,AL        ; dac=0

	INC DX
ni_wait1:                ; wait for dav=1
	IN AL,DX
	AND AL,10000000B
	CALL check_break
	JNZ ni_wait1

	IN AL,DX         ; empfangenes Byte
	MOV CL,3
	SHR AL,CL
	AND AL,0fh
	MOV AH,AL

	DEC DX
	IN AL,DX
	AND AL,11100000B ; dac=1,tx=0
	OR AL,AH
	OUT DX,AL        ; quittieren

	INC DX
ni_wait0:                ;wait for ACK
	IN AL,DX
	AND AL,10000000B
	CALL check_break
	JZ ni_wait0

	DEC DX
	IN AL,DX
	OR AL,00010000B  ; dac=0
	OUT DX,AL

	MOV AL,AH        ; return nibble in al
	POP CX
	POP DX
	RET

; ************************************************
; rcve_byte
; =========
; ENTRY    : none
; EXIT     : byte in AL
; DESTROYS : none
; CALLS    : rcve_nibble
; ************************************************
rcve_byte:
	PUSH BX
	PUSH CX
	CALL rcve_nibble ; low
	PUSH AX
	CALL rcve_nibble ; high
	POP BX
	MOV CL,4
	SHL AL,CL
	OR AL,BL
	POP CX
	POP BX
	RET

; ************************************************
; rcve_int
; ========
; ENTRY    : none
; EXIT     : int in AX
; DESTROYS : none
; CALLS    : rcve_byte
; ************************************************
rcve_int:
	PUSH BX
	call rcve_byte   ; low
	PUSH AX
	call rcve_byte   ; high
	POP BX
	MOV AH,AL
	MOV AL,BL
	POP BX
	RET

txt_nosync  DB "NOSYNC$"
txt_nolen   DB "LEN=0$"
txt_dataend DB "OK$"
txt_break   DB "ESC$"
txt_create  DB "CREATE_ERR$"
txt_write   DB "WRITE_ERR$"
txt_close   DB "CLOSE_ERR$"
filename    DB "LAP.BIN"
buffer  DB  60000 DUP (?)
CSeg	ENDS
	END  lap31rxa

