/* LAP31TX.CPP */
/* LAP-LINK Parallel-Kabel Sendergsprogramm */
#include <string.h>
#include <io.hpp>
#include "\develop\mylib\source\io.cpp"
#include <iodef.h> // PC_LPT1
#include <fcntl.h> // O_BINARY, O_RDONLY
#include <io.h>    // open()

#define MAXLENGTH 32000
#define SYNC 0x5
#define NIB_RX(v) (((v)>>3)&0xf)
#define NIB_TX(v) ((v)&0xf)
IOBYTE_IO tx(PC_LPT1,FALSE);     // Daten
IOBYTE_IN rx(PC_LPT1+1,FALSE);
IOBIT_IO dav(4,PC_LPT1,FALSE,FALSE); // Handshake
IOBIT_IN dac(7,PC_LPT1+1,FALSE);
UINT length;
CHAR buffer[MAXLENGTH] = "Das ist ein Probetext\n";

BOOL check_break()
{ if (kbhit()) return TRUE;
  else return FALSE;
}

INT xmit_nibble(UCHAR to_be_transmitted)
{ do
    if (check_break()) return FALSE;
  while (dac()==1);
  tx = NIB_TX(to_be_transmitted);
  dav=1;
  do
    if (check_break()) return FALSE;
  while (dac()==0);
  UCHAR received = NIB_RX(rx());
  if (received!=to_be_transmitted)
  { cout << "gesendet: " << hex << (int)to_be_transmitted
	 << " empfangen: " << hex << (int)received
	 << endl;
    return FALSE;
  }
  dav=0;
  do
    if (check_break()) return FALSE;
  while (dac()==1);
  return TRUE;
}

BOOL xmit_byte(UCHAR to_be_transmitted)
{ if (xmit_nibble(to_be_transmitted&0xf)) // low
  { if (xmit_nibble(to_be_transmitted>>4)) // high
    { return TRUE;
    }
  }
  return FALSE;
}

BOOL xmit_int(UINT to_be_transmitted)
{ if (xmit_byte(to_be_transmitted&0xff)) // low
  { if (xmit_byte(to_be_transmitted>>8)) // high
    { return TRUE;
    }
  }
  return FALSE;
}

INT main(INT argc,CHAR *argv[])
{ cout << "Senden ber LAP-LINK-Kabel an LPT1\n";
  cout << "==================================\n";
  switch (argc)
  {
  default:
    cout << "zu viele Parameter\n";
    return EXIT_FAILURE;
  case 1:
    cout << "Gesendet werden Testdaten: " << buffer << endl;
    length=strlen(buffer);
    cout << "Dateinamen als Argument bergeben\n";
    break;
  case 2:
    int handle;
    if ((handle = open(argv[1], O_BINARY | O_RDONLY)) == -1)
    { cout << "Fehler beim ffnene\n";
      return EXIT_FAILURE;
    }
    length=read(handle,buffer,MAXLENGTH);
    close(handle);
    cout << "Dateilnge : " << length << endl;
    break;
  }
  cout << "Synchronisation\n";
  if (xmit_nibble(SYNC)==FALSE)
  { cout << "Fehler bei der Synchronisation\n";
    return EXIT_FAILURE;
  }
  cout << "Lngenfeld\n";
  if (xmit_int(length)==FALSE)
  { cout << "Fehler beim Lngenbyte\n";
    return EXIT_FAILURE;
  }
  cout << "Daten\n";
  for (INT i=0; i<length; i++)
  { if (xmit_byte((UCHAR)buffer[i])==FALSE)
    { cout << "Fehler beim Datenbytenr.: " << i << endl;
      return EXIT_FAILURE;
    }
  }
  cout << "bertragung erfolgreich beendet\n";
  return EXIT_SUCCESS;
}
