/* LAP31TXC.C */
/* LAP-LINK Parallel-Kabel Sendergsprogramm */
#include <stdio.h> // printf()
#include <stdlib.h> // EXIT_SUCCESS,
#include <conio.h> // kbhit(), inp(), outp()
#include <string.h>
#include <iodef.h> // PC_LPT3
#include <mytypes.h> // CHAR, INT...
#include <bit.h>   // BITTST,BITCLR,BITSET
#include <fcntl.h> // O_BINARY, O_RDONLY
#include <io.h>    // open()

#define MAXLENGTH 32000
#define SYNC 0x5
#define NIB_RX(v) (((v)>>3)&0xf)
#define NIB_TX(v) ((v)&0xf)

INT tx=PC_LPT2;   /* Daten */
INT rx=PC_LPT2+1;
CHAR dav=4;       /* Handshake */
CHAR dac=7;

UINT length;
CHAR buffer[MAXLENGTH] = "Das ist ein Probetext\n";

BOOL check_break(VOID)
{ if (kbhit()) return TRUE;
  else return FALSE;
}

BOOL xmit_nibble(UCHAR to_be_transmitted)
{
  UCHAR received, transmit;
  do
  { if (check_break()) return FALSE;
    received=inp(rx);
  }
  while (BITTST(received,dac));
  transmit=BITSET(NIB_TX(to_be_transmitted),dav);
  outp(tx,transmit);
  do
  { if (check_break()) return FALSE;
    received=inp(rx);
  }
  while (!BITTST(received,dac));
  received = NIB_RX(inp(rx));
  if (received!=to_be_transmitted)
  { printf("gesendet: %x empfangen: %x\n",
      to_be_transmitted, received);
    return FALSE;
  }
  transmit=BITCLR(NIB_TX(to_be_transmitted),dav);
  outp(tx,transmit);
  do
  { if (check_break()) return FALSE;
    received=inp(rx);
  }
  while (BITTST(received,dac));
  return TRUE;
}

BOOL xmit_byte(UCHAR to_be_transmitted)
{ if (xmit_nibble(to_be_transmitted&0xf)) // low
  { if (xmit_nibble(to_be_transmitted>>4)) // high
    { return TRUE;
    }
  }
  return FALSE;
}

BOOL xmit_int(UINT to_be_transmitted)
{ if (xmit_byte(to_be_transmitted&0xff)) // low
  { if (xmit_byte(to_be_transmitted>>8)) // high
    { return TRUE;
    }
  }
  return FALSE;
}

INT main(INT argc,CHAR *argv[])
{
  INT handle,i;
  printf("Senden ber LAP-LINK-Kabel an LPT2\n");
  printf("==================================\n");
  switch (argc)
  {
  default:
    printf("zu viele Parameter\n");
    return EXIT_FAILURE;
  case 1:
    printf("Gesendet werden Testdaten: %s\n",buffer);
    length=strlen(buffer);
    printf("Dateinamen als Argument bergeben\n");
    break;
  case 2:
    if ((handle = open(argv[1], O_BINARY | O_RDONLY)) == -1)
    { printf("Fehler beim ffnen\n");
      return EXIT_FAILURE;
    }
    length=read(handle,buffer,MAXLENGTH);
    close(handle);
    printf("Dateilnge : %i\n",length);
    break;
  }
  printf("Synchronisation\n");
  if (xmit_nibble(SYNC)==FALSE)
  { printf("Fehler bei der Synchronisation\n");
    return EXIT_FAILURE;
  }
  printf("Lngenfeld\n");
  if (xmit_int(length)==FALSE)
  { printf("Fehler beim Lngenbyte\n");
    return EXIT_FAILURE;
  }
  printf("Daten\n");
  for (i=0; i<length; i++)
  { if (xmit_byte((UCHAR)buffer[i])==FALSE)
    { printf("Fehler beim Datenbytenr.: %i\n",i);
      return EXIT_FAILURE;
    }
  }
  printf("bertragung erfolgreich beendet\n");
  return EXIT_SUCCESS;
}
