; TypeMati.ASM: Setzt Typematic-Rate auf gewnschten Wert
; Die Delayzeit wird auf 0,5 s eingestellt
; Aufruf: TYPEMATI n  , n .. 0 bis F (erzeugt 2,1 bis 30 Wiederholungen/s)
; Dabei ist nur jede zweite der 32 Typematic-Raten einstellbar
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS:CodeSeg,ES:CodeSeg
KBStatP  EQU      64h          ; Keyboard Status-Port
KBDatP   EQU      60h          ; Keyboard Daten-Port
MaxTry   EQU      3            ; Anzahl Fehlversuche
Ack      EQU      0FAh         ; Acknowledge von der Tastatur
SetTypeM EQU      0F3h         ; Set-Typematic-Code fr Tastatur
         ORG      100h
Begin:   JMP      Start
FehlM    DB       10,13,"Aufruf TYPEMATI n (n = 0 .. F)",10,13,"$"
ErrM     DB       10,13,"Typematic-Rate konnte nicht gendert werden",10,13,"$"
Param    DB       0
ZulParam DB       10h,1h,12h,13h,14h,15h,16h,17h,18h,19h,41h,42h,43h,44h,45h,46h
Start:   AND      BYTE PTR DS:82h,0DFh ; Parameter in Grobuchstaben umsetzen
                                       ; Ziffer z.B. "4"=34h wird 14h
         CMP      BYTE PTR DS:80h,0   ; Parameter vorhanden?
         JNE      St1                 ; ja
St0:     LEA      DX,FehlM
         JMP      Ausgeben
St1:     MOV      AL,BYTE PTR DS:82h  ; Parameter holen
         CALL     TestParam    ; auf zulssigenParamter prfen
         CMP      AL,"A"       ; A .. F ?
         JL       St2          ; nein
         ADD      AL,9         ; "A" = 41h wird 4Ah
St2:     OR       AL,0F0h      ; 4Ah wird FAh, "4"=34h wird F4h
         NOT      AL           ; Bits umkehren: FAh wird 05h, F4h wird 0Bh
         SHL      AL,1         ; 05h wird 1Bh, 0Bh wird 16h
         OR       AL,20h       ; Delay-Rate 1/2 s ergnzen: 1Bh wird 3Bh
         MOV      Param,AL
         MOV      AH,SetTypeM  ; Befehlscode fr "Typematic setzen"
         CLI                   ; Interrupts sperren
         CALL     SendKB
         JNE      Error        ; Wenn ZF=0: Error
         MOV      AH,Param     ; Typematic-Rate holen
         CALL     SendKB
         JNE      Error        ; Wenn ZF=0: Error
         JMP      Exit
; *** Routine zum Senden des Inhalts von AH zum Keyboard
SendKB:  MOV      BL,MaxTry    ; Fehlversuche begrenzen
         XOR      CX,CX        ; maximal 65563 Schleifendurchlufe
SKB2:    IN       AL,KBStatP   ; vom Status-Port einlesen
         TEST     AL,2         ; Zeichen im Input-Buffer?
         LOOPNE   SKB2         ; ja: nochmals probieren
         MOV      AL,AH        ; nein: zu sendendes Zeichen nach AL
         OUT      KBDatP,AL    ;       Zeichen ber Datenport ausgeben
SKB3:    IN       AL,KBStatP   ; vom Status-Port einlesen
         TEST     AL,1         ; Antwort im Output-Buffer?
         LOOPE    SKB3         ; nein: nochmals probieren
         IN       AL,KBDatP    ; ja: Antwort vom Datenport holen
         CMP      AL,Ack       ;     Zeichen akzeptiert?
         JE       SKBEnd       ;     ja: Routine verlassen
         DEC      BL           ;     nein: Fehlerzhler dekrementieren
         JNE      SKB2         ; neuer Versuch, wenn noch Fehlversuche frei
         OR       BL,1         ; keine mehr frei, Zero-Flag auf 0 setzen
                               ; zur Fehleranzeige
SKBEnd:  RET
;
Error:   LEA      DX,ErrM
Ausgeben:MOV      AH,9
         INT      21h
Exit:    MOV      AL,20h       ; EOI fr Programmable Interrupt Controller
         MOV      DX,20h       ; Control Port fr PIC 8259A
         OUT      DX,AL        ; PIC fr kommende Interrupts freigeben
         MOV      AH,4Ch       ; Exit
         INT      21h
;
TestParam:
         PUSH     DS
         POP      ES
         LEA      DI,ZulParam
         MOV      CX,16        ; Lnge der Tabelle zulssiger Parameter
         REPNE SCASB           ; durchsuchen
         JNZ      St0          ; Nicht gefunden: Meldung ausgeben
         RET                   ; Parameter zulssig
;
CodeSeg  ENDS
         END      Begin
