;----------------------------------------------------------
;MAKEBOOT.ASM
;Autor: Martin Althaus '92
;
;Richtet auf einer formatierten Diskette einen neuen Boot-
;Sektor ein, der im Listing verndert werden kann.
;----------------------------------------------------------
;
.model small
.stack
.data
;
;----------------------------------------------------------
;Tragen Sie in die Variable LAUFWERK die Nummer des ge-
;wnschten Laufwerks ein:
;
; 0 = Laufwerk A:
; 1 = Laufwerk B:
;
;----------------------------------------------------------
;
laufwerk        equ 0
;
;----------------------------------------------------------
;Datenbereiche fr Programmausfhrung
;----------------------------------------------------------
;
startmeld db 'Ich schreibe einen neuen Boot-Sektor auf die'
          db ' Diskette in Laufwerk '
          db 65+laufwerk
          db ': ',0ah,0dh
          db 'Drcken Sie eine Taste zur Besttigung oder '
          db '[Ctrl C] zum Abbrechen $'
endemeld  db 0dh,0ah,0ah
          db 'Programm erfolgreich abgeschlossen!'
          db 0dh,0ah,0ah,'$'
fehlmeld  db 0dh,0ah,0ah
          db 'Fehler beim Ansprechen des Boot-Sektors!'
          db 0dh,0ah,0ah,'$'
format1   db 0dh,0ah,0ah,'Diskettenformat: $'
format36  db '360 KByte$'
format72  db '720 KByte$'
format12  db '1,2 MByte$'
format14  db '1,44 MByte$'
formatss  db 'Einseitig (160 KByte oder 180 KByte)$'
;
;----------------------------------------------------------
;Puffer fr das Lesen und Schreiben des Boot-Sektors
;----------------------------------------------------------
;
puffer     db 16h dup (?)       ;16 uninteressante Bytes
fatsek     dw ?                 ;Anzahl der FAT-Sektoren
           db 2bh-18h  dup (?)  ;Uninteressant bis 2Bh
laderstart db 200h-2bh dup (?)  ;Platz bis Sektorende
;
;----------------------------------------------------------
;Programmcode
;----------------------------------------------------------
;
.code
start:   mov  ax,@data              ;Datensegment ein-
         mov  ds,ax                 ;richten
         mov  dx,offset startmeld   ;Adresse der Meldung
         mov  ah,09h                ;Meldung ber Int 21h
         int  21h                   ;ausgeben
         mov  ah,0ch
         mov  al,08h                ;ber Funktion 0Ch
         int  21h                   ;auf Taste warten
         xor  al,03h                ;Ist es [Ctrl C]?
         je   abbruch               ;Ja, abbrechen
         mov  dx,0                  ;Nummer des Boot-Sek.
         mov  cx,1                  ;Anzahl der Sektoren: 1
         mov  bx,offset puffer      ;Adresse des Puffers
         mov  al,laufwerk           ;Laufwerknummer
         int  25h                   ;Funktion: Sektor lesen
         pop  bx                    ;Flags vom Stapel
         jc   fehler                ;Fehler beim Lesen
         mov  dx,offset format1     ;Hinweis zum Format
         mov  ah,09h                ;ausgeben
         int  21h
         mov  dx,offset format36    ;Text: 360 KByte
         mov  ax,fatsek             ;Format auslesen
         cmp  ax,2                  ;Ist es 360 KByte?
         je   schreibeformat        ;Ja: ausgeben
         mov  dx,offset format72    ;Text: 720 KByte
         cmp  ax,3                  ;Ist es 720 KByte?
         je   schreibeformat        ;Ja: ausgeben
         mov  dx,offset format12    ;Text: 1,2 MByte
         cmp  ax,7                  ;Ist es 1,2 MByte?
         je   schreibeformat        ;Ja, ausgeben
         mov  dx,offset format14    ;Bleibt nur noch 1,44
         cmp  ax,9                  ;Ja?
         je   schreibeformat        ;Ja, tatschlich
         mov  dx,offset formatss    ;Einseitiges Format
schreibeformat:
         mov  ah,09h                ;Format ber Interrupt
         int  21h                   ;21h ausgeben
         mov  cx,3                  ;Anzahl der Bytes
         mov  si,offset bootsektor  ;Start neuer Boot-Sek.
         mov  di,offset puffer      ;Start alter Boot-Sek.
aenderesprungziel:
         mov  al,cs:[si]            ;Byte lesen
         mov  ds:[di],al            ;und schreiben
         inc  di                    ;neue Adressen
         inc  si                    ;ansprechen
         loop aenderesprungziel     ;fr drei Byte
         mov  cx,laderoutinelaenge  ;Bytes des Laders
         mov  di,offset laderstart  ;Rel. Start des Laders
         mov si,offset startroutine ;auch fr neuen Code
aenderelader:
         mov  al,cs:[si]            ;Byte lesen
         mov  ds:[di],al            ;und schreiben
         inc  di                    ;neue Adressen
         inc  si
         loop aenderelader          ;Fr gesamten Lader
         mov  dx,0                  ;Nummer Boot-Sek.
         mov  al,laufwerk           ;Nummer Laufwerk
         mov  bx,offset puffer      ;Adresse neuer Sek.
         mov  cx,1                  ;Anzahl Sek.
         int  26h                   ;Sektor schreiben
         pop  bx                    ;Flags vom Stapel
         jc   fehler                ;Fehler beim Schreiben
         mov  dx,offset endemeld    ;Beendigunsmeldung
         mov  ah,09h                ;ber Funktion 09h
         int  21h                   ;von Int 21h ausgeben
abbruch: mov  ax,4c00h              ;Programm ber
         int  21h                   ;Int 21h abbrechen
fehler:  mov  dx,offset fehlmeld    ;Fehlermeldung
         mov  ah,09h                ;ber Interrupt 21h
         int  21h                   ;ausgeben
         jmp  abbruch               ;und Programm beenden
;
;----------------------------------------------------------
;Diese Routine wird als neuer Boot-Sektor hinter die Para-
;metertabelle gesetzt
;----------------------------------------------------------
;
bootsektor:
         jmp  short startroutine
         nop
dummy    db 28h dup (?)             ;Tabelle zu Beginn
;
;----------------------------------------------------------
;Hier knnen Sie eine eigene Laderoutine einfgen
;----------------------------------------------------------
;
startroutine:
         cli                        ;Interrupt verhindern
         mov  bx,cs                 ;Stack einrichten
         mov  ss,bx                 ;unterhalb des
         mov  sp,7c00h              ;Programmcodes
         mov  ds,bx                 ;Datensegment init.
         sti                        ;Interrupt erlauben
         mov  si,7c00h+textstart    ;Adresse der Meldung
zeichen: lodsb                      ;Zeichen lesen
         cmp  al,'$'                ;Ende-Markierung?
         je   textfertig            ;Ja, beenden
         mov  bx,7                  ;Nein, Zeichen ber
         mov  ah,0Eh                ;Funktion 0Eh von 
         int  10h                   ;Int 10h ausgeben
         jmp  short zeichen         ;und nchstes Zeichen
textfertig:
         jmp  short textfertig      ;Text komplett
;
;----------------------------------------------------------
;Hier knnen Sie eine Meldung nach Ihrer Wahl einfgen
;----------------------------------------------------------
;
textstart equ $-bootsektor+0
         db   'Dies ist keine Diskette, mit der Sie '
         db   'starten knnen!',0dh,0ah,0ah
         db   'Falls Sie von Ihrem Diskettenlaufwerk aus '
         db   'starten mchten,',0dh,0ah
         db   'mssen Sie eine startfhige Diskette ein'
         db   'legen.',0dh,0ah,0ah
         db   'Falls Sie von der Festplatte aus starten '
         db   'mchten,',0dh,0ah
         db   'mssen Sie die Diskette aus dem Laufwerk '
         db   'herausnehmen.'
         db   0dh,0ah,0ah
         db   'Drcken Sie [Ctrl Alt Del] fr einen '
         db   'neuen Startversuch!$'
;
;----------------------------------------------------------
;Hier endet die Laderoutine
;----------------------------------------------------------
;
laderoutinelaenge equ $-startroutine+0
end      start
