/* pcp04c.c
   Dieses Programm erzeugt zweimal 1999 Zufallszahlen und trgt diese
   Zahlen in ein Feld ein. Das Feld wird einmal mit Hilfe der
   Bibliotheksfunktion qsort, das zweite Mal mit Hilfe einer externen
   Assemblerroutine sortiert.
*/

#include <stdio.h> 
#include <stdlib.h> 

#define getrandom( min, max) ((rand() % (int)((max) - (min))) + (min) + 1) 
#define ASIZE 1000 

extern void qsort_asm(int anzahl, unsigned feld[]); 
       void sort_by_asm(void); 
       void sort_by_c(void); 
unsigned cmpgle( unsigned *arg1, unsigned *arg2); 
unsigned feld[ASIZE]; 

main() 
{ 
   int i; 
   printf("Zufallszahlen werden erzeugt...\n"); 
   for (i=0; i<ASIZE; i++) 
     feld[i] = getrandom(1, ASIZE); 
   sort_by_c(); 
   for (i=0; i<ASIZE; i++) 
     printf("%d  ",feld[i]); 
   printf("Zufallszahlen werden erzeugt...\n"); 
   for (i=0; i<ASIZE; i++) 
     feld[i] = getrandom(1, ASIZE); 
   sort_by_asm(); 
   for (i=0; i<ASIZE; i++) 
     printf("%d  ",feld[i]); 
} 

void sort_by_c(void) 
{ 
    int i; 
    printf("und von der C-Routine sortiert...\n"); 
    qsort((void *) feld, (size_t) ASIZE, sizeof( int), cmpgle); 
} 

void sort_by_asm(void) 
{ 
    int i; 
    printf("und von der Assemblerroutine sortiert...\n"); 
    qsort_asm(ASIZE, feld); 
} 

unsigned cmpgle( unsigned *arg1, unsigned *arg2) 
{ 
    if(*arg1 > *arg2) 
     return 1; 
    else if(*arg1 < *arg2) 
     return -1; 
    else 
     return 0; 
} 

