program ZSATZ;
{----------------------------------------------------------
 Aktivieren von Videomodi und Zeichenstzen

 von Martin Althaus
 ----------------------------------------------------------
}
 uses dos;
var
 cpu:                                 registers;
 zaehler:                             byte;
 ParamModus,ParamZeichensatz:         byte;
 ParamUngueltig,ZeichensatzDefiniert: boolean;
 Param:                               string;
 change:                              integer;

procedure SetzeModus(Modus: byte);
{----------------------------------------------------------
 Setzt einen Videomodus ber das Bios. Die Bios-Nummer des
 Modus wird mit dem Parameter MODUS bergeben.
 ----------------------------------------------------------
}
begin
 cpu.ah:=0;
 cpu.al:=Modus;
 intr($10,cpu);
end;

procedure LadeZeichensatz(Satz: byte);
{----------------------------------------------------------
 Ldt einen Zeichensatz des Bios ber Funktion 11h des
 Interrupt 10h. Die Nummer der gewnschten Unterfunktion
 von Funktion 11h bergeben Sie mit dem Parameter SATZ.
 ----------------------------------------------------------
}
begin
 cpu.ah:=$11;
 cpu.al:=Satz;
 cpu.bl:=0;
 intr($10,cpu);
end;

procedure SchalteEmulation(An: boolean);
{----------------------------------------------------------
 Schaltet das Emulationsbit an der Bios-Speicherstelle
 0040:0087h ein oder aus. Wenn Sie fr den Parameter AN
 den Wert TRUE bergeben, wird das Bit gesetzt, im Fall
 von FALSE wird es gelscht.
 ----------------------------------------------------------
}
var
 Wert: byte;
begin
 Wert:=mem[$40:$87];
 if An
 then
  mem[$40:$87]:=Wert and 254
 else
  mem[$40:$87]:=Wert or 1;
end;

procedure SchreibeErlaeuterung;
{----------------------------------------------------------
 Schreibt eine Erluterung zur Verwendung des
 Programms auf den Bildschirm.
 ----------------------------------------------------------
}
begin
 writeln(#10#13'----------------------------------------------------');
 writeln('Aufruf: ZSATZ <Modus> [<Zeichensatz>]'#13#10);
 writeln('Parameter:'#10#13);
 writeln('  <Modus>        Nummer des Videomodus');
 writeln('  <Zeichensatz>  Nummer der Zeichensatzfunktion'#10#13);
 writeln('Falls keine Zeichensatznummer bergeben wird, ndert');
 writeln('das Programm nichts an der aktuellen Einstellung.');
 writeln('----------------------------------------------------'#10#13);
 ParamUngueltig:=true;
end;

procedure SucheOptionaleParameter;
{----------------------------------------------------------
 Stellt fest, ob der ZEICHENSATZ-Parameter an das
 Programm bergeben wurde und wertet ihn aus.
 ----------------------------------------------------------
}
const
 ZeichensatzNummern = [1,2,4,17,18,20,34,35,36];
begin
 ZeichensatzDefiniert:=false;
 param:=paramstr(2);
 val(Param,ParamZeichensatz,change);
 if (change<>0) or
    not (ParamZeichensatz in ZeichensatzNummern)
 then begin
   writeln('Fehler: Zeichensatznummer ',Param,' ungltig!');
   SchreibeErlaeuterung;
 end
 else ZeichensatzDefiniert:=true;
end;

procedure ParameterAuswerten;
{----------------------------------------------------------
 Wertet den MODUS-Parameter aus.
 ----------------------------------------------------------
}
const
 VideomodusNummern =
 [0,1,2,3,4,5,6,7,13,14,15,16,17,18,19];
begin
 ParamUngueltig:=false;
 if (ParamCount=0) then
 begin
  writeln('Fehler: Keine Parameter definiert!');
  SchreibeErlaeuterung;
 end
 else
 begin
  Param:=paramstr(1);
  if (Param[1]='/') then
  begin
   writeln('Fehler: Kein Modus angegeben!');
   SchreibeErlaeuterung;
  end
  else
  begin
   val(Param,ParamModus,change);
   if (change<>0) or
      not (ParamModus in VideomodusNummern)
   then begin
    writeln('Fehler: Videomodus ',Param,' ungltig!');
    SchreibeErlaeuterung;
   end
   else
    if (paramcount>1) then
     SucheOptionaleParameter;
  end;
 end;
end;

{----------------------------------------------------------
 Hauptprogramm
 ----------------------------------------------------------
}

begin
 writeln(#10#13'ZSATZ 1.0   Autor: Martin Althaus'#13#10);
 ParameterAuswerten;
 if not ParamUngueltig then
 begin
  SetzeModus(ParamModus);
  if ZeichensatzDefiniert then
  begin
   SchalteEmulation(false);
   LadeZeichensatz((ParamZeichensatz));
   SchalteEmulation(true);
  end;
 end;
end.
