program sechs_aus_45;

{Zweck: Allen notorischen Lottospielern einen todsicheren Tip (Har Har Har)}
{	fuer das Spiel 6 aus 45 liefern		}
{Autor: Gunter Hatze				}
{Letzte Aenderung: 29.03.93			}


uses crt,graph,bgi_inc;

type satz=string[3];

var hilf,i,j:byte;
    zahlen:array[1..6] of integer;
    ch:char;
    zahl,GraphMode,OldVideo,GraphDriver,p1,hilf1,dummy:integer;
    aus,abort:boolean;
    help:integer absolute $0040:$0049; 
    BackGrnd,Y1,XMax,YMax,XMax_halbe,YMax_halbe,Jahr,Monat,Tag,Wochentag:word;
    view1:ViewPortType;
    LineInfo:LineSettingsType;


{ Die folgenden 4 Prozeduren sind durch binobj.exe in Objekt-Dateien um-}
{ gewandelte Font-Treiber. Sie werden direkt in das Programm eingebunden.}
{ Dadurch ist es nicht notwendig, die Treiber separat mit dem Hauptprogramm}
{ mitzuliefern}


procedure gothic_satz;external;  	
{$l gothic}

procedure little_satz;external;
{$l little}

procedure sans_satz;external;
{$l sans}

procedure triplex_satz;external;
{$l triplex}



{	--------------------  PROCEDURE INIT  ------------------}

{			* Initialisiert die Graphik *		}	


procedure init;

begin
  bgi_init;  		{Eine selbst kreierte UNIT, welche die drei durch}
  			{binobj.exe in Objekt-Dateien umgewandelte Graphik-}
                        {treiber herc.bgi, cga.bgi und egavga.bgi in das}
                        {Programm einbindet. Dies musste in einer separaten}
                        {Unit geschehen, da das Hauptprogramm sonst die}
                        {64kB - Grenze gesprengt haette}
  GraphDriver:=detect;
  InitGraph (GraphDriver,GraphMode,' ');
  SetGraphMode (GraphMode);
  XMax:=GetMaxX;  		{Pixelanzahl des Graphikmodus in X-Richtung}
  XMax_halbe:=trunc(XMax/2);
  YMax:=GetMaxY;                {Pixelanzahl des Graphikmodus in Y-Richtung}
  YMax_halbe:=trunc(YMax/2);
  BackGrnd:=0;			{= black}
  SetBkColor(BackGrnd);
  if GraphDriver = 7 then       {7 = Hercules-Modus}
    begin     
      OldVideo:=help;	{Alten Display-Modus sichern}
      help:=6; 		{Nur mittels diesen Modus ist es moeglich, dass die}
    end;     		{Graphik bei einer Hercules-Karte richtig dargestellt}
                        {wird}
end;



{	--------------------  PROCEDURE LOGO1  ------------------}

{	* Gibt das Logo '6 aus 45' in einer 'wachsenden' Weise aus *   }	

procedure logo1;

procedure grow(x,y:integer;ausgabe:satz);

var i,Xa,Ya:integer;
    
begin
  Xa:=x;
  Ya:=y;
  SetTextStyle(4,0,1); 		{Font=Gothic, Direction=horiz., Size=1}
  for i:=1 to 10 do
    begin
      SetTextStyle(4,0,i); 	{Font=Gothic, Direction=horiz., Size=i}
      MoveTo(Xa,Ya);
      SetColor(yellow);
      OutText(ausgabe);
      delay(10);                {Etwa 0.01 Sekunden Pause}
      MoveTo(Xa,Ya);
      SetColor(BackGrnd); 
      OutText(ausgabe);		
    end;
    MoveTo(Xa,Ya);              {In der For-Schleife wird zuerst gezeichnet,}
    SetColor(yellow);           {dann geloescht --> letzter Durchgang wird}
    OutText(ausgabe);           {auch geloescht --> noch einmal zeichnen}
    delay(300);
end;


var X1,Y1,Y2,Y3,hilf1,hilf2:word;

begin
  X1:=XMax_halbe;
  hilf1:=YMax - 100;	{Von oben bzw. unten jeweils 50 Pixel abziehen}
  hilf2:=trunc(hilf1/3);
  Y1:=40;
  Y2:=Y1 + hilf2 + 10;
  Y3:=Y2 + hilf2 + 40;
  SetTextJustify(1,1);	{Gibt Text vertikal und horizontal zentriert aus}
  grow(X1,Y1,'6');
  grow(X1,Y2,'aus');
  grow(X1,Y3,'45');
  delay(2000);
end;



{	--------------------  PROCEDURE LOGO2  ------------------}

{			* Copyright - Meldung ausgeben *	 }	

procedure logo2;

const right:string[26]='COPYRIGHT (C) P.L.G / 1993';

var X1,Y1:word;

begin
  X1:=XMax_halbe;
  Y1:=YMax_halbe;
  ClearViewPort;
  SetTextJustify(1,0);	
  SetTextStyle(1,0,5); 	{Font=Triplex, Direction=horiz., Size=5}
  SetColor(magenta);
  MoveTo(X1,Y1);
  OutText(right);		
  delay(2000);
end;


{	--------------------  PROCEDURE LOGO3  ------------------}

{	* Das Logo '6 aus 45' oben am Bildschirm ausgeben *	 }	

procedure logo3;

const satz1:string[8]='6 aus 45';

var X1:word;

begin
  SetColor(yellow);
  ClearViewPort;
  X1:=XMax_halbe;
  SetTextStyle(4,0,8); 	{Font=Gothik, Direction=horiz., Size=8}
  MoveTo(X1,70);
  OutText(satz1);
end;		


{	--------------------  PROCEDURE DICE1  ------------------}

{			* Zeichnet den linken Wuerfel *          }	

procedure dice1(x1,y1,x2,y2:integer;tiefe:word;spitze:boolean);

begin
  SetFillStyle(SolidFill,BackGrnd);     {Flaechen werden also mit der}
  SetColor(red);                        {Hintergrundfarbe gefuellt --> leer!}
  Bar3D(x1,y1,x2,y2,tiefe,spitze);      
  SetColor(yellow);
  SetFillStyle(SolidFill,red);	

{ Nun werden die Punkte im Wuerfel gezeichnet:}

  FillEllipse(x1+12,y1+13,5,5);         {Mittelpunkt x,y. Achsen a,b}
  FillEllipse(x1+38,y1+13,5,5);
  FillEllipse(x1+12,y1+37,5,5);
  FillEllipse(x1+38,y1+37,5,5);
  FillEllipse(x1+30,y1-13,6,3);     	{2.a}
  FillEllipse(x1+45,y1-5,6,3);          {2.b}
  FillEllipse(x1+63,y1+16,4,6);         {1}
end;


{	--------------------  PROCEDURE DICE2  ------------------}

{			* Zeichnet den rechten Wuerfel *  	 }	

procedure dice2(x1,y1,x2,y2:integer;tiefe:word;spitze:boolean);

begin
  SetFillStyle(SolidFill,BackGrnd);	{Flaechen werden also mit der}
  SetColor(red);                        {Hintergrundfarbe gefuellt --> leer!}
  Bar3D(x1,y1,x2,y2,tiefe,spitze);      
  SetColor(yellow);
  SetFillStyle(SolidFill,red);	
  FillEllipse(x1+10,y1+10,5,5);         {Mittelpunkt x,y. Achsen a,b}
  FillEllipse(x1+40,y1+10,5,5);
  FillEllipse(x1+25,y1+25,5,5);
  FillEllipse(x1+10,y1+40,5,5);
  FillEllipse(x1+40,y1+40,5,5);
  FillEllipse(x1+35,y1-7,6,3);  	{1}
  FillEllipse(x1+64,y1,4,6);            {3,oben}
  FillEllipse(x1+57,y1+34,4,6);         {3,unten}
  FillEllipse(x1+60,y1+16,4,6);         {3,mitte}
end;


{	--------------------  PROCEDURE FERTIG  ------------------}

{			* Deinstalliert die Graphik *   	  }	

procedure fertig;

begin
  if GraphDriver = 7 then
    help:=OldVideo;
  RestoreCrtMode;
  CloseGraph
end;


{	--------------------  PROCEDURE ZAHL_GEN  ------------------}

{			* Generiert Zufallszahlen *		    }	

procedure zahl_gen(var x:integer);

const max=46;

begin
  randomize;
  repeat
    x:=random(max)
  until x >0;
end;


{	--------------------  PROCEDURE UNRAVEL  ------------------}

{	* Gibt eine generierte Zufallszahl 'wachsend' aus *	   }

procedure unravel(x:integer);

var div_x,div_y,help:word;
    X1,Y1,hilf1,hilf2,TextMitte,zahl,laenge:integer;
    satz:string[2];
    view:ViewPortType;


begin
  zahl:=x;
  satz:='  ';

{ Umwandlung der Zahl in einen ASCII-Code:}

  if zahl<10 then
    satz:=chr(zahl+48)	{Wegen ASCII-Tabelle muss zur Zahl jeweils 48 }
    			{addiert werden}
  else
    begin
      hilf1:=trunc(zahl/10);    {Zehner-Stelle an die Einer-Stelle bringen}
      satz[1]:=chr(hilf1+48);
      hilf2:=hilf1*10;
      hilf1:=zahl-hilf2;	{Dadurch wird die Einerstelle errechnet}
      satz[2]:=chr(hilf1+48);
    end;
  X1:=XMax_halbe;
  Y1:=trunc(YMax_halbe-(1/12 * YMax));
  SetTextStyle(1,0,9); 	{Font=Triplex, Direction=horiz., Size=9}
  SetTextJustify(1,1);	{Gibt Text vertikal und horizontal zentriert aus}
  div_x:=30;
  div_y:=30;
  SetUserCharSize(3,div_x,3,div_y);
  GetViewSettings(view);
  SetViewPort(X1-70,Y1-50,X1+70,Y1+50,true);
  ClearViewPort;
  SetViewPort(view.x1,view.y1,view.x2,view.y2,view.clip);
  repeat
    SetColor(yellow);
    OutTextXY(X1,Y1,satz);
    SetColor(BackGrnd);
    OutTextXY(X1,Y1,satz);
    dec(div_x,1);
    dec(div_y,1);
    SetUserCharSize(3,div_x,3,div_y)
  until div_x=0;
  SetColor(yellow);
  OutTextXY(X1,Y1,satz);
  SetTextStyle(1,0,2); 	{Font=Triplex, Direction=horiz., Size=2}
  SetTextJustify(1,0);
  OutTextXY(p1,trunc(YMax-(YMax*0.2)),satz);	{P1 wird benutzt, um die}
  				{6 generierten Zahlen in einer Reihe unter}
{ dem Schriftzug 'Deine Glueckszahlen' in einer Reihe auszugeben. Dazu wird}
{ zur X-Position der zuletzt ausgegeben Zahl 60 addiert --> X-Position fuer}
{ neue Zahl}

  inc(p1,60);
end;


{	--------------------  MAIN ROUTINE  ------------------}

const  satz1:string[20]='Deine Glckszahlen: ';
       satz2:string[58]='Drcke die SPACE - Taste fr die nchste Zahl, ESC um das';
       satz5:string[22]='Programm zu verlassen';
       satz3:string[44]='Willst Du noch einmal Dein Glck versuchen?';
       satz4:string[49]='(SPACE = Ja, alle anderen Tasten = Programmende)';

begin

{ Die naechsten vier Anweisungen werden benoetigt, um die Adressen der }
{ in das Hauptprogramm einzubindenden Font-Objektdateien zu erhalten}

  dummy:=registerbgifont(@gothic_satz);
  dummy:=registerbgifont(@little_satz);
  dummy:=registerbgifont(@sans_satz);
  dummy:=registerbgifont(@triplex_satz);
  init;
  logo1; 
  logo2;
  logo3;
  GetLineSettings(LineInfo);
  SetLineStyle(LineInfo.LineStyle,LineInfo.pattern,2);
  dice1(40,70,90,120,25,true); 	        {Linke obere Ecke,}
  					{untere rechte Ecke,}
  			{Tiefe,oberstes Rechteck wird gezeichnet}
  dice2(XMax_halbe+200,20,XMax_halbe+250,70,20,true);
  SetLineStyle(LineInfo.LineStyle,LineInfo.Pattern,LineInfo.Thickness);
  repeat
    abort:=false;		{Abort=true --> Programmende}
    i:=1;
    p1:=XMax_halbe-155;
    GetViewSettings(view1);                                     
    SetViewPort(0,YMax_halbe-50,XMax,YMax,true); 	{Den Bereich des}
    							{Graphik-Fensters}
{   unterhalb der Wuerfel bzw. des Schriftzuges '6 aus 45' loeschen}

    ClearViewPort;                                              
    SetViewPort(view1.x1,view1.y1,view1.x2,view1.y2,view1.clip);
    SetTextStyle(1,0,4); 	{Font=Triplex, Direction=horiz., Size=4}
    SetTextJustify(1,0);
    SetColor(green);
    OutTextXY(XMax_halbe,trunc(YMax-(YMax*0.3)),satz1);  
    SetTextJustify(0,0);
    SetTextStyle(2,0,6); 	{Font=SmallFont, Direction=horiz., Size=6}
    OutTextXY(20,YMax-35,satz2);
    OutTextXY(20,YMax-15,satz5);
    while i<7  do
      begin
        ch:=readkey;
        hilf:=ord(ch);
        if hilf=27 then     	{Wenn ESC gedrueckt}
          begin
            fertig;
            clrscr;
            exit
          end;
        if hilf=32 then		{Wenn SPACE gedrueckt}
        begin
          repeat
            aus:=true;
            zahl_gen(zahl);
            for j:=1 to (i-1) do        	{Ueberpruefen, ob diese}
              begin                             {Zahl scon einmal generiert}
                if zahlen[j]=zahl then          {wurde. Wenn ja, dann solange}
                  begin                         {wiederholen, bis generierte}
                    aus:=false;                 {Zahl neu ist}
                  end
              end
          until aus=true;
        zahlen[i]:=zahl;
        unravel(zahl);
        inc(i,1);
      end;
    end;
    delay(300);
    GetViewSettings(view1);
    Y1:=trunc(YMax_halbe-(1/12 * YMax));
    SetViewPort(XMax_halbe-70,Y1-50,XMax_halbe+70,Y1+50,true);
    ClearViewPort;
    SetViewPort(0,YMax_halbe-50,XMax,YMax_halbe+20,true);
    ClearViewPort;
    SetViewPort(view1.x1,view1.y1,view1.x2,view1.y2,view1.clip);
    SetTextStyle(1,0,3); 	{Font=Triplex, Direction=horiz., Size=3}
    SetTextJustify(0,0);
    OutTextXY(80,YMax_halbe-10,satz3);
    SetTextStyle(2,0,6); 	{Font=SmallFont, Direction=horiz., Size=6}
    OutTextXY(80,YMax_halbe+10,satz4);
    ch:=readkey;
    hilf1:=ord(ch);
    if hilf1<>32 then abort:=true        {32 = SPACE}
  until abort=true;			{Ende der Repeat-Schleife}
  fertig;
end.