PROGRAM Adressverwaltung;
(*Copyright by WATer Inc. 1992*)

USES
    Crt,Graph,Printer,Dos,BGIDriv,BGIFont;

CONST
     NAGr=1000;  {Nummernarraygre, begrenzt Datensatzanzahl}
     ANRtyp:ARRAY [0..7] OF STRING[14]=('              ','Herrn         ',
      'Frau          ','Familie       ','Herrn und Frau','Frulein      ',
      'Schwester     ','Firma         ');

     LNDtyp:ARRAY [0..13] OF STRING[24]=(
     '                        ','STERREICH - AUSTRIA    ',
     'DEUTSCHLAND - GERMANY   ','MAGYARORSZAG - HUNGARY  ',
     'CSFR                    ','FRANCE                  ',
     'ITALIA - ITALY          ','CHILE                   ',  {Landessprache?}
     'ARGENTINIA              ','BRAZIL                  ',
     'JAPAN                   ','SCHWEIZ - SWITZERLAND   ',
     'REPUBLIC OF SOUTH AFRICA','HRVATSKA - CROATIA      ');
     {KNZtyp:Landeskennzeichen vorsehen!}

     Hilfetyp:ARRAY [1..16] OF STRING[70]=
      ('Sie befinden sich hier im Hauptmen des Adreverwaltungsprogrammes',
       'von WATer, Copyright 1992.',
       '',
       'Durch Drcken der Funktionstasten knnen Sie die im Hauptmen ange-',
       'fhrten Untermens auswhlen.',
       '',
       'Es folgt eine Kurzbeschreibung der einzelnen Untermens:',
       '',
       '   Hilfe:      liefert diesen Bildschirm',
       '   Speichern:  Speichert die Adressen, aktualisiert die Nummern',
       '   ffnen:     ffnet (ldt) eine beliebige Datenbank von Diskette',
       '   Lschen:    Lscht eine beliebige Datenbank vom Datentrger',
       '   Bearbeiten: Erlaubt Bearbeitung, Neuerstellung und Lschen',
       '               von Datenstzen sowie Suchen nach Adressen',
       '   Listen:     Gibt seitenweise eine Liste aller Adressen aus',
       '   Drucken:    Druckt Adressen der Datenbank auf Adreaufkleber');
     Grenze:ARRAY [0..12] OF BYTE=(1,15,30,30,30,30,6,40,3,20,57,57,1);

TYPE
    DAT=RECORD
          DSN:INTEGER;
          ANR:SHORTINT;
          TIT:ARRAY [1..15] OF CHAR;
          VON:ARRAY [1..30] OF CHAR;
          NAN:ARRAY [1..30] OF CHAR;
          CO :ARRAY [1..30] OF CHAR;
          STR:ARRAY [1..30] OF CHAR;
          PLZ:ARRAY [1..6] OF CHAR;
          ORT:ARRAY [1..40] OF CHAR;
          LN1:ARRAY [1..3] OF CHAR;
          LND:INTEGER;
          TEL:ARRAY [1..20] OF CHAR;
          HOB:ARRAY [1..57] OF CHAR;
          INF:ARRAY [1..57] OF CHAR;
          AKT:BOOLEAN;
        END;
    Nummernarraytyp=ARRAY [1..NAGr] OF INTEGER;
    Richtungstyp=(hinauf,hinunter);
    Laengetyp=ARRAY [0..12] OF BYTE;

VAR
   Datensatz,Such:DAT;
   Geaendert,Geoeffnet,LetzteZeile,gefunden,ImSuch,ImSpeich:BOOLEAN;
   InsertModus:BOOLEAN;
   Datenbank:FILE OF DAT;
   NA:Nummernarraytyp;
   DBN,DBN2:STRING[14];
   X,CH:CHAR;
   Anzahl,a,Zeile,Feldnr,Zeichennr,Nummer,PosFile:INTEGER;
   Richtung:Richtungstyp;
   Laenge:Laengetyp;

{$I Rahmen.PRO}

PROCEDURE Formular;
(*Copyright by Titus 1992*)
  PROCEDURE Funktionstastenausgabe;
  (*Copyright by Titus 1992*)
    BEGIN
      TEXTCOLOR(9);
      GOTOXY(1,25);
      WRITE('F1 Hilfe');
      GOTOXY(10,25);
      WRITE('F2 Speichern');
      GOTOXY(23,25);
      WRITE('F3 Neu');
      GOTOXY(30,25);
      WRITE('F4 Lschen');
      GOTOXY(41,25);
      WRITE('F5 Suchen');
      GOTOXY(51,25);
      WRITE('F6 Bearbeiten');
      GOTOXY(68,25);
      WRITE('ESC Abrechen');
      GOTOXY(7,6);
      TEXTCOLOR(7);
    END;

{$I Formular.PRO}

PROCEDURE Hilfe(x1,y1,x2,y2,von,bis:INTEGER);
(*Copyright by Wobe Inc. 1992*)
  BEGIN
    WINDOW(x1,y1,x2,y2);
    CLRSCR;
    FOR a:=von TO bis DO
      IF Hilfetyp[a]<>'' THEN
        WRITELN(Hilfetyp[a])
      ELSE
        WRITELN;
    GOTOXY(ROUND((x2-x1)/2)-14,y2-y1+1);
    WRITE('Weiter mit bliebiger Taste...');
    REPEAT UNTIL KeyPressed;
  END;

PROCEDURE DBNEingabe;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Beginn:BYTE;

  BEGIN
    Zeichennr:=1;
    DBN:='';
    IF ImSpeich=True THEN
      Beginn:=56
    ELSE
      Beginn:=62;
    GOTOXY(Beginn+1,1);
    REPEAT
      CH:=ReadKey;
      IF (CH<>#27) AND (CH<>#13) AND (CH<>#8) AND (Zeichennr<12) THEN
        BEGIN
          INSERT(CH,DBN,Zeichennr);
          GOTOXY(Beginn+Zeichennr,1);
          WRITE(CH);
          INC(Zeichennr);
        END;
      IF (CH=#8) AND (Zeichennr>1) THEN
        BEGIN
          GOTOXY(WhereX-1,WhereY);
          WRITE(' ');
          GOTOXY(WhereX-1,WhereY);
          DELETE(DBN,Zeichennr-1,1);
          DEC(Zeichennr);
        END;
      IF Zeichennr=12 THEN
        WRITE(#7);
    UNTIL (CH=#13) OR (CH=#27);
    IF CH=#27 THEN
      DBN:=#27;
  END;

PROCEDURE DatenbankSpeichern;
(*Copyright by Wobe Inc. 1992*)
  VAR
     b:INTEGER;
     a:LONGINT;
     Hilfsrecord:DAT;
     DateiVorhanden,Ueberschreiben:BOOLEAN;
     DirInfo:SearchRec;
     xpos,ypos:BYTE;

  PROCEDURE Exist;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      DateiVorhanden:=True;
      ASSIGN(Datenbank,DBN);
      FindFirst(DBN,Archive,DirInfo);    {Feststellen, ob Datei}
      IF DosError=18 THEN                {vorhanden, 18 heit:}
        DateiVorhanden:=False;           {No more Files vorhanden}
    END;

  BEGIN
    xpos:=WhereX;
    ypos:=WhereY;
    WINDOW(3,22,76,22);
    CLRSCR;
    DBN2:=DBN;
    ImSpeich:=True;
    REPEAT
      GOTOXY(10,1);
      WRITE('Geben Sie bitte den gewnschten Dateinamen ein:',' ':13);
      DBNEingabe;
    UNTIL DBN<>'';
    IF DBN<>#27 THEN
      BEGIN
        DBN:=DBN+'.adr';
        REPEAT
          Ueberschreiben:=True;
          Exist;
          IF DateiVorhanden=True THEN
            BEGIN
              CLRSCR;
              GOTOXY(14,1);
              WRITE('Datei ist bereits vorhanden. berschreiben(j/n)?');
              GOTOXY(62,1);
              IF UPCASE(ReadKey)='N' THEN
                BEGIN
                  Ueberschreiben:=False;
                  CLRSCR;
                  REPEAT
                    GOTOXY(12,1);
                    WRITE('Geben Sie bitte einen anderen Dateinamen ein:    ',' ':9);
                    DBNEingabe;
                  UNTIL DBN<>'';
                  IF DBN<>#27 THEN
                    BEGIN
                      DBN:=DBN+'.adr';
                      Exist;     {DateiVorhanden setzen, um Probleme}
                    END          {mit 'Fehler beim Erstellen' zu vermeiden}
                  ELSE
                    Ueberschreiben:=TRUE;   {um rauszukommen}
                END;
            END;
        UNTIL Ueberschreiben=True;
        IF DBN<>#27 THEN
          BEGIN
            IF DateiVorhanden=True THEN
              BEGIN
                {$I-}
                RESET(Datenbank);
                CLOSE(Datenbank);
                {$I+}
              END
            ELSE
              BEGIN
                {$I-}
                REWRITE(Datenbank);
                CLOSE(Datenbank);
                {$I+}
              END;
            IF IOResult<>0 THEN
              BEGIN
                CLRSCR;
                GOTOXY(18,1);
                WRITE('Fehler beim Erstellen der Datenbank "',DBN,'"!');
                SOUND(440);
                DELAY(1000);
                NOSOUND;
                DBN:=DBN2;
              END
            ELSE
              BEGIN
                CLRSCR;
                GOTOXY(24,1);
                WRITE('Speichern von "',DBN,'" luft...');
                RESET(Datenbank);
                b:=FileSize(Datenbank);
                a:=0;
                WHILE a<b DO
                  BEGIN
                    SEEK(Datenbank,a);
                    READ(Datenbank,Datensatz);
                    Hilfsrecord.DSN:=Datensatz.DSN;
                    IF Hilfsrecord.DSN=0 THEN
                      BEGIN
                        SEEK(Datenbank,FileSize(Datenbank)-1);
                        READ(Datenbank,Hilfsrecord);
                        SEEK(Datenbank,a);
                        WRITE(Datenbank,Hilfsrecord);
                        SEEK(Datenbank,FileSize(Datenbank)-1);
                        TRUNCATE(Datenbank);
                        DEC(b);
                      END;
                    INC(a);
                  END;
                b:=FileSize(Datenbank)-1;
                FOR a:=0 TO b DO    {Umnummerierung, sonst gleiche Nummern}
                  BEGIN
                    SEEK(Datenbank,a);
                    READ(Datenbank,Datensatz);
                    Datensatz.DSN:=a+1;
                    SEEK(Datenbank,a);
                    WRITE(Datenbank,Datensatz);
                  END;
                CLOSE(Datenbank);
                CLRSCR;
                GOTOXY(16,1);
                WRITE('Speichern von ',DBN,' erfolgreich abgeschlossen');
                Geaendert:=False;
                DELAY(1000);
              END;
          END
        ELSE
          DBN:=DBN2;
      END
    ELSE
      DBN:=DBN2;
    CLRSCR;
    ImSpeich:=False;
  END;

PROCEDURE DatenbankOeffnen;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Bestaetigung:CHAR;
     a:INTEGER;

  BEGIN
    WINDOW(3,22,76,22);
    CLRSCR;
    DBN2:=DBN;
    DBN:='';
    REPEAT
      GOTOXY(6,1);
      WRITE('Geben Sie bitte den Namen der zu ffnenden Datenbank ein:');
      DBNEingabe;
    UNTIL DBN<>'';
    IF DBN<>#27 THEN
      BEGIN
        DBN:=DBN+'.adr';
        ASSIGN(Datenbank,DBN);
        {$I-}
        RESET(Datenbank);
        {$I+}
        IF IOResult<>0 THEN
          BEGIN
            CLRSCR;
            GOTOXY(15,1);
            WRITE('Die Datenbank "',DBN,'" wurde nicht gefunden!');
            SOUND(440);
            DELAY(1000);
            NOSOUND;
            CLRSCR;
            GOTOXY(9,1);
            WRITE('Wollen Sie eine neue Datenbank "',DBN,'" anlegen(j/n)?');
            Bestaetigung:=ReadKey;
            IF (UPCASE(Bestaetigung)='J') OR (Bestaetigung=#13) THEN
              BEGIN
                {$I-}
                REWRITE(Datenbank);
                CLOSE(Datenbank);
                {$I+}
                IF IOResult<>0 THEN
                  BEGIN
                    CLRSCR;
                    GOTOXY(16,1);
                    WRITE('Fehler beim Erstellen der Datenbank "',DBN,'"!');
                    SOUND(440);
                    DELAY(1000);
                    NOSOUND;
                  END
                ELSE Geoeffnet:=True;
              END
            ELSE
              BEGIN
                Geoeffnet:=False;
                DBN:='Noname';
              END;
          END
        ELSE
          BEGIN
            CLRSCR;
            GOTOXY(20,1);
            WRITE('Die Datenbank "',DBN,'" wurde geffnet.');
            DELAY(500);
            Geoeffnet:=True;
            Geaendert:=False;
          END;
        FOR a:=1 TO NAGr DO
          NA[a]:=-1;
        IF Geoeffnet=True THEN
          BEGIN
            RESET(Datenbank);
            FOR a:=0 TO (FileSize(Datenbank)-1) DO
              BEGIN
                SEEK(Datenbank,a);
                READ(Datenbank,Datensatz);
                NA[a+1]:=Datensatz.DSN;
              END;
            CLRSCR;
            GOTOXY(11,1);
            WRITE('Sie knnen nun mit dem Bearbeiten der Daten beginnen.');
            DELAY(1000);
          END;
      END
    ELSE
      DBN:=DBN2;
    CLRSCR;
  END;

PROCEDURE DatenbankLoeschen;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Dateiname:STRING[14];
     f:FILE;
     xpos,ypos:BYTE;

  BEGIN
    xpos:=WhereX;
    ypos:=WhereY;
    WINDOW(3,22,76,22);
    CLRSCR;
    REPEAT
      GOTOXY(6,1);
      WRITE('Geben Sie bitte den Namen der zu lschenden Datenbank ein:',' ':7);
      GOTOXY(64,1);
      READLN(Dateiname);
    UNTIL Dateiname<>'';
    Dateiname:=Dateiname+'.adr';
    ASSIGN(f,Dateiname);
    {$I-}
    RESET(f);
    {$I+}
    IF IOResult<>0 THEN
      BEGIN
        CLRSCR;
        GOTOXY(20,1);
        WRITE('Die Datenbank "',Dateiname,'" wurde nicht gefunden!');
        SOUND(440);
        DELAY(1000);
        NOSOUND;
      END
    ELSE
      BEGIN
        CLOSE(f);
        CLRSCR;
        GOTOXY(9,1);
        WRITE('Wollen Sie die Datenbank "',Dateiname,'" wirklich lschen? (j/n)');
        IF UPCASE(ReadKey)='J' THEN
          BEGIN
            ERASE(f);
            CLRSCR;
            GOTOXY(25,1);
            WRITE('Datenbank "',Dateiname,'" gelscht');
            DELAY(1000);
          END;
      END;
    CLRSCR;
    WINDOW(1,1,80,25);
    GOTOXY(xpos,ypos);
  END;

PROCEDURE ANRAnzeige;
(*Copyright by Wobe Inc. 1992*)
  BEGIN
    GOTOXY(19,6);
    IF ImSuch=True THEN
      WRITE(ANRtyp[Such.ANR])
    ELSE
      WRITE(ANRtyp[Datensatz.ANR]);
  END;

PROCEDURE Umrechnung;
(*Copyright by Wobe Inc. 1992*)
  TYPE
      Hilfstyp=ARRAY [1..3] OF CHAR;

  VAR
     Zehner:BYTE;
     Hilfs:Hilfstyp;

  PROCEDURE Gleichsetzen;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      FOR a:=1 TO 3 DO
        Hilfs[a]:=Datensatz.LN1[a];
    END;

  PROCEDURE GleichsetzenSuch;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      FOR a:=1 TO 3 DO
        Hilfs[a]:=Such.LN1[a];
    END;

  BEGIN
    IF ImSuch=True THEN
      GleichsetzenSuch
    ELSE
      Gleichsetzen;
    IF Hilfs[3]=#0 THEN
      BEGIN
        Hilfs[3]:=Hilfs[2];
        Hilfs[2]:=Hilfs[1];
        Hilfs[1]:=#0;
      END;
    IF Hilfs[3]=#0 THEN
      BEGIN
        Hilfs[3]:=Hilfs[2];
        Hilfs[2]:=#0;
      END;
    Datensatz.LND:=0;
    Zehner:=1;
    FOR a:=1 TO 3 DO
      BEGIN
        IF Hilfs[4-a]<>#0 THEN
          BEGIN
            Datensatz.LND:=Datensatz.LND+(ORD(Hilfs[4-a])-48)*Zehner;
            Zehner:=Zehner*10;
          END
        ELSE
          a:=3;
      END;
    IF (Datensatz.LND<1) OR (Datensatz.LND>13) THEN
      BEGIN
        WRITE(#7);
        Datensatz.LND:=0;
        GOTOXY(19,13);
        WRITE(' ':24);
      END
    ELSE
      BEGIN
        GOTOXY(19,13);
        WRITE(LNDtyp[Datensatz.LND]);
      END;
  END;

PROCEDURE RechneLaenge;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Ende:BOOLEAN;

  BEGIN
    Feldnr:=0;
    Laenge[0]:=1;
    Laenge[12]:=1;
    FOR Feldnr:=1 TO 11 DO
      BEGIN
        Laenge[Feldnr]:=1;
        Ende:=False;
        REPEAT
          CASE Feldnr OF
            1:CH:=Datensatz.TIT[Laenge[Feldnr]];
            2:CH:=Datensatz.VON[Laenge[Feldnr]];
            3:CH:=Datensatz.NAN[Laenge[Feldnr]];
            4:CH:=Datensatz.CO[Laenge[Feldnr]];
            5:CH:=Datensatz.STR[Laenge[Feldnr]];
            6:CH:=Datensatz.PLZ[Laenge[Feldnr]];
            7:CH:=Datensatz.ORT[Laenge[Feldnr]];
            8:CH:=Datensatz.LN1[Laenge[Feldnr]];
            9:CH:=Datensatz.TEL[Laenge[Feldnr]];
            10:CH:=Datensatz.HOB[Laenge[Feldnr]];
            11:CH:=Datensatz.INF[Laenge[Feldnr]];
          END;
          IF (CH<>#0) AND (Laenge[Feldnr]<>Grenze[Feldnr]) THEN
            INC(Laenge[Feldnr])
          ELSE
            BEGIN
              Ende:=True;
              IF Laenge[Feldnr]=Grenze[Feldnr] THEN
                INC(Laenge[Feldnr]);
              DEC(Laenge[Feldnr]);
            END;
        UNTIL Ende=True;
      END;
  END;

PROCEDURE RechneLN1;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Zehner:BYTE;
     Hilfs:BYTE;

  BEGIN
    Zehner:=100;
    Hilfs:=Datensatz.LND;
    FOR a:=1 TO 3 DO
      BEGIN
        Datensatz.LN1[a]:=CHR(TRUNC(Hilfs/Zehner)+48);
        Hilfs:=Hilfs-TRUNC(Hilfs/Zehner)*Zehner;
        Zehner:=ROUND(Zehner/10);
      END;
    FOR a:=1 TO 3 DO
      IF ORD(Datensatz.LN1[a])=48 THEN    {entspricht dem Zeichen '0'}
        Datensatz.LN1[a]:=#0;
    Hilfs:=ORD(Datensatz.LN1[1]);
    Datensatz.LN1[1]:=Datensatz.LN1[3];
    Datensatz.LN1[3]:=CHR(Hilfs);
  END;

PROCEDURE PfeilUp;
(*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
  BEGIN
    LetzteZeile:=False;
    IF (Zeile<>6) AND (Feldnr<>8) AND (Feldnr<>7) THEN
      BEGIN
        GOTOXY(7,Zeile);
        WRITE(' ');
        DEC(Zeile);
        GOTOXY(7,Zeile);
        WRITE('*');
        GOTOXY(18,Zeile);
        DEC(Feldnr);
        Zeichennr:=1;
      END
    ELSE
      CASE Feldnr OF
        7:BEGIN
            GOTOXY(25,Zeile);
            WRITE(' ');
            GOTOXY(7,Zeile);
            WRITE('*');
            GOTOXY(18,Zeile);
            DEC(Feldnr);
            Zeichennr:=1;
          END;
        8:BEGIN
            Umrechnung;
            GOTOXY(7,Zeile);
            WRITE(' ');
            DEC(Zeile);
            GOTOXY(25,Zeile);
            WRITE('*');
            GOTOXY(30,Zeile);
            DEC(Feldnr);
            Zeichennr:=1;
          END;
      END;
  END;

PROCEDURE PfeilDn;
(*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
  VAR
     Machsnicht:BOOLEAN;

  BEGIN
    Machsnicht:=False;
    CASE Feldnr OF
      0:ANRAnzeige;
      8:Umrechnung;
      7:BEGIN
          GOTOXY(25,Zeile);
          WRITE(' ');
          INC(Zeile);
          GOTOXY(7,Zeile);
          WRITE('*');
          GOTOXY(18,Zeile);
          INC(Feldnr);
          Zeichennr:=1;
          Machsnicht:=True;
        END;
      6:BEGIN
          GOTOXY(7,Zeile);
          WRITE(' ');
          GOTOXY(25,Zeile);
          WRITE('*');
          GOTOXY(30,Zeile);
          INC(Feldnr);
          Zeichennr:=1;
        END;
    END;
    IF (LetzteZeile=False) AND (Feldnr<>7) AND (Feldnr<>6) AND (Machsnicht=False) THEN
      BEGIN
        GOTOXY(7,Zeile);
        WRITE(' ');
        INC(Zeile);
        GOTOXY(7,Zeile);
        WRITE('*');
        GOTOXY(18,Zeile);
        INC(Feldnr);
        Zeichennr:=1;
      END;
    IF Zeile=17 THEN
      LetzteZeile:=True;
    Machsnicht:=False;
  END;

PROCEDURE PfeilLi;
(*Copyright by Wobe Inc. 1992*)
  BEGIN
    IF Zeichennr>1 THEN
      BEGIN
        GOTOXY(WhereX-1,WhereY);
        DEC(Zeichennr);
      END;
  END;

PROCEDURE PfeilRe;
(*Copyright by Wobe Inc. 1992*)
  BEGIN
    GOTOXY(WhereX+1,WhereY);
    INC(Zeichennr);
  END;

PROCEDURE Begrenzung;
(*Copyright by Wobe Inc. 1992*)
  BEGIN
    IF Zeichennr>=Grenze[Feldnr]+1 THEN
      BEGIN
        WRITE(#7);
        GOTOXY(Zeichennr+18,Zeile);       {wegen PfeilRe}
        DEC(Zeichennr);
        DEC(Laenge[Feldnr]);
      END
    ELSE
      IF Laenge[Feldnr]>=Grenze[Feldnr]+1 THEN
        BEGIN
          WRITE(#7);
          DEC(Laenge[Feldnr]);
          DEC(Zeichennr);
        END;
  END;

PROCEDURE Suchen;
(*Copyright by Wobe Inc. 1992*)
  VAR
   a,b:INTEGER;
   Gefunden,Ende:BOOLEAN;

  CONST
       F:SET OF CHAR=[' ','?','*',#0];

  PROCEDURE NullSuch;
  (*Copyright by Titus 1992*)
    VAR
       Y:INTEGER;

    BEGIN
      Such.ANR:=0;
      FOR Y:=1 TO 15 DO
        Such.TIT[Y]:=#0;
      FOR Y:=1 TO 30 DO
        BEGIN
          Such.VON[Y]:=#0;
          Such.NAN[Y]:=#0;
          Such.CO[Y]:=#0;
          Such.STR[Y]:=#0;
        END;
      FOR Y:=1 TO 6 DO
        Such.PLZ[Y]:=#0;
      FOR Y:=1 TO 40 DO
        Such.ORT[Y]:=#0;
      FOR Y:=1 TO 3 DO
        Such.LN1[Y]:=#0;
      Such.LND:=0;
      FOR Y:=1 TO 20 DO
        Such.TEL[Y]:=#0;
      FOR Y:=1 TO 57 DO
        BEGIN
          Such.HOB[Y]:=#0;
          Such.INF[Y]:=#0;
        END;
      Such.AKT:=True;
      Such.DSN:=0;
    END;

  PROCEDURE DatensatzSchreibenSuch;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      GOTOXY(19,6);
      WRITE(ANRtyp[Such.ANR]);
      GOTOXY(19,7);
      WRITE(Such.TIT);
      GOTOXY(19,8);
      WRITE(Such.VON);
      GOTOXY(19,9);
      WRITE(Such.NAN);
      GOTOXY(19,10);
      WRITE(Such.CO);
      GOTOXY(19,11);
      WRITE(Such.STR);
      GOTOXY(19,12);
      WRITE(Such.PLZ);
      GOTOXY(31,12);
      WRITE(Such.ORT);
      GOTOXY(19,13);
      WRITE(LNDtyp[Such.LND]);
      GOTOXY(19,14);
      WRITE(Such.TEL);
      GOTOXY(19,15);
      WRITE(Such.HOB);
      GOTOXY(19,16);
      WRITE(Such.INF);
      IF Such.AKT=True THEN
        BEGIN
          GOTOXY(19,17);
          WRITE('j');
        END
      ELSE
        BEGIN
          GOTOXY(19,17);
          WRITE('n');
        END;
      GOTOXY(19,18);
      WRITE(Such.DSN);
      GOTOXY(18,6);
    END;

  PROCEDURE DatFeldSuch;
  (*Copyright by Titus 1992*)
    BEGIN
      CASE Feldnr OF
        0:Such.ANR:=ORD(CH)-48;
        1:Such.TIT[Zeichennr]:=CH;
        2:Such.VON[Zeichennr]:=CH;
        3:Such.NAN[Zeichennr]:=CH;
        4:Such.CO[Zeichennr]:=CH;
        5:Such.STR[Zeichennr]:=CH;
        6:Such.PLZ[Zeichennr]:=CH;
        7:Such.ORT[Zeichennr]:=CH;
        8:Such.LN1[Zeichennr]:=CH;
        9:Such.TEL[Zeichennr]:=CH;
        10:Such.HOB[Zeichennr]:=CH;
        11:Such.INF[Zeichennr]:=CH;
        12:BEGIN
             CASE UPCASE(CH) OF
               'J':Such.AKT:=True;
               'N':Such.AKT:=False;
             END;
           END;
      END;
    END;

  PROCEDURE SchreibbereichSuch;
  (*Copyright by Titus 1992*)
    BEGIN
      CASE CH OF
        #13:PfeilDn;
        #08:BEGIN
              IF Zeichennr>1 THEN
                BEGIN
                  GOTOXY(WhereX-1,WhereY);
                  WRITE(' ');
                  CH:=#0;
                  DEC(Zeichennr);
                  DatFeldSuch;
                  GOTOXY(WhereX-1,WhereY);
                END;
            END;
      END;
    END;

  PROCEDURE EingebenSuch;
  (*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
    VAR
       Eingabe,Speichern:BOOLEAN;

    CONST
         NichtErlaubt:SET OF CHAR=[#0,#7,#8,#13,#27];

    BEGIN
      NullSuch;
      DatensatzSchreibenSuch;
      TEXTCOLOR(15);
      GOTOXY(1,4);
      WRITE(' ':80);
      GOTOXY(35,4);
      WRITE('Suchmodus');
      TEXTCOLOR(7);
      Feldnr:=0;
      Zeichennr:=1;
      Eingabe:=True;
      LetzteZeile:=False;
      Zeile:=6;
      Speichern:=False;
      ImSuch:=True;
      GOTOXY(7,6);
      WRITE('*');
      GOTOXY(18,6);
      REPEAT
        CH:=ReadKey;
        IF CH=#0 THEN
          BEGIN
            CH:=ReadKey;
            CASE CH OF
              #72:PfeilUp;
              #75:PfeilLi;
              #77:PfeilRe;
              #80:PfeilDn;
              #60:Speichern:=True;
            END;
            Begrenzung;
            CH:=#7;
          END;
        SchreibbereichSuch;
        IF (CH IN NichtErlaubt)=False THEN
          BEGIN
            Begrenzung;
            CASE Feldnr OF
              0:IF ((ORD(CH)-48)<1) OR ((ORD(CH)-48)>7) THEN
                  WRITE(#7)
                ELSE
                  BEGIN
                    GOTOXY(Zeichennr+18,Zeile);
                    WRITE(CH);
                    DatFeldSuch;
                    INC(Zeichennr);
                  END;
              7:BEGIN
                  GOTOXY(Zeichennr+30,12);
                  WRITE(CH);
                  DatFeldSuch;
                  INC(Zeichennr);
                END;
              8:BEGIN
                  IF ((ORD(CH)-48)<0) OR ((ORD(CH)-48)>9) THEN
                    WRITE(#7)
                  ELSE
                    BEGIN
                      GOTOXY(Zeichennr+18,Zeile);
                      WRITE(CH);
                      DatFeldSuch;
                      INC(Zeichennr);
                    END;
                END;
              12:BEGIN
                   IF (UPCASE(CH)='J') OR (UPCASE(CH)='N') THEN
                     BEGIN
                       GOTOXY(Zeichennr+18,Zeile);
                       WRITE(CH);
                       DatFeldSuch;
                       INC(Zeichennr)
                     END
                   ELSE
                     WRITE(#7);
                 END
              ELSE
                BEGIN
                  GOTOXY(Zeichennr+18,Zeile);
                  WRITE(CH);
                  DatFeldSuch;
                  INC(Zeichennr);
                END;
            END;
          END;
      UNTIL (CH=#27) OR ((CH=#7) AND (Speichern=True));
      GOTOXY(7,Zeile);
      WRITE(' ');
      GOTOXY(18,6);
      ImSuch:=False;
    END;

  BEGIN
    EingebenSuch;
    IF CH=#27 THEN EXIT;
    GOTOXY(1,22);
    WRITE(' ':80);
    GOTOXY(30,22);
    WRITE('Suchvorgang luft...');
    Anzahl:=1;
    Gefunden:=True;
    Ende:=False;
    FOR a:=1 TO NAGr DO
      NA[a]:=-1;
    a:=0;
    RESET(Datenbank);
    SEEK(Datenbank,a);     {sonst Fehler bei Listen/Zhlen}
    WHILE NOT EOF(Datenbank) DO
      BEGIN
        SEEK(Datenbank,a);
        READ(Datenbank,Datensatz);
        IF Datensatz.DSN<>0 THEN
          BEGIN
            IF (Such.ANR<>Datensatz.ANR) AND (Such.ANR<>0) THEN
              BEGIN
                Gefunden:=False;
                Ende:=True;
              END;
            IF Ende=False THEN
              FOR b:=1 TO 15 DO
                IF (Such.TIT[b]<>Datensatz.TIT[b]) AND ((Such.TIT[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 30 DO
                IF (Such.VON[b]<>Datensatz.VON[b]) AND ((Such.VON[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 30 DO
                IF (Such.NAN[b]<>Datensatz.NAN[b]) AND ((Such.NAN[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 30 DO
                IF (Such.co[b]<>Datensatz.CO[b]) AND ((Such.CO[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 30 DO
                IF (Such.STR[b]<>Datensatz.STR[b]) AND ((Such.STR[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 6 DO
                IF (Such.PLZ[b]<>Datensatz.PLZ[b]) AND ((Such.PLZ[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 40 DO
                IF (Such.ORT[b]<>Datensatz.ORT[b]) AND ((Such.ORT[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              IF (Such.LND<>Datensatz.LND) AND (Such.LND<>0) THEN
                BEGIN
                  Gefunden:=False;
                  Ende:=True;
                END;
            IF Ende=False THEN
              FOR b:=1 TO 20 DO
                IF (Such.TEL[b]<>Datensatz.TEL[b]) AND ((Such.TEL[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 57 DO
                IF (Such.HOB[b]<>Datensatz.HOB[b]) AND ((Such.HOB[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              FOR b:=1 TO 57 DO
                IF (Such.INF[b]<>Datensatz.INF[b]) AND ((Such.INF[b] IN F)=False) THEN
                  BEGIN
                    Gefunden:=False;
                    Ende:=True;
                  END;
            IF Ende=False THEN
              IF (Such.DSN<>Datensatz.DSN) AND (Such.DSN<>0) THEN
                Gefunden:=False;
          END;
        IF Gefunden=True THEN
          BEGIN
            NA[Anzahl]:=Datensatz.DSN;
            INC(Anzahl);
          END;
        INC(a);
        Gefunden:=True;
        Ende:=False;
      END;
    GOTOXY(35,4);
    WRITE(' ':9);    {"Suchmodus" lschen}
    WINDOW(3,22,78,22);
    CLRSCR;
    GOTOXY(21,1);
    IF Anzahl-1=1 THEN
      WRITE('Suche beendet. 1 Datensatz gefunden.')
    ELSE
      WRITE('Suche beendet. ',Anzahl-1,' Datenstze gefunden.');
    WINDOW(1,1,80,25);
  END;

PROCEDURE DatenbankBearbeiten;
(*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
  TYPE
      Modustyp=(Bearb,Eing);

  VAR
     CH:CHAR;
     Eingabe:BOOLEAN;
     Modus:Modustyp;
     Zahl:INTEGER;

  PROCEDURE Null;
  (*Copyright by Titus 1992*)
    VAR
       Y:INTEGER;

    BEGIN
      Datensatz.DSN:=0;
      Datensatz.ANR:=0;
      FOR Y:=1 TO 15 DO
        Datensatz.TIT[Y]:=#0;
      FOR Y:=1 TO 30 DO
        BEGIN
          Datensatz.VON[Y]:=#0;
          Datensatz.NAN[Y]:=#0;
          Datensatz.CO[Y]:=#0;
          Datensatz.STR[Y]:=#0;
        END;
      FOR Y:=1 TO 6 DO
        Datensatz.PLZ[Y]:=#0;
      FOR Y:=1 TO 40 DO
        Datensatz.ORT[Y]:=#0;
      FOR Y:=1 TO 3 DO
        Datensatz.LN1[Y]:=#0;
      Datensatz.LND:=0;
      FOR Y:=1 TO 20 DO
        Datensatz.TEL[Y]:=#0;
      FOR Y:=1 TO 57 DO
        BEGIN
          Datensatz.HOB[Y]:=#0;
          Datensatz.INF[Y]:=#0;
        END;
      Datensatz.AKT:=True;
    END;

  PROCEDURE DatFeld;
  (*Copyright by Titus 1992*)
    BEGIN
      CASE Feldnr OF
        0:Datensatz.ANR:=ORD(CH)-48;
        1:Datensatz.TIT[Zeichennr]:=CH;
        2:Datensatz.VON[Zeichennr]:=CH;
        3:Datensatz.NAN[Zeichennr]:=CH;
        4:Datensatz.CO[Zeichennr]:=CH;
        5:Datensatz.STR[Zeichennr]:=CH;
        6:Datensatz.PLZ[Zeichennr]:=CH;
        7:Datensatz.ORT[Zeichennr]:=CH;
        8:Datensatz.LN1[Zeichennr]:=CH;
        9:Datensatz.TEL[Zeichennr]:=CH;
        10:Datensatz.HOB[Zeichennr]:=CH;
        11:Datensatz.INF[Zeichennr]:=CH;
        12:BEGIN
             CASE UPCASE(CH) OF
               'J':Datensatz.AKT:=True;
               'N':Datensatz.AKT:=False;
             END;
           END;
      END;
    END;

  PROCEDURE Schreibbereich;
  (*Copyright by Titus 1992*)
    BEGIN
      CASE CH OF
        #13:PfeilDn;
        #08:BEGIN
              IF Zeichennr>1 THEN
                BEGIN
                  GOTOXY(WhereX-1,WhereY);
                  WRITE(' ');
                  CH:=#0;
                  DEC(Zeichennr);
                  DEC(Laenge[Feldnr]);
                  DatFeld;
                  GOTOXY(WhereX-1,WhereY);
                END;
            END;
      END;
    END;

  PROCEDURE LeereFelder;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      IF Datensatz.TIT[1]=#0 THEN Datensatz.TIT[1]:=' ';
      IF Datensatz.VON[1]=#0 THEN Datensatz.VON[1]:=' ';
      IF Datensatz.NAN[1]=#0 THEN Datensatz.NAN[1]:=' ';
      IF Datensatz.CO[1]=#0 THEN Datensatz.CO[1]:=' ';
      IF Datensatz.STR[1]=#0 THEN Datensatz.STR[1]:=' ';
      IF Datensatz.PLZ[1]=#0 THEN Datensatz.PLZ[1]:=' ';
      IF Datensatz.ORT[1]=#0 THEN Datensatz.ORT[1]:=' ';
      IF Datensatz.LN1[1]=#0 THEN Datensatz.LN1[1]:=' ';
      IF Datensatz.TEL[1]=#0 THEN Datensatz.TEL[1]:=' ';
      IF Datensatz.HOB[1]=#0 THEN Datensatz.HOB[1]:=' ';
      IF Datensatz.INF[1]=#0 THEN Datensatz.INF[1]:=' ';
    END;

  PROCEDURE DatensatzSchreiben;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      GOTOXY(19,6);
      WRITE(ANRtyp[Datensatz.ANR]);
      GOTOXY(19,7);
      WRITE(Datensatz.TIT);
      GOTOXY(19,8);
      WRITE(Datensatz.VON);
      GOTOXY(19,9);
      WRITE(Datensatz.NAN);
      GOTOXY(19,10);
      WRITE(Datensatz.CO);
      GOTOXY(19,11);
      WRITE(Datensatz.STR);
      GOTOXY(19,12);
      WRITE(Datensatz.PLZ);
      GOTOXY(31,12);
      WRITE(Datensatz.ORT);
      GOTOXY(19,13);
      WRITE(LNDtyp[Datensatz.LND]);
      GOTOXY(19,14);
      WRITE(Datensatz.TEL);
      GOTOXY(19,15);
      WRITE(Datensatz.HOB);
      GOTOXY(19,16);
      WRITE(Datensatz.INF);
      IF Datensatz.AKT=True THEN
        BEGIN
          GOTOXY(19,17);
          WRITE('j');
        END
      ELSE
        BEGIN
          GOTOXY(19,17);
          WRITE('n');
        END;
      GOTOXY(19,18);
      WRITE(' ':10);
      GOTOXY(19,18);
      WRITE(Datensatz.DSN);
      GOTOXY(18,6);
    END;

  PROCEDURE SpeichNeu;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       Groesse:INTEGER;

    BEGIN
      RESET(Datenbank);
      Groesse:=FileSize(Datenbank);
      SEEK(Datenbank,Groesse);
      Datensatz.DSN:=Groesse+1;
      NA[Groesse+1]:=Groesse+1;
      Datensatz.AKT:=True;
      IF Datensatz.LND=0 THEN
        BEGIN
          Datensatz.LND:=1;
          DatensatzSchreiben;
        END;
      WRITE(Datenbank,Datensatz);
      SEEK(Datenbank,FilePos(Datenbank)-1);
    END;

  PROCEDURE SpeichBearb;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      PosFile:=FilePos(Datenbank);
      RESET(Datenbank);
      SEEK(Datenbank,PosFile);
      WRITE(Datenbank,Datensatz);
      SEEK(Datenbank,Filepos(Datenbank)-1);
    END;

  PROCEDURE Haupt;
  (*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
    VAR
       Speichern:BOOLEAN;

    PROCEDURE DatensatzHolen(Nummer1:INTEGER);
    (*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
      VAR
         enthalten,beenden:BOOLEAN;
         c:INTEGER;

      BEGIN
        gefunden:=False;
        enthalten:=False;
        beenden:=False;
        RESET(Datenbank);
        SEEK(Datenbank,Nummer1);
        REPEAT
          IF (Nummer1<0) OR (Nummer1>FileSize(Datenbank)-1) THEN
            BEGIN
              GOTOXY(1,22);
              WRITE(' ':80);
              GOTOXY(23,22);
              WRITE('Keine weiteren Datenstze gefunden!  ');
              WRITE(#7);
              beenden:=True;
            END
          ELSE
            BEGIN
              GOTOXY(5,22);
              WRITE(' ':70);
            END;
          IF (FileSize(Datenbank)<>0) AND (beenden=False) THEN
            BEGIN    {sonst Absturz bei Neuanlegen}
              SEEK(Datenbank,Nummer1);
              READ(Datenbank,Datensatz);
              SEEK(Datenbank,FilePos(Datenbank)-1);
            END;
          FOR c:=1 TO NAGr DO
            IF NA[c]=Datensatz.DSN THEN
              BEGIN
                enthalten:=True;
                c:=NAGr;
              END;
          IF (Datensatz.DSN<>0) AND (enthalten=True) AND (beenden=False) THEN
            BEGIN
              gefunden:=True;
            END;
          IF gefunden=False THEN
            IF Richtung=hinauf THEN
              DEC(Nummer1)
            ELSE
              INC(Nummer1);
        UNTIL (gefunden=True) OR (beenden=True);
        GOTOXY(18,6);
      END;

    PROCEDURE Eingeben;
    (*Copyright by Titus 1992, Portions Copyright by Wobe Inc. 1992*)
      CONST
           NichtErlaubt:SET OF CHAR=[#0,#7,#8,#13,#27];

      VAR
         xpos,ypos:BYTE;

      BEGIN
        Feldnr:=0;
        Zeichennr:=1;
        Eingabe:=True;
        LetzteZeile:=False;
        Zeile:=6;
        Speichern:=False;
        InsertModus:=False;
        GOTOXY(7,6);
        WRITE('*');
        GOTOXY(18,6);
        REPEAT
          CH:=ReadKey;
          IF CH=#0 THEN
            BEGIN
              CH:=ReadKey;
              CASE CH OF
                #71:BEGIN
                      GOTOXY(7,Zeile);
                      WRITE(' ');
                      Zeile:=7;
                      Feldnr:=1;
                      PfeilUp;
                    END;
                #72:PfeilUp;
                #75:PfeilLi;
                #77:PfeilRe;
                #79:BEGIN
                      GOTOXY(7,Zeile);
                      WRITE(' ');
                      Zeile:=16;
                      Feldnr:=11;
                      PfeilDn;
                    END;
                #80:PfeilDn;
                #82:IF InsertModus=False THEN
                      BEGIN
                        InsertModus:=True;
                        xpos:=WhereX;
                        ypos:=WhereY;
                        GOTOXY(73,24);
                        TEXTCOLOR(0);
                        TEXTBACKGROUND(15);
                        WRITE('Einfgen');
                        TEXTCOLOR(7);
                        TEXTBACKGROUND(0);
                        GOTOXY(xpos,ypos);
                      END
                    ELSE
                      BEGIN
                        InsertModus:=False;
                        xpos:=WhereX;
                        ypos:=WhereY;
                        GOTOXY(73,24);
                        WRITE(' ':8);
                        GOTOXY(xpos,ypos);
                      END;
                #60:Speichern:=True;
              END;
              Begrenzung;
              CH:=#7;
            END;
          Schreibbereich;
          IF (CH IN NichtErlaubt)=False THEN
            BEGIN
              Begrenzung;
              CASE Feldnr OF
                0:IF ((ORD(CH)-48)<1) OR ((ORD(CH)-48)>7) THEN
                    WRITE(#7)
                  ELSE
                    BEGIN
                      GOTOXY(Zeichennr+18,Zeile);
                      WRITE(CH);
                      DatFeld;
                      INC(Zeichennr);
                      INC(Laenge[Feldnr]);
                    END;
                7:BEGIN
                    GOTOXY(Zeichennr+30,12);
                    WRITE(CH);
                    DatFeld;
                    INC(Zeichennr);
                    INC(Laenge[Feldnr]);
                  END;
                8:BEGIN
                    IF ((ORD(CH)-48)<0) OR ((ORD(CH)-48)>9) THEN
                      WRITE(#7)
                    ELSE
                      BEGIN
                        GOTOXY(Zeichennr+18,Zeile);
                        WRITE(CH);
                        DatFeld;
                        INC(Zeichennr);
                        INC(Laenge[Feldnr]);
                      END;
                  END;
                12:BEGIN
                     IF (UPCASE(CH)='J') OR (UPCASE(CH)='N') THEN
                       BEGIN
                         GOTOXY(Zeichennr+18,Zeile);
                         WRITE(CH);
                         DatFeld;
                         INC(Zeichennr);
                         INC(Laenge[Feldnr]);
                       END
                     ELSE
                       WRITE(#7);
                   END
                ELSE
                  BEGIN
                    GOTOXY(Zeichennr+18,Zeile);
                    WRITE(CH);
                    DatFeld;
                    INC(Zeichennr);
                    INC(Laenge[Feldnr]);
                  END;
              END;
            END;
        UNTIL (CH=#27) OR ((CH=#7) AND (Speichern=True));
        GOTOXY(7,Zeile);
        WRITE(' ');
        GOTOXY(18,6);
      END;

    PROCEDURE Anzeigen;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        READ(Datenbank,Datensatz);
        SEEK(Datenbank,FilePos(Datenbank)-1);
        RechneLaenge;
        RechneLN1;
        {IF Datensatz.DSN>0 THEN}
          DatensatzSchreiben;
      END;

    PROCEDURE FreieNummer;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        Richtung:=hinauf;
        IF Zahl>FileSize(Datenbank) THEN
          Zahl:=FileSize(Datenbank);
        DatensatzHolen(Zahl-1);
        IF gefunden=True THEN
          Anzeigen
        ELSE
          SEEK(Datenbank,FilePos(Datenbank)+1);
      END;

    PROCEDURE Home;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        Richtung:=hinunter;
        DatensatzHolen(0);
        IF gefunden=True THEN
          Anzeigen
        ELSE
          SEEK(Datenbank,FilePos(Datenbank)-1);
      END;

    PROCEDURE PgUp;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        Richtung:=hinauf;
        DatensatzHolen(FilePos(Datenbank)-1);
        IF gefunden=True THEN
          BEGIN
            Anzeigen
          END
        ELSE
          SEEK(Datenbank,FilePos(Datenbank)+1);
      END;

    PROCEDURE EndTaste;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        Richtung:=hinauf;
        DatensatzHolen(FileSize(Datenbank)-1);
        IF gefunden=True THEN
          Anzeigen
        ELSE
          SEEK(Datenbank,FilePos(Datenbank)+1);
      END;

    PROCEDURE PgDn;
    (*Copyright by Wobe Inc. 1992*)
      BEGIN
        Richtung:=hinunter;
        DatensatzHolen(FilePos(Datenbank)+1);
        IF gefunden=True THEN
          Anzeigen
        ELSE
          SEEK(Datenbank,FilePos(Datenbank)-1);
      END;

    PROCEDURE DatensatzLoeschen;
    (*Copyright by Titus 1992*)
      BEGIN
        Datensatz.DSN:=0;
        SpeichBearb;
        GOTOXY(23,22);
        WRITE(' ':35);
        GOTOXY(30,22);
        WRITE('Datensatz gelscht');
        GOTOXY(18,6);
      END;

    BEGIN
      Geaendert:=True;
      Null;
      Richtung:=hinunter;
      Nummer:=0;
      DatensatzHolen(Nummer);
      RechneLaenge;
      RechneLN1;
      DatensatzSchreiben;
      TEXTCOLOR(15);
      GOTOXY(34,4);
      WRITE('Anzeigemodus');
      TEXTCOLOR(7);
      REPEAT
        CH:=ReadKey;
        IF CH=#0 THEN
          BEGIN
            CH:=ReadKey;
            CASE CH OF
              #61:BEGIN
                    Null;
                    DatensatzSchreiben;
                    GOTOXY(34,4);
                    WRITE('Eingabemodus');
                    Eingeben;
                    IF Speichern=True THEN
                      BEGIN
                        LeereFelder;
                        SpeichNeu;
                        DatensatzSchreiben;   {wegen DSN-Anzeige}
                      END
                    ELSE
                      BEGIN
                        SEEK(Datenbank,FilePos(Datenbank)-1);
                        PgDn;   {alten Zustand wieder herstellen}
                      END;
                    GOTOXY(34,4);
                    WRITE(' ':12);
                    TEXTCOLOR(15);
                    GOTOXY(34,4);
                    WRITE('Anzeigemodus');
                    TEXTCOLOR(7);
                    GOTOXY(18,6);
                  END;
              #62:DatensatzLoeschen;
              #63:BEGIN
                    Suchen;
                    Formular;
                    TEXTCOLOR(15);
                    GOTOXY(34,4);
                    WRITE('Anzeigemodus');
                    TEXTCOLOR(7);
                    DELAY(500);
                    PgUp;
                  END;
              #64:BEGIN
                    GOTOXY(34,4);
                    WRITE('Eingabemodus');
                    Eingeben;
                    IF Speichern=True THEN
                      BEGIN
                        LeereFelder;
                        SpeichBearb;
                      END
                    ELSE
                      BEGIN
                        SEEK(Datenbank,FilePos(Datenbank)-1);
                        PgDn;   {alten Zustand wieder herstellen}
                      END;
                    GOTOXY(34,4);
                    WRITE(' ':12);
                    TEXTCOLOR(15);
                    GOTOXY(34,4);
                    WRITE('Anzeigemodus');
                    TEXTCOLOR(7);
                    GOTOXY(18,6);
                  END;
              #108:BEGIN
                     GOTOXY(9,22);
                     WRITE('Bitte geben Sie die Nummer des anzuzeigenden Datensatzes ein:');
                     READLN(Zahl);
                     FreieNummer;
                   END;
              #71:Home;
              #73:PgUp;
              #79:EndTaste;
              #81:PgDn;
            END;
            CH:=#7;
          END;
      UNTIL CH=#27;
    END;

  BEGIN
    CLRSCR;
    Formular;
    Haupt;
  END;

PROCEDURE DatenbankListen;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Seite:INTEGER;

  PROCEDURE Bildschirm;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      CLRSCR;
      TEXTCOLOR(2);
      RahmenZeichnen(21,1,59,3);
      GOTOXY(23,2);
      WRITE('ADRESSVERWALTUNG V1.0 by WATer 1992');
      GOTOXY(2,4);
      WRITE('Datenbank:',DBN);
      GOTOXY(69,4);
      WRITE('ADRESSLISTE');
      GOTOXY(1,5);
      FOR a:=1 TO 80 DO
        WRITE('');
      GOTOXY(1,6);
      WRITE('Nr.');
      GOTOXY(5,6);
      WRITE('Vorname');
      GOTOXY(30,6);
      WRITE('Nachname');
      GOTOXY(55,6);
      WRITE('PLZ');
      GOTOXY(62,6);
      WRITE('Ort');
      GOTOXY(1,24);
      WRITE('Anzahl:',Anzahl-1);
      GOTOXY(15,24);
      WRITE('Gesamt:',FileSize(Datenbank));
      GOTOXY(1,25);
      WRITE('F1 Hilfe');
      GOTOXY(11,25);
      WRITE('F5 Zhlen');
      GOTOXY(22,25);
      WRITE('PgUp Zurckblttern');
      GOTOXY(43,25);
      WRITE('PgDn/Enter Vorblttern');
      GOTOXY(67,25);
      WRITE('Esc Abbrechen');
      TEXTCOLOR(7);
      WINDOW(1,7,80,23);
    END;

  PROCEDURE Auflisten;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       b:INTEGER;

    BEGIN
      CLRSCR;
      IF FileSize(Datenbank)>0 THEN
        FOR a:=(Seite-1)*16 TO Seite*16 DO
          BEGIN
            SEEK(Datenbank,a);
            READ(Datenbank,Datensatz);
            GOTOXY(1,a-(Seite-1)*16+1);
            WRITE(Datensatz.DSN);
            GOTOXY(5,a-(Seite-1)*16+1);
            WRITE(Datensatz.VON);
            GOTOXY(30,a-(Seite-1)*16+1);
            WRITE(Datensatz.NAN);
            GOTOXY(55,a-(Seite-1)*16+1);
            WRITE(Datensatz.PLZ);
            FOR b:=0 TO 17 DO
              BEGIN
                GOTOXY(62+b,a-(Seite-1)*16+1);
                WRITE(Datensatz.ORT[b+1]);
              END;
            IF a+1=FileSize(Datenbank) THEN
              a:=Seite*16;
        END;
    END;

  BEGIN
    RESET(Datenbank);
    Anzahl:=FileSize(Datenbank)+1;
    Seite:=1;
    Bildschirm;
    Auflisten;
    REPEAT
      CH:=ReadKey;
      IF CH=#0 THEN
        BEGIN
          CH:=ReadKey;
          CASE CH OF
            {#59:Hilfe;}
            #63:BEGIN
                  WINDOW(1,1,80,25);
                  CLRSCR;
                  Formular;
                  Suchen;
                  Bildschirm;
                  Auflisten;
                END;
            #73:BEGIN
                  IF Seite>1 THEN
                    BEGIN
                      DEC(Seite);
                      Auflisten;
                    END;
                END;
            #81:BEGIN
                  IF Seite*16<=FileSize(Datenbank) THEN
                    BEGIN
                      INC(Seite);
                      Auflisten;
                    END;
                END;
          END;
        END;
      IF CH=#13 THEN
        BEGIN
          IF Seite*16<=FileSize(Datenbank) THEN
            BEGIN
              INC(Seite);
              Auflisten;
            END;
        END;
    UNTIL CH=#27;
    WINDOW(1,1,80,25);
  END;

PROCEDURE DatenbankAusgeben;
(*Copyright by Wobe Inc. 1992*)
  VAR
     Eingabe:CHAR;

  PROCEDURE Formular;
  (*Copyright by Titus 1992*)

    BEGIN
      TEXTCOLOR(2);
      GOTOXY(50,6);
      WRITE('Datenbank:');
      GOTOXY(60,6);
      WRITE(DBN);
      GOTOXY(9,6);
      WRITE('Anrede  :');
      GOTOXY(9,7);
      WRITE('Titel   :');
      GOTOXY(9,8);
      WRITE('Vorname :');
      GOTOXY(9,9);
      WRITE('Nachname:');
      GOTOXY(9,10);
      WRITE('c/o     :');
      GOTOXY(9,11);
      WRITE('Strae  :');
      GOTOXY(9,12);
      WRITE('PLZ     :');
      GOTOXY(26,12);
      WRITE('Ort:');
      GOTOXY(9,13);
      WRITE('Land    :');
      GOTOXY(9,14);
      WRITE('Teln.   :');
      GOTOXY(9,15);
      WRITE('Hobbys  :');
      GOTOXY(9,16);
      WRITE('Info    :');
      GOTOXY(9,17);
      WRITE('Aktiv   :');
      GOTOXY(9,18);
      WRITE('Nummer  :');
      TextColor(0);
      TextBackground(15);
      GOTOXY(1,25);
      WRITE('Esc Beenden');
      GOTOXY(13,25);
      WRITE('F2 Drucken beginnen');
      GOTOXY(33,25);
      WRITE('F5 Auswahl');
      Textcolor(15);
      TextBackground(0);
    END;

  PROCEDURE Drucken;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       Zeilenausgleich:BYTE;
       b,c:INTEGER;
       enthalten:BOOLEAN;

    BEGIN
      CLRSCR;
      GOTOXY(30,1);
      WRITE('Druckvorgang luft...');
      FOR b:=1 TO FileSize(Datenbank) DO
        BEGIN
          Zeilenausgleich:=0;
          RESET(Datenbank);
          SEEK(Datenbank,b-1);
          READ(Datenbank,Datensatz);
          enthalten:=False;
          FOR c:=1 TO NAGr DO
            IF NA[c]=Datensatz.DSN THEN
              BEGIN
                enthalten:=True;
                c:=NAGr;
              END;
          IF (Datensatz.DSN<>0) AND (Datensatz.AKT=True) AND (enthalten=True) THEN
            BEGIN
              WRITE(Lst,ANRtyp[Datensatz.ANR]);
              WRITE(Lst,' ');
              FOR c:=1 TO 15 DO
                BEGIN
                  IF Datensatz.TIT[c]=#0 THEN c:=15;
                  WRITE(Lst,Datensatz.TIT[c]);
                END;
              WRITELN(Lst);
              FOR c:=1 TO 30 DO
                BEGIN
                  IF Datensatz.VON[c]=#0 THEN c:=30;
                  WRITE(Lst,Datensatz.VON[c]);
                END;
              WRITE(Lst,' ');
              FOR c:=1 TO 30 DO
                BEGIN
                  IF Datensatz.NAN[c]=#0 THEN c:=30;
                  WRITE(Lst,Datensatz.NAN[c]);
                END;
              WRITELN(Lst);
              IF Datensatz.CO[1]<>' ' THEN
                BEGIN
                  WRITELN(Lst);
                  WRITE(Lst,Datensatz.CO);
                END
              ELSE
                INC(Zeilenausgleich);
              IF Datensatz.STR[1]<>' ' THEN
                BEGIN
                  WRITE(Lst,Datensatz.STR);
                  WRITELN(Lst);
                END
              ELSE
                INC(Zeilenausgleich);
              FOR c:=1 TO 6 DO
                BEGIN
                  IF Datensatz.PLZ[c]=#0 THEN c:=6;
                  WRITE(Lst,Datensatz.PLZ[c]);
                END;
              WRITE(Lst,' ');
              FOR c:=1 TO 40 DO
                BEGIN
                  IF Datensatz.ORT[c]=#0 THEN c:=40;
                  WRITE(Lst,Datensatz.ORT[c]);
                END;
              WRITELN(Lst);
              WRITELN(Lst,LNDtyp[Datensatz.LND]);
              FOR c:=1 TO 3+Zeilenausgleich DO
                WRITELN(Lst);
            END;
        END;
      CLRSCR;
      GOTOXY(30,1);
      WRITE('Druckvorgang beendet');
    END;

  BEGIN
    WINDOW(1,1,80,25);
    CLRSCR;
    RahmenZeichnen(5,5,75,19);
    Formular;
    WINDOW(3,23,78,23);
    CLRSCR;
    GOTOXY(3,1);
    WRITE('Drcken Sie F5, um Auswahlkriterien einzugeben oder F2 fr Druckbeginn.');
    WINDOW(3,22,78,22);
    REPEAT
      Eingabe:=ReadKey;
      IF Eingabe=#0 THEN
        BEGIN
          Eingabe:=ReadKey;
          CASE Eingabe OF
            #60:Drucken;
            #63:BEGIN
                  WINDOW(1,1,80,25);
                  Suchen;
                  WINDOW(3,22,78,22);
                END;
          END;
        END;
    UNTIL Eingabe=#27;
  END;

PROCEDURE Hauptmenue(X1,Y1,X2,Y2,X5,Y5:INTEGER);
(*Copyright by Arthur Fritz 1992, Portions Copyright by Wobe Inc. 1991*)
  VAR
     Zaehler,w,i:INTEGER;
     Ort:STRING[10];

  CONST
       Hor='';
       Ver='';
       LoE='';
       RoE='';
       LuE='';
       RuE='';
       Eli='';
       Ere='';
       d='';
       x3=3;
       y3=3;
       x4=76;
       y4=21;

  BEGIN
    CLRSCR;
    Ort:='HAUPTMENUE';
    GOTOXY(X1,Y1);
    WRITE(LoE);
    GOTOXY(X2,Y1);
    WRITE(RoE);
    GOTOXY(X1,Y2);
    WRITE(LuE);
    GOTOXY(X2,Y2);
    WRITE(RuE);
    FOR Zaehler:=(X1+1) TO (X2-1) DO
      BEGIN
        GOTOXY(Zaehler,Y1);
        WRITE(Hor);
        GOTOXY(Zaehler,Y2);
        WRITE(Hor);
      END;
    FOR Zaehler:=(Y1+1) TO (Y2-1) DO
      BEGIN
        GOTOXY(X1,Zaehler);
        WRITE(Ver);
        GOTOXY(X2,Zaehler);
        WRITE(Ver);
      END;
    GOTOXY(X1,Y2+1);
    GOTOXY(X3,Y3);
    WRITE(LoE);
    GOTOXY(X4,Y3);
    WRITE(RoE);
    GOTOXY(X3,Y4);
    WRITE(LuE);
    GOTOXY(X4,Y4);
    WRITE(RuE);
    FOR Zaehler:=(X3+1) TO (X4-1) DO
      BEGIN
        GOTOXY(Zaehler,Y3);
        WRITE(Hor);
        GOTOXY(Zaehler,Y4);
        WRITE(Hor);
      END;
    FOR Zaehler:=(Y3+1) TO (Y4-1) DO
      BEGIN
        GOTOXY(X3,Zaehler);
        WRITE(Ver);
        GOTOXY(X4,Zaehler);
        WRITE(Ver);
      END;
    GOTOXY(X1,Y2+1);
    w:=2;
    FOR i:=1 TO 74 DO
      BEGIN
        INC(w);
        GOTOXY(w,23);
        WRITE(d);
      END;
    GOTOXY(23,2);
    WRITE('ADRESSVERWALTUNG V1.0 by WATer 1992');
    GOTOXY(x5,y5);
    WRITELN('F1...........................Hilfe');
    GOTOXY(x5,y5+2);
    WRITELN('F2.............Datenbank speichern');
    GOTOXY(x5,y5+3);
    WRITELN('F3................Datenbank ffnen');
    GOTOXY(x5,y5+4);
    WRITELN('F4...............Datenbank lschen');
    GOTOXY(x5,y5+6);
    WRITELN('F6............Datenbank bearbeiten');
    GOTOXY(x5,y5+7);
    WRITELN('F7................Datenbank listen');
    GOTOXY(x5,y5+8);
    WRITELN('F8...............Datenbank drucken');
    GOTOXY(x5,y5+10);
    WRITELN('Esc...........................Quit');
    GOTOXY(5,4);
    IF DBN='' THEN
      DBN:='Noname';
    WRITE('Datenbank:',DBN);
    GOTOXY(65,4);
    WRITE(Ort);
    GOTOXY(5,20);
    WRITE('Ihre Wahl:');
  END;

PROCEDURE Wahl;
(*Copyright by Arthur Fritz 1992*)
  CONST
       f1=#59;
       f2=#60;
       f3=#61;
       f4=#62;
       f6=#64;
       f7=#65;
       f8=#66;

  BEGIN
    X:=ReadKey;
    IF X=#0 THEN
      BEGIN
        X:=ReadKey;
        CASE X OF
          f1:BEGIN
               Hilfe(5,4,74,20,1,16);
               WINDOW(1,1,80,25);
               Hauptmenue(2,1,77,25,20,7);
             END;
          f2:BEGIN
               IF Geoeffnet=True THEN
                 DatenbankSpeichern
               ELSE
                 BEGIN
                   WINDOW(3,22,76,22);
                   GOTOXY(17,1);
                   WRITE('Bitte ffnen Sie zuerst eine Datenbank!');
                   WRITE(#7);
                   WINDOW(1,1,80,25);
                   GOTOXY(15,20);
                 END;
               WINDOW(1,1,80,25);
               GOTOXY(15,20);
             END;
          f3:BEGIN
               IF Geaendert=False THEN
                 DatenbankOeffnen;
               IF (Geaendert=True) AND (Geoeffnet=True) THEN
                 BEGIN
                   WINDOW(3,22,76,22);
                   GOTOXY(3,1);
                   WRITE('Wollen Sie die Datenbank speichern, bevor Sie eine neue ffnen(j/n)?');
                   WRITE(#7);
                   GOTOXY(71,1);
                   IF UPCASE(ReadKey)='J' THEN
                     DatenbankSpeichern;
                   DatenbankOeffnen;
                 END;
               WINDOW(1,1,80,25);
               GOTOXY(15,20);
             END;
          f4:DatenbankLoeschen;
          f6:BEGIN
               IF Geoeffnet=True THEN
                 BEGIN
                   RESET(Datenbank);
                   FOR a:=0 TO (FileSize(Datenbank)-1) DO
                     BEGIN    {damit sich keine NA-Vernderungen vom Listen}
                       SEEK(Datenbank,a);                 {auswirken knnen}
                       READ(Datenbank,Datensatz);
                       NA[a+1]:=Datensatz.DSN;
                     END;
                   DatenbankBearbeiten;
                   Hauptmenue(2,1,77,25,20,7);
                 END
               ELSE
                 BEGIN
                   WINDOW(3,22,76,22);
                   GOTOXY(17,1);
                   WRITE('Bitte ffnen Sie zuerst eine Datenbank!');
                   WRITE(#7);
                 END;
               WINDOW(1,1,80,25);
               GOTOXY(15,20);
             END;
          f7:BEGIN
               IF Geoeffnet=True THEN
                 BEGIN
                   DatenbankListen;
                   Hauptmenue(2,1,77,25,20,7);
                 END
               ELSE
                 BEGIN
                   WINDOW(3,22,76,22);
                   GOTOXY(17,1);
                   WRITE('Bitte ffnen Sie zuerst eine Datenbank!');
                   WRITE(#7);
                 END;
               WINDOW(1,1,80,25);
               GOTOXY(15,20);
             END;
          f8:BEGIN
               IF Geoeffnet=True THEN
                 BEGIN
                   DatenbankAusgeben;
                   WINDOW(1,1,80,25);
                   Hauptmenue(2,1,77,25,20,7);
                 END
               ELSE
                 BEGIN
                   WINDOW(3,22,76,22);
                   GOTOXY(17,1);
                   WRITE('Bitte ffnen Sie zuerst eine Datenbank!');
                   WRITE(#7);
                   WINDOW(1,1,80,25);
                   GOTOXY(15,20);
                 END;
             END;
        END;
      END;
  END;

{$I Titelbil.PRO}

PROCEDURE Abort(Msg:string);
(*Copyright by Wobe Inc. 1992*)
BEGIN
  WRITELN(Msg, ': ', GraphErrorMsg(GraphResult));
  HALT(1);
END;

BEGIN
  IF RegisterBGIdriver(@EGAVGADriverProc) < 0 THEN
    Abort('EGA/VGA');
  IF RegisterBGIfont(@GothicFontProc) < 0 THEN
    Abort('Gothic');
  IF RegisterBGIfont(@SansSerifFontProc) < 0 THEN
    Abort('SansSerif');
  IF RegisterBGIfont(@SmallFontProc) < 0 THEN
    Abort('Small');
  IF RegisterBGIfont(@TriplexFontProc) < 0 THEN
    Abort('Triplex');
  CLRSCR;
  CheckBreak:=False;
  Geoeffnet:=False;
  Geaendert:=False;
  gefunden:=False;
  ImSuch:=False;
  ImSpeich:=False;
  DBN:='';
  Titelbild;
  Hauptmenue(2,1,77,25,20,7);
  REPEAT
    Wahl;
    IF (X=#27) AND (Geaendert=True) THEN
      BEGIN
        WINDOW(3,22,76,22);
        GOTOXY(13,1);
        WRITE('Wollen Sie ohne gespeichert zu haben beenden (j/n)?');
        WRITE(#7);
        REPEAT
          X:=ReadKey;
          IF X=#27 THEN X:=#7;
          IF UPCASE(X)='J' THEN X:=#27;
          IF UPCASE(X)='N' THEN
            IF Geoeffnet=True THEN
              BEGIN
                DatenbankSpeichern;
                X:=#27;
              END;
        UNTIL (X=#27) OR (X=#7);
        IF X=#7 THEN
          BEGIN
            CLRSCR;
            WINDOW(1,1,80,25);
            GOTOXY(15,20);
          END;
      END;
  UNTIL X=#27;
  CLRSCR;
  FOR a:=1 TO 350 DO
    BEGIN
      SOUND(5000-a*14);
      DELAY(1);
      NOSOUND;
    END;
  WRITELN('Auf Wiedersehen!!!');
  WRITELN('Copyright by WATer 1992');
END.