// ----------------------------------------------------
// 	CMOSRAM Auslesen und Speichern
// 	von Disk laden und ins Cmos schreiben
// 	Autor: Mathias Knapp
// 	Datum: 3.Mai 1993
// 	Klasse 2BNK
// ----------------------------------------------------

#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CMOSADR 0x70			//Port 70h
#define CMOSDAT 0x71			//Port 71h
#define CMOS_DISC 0x31			//Ascii - Code fr "1"
#define DISC_CMOS 0x32			//Ascii - Code fr "2"

void VonDiskLaden(char *);
void AufDiskSichern(char*);

void VonDiskLaden(char * name)
{
  unsigned char wert;			//abgespeicherter Wert
  int satz;				//Schleifenvariable
  FILE * fpl=fopen(name,"r");		//File wird zum Lesen geffnet
  for (satz=0;satz<0x40;satz++)		//Schleife beginnt von 00 bis 63
  {
    fscanf(fpl,"%x ",&wert);		//Der Wert wird von der Datei eingelesen
    printf("\t%x",wert);		//auf dem Bildschirm ausgeben
    outp(CMOSADR,satz);			//Outport Adresse setzen
    outportb(CMOSDAT,wert);		//Wert ins Cmos schreiben
  }
  fclose(fpl);				//Datei schlieen
  return;
}

void AufDiskSichern(char * name)
{
  unsigned char inhalt;			//Inhalt des Cmos- Rams
  int adresse;				//Adresse
  FILE * fpw=fopen(name,"w");		//Datei ffnen zum Schreiben

  for(adresse=0; adresse<0x40; adresse++)  //Adresse von 0 bis 63 inkrementieren
  {
    outp(CMOSADR,adresse);		//Outport Adresse setzen
    inhalt=inportb(CMOSDAT);		//Cmos Byteweise auslesen
    fprintf(fpw,"%x ",inhalt);		//in Datei Schreiben
    printf("adr:%x= %x \t",adresse,inhalt);  //am Bildschirm ausgeben
  }
  fclose(fpw);				//Datei schlieen
  return;
}

void main(int argc, char * argv[])	//Hauptprogramm
{				//Parameteranzahl und Parameter bernehmen
  char datenfile[80] = "CMOS.DAT";

  printf("\n\n\tKnappsi's CMos Ram Konservierer");
  printf("\n\tdefault Filename:%s",datenfile);
  printf("\n\n\tCmos -> Disk ..... 1\n\tCmos <- Disk  .....2    :");
  int option = getche();
  printf("\n\n");

  if(argv[1][0] == 0)                   //Dateiname eingeben
    {
      char tmp[80];
      printf("\n\n\t Dateiname bitte angeben: ");
      gets(tmp);
      if (tmp[0] != 0) strcpy(datenfile,tmp);
    }
  else
     strcpy(datenfile, argv[1]);

  printf("\n\t Filename:%s\n\n",datenfile);

  switch(option)                        //Verzeigung lesen - Schreiben
  {
    case 0x31: AufDiskSichern(datenfile);
	       printf("\nSichere auf Disk") ;break;
    case 0x32: VonDiskLaden(datenfile);
	       printf("\nSchreibe ins Cmos");break;
  }
}