PROGRAM Codierung;
(*Copyright by Wobe Inc. 1992*)

USES Crt,Graph,Dos,Printer;

TYPE
    Characterarray=ARRAY [1..1000] OF CHAR;
    Binaertyp=0..1;
    Binaerarray=ARRAY [1..1000,1..8] OF Binaertyp;
    HWtyptyp=' '..'';
    HWtyp=ARRAY[1..139,1..7] OF HWtyptyp;
    Codearray=ARRAY [1..750] OF INTEGER;

VAR
   Text:Characterarray;
   Binaer:Binaerarray;
   AnzZei,a:INTEGER;
   Gespeichert,Ende:BOOLEAN;

CONST
     HW:HWtyp=('soll!  ','der!   ','und!   ','in!    ','zu!    ','den!   ',
     'das!   ','nichts!','von!   ','sie!   ','ist!   ','des!   ','sich!  ',
     'mit!   ','dem!   ','er!    ','es!    ','da!   ','also!  ','ich!   ',
     'auf!   ','ihren! ','eines! ','auch!  ','als!   ','an!    ','nach!  ',
     'wie!   ','im!    ','fr!   ','man!   ','aber!  ','durch! ','aus!   ',
     'wenn!  ','nur!   ','waren! ','noch!  ','werden!','bei!   ','will!  ',
     'wird!  ','was!   ','wir!   ','diesem!','welche!','sind!  ','einen! ',
     'oder!  ','um!    ','haben! ','einer! ','mir!   ','ber!  ','ihm!   ',
     'diesen!','einem! ','Herr!  ','uns!   ','da!    ','kann!  ','zum!   ',
     'zur!   ','doch!  ','vor!   ','dieser!','mich!  ','viel!  ','du!    ',
     'hatte! ','seinen!','mehr!  ','am!    ','denn!  ','unter! ','nun!   ',
     'sehr!  ','selbst!','schon! ','hier!  ','bis!   ','habe!  ','ihres! ',
     'dann!  ','ihnen! ','seiner!','alle!  ','wo!    ','wieder!','meine! ',
     'Zeit!  ','gegen! ','vom!   ','ganz!  ','mu!   ','ohne!  ','eine!  ',
     'ent!   ','ge!    ','ver!   ','zer!   ','heit!  ','keit!  ','lich!  ',
     'sam!   ','ierte! ','ieren! ','iert!  ','nis!   ','end!   ','en!    ',
     'ja!    ','wurde! ','knnen!','seine! ','jetzt! ','immer! ','sei!   ',
     'wohl!  ','dieses!','ihre!  ','wrde! ','diese! ','alles! ','sondern',
     'weil!  ','welcher','nicht! ','sein!  ','war!   ','hat!   ','ihr!   ',
     'ihn!   ','mein!  ','so!    ','ein!   ','die!   ','schaft!','ung!   ');

PROCEDURE Titelbild;
(*Copyright by Wobe Inc. 1992*)
  TYPE
      TonArray=ARRAY [1..36] OF INTEGER;

  CONST
       T:TonArray=(262,330,392,262,330,392,262,330,392,262,330,392,349,
       440,523,349,440,523,262,330,392,262,330,392,587,494,392,349,440,
       523,262,330,392,262,330,392);

  VAR
     Driver,Mode,Font,x1,y1,c,g:INTEGER;
     FillInfo:FillSettingsType;
     v:ViewPortType;

  BEGIN
    DirectVideo:=False;
    Driver:=0;
    InitGraph(Driver,Mode,'');
    IF GraphResult<0 THEN HALT(1);
    RANDOMIZE;
    x1:=GetMaxX;
    y1:=GetMaxY;
    c:=GetMaxColor;
    FOR Font:=1 TO 4000 DO
      PutPixel(Random(x1),Random(y1),Random(c)+1);  {Sterne}
    c:=RANDOM(c)+1;
    SetColor(c);
    x1:=x1 DIV 14;
    y1:=y1 DIV 14;
    MoveTo(x1,y1);
    g:=(GetMaxX-x1)-10;
    SetTextStyle(1,HorizDir,2);
    WHILE x1<g DO
      BEGIN
        CIRCLE(x1,y1,10);                   {bewegender Kreis}
        DELAY(2);
        SetViewPort(x1-10,y1-10,x1+10,y1+10,ClipOn);
        ClearViewPort;
        SetViewPort(0,0,GetMaxX,GetMaxY,ClipOn);
        INC(x1);
        CASE x1 OF
          60:OutTextXY(x1-25,y1-10,'W');    {Schriftzug}
          70:OutTextXY(x1-20,y1-10,'o');
          80:OutTextXY(x1-20,y1-10,'b');
          90:OutTextXY(x1-20,y1-10,'e');
          114:OutTextXY(x1-22,y1-10,'P');
          125:OutTextXY(x1-20,y1-10,'r');
          135:OutTextXY(x1-20,y1-10,'o');
          145:OutTextXY(x1-20,y1-10,'g');
          155:OutTextXY(x1-20,y1-10,'r');
          165:OutTextXY(x1-20,y1-10,'a');
          184:OutTextXY(x1-29,y1-10,'m');
          204:OutTextXY(x1-29,y1-10,'m');
          215:OutTextXY(x1-20,y1-10,'i');
          222:OutTextXY(x1-22,y1-10,'n');
          233:OutTextXY(x1-20,y1-10,'g');
          255:OutTextXY(x1-20,y1-10,'p');
          265:OutTextXY(x1-20,y1-10,'r');
          275:OutTextXY(x1-20,y1-10,'');
          285:OutTextXY(x1-20,y1-10,'s');
          295:OutTextXY(x1-20,y1-10,'e');
          305:OutTextXY(x1-20,y1-10,'n');
          315:OutTextXY(x1-20,y1-10,'t');
          325:OutTextXY(x1-20,y1-10,'i');
          335:OutTextXY(x1-20,y1-10,'e');
          345:OutTextXY(x1-20,y1-10,'r');
          355:OutTextXY(x1-20,y1-10,'t');
          365:OutTextXY(x1-20,y1-10,':');
        END;
      END;
    CIRCLE(x1,y1,10);                       {Gesicht}
    PutPixel(x1-5,y1-4,c);                  {Augen}
    PutPixel(x1+5,y1-4,c);
    Line(x1,y1-4,x1,y1+2);                  {Nase}
    Arc(x1,y1,225,320,7);                   {Mund}
    x1:=GetMaxX DIV 7;                      {Rechteck mit Schrift}
    y1:=GetMaxY DIV 7;
    SetColor(Random(GetMaxColor)+1);
    SetFillStyle(SolidFill,GetColor);
    BAR(x1,y1,GetMaxX-x1,GetMaxY-y1);
    SetColor(0);
    SetTextStyle(1,HorizDir,5);
    OutTextXY((GetMaxX DIV 2)-90,y1+50,'PC-Code');
    SetTextStyle(1,HorizDir,2);
    OutTextXY(x1+10,GetMaxY-y1-30,'(C) by Wobe 1991,1992');
    FOR c:=1 TO 36 DO
      BEGIN
        SOUND(T[c]);DELAY(250);
        IF KeyPressed THEN c:=36;
      END;
    NOSOUND;
    CloseGraph;
  END;

PROCEDURE RahmenZeichnen(X1, Y1, X2, Y2:INTEGER);
(*Copyright by Wobe Inc. 1991*)
  VAR
     Zaehler:INTEGER;

  CONST
       Hor='';
       Ver='';
       LoE='';
       RoE='';
       LuE='';
       RuE='';

  BEGIN
    GOTOXY(X1,Y1);
    WRITE(LoE);
    GOTOXY(X2,Y1);
    WRITE(RoE);
    GOTOXY(X1,Y2);
    WRITE(LuE);
    GOTOXY(X2,Y2);
    WRITE(RuE);
    FOR Zaehler:=(X1+1) TO (X2-1) DO
      BEGIN
        GOTOXY(Zaehler,Y1);
        WRITE(Hor);
        GOTOXY(Zaehler,Y2);
        WRITE(Hor);
      END;
    FOR Zaehler:=(Y1+1) TO (Y2-1) DO
      BEGIN
        GOTOXY(1,Zaehler);
        WRITE(Ver);
        GOTOXY(X2,Zaehler);
        WRITE(Ver);
      END;
    GOTOXY(X1,Y2+1);
  END;

PROCEDURE Speichern(VAR Gespeichert,Ende:BOOLEAN);
(*Copyright by Wobe Inc. 1992*)
  VAR
     a:LONGINT;
     Ausgabedatei:FILE OF INTEGER;
     DateiVorhanden,Ueberschreiben:BOOLEAN;
     DirInfo:SearchRec;
     C:Codearray;
     Codelaenge:INTEGER;
     Dateiname:STRING[14];

  PROCEDURE Worterkennung;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a,b:INTEGER;
       g:SHORTINT;
       Hilfs1,Hilfs2:STRING[1];

    PROCEDURE Verschieben(Wieviel:SHORTINT;a:INTEGER);
    (*Copyright by Wobe Inc. 1992*)
      VAR
         b:INTEGER;

      BEGIN
        FOR b:=a+Wieviel TO AnzZei DO
          Text[b-Wieviel]:=Text[b-1];
        DEC(AnzZei,Wieviel-1);
      END;

    BEGIN
      FOR a:=1 TO AnzZei DO
        BEGIN
          g:=1;
          b:=1;
          REPEAT
            Hilfs1:=Text[a+g-1];
            Hilfs2:=HW[b,g];
            IF Hilfs1=Hilfs2 THEN
              BEGIN
                INC(g);
                IF (g=8) OR (HW[b,g]='!') THEN
                  BEGIN
                    IF b<17 THEN
                      Text[a]:=CHR(b+15);
                    IF (b=17) OR (b=18) THEN
                      Text[a]:=CHR(b+110);
                    IF (b=19) OR (b=20) THEN
                      Text[a]:=CHR(b+111);
                    IF (b>20) AND (b<30) THEN
                      Text[a]:=CHR(b+112);
                    IF (b>29) AND (b<35) THEN
                      Text[a]:=CHR(b+113);
                    IF (b>34) AND (b<39) THEN
                      Text[a]:=CHR(b+114);
                    IF b>38 THEN
                      Text[a]:=CHR(b+116);
                    IF b=109 THEN
                      Text[a]:=CHR(15);
                    Verschieben(g-1,a+1);
                    b:=140;
                  END;
              END
            ELSE
              BEGIN
                INC(b);
                g:=1;
              END;
          UNTIL b>139;
        END;
    END;

  PROCEDURE BinaerCodieren;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a:INTEGER;
       Code:BYTE;
       b:SHORTINT;

    BEGIN
      FOR a:=1 TO 1000 DO
        FOR b:=1 TO 8 DO
          Binaer[a,b]:=0;
      FOR a:=1 TO AnzZei-1 DO     {-1, weil sonst letzes gelschtes Zeichen}
        BEGIN                     {auch gespeichert wird}
          Code:=ORD(Text[a]);
          FOR b:=1 TO 8 DO
            BEGIN
              Binaer[a,9-b]:=Code MOD 2;
              Code:=Code DIV 2;
            END;
        END;
    END;

  PROCEDURE Verschluesseln;
  (*Copyright by Wobe Inc. 1992*)
    TYPE
        AAtyp=ARRAY [1..12] OF INTEGER;
        Codearray=ARRAY [1..750] OF INTEGER;

    CONST
         {m=6566;}
         {w=5021;}
         {w_1=6549;}
      AA:AAtyp=(3476,1931,3862,1158,771,1542,3084,1147,4611,339,6085,4825);

    VAR
       a,i:INTEGER;
       z,b:SHORTINT;

    BEGIN
      i:=1;
      z:=1;
      FOR a:=1 TO 750 DO
        C[a]:=0;
      FOR a:=1 TO AnzZei-1 DO
        FOR b:=1 TO 8 DO
          BEGIN
            C[i]:=C[i]+Binaer[a,b]*AA[z];
            INC(z);
            IF z=13 THEN
              BEGIN
                z:=1;
                INC(i);
              END;
          END;
      IF z=1 THEN   {kein vllig leeres Feld mitnehmen}
        DEC(i);
      Codelaenge:=i;
    END;

  BEGIN
    WINDOW(3,3,78,3);
    CLRSCR;
    REPEAT
      GOTOXY(10,1);
      WRITE('Geben Sie bitte den gewnschten Dateinamen ein:    ',' ':9);
      GOTOXY(57,1);
      READLN(Dateiname);
    UNTIL Dateiname<>'';
    Dateiname:=Dateiname+'.cod';
    REPEAT
      DateiVorhanden:=True;
      Ueberschreiben:=True;
      ASSIGN(Ausgabedatei,Dateiname);
      FindFirst(Dateiname,Archive,DirInfo);   {Feststellen, ob Datei}
      IF DosError=18 THEN                     {vorhanden, 18 heit:}
        DateiVorhanden:=False;                {No more Files vorhanden}
      IF DateiVorhanden=True THEN
        BEGIN
          CLRSCR;
          GOTOXY(15,1);
          WRITE('Datei ist bereits vorhanden. berschreiben(j/n)?');
          GOTOXY(63,1);
          IF UPCASE(READKEY)='N' THEN
            BEGIN
              Ueberschreiben:=False;
              CLRSCR;
              REPEAT
                GOTOXY(11,1);
                WRITE('Geben Sie bitte einen anderen Dateinamen ein:    ',' ':9);
                GOTOXY(56,1);
                READLN(Dateiname);
              UNTIL Dateiname<>'';
              Dateiname:=Dateiname+'.cod';
            END;
        END;
    UNTIL Ueberschreiben=True;
    {$I-}
    REWRITE(Ausgabedatei);
    CLOSE(Ausgabedatei);
    {$I+}
    IF IOResult<>0 THEN
      BEGIN
        CLRSCR;
        GOTOXY(18,1);
        WRITE('Fehler beim Erstellen der Datei"',Dateiname,'"!');
        SOUND(440);
        DELAY(1000);
        NOSOUND;
      END
    ELSE
      BEGIN
        CLRSCR;
        GOTOXY(24,1);
        WRITE('Speichern von "',Dateiname,'" luft...');
        Worterkennung;
        BinaerCodieren;
        Verschluesseln;
        REWRITE(Ausgabedatei);
        FOR a:=1 TO Codelaenge DO
          WRITE(Ausgabedatei,C[a]);
        CLOSE(Ausgabedatei);
        Gespeichert:=True;
        CLRSCR;
        GOTOXY(21,1);
        WRITE('Speichern erfolgreich abgeschlossen');
        DELAY(1000);
      END;
    IF Ende=False THEN
      BEGIN
        CLRSCR;
        GOTOXY(14,1);
        WRITE('Bitte geben Sie den zu verschlsselnden Text ein:');
      END;
    WINDOW(3,3,78,23);
  END;

PROCEDURE Laden(VAR Text:Characterarray;VAR AnzZei:INTEGER;VAR Ausgeben:BOOLEAN);
(*Copyright by Wobe Inc. 1992*)
  TYPE
      EEtyp=ARRAY [1..12] OF INTEGER;
      Hilfsarraytyp=ARRAY [1..750,1..12] OF Binaertyp;

  VAR
     Ausgabedatei:FILE OF INTEGER;
     Codelaenge:LONGINT;
     b,i:SHORTINT;
     Dateiname:STRING[14];
     C,D:Codearray;
     Binaer:Binaerarray;
     Hilfsarray:Hilfsarraytyp;

  CONST
       W_1:LONGINT=6549;
       m=6566;
       e:EEtyp=(3333,1611,803,405,199,100,50,25,12,6,3,2);

  PROCEDURE Einlesen;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a:INTEGER;

    BEGIN
      Codelaenge:=FileSize(Ausgabedatei);
      FOR a:=1 TO Codelaenge DO
        BEGIN
          READ(Ausgabedatei,C[a]);
          D[a]:=w_1*C[a] MOD m;
        END;
      CLOSE(Ausgabedatei);
      {IF D[Codelaenge]=0 THEN}
        {DEC(Codelaenge);}    {frher diese 2 Zeilen 2mal}
    END;

  PROCEDURE DecodierenInBinaer;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a,Hilfs:INTEGER;
       b,i:SHORTINT;

    BEGIN
      {Alle Variablen rcksetzen}
      FOR a:=1 TO 1000 DO
        FOR b:=1 TO 8 DO
          Binaer[a,b]:=0;
      FOR a:=1 TO 750 DO
        FOR b:=1 TO 12 DO
          Hilfsarray[a,b]:=0;
      FOR a:=1 TO 1000 DO
        Text[a]:=' ';
      b:=1;
      AnzZei:=1;
      {Entschlsseln}
      FOR a:=1 TO Codelaenge DO
        FOR i:=1 TO 12 DO
          BEGIN
            Hilfs:=D[a]-e[i];
            IF Hilfs>=0 THEN
              BEGIN
                D[a]:=D[a]-e[i];
                Hilfsarray[a,i]:=1;
              END;
         END;
      {Von Hilfsarray in Binaerarray umschreiben}
      FOR a:=1 TO Codelaenge DO
        FOR i:=12 DOWNTO 1 DO
          BEGIN
            Binaer[AnzZei,b]:=Hilfsarray[a,i];
            INC(b);
            IF b=9 THEN
              BEGIN
                b:=1;
                INC(AnzZei);
              END;
          END;
      IF b=1 THEN
        DEC(AnzZei);     {kein leeres Binrfeld mitnehmen!}
    END;

  PROCEDURE BinaerInText;
  (*Copyright by Wobe Inc. 1992*)
    VAR
      a,Code:INTEGER;
      Potenz:BYTE;
      b:SHORTINT;

    BEGIN
      FOR a:=1 TO AnzZei DO
        BEGIN
          Code:=0;
          Potenz:=128;
          FOR b:=1 TO 8 DO
            BEGIN
              Code:=Code+TRUNC(Binaer[a,b]*Potenz);
              Potenz:=Potenz DIV 2;
            END;
          Text[a]:=CHR(Code);
        END;
    END;

  PROCEDURE Wortrueckwandlung;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a,b,h:INTEGER;
       Code:BYTE;
       Laenge:SHORTINT;
       Hilfs:CHAR;

    PROCEDURE Vorschieben(Wieviel:SHORTINT;a:INTEGER);
    (*Copyright by Wobe Inc. 1992*)
      VAR
         g:INTEGER;

      BEGIN
        INC(AnzZei,Wieviel);
        FOR g:=AnzZei DOWNTO a DO
          Text[g]:=Text[g-Wieviel];
      END;

    BEGIN
      a:=1;
      WHILE a<=AnzZei DO
        BEGIN
          b:=0;
          Laenge:=0;
          Code:=ORD(Text[a]);
          IF Code=15 THEN
            b:=109;
          IF (Code>15) AND (Code<32) THEN
            b:=Code-15;
          IF (Code=127) OR (Code=128) THEN
            b:=Code-110;
          IF (Code=130) OR (Code=131) THEN
            b:=Code-111;
          IF (Code>132) AND (Code<142) THEN
            b:=Code-112;
          IF (Code>142) AND (Code<148) THEN
            b:=Code-113;
          IF (Code>148) AND (Code<153) THEN
            b:=Code-114;
          IF Code>154 THEN
            b:=Code-116;
          IF Code=225 THEN
            b:=0;
          IF b<>0 THEN
            BEGIN
              WHILE (HW[b,Laenge+1]<>'!') AND (Laenge<7) DO
                INC(Laenge);
              Vorschieben(Laenge-1,a);   {-1 wegen berschreiben des}
              FOR h:=1 TO Laenge DO      {Codezeichens}
                Text[a+h-1]:=HW[b,h];
            END;
          INC(a);
        END;
  END;

  BEGIN
    WINDOW(3,3,78,3);
    CLRSCR;
    Dateiname:='';
    REPEAT
      GOTOXY(5,1);
      WRITE('Geben Sie bitte den Namen der zu entschlsselnden Datei ein:');
      GOTOXY(65,1);
      READLN(Dateiname);
    UNTIL Dateiname<>'';
    Dateiname:=Dateiname+'.cod';
    ASSIGN(Ausgabedatei,Dateiname);
    {$I-}
    RESET(Ausgabedatei);
    {$I+}
    IF IOResult<>0 THEN
      BEGIN
        CLRSCR;
        GOTOXY(20,1);
        WRITE('Die Datei "',Dateiname,'" wurde nicht gefunden!');
        SOUND(440);
        DELAY(1000);
        NOSOUND;
      END
    ELSE
      BEGIN
        CLRSCR;
        GOTOXY(25,1);
        WRITE('Entschluesseln luft...');
        Einlesen;
        DecodierenInBinaer;
        BinaerInText;
        Wortrueckwandlung;
        CLRSCR;
        GOTOXY(20,1);
        WRITE('Umwandlung erfolgreich abgeschlossen');
        DELAY(1000);
        Ausgeben:=True;
      END;
    CLRSCR;
    GOTOXY(14,1);
    WRITE('Bitte geben Sie den zu verschlsselnden Text ein:');
    WINDOW(3,3,78,23);
  END;

PROCEDURE Eingabe(VAR Gespeichert:BOOLEAN);
(*Copyright by Wobe Inc. 1992*)
  TYPE
      ShortintArray=ARRAY [1..20] OF SHORTINT;

  VAR
     Zeichen:CHAR;
     Wert:LONGINT;
     Zaehler,Zwischen:INTEGER;
     xpos,ypos:BYTE;
     Zeilenzahl,b:SHORTINT;
     Vorwarnung,Warnung,Escape,Ausgeben:BOOLEAN;
     WievielZurueck:ShortintArray;

  PROCEDURE Hilfe;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      SOUND(800);
      DELAY(200);
      NOSOUND;
    END;

  PROCEDURE F2_Speichern(VAR Gespeichert,Ende:BOOLEAN);
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      xpos:=WhereX;
      ypos:=WhereY;
      Speichern(Gespeichert,Ende);
      GOTOXY(xpos,ypos);
    END;

  PROCEDURE F3_Laden;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      IF (AnzZei>1) AND (Gespeichert=False) THEN
        BEGIN
          WINDOW(3,3,78,3);
          CLRSCR;
          GOTOXY(4,1);
          WRITE('Wollen Sie den Text speichern, bevor Sie eine neue Datei laden(j/n)?');
          IF UPCASE(READKEY)='J' THEN
            BEGIN
              Ende:=True;
              Speichern(Gespeichert,Ende);
            END;
        END;
      Laden(Text,AnzZei,Ausgeben);
      Zaehler:=1;
      Zwischen:=AnzZei;
      AnzZei:=1;
      Zeilenzahl:=1;
      WINDOW(3,4,78,23);
      CLRSCR;
      WINDOW(3,3,78,23);
      GOTOXY(1,2);
    END;

  PROCEDURE Optionen;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      SOUND(1200);
      DELAY(200);
      NOSOUND;
    END;

  PROCEDURE Loeschen;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       Dateiname:STRING[14];
       f:FILE;

    BEGIN
      xpos:=WhereX;
      ypos:=WhereY;
      WINDOW(3,3,78,3);
      CLRSCR;
      REPEAT
        GOTOXY(11,1);
        WRITE('Geben Sie bitte den Namen der zu lschenden Datei ein:',' ':7);
        GOTOXY(65,1);
        READLN(Dateiname);
      UNTIL Dateiname<>'';
      Dateiname:=Dateiname+'.cod';
      ASSIGN(f,Dateiname);
      {$I-}
      RESET(f);
      {$I+}
      IF IOResult<>0 THEN
        BEGIN
          CLRSCR;
          GOTOXY(18,1);
          WRITE('Die Datei "',Dateiname,'" wurde nicht gefunden!');
          SOUND(440);
          DELAY(1000);
          NOSOUND;
        END
      ELSE
        BEGIN
          CLOSE(f);
          CLRSCR;
          GOTOXY(14,1);
          WRITE('Wollen Sie die Datei "',Dateiname,'" wirklich lschen? (j/n)');
          IF UPCASE(READKEY)='J' THEN
            BEGIN
              ERASE(f);
              CLRSCR;
              GOTOXY(27,1);
              WRITE('Datei "',Dateiname,'" gelscht');
              DELAY(1000);
            END;
        END;
      CLRSCR;
      GOTOXY(14,1);
      WRITE('Bitte geben Sie den zu verschlsselnden Text ein:');
      WINDOW(3,3,78,23);
      GOTOXY(xpos,ypos);
    END;

  PROCEDURE Neu;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       b:SHORTINT;

    BEGIN
      IF (Gespeichert=False) AND (AnzZei>1) THEN
        BEGIN
          WINDOW(3,3,78,3);
          CLRSCR;
          GOTOXY(3,1);
          WRITE('Wollen Sie den Text speichern, bevor Sie eine neue Datei anfangen(j/n)?');
          IF UPCASE(READKEY)='J' THEN
            Speichern(Gespeichert,Ende);
        END;
      FOR a:=1 TO 1000 DO
        FOR b:=1 TO 8 DO
          Binaer[a,b]:=0;
      FOR a:=1 TO 1000 DO
        Text[a]:=' ';
      AnzZei:=1;
      Zeilenzahl:=1;
      Vorwarnung:=False;
      Warnung:=False;
      Escape:=False;
      Ausgeben:=False;
      Zaehler:=1;     {nicht 0, sonst keine Speichern?-Frage bei ESC}
      Zwischen:=0;
      Gespeichert:=False;
      CLRSCR;
      GOTOXY(14,1);
      WRITE('Bitte geben Sie den zu verschlsselnden Text ein:');
      WINDOW(3,4,78,23);
      CLRSCR;
      WINDOW(3,3,78,23);
      GOTOXY(1,2);
    END;

  PROCEDURE Drucken;
  (*Copyright by Wobe Inc. 1992*)
    VAR
       a:INTEGER;

    BEGIN
      FOR a:=1 TO AnzZei-1 DO
        WRITE(Lst,Text[a]);
      WRITELN(Lst,'');
    END;

  PROCEDURE Zeilenueberschreitung;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
{Wenn ein Wort so lang wird, da es die Zeile berschreitet, wird es in}
{die nchste Zeile geschrieben}
      WievielZurueck[Zeilenzahl]:=1;
      Zeichen:='x';
      WHILE Zeichen<>' ' DO
        BEGIN
          Zeichen:=Text[AnzZei-WievielZurueck[Zeilenzahl]];
          INC(WievielZurueck[Zeilenzahl]);
        END;
      DEC(WievielZurueck[Zeilenzahl]);
      GOTOXY(78-WievielZurueck[Zeilenzahl],WhereY-1);
      WRITE(' ':WievielZurueck[Zeilenzahl]);
      GOTOXY(1,WhereY);
      FOR a:=1 TO WievielZurueck[Zeilenzahl]-1 DO
        WRITE(Text[AnzZei-WievielZurueck[Zeilenzahl]+a]);
      Warnung:=False;
      INC(Zeilenzahl);
    END;

  PROCEDURE Backspace;
  (*Copyright by Wobe Inc. 1992*)
    BEGIN
      Gespeichert:=False;
      DEC(AnzZei);
      IF (WhereX=1) AND (WhereY>2) THEN
        GOTOXY(76,WhereY-1);
      GOTOXY(WhereX-1,WhereY);   {Zeichen lschen}
      WRITE(' ');
      IF (Zeilenzahl-1)>0 THEN
        BEGIN
          IF (WhereX<WievielZurueck[Zeilenzahl-1]) AND (WhereY>2) THEN
            BEGIN
{Wenn ein Wort, das in der nchsten Zeile steht, so kurz wird wird, da es}
{wieder in die vorige Zeile pat}
              GOTOXY(1,WhereY);
              WRITE(' ':WievielZurueck[Zeilenzahl-1]);
              GOTOXY(77-WievielZurueck[Zeilenzahl-1],WhereY-1);
              FOR a:=1 TO WievielZurueck[Zeilenzahl-1]-1 DO
                WRITE(Text[AnzZei-WievielZurueck[Zeilenzahl-1]+a]);
              WRITE(' ');
              GOTOXY(77,WhereY-1);
              DEC(Zeilenzahl);
            END;
        END;
    END;

  BEGIN
    AnzZei:=1;
    Gespeichert:=True;
    Zeilenzahl:=1;
    Vorwarnung:=False;
    Warnung:=False;
    Escape:=False;
    Ausgeben:=False;
    GOTOXY(14,1);
    WRITELN('Bitte geben Sie den zu verschlsselnden Text ein:');
    GOTOXY(1,2);
    REPEAT
      BEGIN
        IF Ausgeben=False THEN
          Zeichen:=READKEY;
        INC(Zaehler); {um bei ESC sofort nach Entschl. gleich aus}
        IF Ausgeben=True THEN
          BEGIN
            Zeichen:=Text[Zaehler-1];
            IF Zaehler=Zwischen THEN
              Ausgeben:=False;
          END;
        IF Zaehler=(Zwischen+1) THEN
          BEGIN
            Gespeichert:=True;
            Zaehler:=0;
          END;
        Wert:=ORD(Zeichen);
        IF (Wert=27) AND (Gespeichert=True) THEN  {Esc-Taste}
          Escape:=True;
        IF Zeichen=#0 THEN {Feststellen einer Sondertaste}
          BEGIN
            Zeichen:=READKEY;
            CASE Zeichen OF
              #59:Hilfe;
              #60:F2_Speichern(Gespeichert,Ende);
              #61:F3_Laden;
              #62:Optionen;
              #63:Loeschen;
              #64:Neu;
              #65:Drucken;
            END;
            Zeichen:=#0;
          END;
        IF (Wert=8) AND (AnzZei>1) THEN {Backspace-Taste}
          Backspace
        ELSE
          IF Zeichen<>#0 THEN    {Sondertasten nicht bear-}
            BEGIN                                  {beiten}
              Text[AnzZei]:=Zeichen;
              INC(AnzZei);
              Gespeichert:=False;
              IF Escape=True THEN
                Gespeichert:=True;
            END;
        IF (Wert<>13) AND (Zeichen<>#0) THEN
          WRITE(Zeichen);
        IF (Warnung=True) AND (Zeichen<>' ') THEN
          Zeilenueberschreitung;
        IF Vorwarnung=True THEN
          BEGIN
            Warnung:=True;
            Vorwarnung:=False;
          END;
        IF WhereX=76 THEN
          Vorwarnung:=True;
      END;
    UNTIL Wert=27;
  END;

{Beginn des Hauptprogrammes}
BEGIN
     Ende:=False;
     CLRSCR;
     Titelbild;
     Rahmenzeichnen(1,1,80,24);
     GOTOXY(3,2);
     WRITELN('PC-Code V1.1',' ':32,'Copyright by Wobe Inc. 1991,1992');
     TEXTCOLOR(0);
     TEXTBACKGROUND(15);
     GOTOXY(1,25);
     WRITE('Esc Ende');
     GOTOXY(10,25);
     WRITE('F1 Hilfe');
     GOTOXY(19,25);
     WRITE('F2 Speichern');
     GOTOXY(32,25);
     WRITE('F3 Laden');
     GOTOXY(41,25);
     WRITE('F4 Optionen');
     GOTOXY(53,25);
     WRITE('F5 Lschen');
     GOTOXY(64,25);
     WRITE('F6 Neu');
     GOTOXY(71,25);
     WRITE('F7 Druck');
     TEXTCOLOR(15);
     TEXTBACKGROUND(0);
     WINDOW(3,3,78,23);
     Eingabe(Gespeichert);
     IF (AnzZei>2) AND (Gespeichert=False) THEN {Esc-Taste bercksichtigen!}
       BEGIN
         WINDOW(3,3,78,3);
         CLRSCR;
         GOTOXY(15,1);
         WRITE('Wollen Sie den chiffrierten Text speichern?(j/n)');
         IF UPCASE(READKEY)='J' THEN
           BEGIN
             Ende:=True;
             Speichern(Gespeichert,Ende);
             WINDOW(26,24,60,25);
             WRITE('Irgendeine Taste fr weiter...');
             GOTOXY(31,1);
             REPEAT UNTIL KEYPRESSED;
           END;
       END;
     WINDOW(1,1,80,25);
     CLRSCR;
     WRITELN('Auf Wiedersehen!');
     WRITELN('Copyright by Wobe Inc. 1991,1992');
END.