/*********************************************************************/
/*                                                                   */
/* FLYAWAY ist ein Flyback-Converter-Berechnungsprogramm             */
/*                                                                   */
/* Software fr ein 80x86 VGA-System                                 */
/*                                                                   */
/* Geschrieben, compiliert und gelinkt im Borland C++ 3.0            */
/*                                                                   */
/* Filename:                FLYAWAY.EXE                              */
/*                                                                   */
/* Erstellung am:           14.Februar 1993                          */
/* Letzte berarbeitung am: 28.Februar 1993                          */
/*                                                                   */
/* Geschrieben von:         Gerhard Fischer (RDT-Gruppe)             */
/*                                                                   */
/* Gwidmet Gerhard Mller, David Knigseder und Franz Esberger       */
/*                                                                   */
/* Schler der Klasse 3CNL Jahrgang 1993 Nachrichtehtechnik am TGM   */
/*                                                                   */
/*********************************************************************/

#include <iostream.h>                    /* Einbinden der iostream.h */
#include <conio.h>                       /* Einbinden der conio.h    */
#include <math.h>                        /* Einbinden der math.h     */
#include <bios.h>                        /* Einbinden der bios.h     */


// Erstellen des globalen Variablensatzes
double Ue_min, Ue_max, Ua, Uspike, Ureserve, Uf;
double freq, freq0, Ia, Ia0, Idp, X, V_switch_off_max;
double Vswitch_off_min, Vswitch_off_max, D_min, D_max;
double Ip_min, Ip_min_mA, Ip_max, Ip_max_mA, H_min, H_max, Lp_min, Lp_min_mH; //Lp_max_mH, Lp_max;
double Usat, AL_Wert, AL_Wert0, le, le0, ns, np_min, N, etha, WERT0;  //np_max,
int Zeile, ENDE;
unsigned Druck;

double WERTE [19] =
{
  Ue_min, Ue_max, Ua, Uspike, Ureserve, Uf, X, N, le0, Ia0, AL_Wert0,
  Usat, etha, freq0, V_switch_off_max, le, Ia, AL_Wert, freq
};


// Ankndigung der Unterprogramme
void Eingabe(void);
void Sinnvoll(void);
void Berechnungsteil(void);
void Help(void);
void Quit(void);

// Unterprogramm fr die Werteeingabe
void Eingabe(void)
{
  char Frage;
  int ok;
  ok = 0;

  gotoxy(44,Zeile);
  cprintf("aktiv:_");
  gotoxy(51,Zeile);

  do
  {
    Druck = bioskey(1);

    if (Druck==0x5230 || Druck==0x4f31 || Druck==0x5032 || Druck==0x5133 || Druck==0x4b34
	|| Druck==0x4c35 || Druck==0x4d36 || Druck==0x4737 || Druck==0x4838 || Druck==0x4939
	|| Druck==0x0b30 || Druck==0x0231 || Druck==0x0332 || Druck==0x0433 || Druck==0x534
	|| Druck==0x0635 || Druck==0x0736 || Druck==0x0837 || Druck==0x0938 || Druck==0x0a39
	|| Druck==0x342e)
    {
      switch (Zeile)
      {
	case 4:
	  do
	  {
	    WERT0 = WERTE[0];
	    cin >> WERTE[0];

	    if (WERTE[0] <= WERTE[11])
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(5,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  Ue mu > Usat sein !");
	      gotoxy(51,4);
	      cprintf("       ");
	      gotoxy(51,4);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 5:
	  do
	  {
	    cin >> WERTE[1];
	    if (WERTE[1] <= WERTE[11])
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(5,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  Ue mu > Usat sein !");
	      gotoxy(51,5);
	      cprintf("       ");
	      gotoxy(51,5);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 6:
	  do
	  {
	    cin >> WERTE[2];
	    if (WERTE[2] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  Ua mu > 0 sein !");
	      gotoxy(51,6);
	      cprintf("       ");
	      gotoxy(51,6);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 7:
	  do
	  {
	    cin >> WERTE[3];
	    if (WERTE[3] < 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("FALSCHE EINGABE!    Uspike mu >= 0 sein !");
	      gotoxy(51,7);
	      cprintf("       ");
	      gotoxy(51,7);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 8:
	  do
	  {
	    cin >> WERTE[4];
	    if (WERTE[4] < 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("FALSCHE EINGABE!   Ureserve mu >= 0 sein !");
	      gotoxy(51,8);
	      cprintf("       ");
	      gotoxy(51,8);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 9:
	  do
	  {
	    cin >> WERTE[5];
	    if (WERTE[5] <= 0 || WERTE[5] >= 5)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(2,20);
	      cprintf("Sind Sie sicher, da Uf= %g V ist? NEIN=N, JA=Taste",WERTE[5]);
	      Frage = getch();
	      if (Frage == 'n' || Frage == 'N')
	      {
		gotoxy(51,9);
		cprintf("       ");
		gotoxy(51,9);
		ok = 0;
	      }
	      else
	      {
		textbackground(0);
		textcolor(13);
		gotoxy(2,20);
		cprintf("       'ESC' um die Berechnungen zu starten !            ");
		ok = 1;
	      }
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(2,20);
	      cprintf("       'ESC' um die Berechnungen zu starten !            ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 10:
	  do
	  {
	    cin >> WERTE[6];
	    if (WERTE[6] <= 0 || WERTE[6] >= 1)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("FALSCHE EINGABE!  X mu > 0 und <= 1 sein !");
	      gotoxy(51,10);
	      cprintf("       ");
	      gotoxy(51,10);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 11:
	  do
	  {
	    cin >> WERTE[7];
	    if (WERTE[7] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  N mu > 0 sein !");
	      gotoxy(51,11);
	      cprintf("       ");
	      gotoxy(51,11);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 12:
	  do
	  {
	    cin >> WERTE[8];
	    WERTE[15] = WERTE[8] / 1000;
	    if (WERTE[15] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  le mu > 0 sein !");
	      gotoxy(51,12);
	      cprintf("       ");
	      gotoxy(51,12);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 13:
	  do
	  {
	    cin >> WERTE[9];
	    WERTE[16] = WERTE[9] / 1000;
	    if (WERTE[9] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(5,20);
	      cprintf("ACHTUNG FALSCHE EINGABE!  Ia mu > 0 sein !");
	      gotoxy(51,13);
	      cprintf("       ");
	      gotoxy(51,13);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(4,20);
	      cprintf("     'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 14:
	  do
	  {
	    cin >> WERTE[10];
	    WERTE[17] = WERTE[10] / 10000000000;
	    if (WERTE[17] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(4,20);
	      cprintf("ACHTUNG FALSCHE EINGABE! AL_Wert mu > 0 sein !");
	      gotoxy(51,14);
	      cprintf("       ");
	      gotoxy(51,14);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(4,20);
	      cprintf("     'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 15:
	  do
	  {
	    cin >> WERTE[11];
	    if (WERTE[11] >= WERTE[0] || WERTE[11] >= WERTE[1] || WERTE[11] < 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("FALSCHE EINGABE! Usat mu <Ue aber >0 sein!");
	      gotoxy(51,15);
	      cprintf("       ");
	      gotoxy(51,15);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 16:
	  do
	  {
	    cin >> WERTE[12];
	    if (WERTE[12] <= 0 || WERTE[12] > 1)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(5,20);
	      cprintf("FALSCHE EINGABE! etha mu > 0 aber < 1 sein !");
	      gotoxy(51,16);
	      cprintf("       ");
	      gotoxy(51,16);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 17:
	  do
	  {
	    cin >> WERTE[13];
	    WERTE[18] = WERTE[13] * 1000;
	    if (WERTE[18] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(6,20);
	      cprintf("ACHTUNG FALSCHE EINGABE! freq mu > 0 sein !");
	      gotoxy(51,17);
	      cprintf("       ");
	      gotoxy(51,17);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(5,20);
	      cprintf("    'ESC' um die Berechnungen zu starten !    ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;

	case 18:
	  do
	  {
	    cin >> WERTE[14];
	    if (WERTE[14] <= 0)
	    {
	      textbackground(0);
	      textcolor(140);
	      gotoxy(4,20);
	      cprintf("FALSCHE EINGABE! V_switch_off_max mu > 0 sein !");
	      gotoxy(51,18);
	      cprintf("       ");
	      gotoxy(51,18);
	      ok = 0;
	    }
	    else
	    {
	      textbackground(0);
	      textcolor(13);
	      gotoxy(4,20);
	      cprintf("     'ESC' um die Berechnungen zu starten !     ");
	      ok = 1;
	    }
	  }
	  while (ok != 1);
	  break;
      }
    }
    if (ok == 1)
      Druck = 0x3920;
  }
  while(Druck==0 || Druck==0x5230 || Druck==0x4f31 || Druck==0x5032 || Druck==0x5133 || Druck==0x4b34
		 || Druck==0x4c35 || Druck==0x4d36 || Druck==0x4737 || Druck==0x4838 || Druck==0x4939
		 || Druck==0x0b30 || Druck==0x0231 || Druck==0x0332 || Druck==0x0433 || Druck==0x534
		 || Druck==0x0635 || Druck==0x0736 || Druck==0x0837 || Druck==0x0938 || Druck==0x0a39
		 || Druck==0x342e);

  gotoxy(44,Zeile);
  textbackground(0);
  textcolor(2);
  cprintf("       ");
  gotoxy(44,Zeile);
}


// Berechnung und Ausgabe auf dem Schirm bei nicht sinnvollen Eingaben
void Sinnvoll(void)
{
  int Code;
  Code = 0;

  if (WERTE[0] >= WERTE[1])
    Code = 1;

  if (WERTE[2] > WERTE[1])
    Code = Code + 2;

  if (WERTE[3] > 10)
    Code = Code + 4;

  if (WERTE[4] > 10)
    Code = Code + 8;

  if (Code != 0)
  {
    textbackground(0);
    clrscr();
    textbackground(4);
    textcolor(4);
    gotoxy(1,7);
    cprintf("                                                                                                                                                                                                                                                                                                                                                                                                                \n");
    gotoxy(1,12);
    cprintf("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \n");
    textbackground(7);
    gotoxy(16,8);
    cprintf(" ACHTUNG! ۲ WARNUNG! ");
    textbackground(4);
    textcolor(7);

    if (Code==1 || Code==3 || Code==5 || Code==7 ||
	Code==9 || Code==11 || Code==13 || Code==15)
    {
      gotoxy(2,10);
      cprintf("Die eingegebene Ue_min ist 'g r   e r', oder 'gleich gro' wie die Ue_max ?!");
    }

    if (Code==2 || Code==3 || Code==6 || Code==7 ||
	Code==10 || Code==11 || Code==14 || Code==15)
    {
      gotoxy(6,12);
      cprintf("Die gewnschte Ausgangsspannung Ua ist  'g r   e r'  als die Ue ?!");
    }

    if (Code>3 && Code<8 || Code>11 && Code<16)
    {
      gotoxy(11,14);
      cprintf("Just for info! Die Uspike ist grer 10V. ??? Sinnvoll ???");
    }

    if (Code > 7 && Code < 16)
    {
      gotoxy(15,16);
      cprintf("Die Ureserve ist grer 10V.  Ist das Ihr Wunsch ?");
    }

    getch();
  }
}


// Berechnungsteil=> Berechnung des Flybackconverters
void Berechnungsteil(void)
{
  Ue_min   = WERTE[0];
  Ue_max   = WERTE[1];
  Ua       = WERTE[2];
  Uspike   = WERTE[3];
  Ureserve = WERTE[4];
  Uf       = WERTE[5];
  X        = WERTE[6];
  N        = WERTE[7];
  le       = WERTE[15];
  Ia       = WERTE[16];
  AL_Wert  = WERTE[17];
  Usat     = WERTE[11];
  etha     = WERTE[12];
  freq     = WERTE[18];

  //BERPRFUNG DER WERTE AUF SINNLOSIGKEIT ! IM UNTERPRG SINNVOLL!


  Sinnvoll();


  Vswitch_off_min = (Ue_min + (Ua + Uf) / N);

  D_min = (Ua + Uf) / (N * (Ue_min - Usat) +Ua +Uf);

  Ip_min = (2 * (N/etha) * (Ia/(1-D_min))) / (2 - X);

  Lp_min = (D_min * (Ue_min - Usat)) / (X * Ip_min * freq);

  np_min = sqrt (Lp_min / AL_Wert);

  H_min  = (Ip_min * np_min) / le;



  Vswitch_off_max = (Ue_max + (Ua + Uf) / N);

  D_max = (Ua + Uf) / (N * (Ue_max - Usat) +Ua +Uf);

  Ip_max = (2 * (N/etha) * (Ia/(1-D_max))) / (2 - X);

  H_max  = (Ip_max * np_min) / le;
}


// Hilfe fr die Bentzung von Flyaway
void Help(void)
{
  textbackground(3);
  clrscr();
  textcolor(0);
  gotoxy(27,1);
  cprintf("ͻ");
  gotoxy(27,2);
  cprintf("      HILFE - INFO      ");
  gotoxy(27,3);
  cprintf("ͼ");
  gotoxy(2,5);
  cprintf("Diese Programm dient zur Berechnung versch. Flyback-Converter (Sperrwandler),");
  gotoxy(2,6);
  cprintf("fr die folgende Formeln gelten.");
  gotoxy(2,7);
  cprintf("Allgemein: V_switch_off = (Ue + (Ua + Uf) / N)");
  gotoxy(2,9);
  cprintf("          Dutycycle = D = (Ua Uf) / (N * (Ue - Usat) + Ua +Uf)");
  gotoxy(2,11);
  cprintf("         ==>  [A]    Ip = (N / etha) * (I_load / (1-D)) + (delta_Ip * Ip) / 2");
  gotoxy(2,12);
  cprintf("         wobei delta_Ip = Ip * X");
  gotoxy(2,13);
  cprintf("         ==>  [A]    Ip = (2 * (N / etha) * (I_load / (1-D))) / (2 - X)");
  gotoxy(2,15);
  cprintf("         ==>  [mH]   Lp = (D * (Ue - Usat)) / (X * Ip * freq)");
  gotoxy(2,17);
  cprintf("         ==>  [Wdg]  np = WURZEL AUS (Lp / AL_Wert)");
  gotoxy(2,19);
  cprintf("         ==>  [A/m]   H = (Ip * np) / le");
  gotoxy(2,21);
  cprintf("Die obigen Rechnungen werden teilweise mit Ue_min und Ue_max durchgefhrt.");
  gotoxy(2,23);
  cprintf("I_load = Ia = Ausgangsstrom;     Lp = primr Induktivitt;");
  gotoxy(2,24);
  cprintf(" H = magnetische Feldstrke;     np = primr Windungszahl;");
  textcolor(128);
  gotoxy(26,25);
  cprintf("T A S T E  D R  C K E N !!!");
  getch();

  clrscr();
  textcolor(0);
  gotoxy(27,1);
  cprintf("ͻ");
  gotoxy(27,2);
  cprintf("      HILFE - INFO      ");
  gotoxy(27,3);
  cprintf("ͼ");

  gotoxy(1,4);
  cprintf("Bei kleinster Ue ist die Spg. gemeint, welche min. anliegt.   Ue (mu) > Usat !");
  gotoxy(1,5);
  cprintf("Bei grter Ue ist die Spg. gemeint welche max. am Eingang anliegt.");
  gotoxy(1,6);
  cprintf("Mit Spikegre sind die Spg.spitzen die max. auftreten knnen gemeint.(max. 10V)");
  gotoxy(1,7);
  cprintf("Die Ureserve gibt die Spg. an welche zur Sicherheit des Trans. eingerechnet wird.");
  gotoxy(1,8);
  cprintf("Uf ist die Fluspg der Diode in der Schaltung. (ca. 1V)");
  gotoxy(1,9);
  cprintf("N gibt das Windungsverhltnis zwischen der primren und sekundren Windungen an.");
  gotoxy(1,10);
  cprintf("le steht fr die wirksame Magnetfeldlnge des Eisenkerns. ACHTUNG in mm !");
  gotoxy(1,11);
  cprintf("Usat ist die Sttigunsspg. des Transistors.");
  gotoxy(1,12);
  cprintf("Die 'freq' des IC's, erfhrt man wie viele andere Werte aus dem Datenbuch !!!");
  gotoxy(1,13);
  cprintf("Die V_switch_off_max [V] (aus DB) darf im Betrieb nicht berschritten werden !");
  gotoxy(1,15);
  cprintf("");
  gotoxy(14,16);
  cprintf("FLYAWAY ist ein Produkt der FISCHER GERHARD SOFT '93");
  gotoxy(5,18);
  cprintf("Entwickelt wurde dieses Prg. fr die Berechnungen des Flyback-Converters");
  gotoxy(5,19);
  cprintf("welcher im Rahmen des FTKL-Projekts des Jahrganges 3CNL  SS'93 entworfen");
  gotoxy(33,20);
  cprintf("werden sollte. ");
  gotoxy(6,21);
  cprintf("Dieses Programm ist ein Beitrag der RDT-Gruppe zum allgemeinen Teil");
  gotoxy(27,22);
  cprintf("der Projektarbeit in FTKL.");
  gotoxy(2,23);
  cprintf(" RDT-Gruppe: Franz Esberger, Gerhard Fischer, David Knigseder, Gerhard Mller");
  textcolor(128);
  gotoxy(26,25);
  cprintf("T A S T E  D R  C K E N !!!");
  getch();
}

// Bei Druck der Taste 'E' wird Quit aufgerufen und lt sich
// den gewnschten Programmabbruch mit 'Q' besttigen
void Quit(void)
{
  char Schluss;
  textbackground(0);
  clrscr();
  textcolor(12);
  gotoxy(15,12);
  cprintf("Sind Sie sicher, da Sie Programm beenden wollen ?");
  gotoxy(15,14);
  cprintf(" 'Q' = Quit         Andere Taste ist 'Fortsetzen'");
  Schluss = getch();
  if (Schluss == 'Q' || Schluss == 'q')
    ENDE = 1;
  else
    ENDE = 0;
}

// Beginn des Hauptprogrammes
void main(void)
{
  char Taste;
  unsigned key, Wahl;
  int Zeilealt, counter, Helpaktiv, Prgaktiv;
  int Block, Zahlalt, Zahl, counter0, AUS;

  WERTE[0]  = 10;
  WERTE[1]  = 20;
  WERTE[3]  = 10;
  WERTE[4]  = 10;
  WERTE[5]  = 1;
  WERTE[6]  = 0.3;
  WERTE[7]  = 1;
  WERTE[8]  = 0.1;
  WERTE[9]  = 100;
  WERTE[10] = 100;
  WERTE[11] = 0.5;
  WERTE[12] = 0.95;
  WERTE[13] = 52;
  WERTE[15] = WERTE[8] / 1000;
  WERTE[16] = WERTE[9] / 1000;
  WERTE[17] = WERTE[10] / 1000000000;
  WERTE[18] = 52000;

  Block    = 1;
  Zahl     = 0;
  Zahlalt  = 34;
  counter0 = 0;
  AUS      = 0;

  //Teil 1
  do
  {
  ENDE = 0;
  Prgaktiv = 0;
  counter0 = 0;

  // Anfangsbild mit Hauptmen
  textbackground(0);
  clrscr();
  textcolor(11);
  gotoxy(1,5);
  cprintf(" ͻ ͻ    ͻ  ͻ ͻ ͻ        ͻ ͻ ͻ  ͻ");
  textcolor(11);
  gotoxy(1,6);
  cprintf("   ͼ                ͻ                  ͻ         ");
  textcolor(9);
  gotoxy(1,7);
  cprintf("   ͻ         ͼ     ͼ       ͻ       ͼ     ͼ  ");
  textcolor(9);
  gotoxy(1,8);
  cprintf("   ͼ       ͻ  ͼ   ͻ                ͻ   ͻ  ͼ");
  textcolor(1);
  gotoxy(1,9);
  cprintf("                                                    ");
  textcolor(1);
  gotoxy(1,10);
  cprintf("           ͻ                ͼ  ͼ              ");
  textcolor(1);
  gotoxy(1,11);
  cprintf(" ͼ      ͼ  ͼ    ͼ ͼ ͼ ͼ ͼ    ͼ");
  textcolor(11);
  gotoxy(1,13);
  cprintf("  F L Y B A C K - C O N V E R T E R - B E R E C H N U N G S P R O G R A M M");
  gotoxy(21,19);
  cprintf("programmed by FISCHER GERHARD SOFT '93");

  textcolor(3);
  textbackground(0);

  gotoxy(14,24);
  cprintf("HILFE / INFO");
  gotoxy(34,24);
  cprintf(" BEARBEITEN ");
  gotoxy(54,24);
  cprintf("    QUIT    ");


  do
  {
  Wahl = bioskey(1);

    if (Wahl != 0 || counter0 == 0)
    {
      if (counter0 != 0)
	  Wahl = bioskey(0);
	else
	  Wahl = 0x3920;

      switch (Wahl)
      {
	case 0x4b00: case 0x4b34:
	  Block = Block - 1;
	  break;

	case 0x4d00: case 0x4d36:
	  Block = Block + 1;
	  break;

	case 0x1c0d:
	  if (Block == 1)
	    Help();
	  if (Block == 2)
	  {
	    Wahl = 0x011b;
	    ENDE = 2;
	  }
	  if (Block == 3)
	    Quit();

	  Prgaktiv = 1;
	  break;

      }
      if (Block == 0)
	Block = 3;
      if (Block == 4)
	Block = 1;

       if (Block == 1)
	 Zahl = 14;
       if (Block == 2)
	 Zahl = 34;
       if (Block == 3)
	 Zahl = 54;


  gotoxy(Zahlalt,24);
  textcolor(3);
  textbackground(0);
  if (Zahlalt == 14)
    cprintf("HILFE / INFO");
  if (Zahlalt == 34)
    cprintf(" BEARBEITEN ");
  if (Zahlalt == 54)
    cprintf("    QUIT    ");


  textcolor(0);
  textbackground(3);
  gotoxy(Zahl,24);
  if (Block == 1)
    cprintf("HILFE / INFO");
  if (Block == 2)
    cprintf(" BEARBEITEN ");
  if (Block == 3)
    cprintf("    QUIT    ");

    Zahlalt = Zahl;
    }
  counter0 = 1;
  if (ENDE == 1 || ENDE == 2)
  {
    Wahl = 0x011b;
    AUS = 1;
  }

  if (Prgaktiv == 1)
    Wahl = 0x011b;

  }
  while(Wahl != 0x011b);

  }
  while(AUS != 1);


  // Teil2
  Zeile     = 4;
  Zeilealt  = 0;
  counter   = 0;
  Helpaktiv = 0;


  if (ENDE != 1)
  {
  do
  {
    textbackground(0);
    clrscr();

    // RAHMEN-GRAPHIK
    textcolor(14);
    gotoxy(1,1);
    cprintf("ͻ");
    gotoxy(1,2);
    cprintf("                                                                              ");
    gotoxy(1,3);
    cprintf("͹");
    gotoxy(1,4);
    cprintf("                                                                             ");
    gotoxy(1,5);
    cprintf("                                                                             ");
    gotoxy(1,6);
    cprintf("                                                                             ");
    gotoxy(1,7);
    cprintf("                                                                             ");
    gotoxy(1,8);
    cprintf("                                                                             ");
    gotoxy(1,9);
    cprintf("                                                                             ");
    gotoxy(1,10);
    cprintf("                                                                             ");
    gotoxy(1,11);
    cprintf("                                                                             ");
    gotoxy(1,12);
    cprintf("                                                                             ");
    gotoxy(1,13);
    cprintf("                                                                             ");
    gotoxy(1,14);
    cprintf("                                                                             ");
    gotoxy(1,15);
    cprintf("                                                                             ");
    gotoxy(1,16);
    cprintf("                                                                             ");
    gotoxy(1,17);
    cprintf("                                                                             ");
    gotoxy(1,18);
    cprintf("                                                                             ");
    gotoxy(1,19);
    cprintf("͹");
    gotoxy(1,20);
    cprintf("                                                                             ");
    gotoxy(1,21);
    cprintf("͹");
    gotoxy(1,22);
    cprintf("                                                                              ");
    gotoxy(1,23);
    cprintf("                                                                              ");
    gotoxy(1,24);
    cprintf("ͼ");


    //SCHRIFT FR RAHMEN
    gotoxy(16,2);
    textcolor(11);
    cprintf("FLYAWAY    Flyback Converter-Berechnungsprogramm");
    textcolor(2);

    gotoxy(2,4);
    cprintf("Kleinste Eingangsspg. [V]        Ue_min = ");

    gotoxy(2,5);
    cprintf("Grte Eingangsspg. [V]          Ue_max = ");

    gotoxy(2,6);
    cprintf("Gewnschte Ausgangsspg. [V]          Ua = ");

    gotoxy(2,7);
    cprintf("Max. Spikesgre [V]             Uspike = ");

    gotoxy(2,8);
    cprintf("Spg.dif. zur V_switch_off  [V] Ureserve = ");

    gotoxy(2,9);
    cprintf("Fluspg. der Diode [V]               Uf = ");

    gotoxy(2,10);
    cprintf("Delta Ip = X * Ip;  (zB 0.3)   ==>    X = ");

    gotoxy(2,11);
    cprintf("Windungsverhltnis  ns/np=N    ==>    N = ");

    gotoxy(2,12);
    cprintf("Wirksame Lnge des Eisenkerns   [mm] le = ");

    gotoxy(2,13);
    cprintf("Summe der I_load [mA]  ==>           Ia = ");

    gotoxy(2,14);
    cprintf("AL_Wert in nanoHenry [nH]       AL_Wert = ");

    textcolor(4);
    gotoxy(2,15);
    cprintf("Stigungsspg. des Transistors [V]  Usat = ");

    gotoxy(2,16);
    cprintf("Transform Efficient Typ. (zB 0.95) etha = ");

    gotoxy(2,17);
    cprintf("Freq. des IC (LM2577=52kHz) [kHz]  freq = ");

    gotoxy(2,18);
    cprintf("V_switch_off_max des Transistors    [V] = ");



    // AUSGABE DER EINGESTELLTEN WERTE AUF DEM EINGABESCHIRM
    gotoxy(62,4);
    textcolor(10);
    cprintf("%g V",WERTE[0]);

    gotoxy(62,5);
    cprintf("%g V",WERTE[1]);

    gotoxy(62,6);
    cprintf("%g V",WERTE[2]);

    gotoxy(62,7);
    cprintf("%g V",WERTE[3]);

    gotoxy(62,8);
    cprintf("%g V",WERTE[4]);

    gotoxy(62,9);
    cprintf("%g V",WERTE[5]);

    gotoxy(62,10);
    cprintf("%g",WERTE[6]);

    gotoxy(62,11);
    cprintf("%g",WERTE[7]);

    gotoxy(62,12);
    cprintf("%g mm",WERTE[8]);

    gotoxy(62,13);
    cprintf("%g mA",WERTE[9]);

    gotoxy(62,14);
    cprintf("%g nH",WERTE[10]);

    textcolor(12);
    gotoxy(62,15);
    cprintf("%g V",WERTE[11]);

    gotoxy(62,16);
    cprintf("%g",WERTE[12]);

    gotoxy(62,17);
    cprintf("%g kHz",WERTE[13]);

    gotoxy(62,18);
    cprintf("%g V",WERTE[14]);


    // INFOS AUF EINGABESCHIRM
    textcolor(13);
    gotoxy(9,20);
    cprintf("'ESC' um die Berechnungen zu starten !");

    gotoxy(62,20);
    cprintf("'H' = Hilfe/Info");

    textcolor(11);
    gotoxy(23,22);
    cprintf("FTKL-Projekt '93        RDT-Gruppe");

    gotoxy(23,23);
    cprintf("programmed by Fischer Gerhard 1993");


    do
    {
      Helpaktiv = 0;
      key = bioskey(1);

      if (key != 0 || counter == 0)
      {
	if (counter != 0)
	  key = bioskey(0);
	else
	  key = 0x3920;

	switch (key)
	{
	  case 0x4800: case 0x4838:
	    Zeile = Zeile - 1;
	    break;

	  case 0x5000: case 0x5032:
	    Zeile = Zeile + 1;
	    break;

	  case 0x1c0d:
	    Eingabe();
	    break;

	  case 0x2368: case 0x2348:
	    Help();
	    Helpaktiv = 1;
	    break;
	}

	if (Helpaktiv == 0)
	{
	counter = 1;

	if (Zeile == 19)
	  Zeile = 4;
	if (Zeile == 3)
	  Zeile = 18;

	gotoxy(2,Zeilealt);

	if (Zeilealt < 15)
	  textcolor(2);
	else
	  textcolor(4);

	textbackground(0);

	if (Zeilealt == 4)
	  cprintf("Kleinste Eingangsspg. [V]        Ue_min = ");
	if (Zeilealt == 5)
	  cprintf("Grte Eingangsspg. [V]          Ue_max = ");
	if (Zeilealt == 6)
	  cprintf("Gewnschte Ausgangsspg. [V]          Ua = ");
	if (Zeilealt == 7)
	  cprintf("Max. Spikesgre [V]             Uspike = ");
	if (Zeilealt == 8)
	  cprintf("Spg.dif. zur V_switch_off  [V] Ureserve = ");
	if (Zeilealt == 9)
	  cprintf("Fluspg. der Diode [V]               Uf = ");
	if (Zeilealt == 10)
	  cprintf("Delta Ip = X * Ip;  (zB 0.3)   ==>    X = ");
	if (Zeilealt == 11)
	  cprintf("Windungsverhltnis  ns/np=N    ==>    N = ");
	if (Zeilealt == 12)
	  cprintf("Wirksame Lnge des Eisenkerns   [mm] le = ");
	if (Zeilealt == 13)
	  cprintf("Summe der I_load [mA]  ==>           Ia = ");
	if (Zeilealt == 14)
	  cprintf("AL_Wert in nanoHenry [nH]       AL_Wert = ");
	if (Zeilealt == 15)
	  cprintf("Stigungsspg. des Transistors [V]  Usat = ");
	if (Zeilealt == 16)
	  cprintf("Transform Efficient Typ. (zB 0.95) etha = ");
	if (Zeilealt == 17)
	  cprintf("Freq. des IC (LM2577=52kHz) [kHz]  freq = ");
	if (Zeilealt == 18)
	  cprintf("V_switch_off_max des Transistors    [V] = ");


	textcolor(0);
	textbackground(3);

	gotoxy(2,Zeile);

	if (Zeile < 15)
	  textbackground(2);
	else
	  textbackground(4);

	textcolor(0);

	if (Zeile == 4)
	  cprintf("Kleinste Eingangsspg. [V]        Ue_min = ");
	if (Zeile == 5)
	  cprintf("Grte Eingangsspg. [V]          Ue_max = ");
	if (Zeile == 6)
	  cprintf("Gewnschte Ausgangsspg. [V]          Ua = ");
	if (Zeile == 7)
	  cprintf("Max. Spikesgre [V]             Uspike = ");
	if (Zeile == 8)
	  cprintf("Spg.dif. zur V_switch_off  [V] Ureserve = ");
	if (Zeile == 9)
	  cprintf("Fluspg. der Diode [V]               Uf = ");
	if (Zeile == 10)
	  cprintf("Delta Ip = X * Ip;  (zB 0.3)   ==>    X = ");
	if (Zeile == 11)
	  cprintf("Windungsverhltnis  ns/np=N    ==>    N = ");
	if (Zeile == 12)
	  cprintf("Wirksame Lnge des Eisenkerns   [mm] le = ");
	if (Zeile == 13)
	  cprintf("Summe der I_load [mA]  ==>           Ia = ");
	if (Zeile == 14)
	  cprintf("AL_Wert in nanoHenry [nH]       AL_Wert = ");
	if (Zeile == 15)
	  cprintf("Stigungsspg. des Transistors [V]  Usat = ");
	if (Zeile == 16)
	  cprintf("Transform Efficient Typ. (zB 0.95) etha = ");
	if (Zeile == 17)
	  cprintf("Freq. des IC (LM2577=52kHz) [kHz]  freq = ");
	if (Zeile == 18)
	  cprintf("V_switch_off_max des Transistors    [V] = ");

	}
	Zeilealt = Zeile;
      }
      if (Helpaktiv == 1)
	key = 0x011b;

    }
    while(key != 0x011b);
    counter = 0;

    if (Helpaktiv == 0)
    {

      Berechnungsteil();

      textbackground(0);
      clrscr();
      gotoxy(16,1);
      textcolor(11);
      cprintf("FLYAWAY    Flyback Converter-Berechnungsprogramm");

      // BILDSCHIRMAUSGABE DER UE_MIN WERTE
      textcolor(13);
      gotoxy(1,4);
      cprintf("Rechenwerte mit Ue_min !!!");

      textcolor(14);
      gotoxy(1,6);
      cprintf("    Vswitch_off =  %g V",Vswitch_off_min);

      gotoxy(1,7);
      cprintf("          D_min =  %6.6f",D_min);

      gotoxy(1,8);
      Ip_min_mA = Ip_min * 1000;
      cprintf("         Ip_min =  %6.6f mA",Ip_min_mA);

      gotoxy(1,9);
      cprintf("          H_min =  %6.4f A/m; Thesla",H_min);

      gotoxy(9,12);
      textcolor(140);

      if (WERTE[14] < Vswitch_off_min)
      {
	cprintf("A C H T U N G !");
	gotoxy(1,14);
	cprintf("V_switch_off_max berschritten !");
      }
      else
      {
	if (WERTE[14] < (Vswitch_off_min + WERTE[3] + WERTE[4]))
	{
	  cprintf("   A C H T U N G !");
	  gotoxy(1,14);
	  cprintf("V_switch_off_max - Kritischer Bereich!");
	}
      }
      textcolor(13);

      // BILDSCHIRMAUSGABE DER UE_MAX WERTE
      gotoxy(40,4);
      cprintf("Rechenwerte mit Ue_max !!!");

      textcolor(14);
      gotoxy(40,6);
      cprintf("    Vswitch_off =  %g V",Vswitch_off_max);

      gotoxy(50,7);
      cprintf("D_max =  %6.6f",D_max);

      gotoxy(49,8);
      Ip_max_mA = Ip_max * 1000;
      cprintf("Ip_max =  %6.6f mA",Ip_max_mA);

      /* gotoxy(49,9);
      Lp_max_mH = Lp_max * 1000;
      cprintf("Lp_max =  %6.6f mH",Lp_max_mH);

      gotoxy(49,10);
      cprintf("np_max =  %6.4f Wdg",np_max);
      */

      gotoxy(50,9);
      cprintf("H_max =  %6.4f A/m;Thesla",H_max);

      gotoxy(49,12);
      textcolor(140);

      if (WERTE[14] < Vswitch_off_max)
      {
	cprintf("A C H T U N G !");
	gotoxy(42,14);
	cprintf("V_switch_off_max berschritten !");
      }
      else
      {
	if (WERTE[14] < (Vswitch_off_max + WERTE[3] + WERTE[4]))
	{
	  cprintf("   A C H T U N G !");
	  gotoxy(41,14);
	  cprintf("V_switch_off_max - Kritischer Bereich!");
	}
      }


      // BILDSCHIRMAUSGABE DER ALLGEMEINWERTE
      gotoxy(32,17);
      textcolor(13);
      cprintf("Allgemeine Werte:");

      gotoxy(32,19);
      textcolor(14);
      Lp_min_mH = Lp_min * 1000;
      cprintf("Lp =  %6.6f mH",Lp_min_mH);

      gotoxy(32,20);
      cprintf("np =  %6.4f Wdg",np_min);

      textcolor(11);
      gotoxy(15,23);
      cprintf("ͻ");
      gotoxy(15,24);
      cprintf("                                                ");
      gotoxy(15,25);
      cprintf("ͼ");



      textcolor(12);
      gotoxy(23,24);
      cprintf("Ende = 'E'");
      gotoxy(44,24);
      textcolor(10);
      cprintf("Nocheinmal = Taste");
      Taste = getch();
      if (Taste == 'E' || Taste == 'e')
	Quit();
    }
  }
  while(ENDE != 1);

  // DOS EINGABEAUFFORDERUNGSEBENE - SCHLUSSBILD
  }
  textbackground(0);
  clrscr();
  textcolor(7);
  gotoxy(10,1);
  cprintf("ͻ");
  gotoxy(10,2);
  cprintf("    A u f w i e d e r s e h e n    im    F L Y A W A Y    ");
  gotoxy(10,3);
  cprintf("                                                          ");
  gotoxy(10,4);
  cprintf("                       wnscht  die                       ");
  gotoxy(10,5);
  cprintf("                                                          ");
  gotoxy(10,6);
  cprintf("                   R D T - G R U P P E                    ");
  gotoxy(10,7);
  cprintf("                                                          ");
  gotoxy(10,8);
  cprintf("   Gerhard Mller, David Knigseder, Franz Esberger und   ");
  gotoxy(10,9);
  cprintf("                     Gerhard Fischer                      ");
  gotoxy(10,10);
  cprintf("                                                          ");
  gotoxy(10,11);
  cprintf("ͼ\n\n\n");

}
// PROGRAMMENDE
