PROGRAM KirchhoffWuerfel;


USES CRT;


CONST  MaximaleAnzahlDerKnoten = 50;
       Faktor=2; {Multiplikator fr die Sternchengrafik um
                 Bildschirm mglichst zu fllen}

VAR Strom,
    Leitwert :ARRAY [1..MaximaleAnzahlDerKnoten, 1..MaximaleAnzahlDerKnoten]
              OF REAL;
    Potential:ARRAY [1..MaximaleAnzahlDerKnoten] OF REAL;

    AnzahlDerKnoten,
    Potknoten1, Potknoten2: INTEGER; {Knotennummern und Potentialhhen fr}
    Pothoehe1,  Pothoehe2,           {fixe Potentiale in Schalutngsgenerator}
    Deltapotential:         REAL;    {Wert der Erhhung des Anfangspotential}

    Ende,                {Wenn true, dann Beendigung des Programms}
    Grafik : BOOLEAN;    {Wenn true, dann Sternchengrafik andernfalls
                         Zahlenwerte}

    Schaltung: CHAR;  {Abfrage fr Schaltungsgenerator}


PROCEDURE NullSetzenAllerWerte;
{*****************************}
{Hier werden alle Strme, Leitwerte und Spanungen aller mglichen
Schaltungen auf 0 gesetzt.}
VAR i,j: INTEGER;
BEGIN FOR i:=1 TO MaximaleAnzahlDerKnoten DO
          BEGIN FOR j:=1 TO MaximaleAnzahlDerKnoten DO
                    BEGIN Leitwert [i,j]:=0;
                          Strom    [i,j]:=0;
                    END;
                Potential [i]:=0;
          END;
END;


PROCEDURE UnveraenderlichePotentiale;
{***********************************}
{Hier werden die unvernderlichen Potentiale der Schaltung festgelegt.}
BEGIN Potential[1]:=10 + Deltapotential;
      Potential[7]:=0;
END;


FUNCTION AenderungDesPotential(KnotenStrom:real):REAL;
{****************************************************}
{Hier wird in Abhngigkeit des Knotenstromes die Potentialnderung
berechnet}
BEGIN AenderungDesPotential:=0.1 * Knotenstrom;
END;


PROCEDURE PotentialBerechnung (KnotenStrom: REAL;Knoten: INTEGER) ;
{*****************************************************************}
{Hier wird das Potential der Knoten verndert}
BEGIN
  Potential[Knoten]:=Potential[Knoten] -AenderungDesPotential(KnotenStrom);
END;


PROCEDURE SchaltungFestlegen;
{***************************}
{Hier werden alle Leitwerte zwischen zwei Knotenpunkten der Schaltung
festgelegt. Die nicht aufgelisteten Vebindungen haben den Wert 0 und
stellen somit Unterbrechungen dar.}
BEGIN Leitwert[1,2]:=1;
      Leitwert[2,3]:=1;     {Schaltung bei der an den Kanten eines }
      Leitwert[3,4]:=1;     {Wrfels Widerstnde angebracht sind}
      Leitwert[1,4]:=1;
      Leitwert[5,6]:=1;
      Leitwert[6,7]:=1;
      Leitwert[7,8]:=1;
      Leitwert[5,8]:=1;
      Leitwert[1,5]:=1;
      Leitwert[2,6]:=1;
      Leitwert[3,7]:=1;
      Leitwert[4,8]:=1;
END;


PROCEDURE Initialisieren;
{***********************}
{Initialisiert alle vorkommenden Variablen}
BEGIN
  NullSetzenAllerWerte;       {Alle physik. Werte werden Null gesetzt.}
  Deltapotential:=0;          {Anfangs ist keine Potentialnderung.}
  Ende:=FALSE;                {Abbruchbedingung auf falsch gesetzt.}
END;


PROCEDURE KirchoffWuerfel;
{Demobeispiel fr Wrfelschaltung}
BEGIN SchaltungFestlegen;
      AnzahlDerKnoten:=8;
      UnveraenderlichePotentiale;
END;


PROCEDURE StroemeBerechnen;
{*************************}
{Berechnet die Strme der Schaltung auf I=G*U Basis}
VAR x,y,z: INTEGER;
BEGIN FOR x := 1 TO AnzahlDerKnoten DO
          Begin FOR y := x TO AnzahlDerKnoten-1 DO
                    BEGIN z:= y+1 ;
                          Strom[x,z] := (Potential[x]-Potential[z]) *
                          Leitwert  [x,z];
                          Strom[z,x] := Strom [x,z]  *(-1);
                    END;
          END;
END;


PROCEDURE AusgabeDerErgebnisse;
{*****************************}
{Gibt die Ergebnisse entweder als Grafik oder Zahlenwert aus}
VAR x,i,j, Multiplikator: INTEGER;
BEGIN
IF Grafik
    THEN BEGIN
           FOR  i:=1 TO AnzahlDerKnoten DO
           BEGIN
                GOTOXY (8,8+i);
                WRITE ('Potential ',i,'  ');
                x:= ROUND (Potential[i]*Faktor);
                GOTOXY (23,8+i);
                FOR j:=1 TO x DO WRITE ('');
                FOR j:=1 TO 74-x DO WRITE (' '); {Um alle nachkommenden
                                                  Zeichen zu lschen}
                WRITELN;
           END;
         END
    ELSE BEGIN
           FOR i:=1 TO AnzahlDerKnoten DO
           BEGIN
                 GOTOXY (1,7+i);
                 WRITE ('                        ');
                 GOTOXY (25,8+i);
                 WRITELN ('Potential  ',i,'                                              ');
                 GOTOXY (39,8+i);
                 WRITELN (' = ',Potential[i]:7:3,' V');
                 GOTOXY (47,9+i);
                 WRITE ('                                                          ');
           END;
    END;
END;


PROCEDURE Tastaturbefehle;
{************************}
BEGIN CASE READKEY OF 'e','E' : Ende:= TRUE;
                      '+'     : Deltapotential:=deltapotential+1;
                      '-'     : Deltapotential:=deltapotential-1;
                      'g','G' : Grafik:= TRUE;
                      'z','Z' : Grafik:= FALSE;
      END;
END;


PROCEDURE Befehlsuebersicht;
{**************************}
BEGIN CLRSCR;
      WRITELN ('                               Befehlsbersicht');
      WRITELN ('                               ');
      WRITELN ('Heben  des Potential 1: +');
      WRITELN ('Senken des Potential 1: -');
      WRITELN ('Beenden des Programms : e oder E');
      WRITELN ('Grafikausgabe: g oder G');
      WRITELN ('Zahlenausgabe: z oder Z');
END;


PROCEDURE KnotenGenerieren;
{*************************}
{Liest die Anzahl der Knoten in selbstgebauter Schaltung}
BEGIN WRITELN ('Geben Sie die Anzahl der Knoten des Netzwerkes an!');
      READLN (AnzahlderKnoten);
      WRITELN;
END;


PROCEDURE Netzwerkgenerieren;
{***************************}
{Liest die Widerstandsverbindungen in selbstgebauter Schaltung ein}
VAR Knoten1, Knoten2: Integer;
    BetragDesLeitwerts: REAL;
    KeineNeuenVerbindungen: Char;
BEGIN WRITELN ('Geben Sie nun die zwei Knotenpunkte der Verbindung und deren');
      WRITELN ('Leitwert an.');
      REPEAT WRITELN ('Leitwert zwischen Knoten i und Knoten j ist g Siemens.');
             WRITE ('i = ');
             READLN (Knoten1);
             WRITE ('j = ');
             READLN (Knoten2);
             WRITE ('g = ');
             READLN (BetragDesLeitwerts);
             Leitwert [Knoten1,Knoten2]:=BetragDesLeitwerts;
             WRITELN;
             WRITELN ('Weitere Verbindungen (J/N)');
             READLN  (KeineNeuenVerbindungen);
      UNTIL KeineNeuenVerbindungen ='n';
END;


PROCEDURE PotGenerieren;
{**********************}
{Liest die fixen Potentiale der selbstgebauten Schaltung ein}
BEGIN WRITELN;
      WRITELN ('Bitte geben Sie nun die 2 fixen Potentiale ein.');
      WRITELN;
      WRITELN ('Knotennummer des 1. fixen Potentials: ');
      READLN (PotKnoten1);
      WRITELN;
      WRITELN ('Knotennummer der 2. fixen Potentials: ');
      READLN (Potknoten2);
      WRITELN;
      WRITELN ('Geben Sie nun die Hhe (in V) des 1. fixen Potentials an');
      READLN (Pothoehe1);
      WRITELN;
      WRITELN ('Geben Sie nun die Hhe (in V) des 2. fixen Potentials an');
      READLN (Pothoehe2);
END;


PROCEDURE GeneriertePotentiale;
{*****************************}
BEGIN Potential[PotKnoten1]:=Pothoehe1 + DeltaPotential;
      Potential[PotKnoten2]:=Pothoehe2;
END;


PROCEDURE SchaltungsGenerator;
{****************************}
BEGIN CLRSCR;
      WRITELN ('Hier knnen Sie nun Ihre eigenen Schaltungen generieren.');
      KnotenGenerieren;
      NetzwerkGenerieren;
      PotGenerieren;
END;


PROCEDURE Erklaerung;
{*******************}
VAR Abfrage: BOOLEAN;
BEGIN Abfrage:=FALSE;
      REPEAT CLRSCR;
             GOTOXY (1,5);
             WRITE ('Sie befinden sich in einem Programm zur Berechnung ');
             WRITE ('von beliebigen Schaltungen.');
             GOTOXY (1 ,10);
             WRITE ('Sie haben nun die Mglichkeit eine eigene Schaltung ');
             WRITELN ('zu generieren, oder eine');
             WRITE ('fertige Demonstration anzusehen.');
             GOTOXY (15,15);
             WRITELN ('ͻ');
             GOTOXY (15,16);
             WRITELN (' Demonstration ansehen          (Taste 1)   ');
             GOTOXY (15,17);
             WRITELN ('͹');
             GOTOXY (15,18);
             WRITELN (' Eigene Schaltung generieren    (Taste 2)   ');
             GOTOXY (15,19);
             WRITELN ('ͼ');

             READLN (Schaltung);
             CASE Schaltung OF '1','2': Abfrage := TRUE
             END;
      UNTIL Abfrage= TRUE;
      CASE Schaltung OF  '2': SchaltungsGenerator;
                         '1': Kirchoffwuerfel;
      END;
END;


PROCEDURE StromAuswerten;
{***********************}
{Hier werden alle in den Knoten einflieenden Strme aufaddiert und die
Potentiale dementsprechend verndert.}
VAR i,y:         INTEGER;
    Knotenstrom: REAL;
BEGIN FOR y:=1 TO AnzahlDerKnoten DO
          BEGIN KnotenStrom:=0;
                FOR i:=1 TO AnzahlDerKnoten DO
                    KnotenStrom:=KnotenStrom+Strom[y,i];
                PotentialBerechnung(KnotenStrom,y);
          END;
      CASE Schaltung OF  '1' :UnveraenderlichePotentiale;
                         '2' :GeneriertePotentiale;
      END;  {Setzt die fixen Potentiale wieder auf ursprngliche Werte
             zurck, da sie im Laufe der Berechnungen verndert wurden}
      DELAY (50);    {Um den Effekt des Einpendelns zu beobachten}
END;



{Mainprogram}
{**********************************************************************}
BEGIN CLRSCR;
      Initialisieren;
      Erklaerung;
      Befehlsuebersicht;
      REPEAT StroemeBerechnen;
             StromAuswerten;
             AusgabeDerErgebnisse;
             IF KEYPRESSED THEN TastaturBefehle;
      UNTIL Ende
END.