UNIT EXTCRT;


INTERFACE


CONST FDOUBLE = 0;
      FSINGLE = 1;

      KUP = 1;
      KDOWN = 2;
      KRET = 3;
      KESC = 4;
      KF1 = 5;


PROCEDURE CursorOff;
PROCEDURE CursorOn;
PROCEDURE WriteXY(x, y : Integer; text : String);
PROCEDURE WriteCenter(z : Integer; text : String);
PROCEDURE TextBox(x, y, w, h, btype : Integer);
PROCEDURE ClearBox(x1, y1, w, h : Integer);
PROCEDURE UpString(VAR text : String);
PROCEDURE Beep;
PROCEDURE KillSpace(VAR s : String);
PROCEDURE NewTextBox(x1, y1, x2, y2, btype : Integer);
PROCEDURE NewClearBox(x1, y1, x2, y2 : Integer);
PROCEDURE Color(fg, bg : Byte);

FUNCTION ReadXY(x, y, maxlen : Integer; VAR text : String) : Integer;


IMPLEMENTATION


USES CRT, DOS;


CONST BoxFrame : ARRAY[0..1] OF String = (('ɻȼͺ'), ('ڿĳ'));


PROCEDURE UpString(VAR text : String);

VAR i : Integer;

BEGIN
  FOR i := 1 TO Length(text) DO text[i] := UpCase(text[i]);
END;


PROCEDURE CursorOff;

VAR regs : Registers;

BEGIN
  regs.ah := 1;
  regs.cl := 51;
  regs.ch := 50;
  Intr($10, regs);
END;


PROCEDURE CursorOn;

VAR regs : Registers;

BEGIN
  regs.ah := 1;
  regs.cl := 13;
  regs.ch := 12;
  Intr($10, regs);
END;


PROCEDURE WriteXY(x, y : Integer; text : String);
BEGIN
  GotoXY(x, y);
  Write(text);
END;


PROCEDURE WriteCenter(z : Integer; text : String);
BEGIN
  WriteXY(40 - Length(text) DIV 2, z, text);
END;


PROCEDURE Color(fg, bg : Byte);
BEGIN
  TextColor(fg);
  TextBackGround(bg);
END;


PROCEDURE TextBox(x, y, w, h, btype : Integer);

VAR i : Integer;

BEGIN
  GotoXY(x, y);
  Write(Char(BoxFrame[btype, 1]));
  FOR i := 1 TO Pred(w) DO Write(Char(BoxFrame[btype, 5]));
  Write(Char(BoxFrame[btype, 2]));
  GotoXY(x, y + h);
  Write(Char(BoxFrame[btype, 3]));
  FOR i := 1 TO Pred(w) DO Write(Char(BoxFrame[btype, 5]));
  Write(Char(BoxFrame[btype, 4]));
  FOR i := 1 TO Pred(h) DO
  BEGIN
    GotoXY(x, y + i);
    Write(Char(BoxFrame[btype, 6]));
  END;
  FOR i := 1 TO Pred(h) DO
  BEGIN
    GotoXY(x + w, y + i);
    Write(Char(BoxFrame[btype, 6]));
  END;
END;


PROCEDURE Beep;
BEGIN
  Sound(880);
  Delay(200);
  NoSound;
END;


PROCEDURE KillSpace(VAR s : String);

VAR i, j : Byte;

BEGIN
  i := 1;
  WHILE s[i] = #32 DO Inc(i);
  IF i > 1 THEN
    FOR j := 1 TO Length(s) - Pred(i) DO s[j] := s[j + Pred(i)];
  s[0] := Chr(Ord(s[0]) - Pred(i));
  i := Length(s);
  WHILE s[i] = #32 DO Dec(i);
  IF i < Length(s) THEN s[0] := Chr(Ord(s[0]) - (Length(s) - i));
END;


FUNCTION ReadXY(x, y, maxlen : Integer; VAR text : String) : Integer;

VAR i, c, ret : Integer;
    t         : Char;
    s         : String;

BEGIN
  TextBackGround(GREEN);
  TextColor(WHITE);
  WriteXY(x, y, text);
  FOR i := 1 TO maxlen - Length(text) DO Write(' ');
  FOR i := Succ(Length(text)) TO maxlen DO text[i] := ' ';
  text[0] := Chr(maxlen);
  GotoXY(x, y);
  c := 1;
  s := text;
  ret := 0;
  CursorOn;
  REPEAT
    t := ReadKey;
    IF t = #0 THEN
    BEGIN
      t := ReadKey;
      CASE t OF
        #77 : IF c < maxlen THEN Inc(c)
              ELSE Beep;
        #75 : IF c > 1 THEN Dec(c)
              ELSE Beep;
        #71 : c := 1;
        #79 : BEGIN
                c := maxlen;
                WHILE (s[c] = #32) AND (c > 1) DO Dec(c);
                IF c < maxlen THEN Inc(c);
              END;
        #83 : BEGIN
                FOR i := c TO Pred(maxlen) DO s[i] := s[Succ(i)];
                s[maxlen] := ' ';
                WriteXY(x, y, s);
              END;
        #72 : ret := KUP;
        #80 : ret := KDOWN;
        #59 : ret := KF1;
      END;
    END
    ELSE
    BEGIN
      CASE t OF
        #32 .. #255 : BEGIN
                        Write(t);
                        s[c] := t;
                        IF c < maxlen THEN Inc(c)
                        ELSE Beep;
                      END;
        #13 : ret := KRET;
        #27 : ret := KESC;
        #8 : BEGIN
               IF c > 1 THEN
               BEGIN
                 Dec(c);
                 FOR i := c TO Pred(maxlen) DO s[i] := s[Succ(i)];
                 s[maxlen] := ' ';
                 WriteXY(x, y, s);
               END
               ELSE Beep;
             END;
      END;
    END;
  GotoXY(x + Pred(c), y);
  UNTIL ret <> 0;
  KillSpace(s);
  IF ret = KESC THEN s := text;
  TextBackGround(BLUE);
  TextColor(YELLOW);
  WriteXY(x, y, s);
  FOR i := 1 TO maxlen - Length(s) DO Write(' ');
  CursorOff;
  text := s;
  ReadXY := ret;
END;


PROCEDURE ClearBox(x1, y1, w, h : Integer);

VAR i : Integer;
    s : String;

BEGIN
  FOR i := 1 TO w DO s[i] := ' ';
  s[0] := Chr(w);
  FOR i := y1 TO y1 + h - 1 DO WriteXY(x1, i, s);
END;


PROCEDURE NewTextBox(x1, y1, x2, y2, btype : Integer);

VAR i : Integer;

BEGIN
  GotoXY(x1, y1);
  Write(Char(BoxFrame[btype, 1]));
  FOR i := Succ(x1) TO Pred(x2) DO Write(Char(BoxFrame[btype, 5]));
  Write(Char(BoxFrame[btype, 2]));
  GotoXY(x1, y2);
  Write(Char(BoxFrame[btype, 3]));
  FOR i := Succ(x1) TO Pred(x2) DO Write(Char(BoxFrame[btype, 5]));
  Write(Char(BoxFrame[btype, 4]));
  FOR i := Succ(y1) TO Pred(y2) DO
  BEGIN
    GotoXY(x1, i);
    Write(Char(BoxFrame[btype, 6]));
    GotoXY(x2, i);
    Write(Char(BoxFrame[btype, 6]));
  END;
END;


PROCEDURE NewClearBox(x1, y1, x2, y2 : Integer);

VAR i  : Integer;
    hs : String;

BEGIN
  FOR  i := 1 TO x2 - x1 DO hs[i] := #32;
  hs[0] := Chr(x2 - x1);
  FOR i := y1 TO y2 DO WriteXY(x1, i, hs);
END;


BEGIN
END.