UNIT IEC;


INTERFACE


TYPE DateType = RECORD                           {Datumstruktur}
                  Day, Month, Year, WDay : Word;
                END;

     PatientType = RECORD                        {Struktur fr Patientendaten}
                     FType  : LongInt;           {Filecode fr eindeutige Fileerkennung}
                     PDate  : DateType;          {heutiges Datum}
                     Name   : String;            {Name des Patienten}
                     Date   : DateType;          {Geburtsdatum}
                     Street,                     {Wohnort}
                     PLZ,
                     City,
                     SozVer : String;            {Versicherungsnummer}
                     Puls,                       {gemessene Patientendaten}
                     Systole, Diastole,
                     Speed,
                     Power,
                     Frequency : Word;
                     EKG    : ARRAY[0..4095] OF Byte;
                   END;


PROCEDURE GetIECData(VAR pnt : PatientType);
PROCEDURE GetIECEKGData(VAR pnt : PatientType);
PROCEDURE InitPatient(VAR Patient : PatientType);


IMPLEMENTATION


USES DOS;


PROCEDURE GetIECData(VAR pnt : PatientType);
BEGIN
END;


PROCEDURE GetIECEKGData(VAR pnt : PatientType);

VAR i : Integer;

BEGIN
  Randomize;
  FOR i := 0 TO 4095 DO pnt.EKG[i] := Random(255) - 127;
END;


PROCEDURE InitPatient(VAR Patient : PatientType);{Funktion um Patientenstruktur}

VAR n : Integer;

BEGIN                                            {anfnglich zu initialisieren}
  WITH Patient DO
  BEGIN
    FType := $4d504400; {'MPD\0'}                {Fileerkennungscode}
    Name := '';                                  {sonst alle Werte auf Null setzen}
    GetDate(PDate.Year, PDate.Month, PDate.Day, PDate.WDay);{aktuelles Datum}
    Date.Day := 1;
    Date.Month := 1;
    Date.Year := 1900;
    Date.WDay := 0;
    Street := '';
    PLZ := '';
    City := '';
    SozVer := '';
    Puls := 0;
    Systole := 0;
    Diastole := 0;
    Speed := 0;
    Power := 0;
    Frequency := 0;
    FOR n := 0 TO 4095 DO EKG[n] := 50;
  END;
END;


BEGIN
END.