{ͻ}
{ Programm: MEDATSYS.PAS                                                  }
{ Sprache:  Borland Turbo Pascal V5.5                                     }
{ Autoren:  Andrejovic, Fiser, Peksa                                      }
{ Datum:    Feb. - Mrz 1993                                              }
{ Funktion: Programm fr das medizinische Datenerfassunfssystem zur Ver-  }
{ waltung der Daten von den Platinen der einzelnen Gruppen am Computer.   }
{ͼ}


PROGRAM MedDataSys;


USES CRT, DOS, PRINTER, GRAPH, EXTCRT, REQ, IEC; {Einbinden der Units}


CONST MenuText : ARRAY[0..5] OF String =         {Menpunkt fr Hauptmen}
                        ((' F1 ............ Load Data '),
                         (' F2 ............ Save Data '),
                         (' F3 ....... Print Protocol '),
                         (' F4 ..... Display Protocol '),
                         (' F5 .... Start Measurement '),
                         (' F10 ......... Exit to DOS '));
      WeekDays : ARRAY[0..6] OF String = ('Sunday',{Wochentagstexte fr Datum}
                                          'Monday',
                                          'Tuesday',
                                          'Wednesday',
                                          'Thursday',
                                          'Friday',
                                          'Saturday');
      ITEM_HI = TRUE;                            {Constanten fr Menpunktdarstellung}
      ITEM_LO = FALSE;                           {(markiert oder normal)}
      ACTIVE = 1;                                {Constanten fr 1. oder 2.}
      BGROUND = 0;                               {Patientenspeicher}

VAR h : Integer;                                 {Hilfsvariable}
    Patient : ARRAY[0..1] OF PatientType;        {Patientenstruktur (1. und 2.)}
                                                 {Patientespeicher}

PROCEDURE WriteItem(nr : Integer; sel : Boolean);{Funktion um Menpunkt markiert}
BEGIN                                            {oder normal darzustellen (wichtig}
  CASE sel OF                                    {fr Menauswahl)}
    TRUE  : Color(WHITE, GREEN);                 {Farbe fr Markierte Darstellung}
    FALSE : Color(YELLOW, BLUE);                 {Farbe fr norm. Darstellung}
  END;
  WriteXY(27, nr + 9, MenuText[nr]);             {Menpunkt an richtige Position schreiben}
END;



FUNCTION StrKonvDate(Date : DateType) : String;  {Wandelt eine Datumstruktur}
                                                 {(DateType) in einen String um}
VAR Help,                                        {Hilfsvariable}
    Datum : String;                              {Variable fr konvertiertes}
                                                 {Datum}
BEGIN
  Str(Date.Day, Help);                           {Umwandlung mu getrennt fr}
  Datum := Help + '.';                           {jede Datumszahl geschehen}
  Str(Date.Month, Help);                         {(Tag, Monat, Jahr)}
  Datum := Datum + Help + '.';
  Str(Date.Year, Help);
  Datum := Datum + Help;
  StrKonvDate := Datum;
END;



PROCEDURE TitleScreen;                           {Funktion fr den Bildschirm-}
                                                 {aufbau im Hauptmen}
VAR i : Integer;                                 {Schleifenvariable}

BEGIN                                            {Farben festlegen}
  Color(YELLOW, BLUE);
  ClrScr;                                        {Bildschirm lschen}
  TextBox(1, 1, 79, 23, FDOUBLE);                {und Kstchen und Text aufbauen}
  TextBox(3, 3, 73, 2, FDOUBLE);
  TextBox(4, 21, 73, 2, FSINGLE);
  WriteCenter(22, 'Press F-Keys, or use cursorkeys and RETURN to select menuitem.');
  TextBox(25, 8, 30, 7, FSINGLE);                {Men aufbauen}
  FOR i := 0 TO 5 DO WriteXY(27, i + 9, MenuText[i]);
  WriteItem(0, ITEM_HI);
  Color(LIGHTRED, BLUE);
  WriteCenter(4, 'Copyright 1993 by Andrejovic, Fiser and Peksa !!!');
END;


FUNCTION SelectMenu : Integer;                   {Funktion fr die Auswahl}
                                                 {eines Menpunktes}
VAR taste   : Char;                              {Variable fr gedrckte Tasten}
    nr, onr : Integer;                           {Zhler fr aktuelle und vorher-}
                                                 {gehende Menposition}
BEGIN
  nr := 0;                                       {Menposition auf Anfang setzen}
  REPEAT                                         {Schleife bis Item ausgewhlt}
    taste := ReadKey;                            {Taste einlesen}
    IF taste = #0 THEN taste := ReadKey;         {evtl. Sondercode einlesen}
    onr := nr;                                   {aktive Position zwischenspeichern}
    CASE taste OF                                {je nach gedrckter Taste verzweigen}
      #80 :                                      {Taste <Pfeil runter>}
      BEGIN
        IF nr = 5 THEN nr := -1;                 {Letzte Position erreicht ?}
        Inc(nr);                                 {sonst weiterzhlen}
      END;
      #72 :                                      {Taste <Pfeil rauf>}
      BEGIN
        IF nr = 0 THEN nr := 6;                  {erste Pos. schon erreicht ?}
        Dec(nr);                                 {sonst weiterzhlen}
      END;                                       {Bei FKeys Pos. direkt festlegen}
      #59 : nr := 0;                             {Taste <F1>}
      #60 : nr := 1;                             {Taste <F2>}
      #61 : nr := 2;                             {Taste <F3>}
      #62 : nr := 3;                             {Taste <F4>}
      #63 : nr := 4;                             {Taste <F5>}
      #68 : nr := 5;                             {Taste <F10>}
      #27 : nr := 5;                             {Taste <ESC>}
    END;
    WriteItem(onr, ITEM_LO);                     {Zwischengesp. Item normal schreiben}
    WriteItem(nr, ITEM_HI);                      {neu gewhlts Item markieren}
  UNTIL (taste = #13) OR (taste = #27) OR (taste = #68) OR ((taste >= #59) AND (taste <= #63));
  SelectMenu := nr;                              {Wert des ausgewhlten Menpunktes}
END;                                             {zurckliefern}


PROCEDURE PrintP(n: Integer);                    {Protokollausgabe am Drucker}

VAR help1,                                       {Hilfsvariablen}
    help2,
    datum : String;                              {String fr Datumconvertierung}
    j, i  : Integer;                             {Schleifenvariablen}

BEGIN
  {$I-}                                          {Versuch, Drucker anzusprechen}
  WriteLn(LST, #10);
  {$I+}
  IF IOResult = 0 THEN                           {Wenn Druckertest erfolgreich}
  BEGIN
    Color(YELLOW, BLUE);                         {BildSchirmmeldung}
    NewTextBox(20, 18, 60, 20, FSINGLE);
    Color(LIGHTRED, BLUE);
    WriteCenter(19,'Printing in action !');
    WITH Patient[n] DO
    BEGIN
      Write(LST, '');
      FOR j := 6 TO 69 DO Write(LST, '');
      WriteLn(LST, '');
      WriteLn(LST, '                          Patient - Protocol                    ');
      Write(LST, '');                           {Zeilenweises Ausdrucken mit}
      FOR j := 6 TO 69 DO Write(LST, '');       {Rahmen}
      WriteLn(LST, '');
      Write(LST, ' Name: ' + Name);
      j := 57 - Length(Name);
      FOR i := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Datum := Weekdays[PDate.WDay]+', ';        {Datum konvertieren in String}
      Datum := Datum + StrKonvDate(Patient[ACTIVE].PDate);
      Write(LST, ' Datum der Protokollaufnahme: '+ Datum);
      j := 34 - Length(Datum);
      FOR i := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Datum := StrKonvDate(Patient[ACTIVE].Date);
      Write(LST, ' Date of Birth: ' + Datum);
      j := 48 - Length(Datum);
      FOR j := 1 TO j DO Write(Lst,' ');
      WriteLn(LST, '');
      Write(LST, ' Street: ' + Street);
      j := 55 - Length(Street);
      FOR j := 1 TO j DO Write(Lst,' ');
      WriteLn(LST, '');
      Write(LST, ' PLZ: ' + PLZ);
      j := 58 - Length(PLZ);
      FOR j := 1 TO j DO Write(Lst,' ');
      WriteLn(LST, '');
      Write(LST, ' City: '+ City);
      j := 57 - Length(City );
      FOR j := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Write(LST, ' Soc. Ins. Nr.: '+ SozVer);
      j := 48 - Length(SozVer);
      FOR j := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Str(Puls:3, help1);
      Write(LST, ' Pulse: '+ Help1 +  '/min');
      j := 49 - Puls;
      FOR j := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Str(Systole:3, help1);
      Str(Diastole:3, help2);
      Write(LST, ' Preasure: '+ Help1 + ':' + Help2 + ' ');
      j := 51 - Length(help1+help2);
      FOR j := 1 TO j DO Write(LST,' ');
      WriteLn(LST, '');
      Str(Speed:3, help1);
      Write(LST,' Speed: ' + help1 + 'U/min     ');
      j := 45 - Speed;
      FOR j := 1 TO j DO Write(LST, ' ');
      WriteLn(LST,'');
      Str(Power:3, help1);
      Write(LST, ' Power: ' + help1 + 'W');
      j := 55 - Power;
      FOR j := 1 TO j DO Write(LST, ' ');
      WriteLn(LST, '');
      Str(Frequency:3, Help1);
      Write(Lst,' Breathfrequency: ' + Help1 + '/min');
      j := 39 - Frequency;
      FOR j:= 1 TO j DO Write(Lst,' ');
      WriteLn(Lst,'');
      Write(LST, '');
      FOR j:=6 TO 69 DO Write(Lst,'');
      WriteLn(Lst,'');
      Write(LST, #12);   (* Seitenvorschub *)
    END;
  END
  ELSE
  BEGIN                                          {Fehlermeldung bei Druckerstrung}
    Color(YELLOW, BLUE);
    NewTextBox(20, 18, 60, 20, FSINGLE);
    Color(LIGHTRED, BLUE);
    WriteCenter(19, 'Printererror ! Press any key.');
    ReadLn;
  END;
END;


PROCEDURE DisplayP;                              {Protokollausgabe und Datennderung}

VAR t         : Char;                            {Variable fr Tastatureingabe}
    key,                                         {Ergebnisvariable fr ReadXY}
    y, z      : Integer;                         {Zhler fr Bildschirmposition}
    s         : String;                          {Hilfsstring}

BEGIN
  z := 1;                                        {Bildschirm aufbauen}
  Color(YELLOW, BLUE);                           {Farbe festlegen}
  ClrScr;                                        {Bildschirm lschen}
  TextBox(1, 1, 79, 23, FDOUBLE);                {Kstchen und Texte ausgeben}
  TextBox(5, 3, 70, 2, FSINGLE);
  TextBox(10, 7, 60, 13, FSINGLE);
  TextBox(4, 21, 73, 2, FSINGLE);
  WriteCenter(4, 'Patient - Protocol');
  WriteXY(12, 8, 'Date :');
  WriteXY(12, 9, 'Name :');
  WriteXY(12, 10, 'Date of Birth :');
  WriteXY(12, 11, 'Street :');
  WriteXY(12, 12, 'PLZ :');
  WriteXY(12, 13, 'City :');
  WriteXY(12, 14, 'Soc. Ins. Nr. :');
  TextColor(LIGHTCYAN);
  WriteXY(12, 15, 'Puls :');
  WriteXY(12, 16, 'Preassure :');
  WriteXY(12, 17, 'Speed :');
  WriteXY(12, 18, 'Power :');
  WriteXY(12, 19, 'Breathfrequency :');
  TextColor(WHITE);
  WITH Patient[ACTIVE] DO                        {Aktuelle Patientendaten}
  BEGIN                                          {Auf Bildschirm ausgeben}
    GotoXY(30, 8); Write(WeekDays[PDate.WDay], ', ', PDate.Day, '.', PDate.Month, '.', PDate.Year, '        ');
    GotoXY(30, 9); Write(Name);                  {Heutiges und Geburtsdatum in String wandeln}
    GotoXY(30, 10); Write(Date.Day:2, '.', Date.Month:2, '.', Date.Year:2, '        ');
    GotoXY(30, 11); Write(Street);
    GotoXY(30, 12); Write(PLZ);
    GotoXY(30, 13); Write(City);
    GotoXY(30, 14); Write(SozVer);
    GotoXY(30, 15); Write(Puls:3, ' /min');
    GotoXY(30, 16); Write(Systole:3, ' : ', Diastole:3, '    ');
    GotoXY(30, 17); Write(Speed:3, ' U/min');
    GotoXY(30, 18); Write(Power:3, ' W');
    GotoXY(30, 19); Write(Frequency:3, ' /min');
  END;
  REPEAT                                         {Schleife fr Tastaturabfrage}
    TextColor(LightGray);
    WriteCenter(22, 'Press F1 to change data, F2 to print sheet, F10 to exit to main menu!');
    t := ReadKey;                                {Taste einlesen}
    IF t = #0 THEN t := ReadKey;                 {evtl. Sonderzeichen einlesen}
    CASE t OF                                    {Je nach Taste verzweigen}
      #59 : BEGIN                                {Taste <F1>, in Changemode umschalten}
      TextColor(GREEN);                          {Bildschirmausgabe}
      WriteCenter(22, '     Press F1 to exit changemode. Use Cursorkeys to change line.     ');
      REPEAT                                     {Schleife bis Eingabe beendet}
        CASE z OF                                {Verzweigen je nach Bildschirmposition}
          1 : key := ReadXY(30, 9, 40, Patient[ACTIVE].Name);{Name einlesen}
          2 :                                    {Tag des Geburtsdatums}
          BEGIN                                  {Zahl in String konvertieren und umgekehrt}
            Str(Patient[ACTIVE].Date.Day:2, s);
            key := ReadXY(30, 10, 2, s); {Conversion fr ReadXY notwendig (nur Strings)}
            Val(s, Patient[ACTIVE].Date.Day, y);
          END;
          3 :                                    {Monat des Geburtsdatums einlesen}
          BEGIN                                  {Conversion}
            Str(Patient[ACTIVE].Date.Month:2, s);
            key := ReadXY(33, 10, 2, s);
            Val(s, Patient[ACTIVE].Date.Month, y);
          END;
          4 :                                    {Jahr des Geburtsdatums einlesen}
          BEGIN                                  {Conversion}
            Str(Patient[ACTIVE].Date.Year:4, s);
            key := ReadXY(36, 10, 4, s);
            Val(s, Patient[ACTIVE].Date.Year, y);
          END;                                   {Wonhort und Versicherungsnr. einlesen}
          5 : key := ReadXY(30, 11, 40, Patient[ACTIVE].Street);
          6 : Key := ReadXY(30, 12, 4, Patient[ACTIVE].PLZ);
          7 : key := ReadXY(30, 13, 30, Patient[ACTIVE].City);
          8 : key := ReadXY(30, 14, 15, Patient[ACTIVE].SozVer);
        END;
        CASE key OF                              {Verzweigen, je nach Taste, mit der}
          KUP :                                  {Eingabe verlasssen wurde}
          BEGIN                                  {Taste <Pfeil rauf>}
            IF z > 1 THEN Dec(z)                 {Position verniedrigen}
            ELSE z := 8;
          END;
          KDOWN, KRET, KESC :                    {Tasten <Pfeil runter>, <RETURN>, <ESC>}
          BEGIN
            IF z < 8 THEN Inc(z)                 {Position erhhen}
            ELSE z := 1;
          END;
        END;
        UNTIL key = KF1;                         {Wenn erneut <F1>, dann}
      END;                                       {Eingabeschleife beenden}
      #60 : PrintP(ACTIVE);                      {Wenn <F2>, dann ausdrucken}
    END;
  UNTIL (t = #68) OR (t = #27);                  {<F10> oder <ESC>, zurck zum}
END;                                             {Hauptmen}


PROCEDURE SaveP;                                 {Funktion fr Patientendaten}
																								 {abspeichern}
VAR key : Integer;                               {Rckgabevar. fr ReadXY}
    s   : String;                                {Hilfsstring}
    fh  : File;                                  {Filehandle}

BEGIN                                            {Bildschirmaufbau}
  Color(YELLOW, BLUE);                           {Farbe festlegen}
  ClrScr;                                        {Bildschirm lschen}
  TextBox(1, 1, 79, 23, FDOUBLE);                {Kstchen und Texte ausgeben}
  TextBox(5, 3, 70, 2, FSINGLE);
  TextBox(4, 21, 73, 2, FSINGLE);
  WriteCenter(4, 'Save Patient - Protocol');
  TextBox(20, 8, 40, 2, FSINGLE);
  WriteXY(22, 9, 'FileName :');
  TextColor(GREEN);
  WriteCenter(22, 'Press ESC to cancel.');
  s := '';
  key := ReadXY(33, 9, 25, s);                   {Filename einlesen}
  IF key <> KESC THEN
  BEGIN
    FOR key := 1 TO Length(s) DO s[key] := UpCase(s[key]);
    key := 1;
    WHILE (s[key] <> '.') AND (key <= Succ(Length(s))) DO Inc(key);
    IF key > Length(s) THEN
    BEGIN
      Dec(key);
      s[key] := '.';                             {Filename um Extension '.MPD'}
      s[key + 1] := 'M';                         {erweitern}
      s[key + 2] := 'P';
      s[key + 3] := 'D';
      s[0] := Chr(Ord(s[0]) + 4);
    END;
    TextColor(YELLOW);
    WriteXY(33, 9, s);
    Assign(fh, s);                               {File fr Schreibzugriff ffnen}
    {$I-}
    ReWrite(fh, SizeOf(PatientType));
    {$I+}
    IF IOResult = 0 THEN                         {Datei mglich zu ffnen}
    BEGIN
      {$I-}
      BlockWrite(fh, Patient[ACTIVE], 1);          {Abspeichern der Patientenstruktur}
      {$I+}
      IF IOResult <> 0 THEN                        {Falls Diskette voll, dann}
      BEGIN                                        {Fehlermeldung ausgeben}
        NewTextBox(20, 18, 60, 20, FSINGLE);
        TextColor(LIGHTRED);
        WriteCenter(13, 'Disk full error ! Press any key.');
        ReadLn;
      END;
      Close(fh);                                   {Schliessen der Datei}
    END
    ELSE
    BEGIN                                          {Bei Diskettenfehler (z. B. keine}
      NewTextBox(20, 18, 60, 20, FSINGLE);         {Disk im Laufwerk), dann}
      TextColor(LIGHTRED);                         {Fehlermeldung ausgeben}
      WriteCenter(19, 'Disk error! Press any key.');
      ReadLn;
    END;
  END;
END;


PROCEDURE LoadP;                                 {Funktion um Patientendaten}
                                                 {zu laden}
VAR s   : String;                                {Hilfsstring}
    fh  : File;                                  {Filehandle}

BEGIN
  s := FileRequester;                            {Filerequester aufrufen (REQ.TPU)}
  IF s <> '' THEN
  BEGIN
    Assign(fh, s);                               {Ausgewhlt Datei ffnen}
    {$I-}
    ReSet(fh, SizeOf(PatientType));
    {$I+}
    IF IOResult = 0 THEN                         {Ist kein Fehler aufgetreten,}
    BEGIN
      {$I-}                                      {dann Patientendaten einlesen}
      BlockRead(fh, Patient[ACTIVE], 1);
      {$I+}
      IF IOResult = 0 THEN                       {Wenn Datei nicht zu klein war,}
      BEGIN                                      {berprfen ob Daten richtig sind}
        IF Patient[ACTIVE].FType <> $4d504400 THEN{Filecode = 'MPD\0'}
        BEGIN
          Color(YELLOW, BLUE);                   {Falls Filecode falsch, dann}
          NewTextBox(18, 18, 61, 20, FSINGLE);   {Fehlermeldung}
          TextColor(LIGHTRED);
          WriteCenter(19, 'File contains wrong data! Press any key.');
          InitPatient(Patient[ACTIVE]);          {und Patientendaten neu initialisieren}
          ReadLn;
        END;
      END
      ELSE                                       {Wenn Datei zu klein war, dann}
      BEGIN                                      {ebenfalls Fehlermeldung ausgeben}
        Color(YELLOW, BLUE);
        NewTextBox(20, 18, 60, 20, FSINGLE);
        TextColor(LIGHTRED);
        WriteCenter(19, 'Disk read error! Press any key.');
        InitPatient(Patient[ACTIVE]);
        ReadLn;
      END;
      Close(fh);                                 {Datei wieder schlieen}
    END
    ELSE                                         {Bei falschen Dateinamen auch}
    BEGIN                                        {Fehlermeldung ausgeben}
      Color(YELLOW, BLUE);
      NewTextBox(20, 18, 60, 20, FSINGLE);
      WriteCenter(19, 'File not found ! Press any key.');
      ReadLn;
    END;
  END;
END;


PROCEDURE Messwertausgabe;                       {Funktion fr Darstellung}
                                                 {der IECBusdaten}
VAR dat, datum,                                  {Datumshilfsvariablen}
    help1, help2 : String;                       {Hilfsvariablen}
    t            : Char;                         {Tastaturpuffer}

BEGIN                                            {BildSchirmaufbau}
  t := #255;
  Color(YELLOW, BLUE);                           {Farbe festlegen}
  ClrScr;                                        {Bildschirm lschen}
  NewTextBox(1, 1, 80, 24, FDOUBLE);             {Aufbau der Kstchen und Texte}
  NewTextBox(5, 2, 75, 4, FSINGLE);
  NewTextBox(10, 13, 70, 20, FSINGLE);
  NewTextBox(5, 10, 75, 12, FSINGLE);
  NewTextBox(10, 5, 70, 9, FSINGLE);
  NewTextBox(5, 21, 75, 23, FSINGLE);
  WriteCenter(3, 'Patient - Data');
  TextColor(LIGHTGRAY);
  WriteCenter(22, 'Press F1 to save data, F10 to cancel.');
  TextColor(LIGHTRED + BLINK);
  WriteCenter(11, 'Measuring in action !');
  WITH Patient[ACTIVE] DO
  BEGIN
    Datum:=Weekdays[PDate.WDay]+', ';            {Datum ins richtige Format bringen}
    Dat:=StrKonvDate(PDate);
    Datum:=Datum+Dat;
    TextColor(YELLOW);
    WriteXY(12,6,'Date: '+Datum);                {Als Hinweis werden die wichtigsten}
    WriteXY(12,7,'Name: '+Name);                 {Patientendaten ausgegeben}
    Datum:=StrKonvDate(Date);
    WriteXY(12,8,'Date of Birth: '+Datum);
  END;
  TextColor(YELLOW);
  WITH Patient[BGROUND] DO                       {Ausgabe der eingelesenen Mewerte}
    REPEAT                                       {Daten ber IECBus holen}
      GetIECData(Patient[BGROUND]);              {und im 2. Speicher ablegen}
      Str(Puls:3, Help1);                        {Konvertieren und ausgeben}
      WriteXY(12, 14, 'Pulse:' + Help1 + '/min    ');
      Str(Systole:3, help1);
      Str(Diastole:3, help2);
      WriteXY(12, 15, 'Preasure: ' + help1 + ' : ' + Help2 + '    ');
      Str(Speed:3, Help1);
      WriteXY(12, 16, 'Speed: ' + help1 + 'U/min    ');
      Str(Power:3, help1);
      WriteXY(12, 17, 'Power: ' + help1 + 'W   ');
      Str(Frequency, Help1);
      WriteXY(12, 18, 'Breathfrequency: '+Help1+'/min    ');
      IF KeyPressed THEN                         {Tastenabfrage}
      BEGIN
        t := ReadKey;
        IF t = #0 THEN t := ReadKey;             {evtl. Sondercode}
      END;
    UNTIL (t = #27) OR (t = #59) OR (t = #68);   {Falls F1, dann Daten vom 2.}
  IF t = #59 THEN Patient[ACTIVE] := Patient[BGROUND];{in den 1. Speicher}
END;                                             {bernehmen}


PROCEDURE EKGGrafik;

VAR ye, mo, da, td  : Word;
    gd, gm,
    x, zX, zY, w, h : Integer;
    FacX, FacY      : Real;
    Taste           : Char;
    dt              : DateType;

BEGIN
  gd := DETECT;
  InitGraph(gd, gm, '');
  SetFillStyle(SOLIDFILL, BLUE);
  Bar(0, 0, GetMaxX, GetMaxY);
  SetColor(YELLOW);
  RectAngle(0, 0, GetMaxX, GetMaxY);
  RectAngle(2, 2, GetMaxX - 2, GetMaxY - 2);
  RectAngle(16, 80, GetMaxX - 16, GetMaxY - 16);
  SetTextStyle(TRIPLEXFONT, HORIZDIR, 4);
  OutTextXY((GetMaxX DIV 2) - TextWidth('ECG - Graphics') DIV 2, 10, 'ECG - Graphics');
  SetTextStyle(TRIPLEXFONT, HORIZDIR, 2);
  GetDate(ye, mo, da, td);
  dt.Year := ye;
  dt.Month := mo;
  dt.Day := da;
  OutTextXY(10, 45, Patient[ACTIVE].Name + ', ' + StrKonvDate(Patient[ACTIVE].Date) + '   Today`s Date: ' + StrKonvDate(dt));
  SetTextStyle(DEFAULTFONT, HORIZDIR, 1);
  SetColor(LIGHTRED);
  OutTextXY(10, GetMaxY - 12, 'Press <F10> to keep information, <ESC> to exit.');
  w := GetMaxX - 34;
  h := GetMaxY - 98;
  zX := 17;
  zY := h DIV 2 + 80;
  FacX := 4096 / w;
  FacY := h / 256;
  SetColor(GREEN);
  REPEAT
    GetIECEKGData(Patient[BGROUND]);
    MoveTo(zX, zY);
    FOR x := 0 TO Pred(w) DO
    BEGIN
      Bar(zX + x, 81, zX + x + 1, GetMaxY - 17);
      LineTo(zX + x, Round(FacY * Patient[BGROUND].EKG[Round(FacX * x)]) + 81);
      IF KeyPressed THEN x := Pred(w);
    END;
    IF KeyPressed THEN
    BEGIN
      Taste := ReadKey;
      IF Taste = #0 THEN Taste := ReadKey;
    END;
  UNTIL (Taste = #27) OR (Taste = #68);
  CloseGraph;
  CursorOff;
END;


PROCEDURE Measurement(n : Integer);              {Menauswahl fr Messung}

CONST mu : ARRAY[0..2] OF String = ('F1 .......... Patientendaten',
                                    'F2 ......... EKG-Darstellung',
                                    'F10 ... Zurck zum Hauptmen');

VAR i, nr, onr : Integer;                        {Schleifenvariable}
    taste, esc : Char;                           {Tastenpuffer}


PROCEDURE WHI(nr : Integer);
BEGIN
  Color(WHITE, GREEN);
  WriteCenter(nr + 10, mu[nr]);
END;


PROCEDURE WLO(nr : Integer);
BEGIN
  Color(YELLOW, BLUE);
  WriteCenter(nr + 10, mu[nr]);
END;


PROCEDURE TScr;
BEGIN                                            {Bildschirmaufbau}
  Color(YELLOW, BLUE);                           {Farbe festlegen}
  ClrScr;                                        {Bildschirm lschen}
  NewTextBox(1, 1, 80, 24, FDOUBLE);             {Kstchen und Text ausgeben}
  NewTextBox(24, 9, 55, 13, FSINGLE);
  NewTextBox(5, 2, 75, 4, FSINGLE);
  WriteCenter(3, 'Measurement - Menu');
  WriteCenter(10, mu[0]);
  WriteCenter(11, mu[1]);
  WriteCenter(12, mu[2]);
  WHI(nr);
END;


BEGIN
  nr := 0;
  TScr;
  REPEAT
    taste:=ReadKey;                              {Taste einlesen}
    IF taste = #0 THEN taste:=ReadKey;           {evtl. Sondercode}
    onr := nr;
    CASE taste OF                                {Je nach Taste verzweigen}
      #80 :
      BEGIN
        IF nr = 2 THEN nr := -1;
        Inc(nr);
      END;
      #72 :
      BEGIN
        IF nr = 0 THEN nr := 3;
        Dec(nr);
      END;
      #59 :
      BEGIN
        nr := 0;
        taste := #255;
      END;
      #60:
      BEGIN
        nr := 1;
        taste := #255;
      END;
      #13 : taste := #255;
    END;
    WHI(nr);
    WLO(onr);
    IF taste = #255 THEN
    BEGIN
      CASE nr OF
        0 : Messwertausgabe;
        1 : EKGGrafik;
        2 : taste := #68;
      END;
      TScr;
    END;
  UNTIL (taste = #27) OR (taste = #68);
END;


BEGIN                                            {Hauptprogramm}
  SetInt;
  InitPatient(Patient[ACTIVE]);                  {Initialisieren des 1. und}
  InitPatient(Patient[BGROUND]);                 {2. Variablenspeichers}
  CursorOff;                                     {Cursor abschalten}
  REPEAT
    TitleScreen;                                 {Funktion fr Hauptbildschirm aufr.}
    h := SelectMenu;                             {Funktion fr Menauswahl aufrufen}
    CASE h OF                                    {Je nach ausgewhlten Item verzw.}
      0 : LoadP;                                 {Funktion fr Daten laden}
      1 : SaveP;                                 {Funktion fr Daten speichern}
      2 : PrintP(ACTIVE);                        {Funktion fr Daten drucken}
      3 : DisplayP;                              {Funktion fr Daten anzeigen und ndern}
      4 : Measurement(ACTIVE);                   {Funktion zum Messen}
    END;
  UNTIL h = 5;                                   {Falls letzter Menpunkt, Schleife beenden}
  Color(RED, BLACK);                             {Beendungsbildschirm aufbauen}
  ClrScr;
  WriteCenter(3, 'Copyright (c) Feb. 1993 by Andrejovic, Fiser, Peksa.');
  TextColor(139);
  WriteCenter(23, '! Additional support by IRON AMIGA EAGLE !');
  TextColor(LIGHTGRAY);
  TextBox(1, 1, 79, 3, FSINGLE);
  TextBox(1, 22, 79, 2, FDOUBLE);
  WriteCenter(2, 'Thanks for using our medical Software !');
  GotoXY(1, 5);
  CursorOn;                                      {Cursor wieder einschalten}
  ClrInt;
END.                                             {Programm verlassen}

