{ͻ}
{ Programm: REQ.TPU                                                       }
{ Sprache:  Borland Turbo Pascal V5.5                                     }
{ Autoren:  Bernhard Fiser alias Iron `AMIGA` Eagle                       }
{ Datum:    Feb. - Mrz 1993                                              }
{ Funktion: Unit fr die komfortable und professionelle Auswahl eines     }
{ Filenamens zur einfacheren Bediehnung des Programms.                    }
{ͼ}
{$M 65000,0,655360}                              {Speichergre einstellen}

UNIT REQ;


INTERFACE


CONST MAXFILES = 100;                             {Anzahl der max. lesbaren Files}
      DEF_EXT = '*.*';                           {Standardextension}
      DEF_DIR = '\';                             {Standarddirectory (Root)}

TYPE FileType = RECORD                           {Struktur fr eingelesene}
                  FName : String[12];            {Filenamen & Datum}
                  Date  : LongInt;
                END;

     FListType = ARRAY[0..MAXFILES] OF FileType; {Feld der Filestruktur}


FUNCTION FileRequester : String;                 {Vordefinition der Funktionen}
FUNCTION ReadDir(ext : String; VAR s : FListType) : Integer;

PROCEDURE SetInt;
PROCEDURE ClrInt;


IMPLEMENTATION


USES CRT, DOS, EXTCRT;                           {Verwendete Units einbinden}

VAR oldprt,                                      {Zwischensp. fr Intvector}
    oldres  : Pointer;


FUNCTION ReadDir(ext : String; VAR s : FListType) : Integer;
                                                 {Fkt. zum Lesen eines Directories}
VAR srec   : SearchRec;                          {DOS-Struktur fr Dirfunktionen}
    fcount : Word;                               {Zhlvariable fr die Anzahl der}
                                                 {gelesenen Filenamen}
BEGIN
  fcount := 0;                                   {Anzahl der Filenamen rcksetzen}
  FindFirst(ext, Directory, srec);               {Ersten Eintrag lesen}
  WHILE DosError = 0 DO                          {Schleife, solange kein DOS-Fehler}
  BEGIN                                          {Falls Name nicht `.` oder `..`}
    IF (srec.Name <> '.') AND (srec.Name <> '..') THEN
    BEGIN
      s[fcount].FName := srec.Name;              {Name & Datum im Feld ablegen}
      IF srec.Attr <> Directory THEN s[fcount].Date := srec.Time
      ELSE s[fcount].Date := 0;
      Inc(fcount);                               {Filezhler erhhen}
    END;
    FindNext(srec);                              {nchsten Eintrag lesen}
  END;
  IF DosError <> 18 THEN fcount := -DosError;    {Falls Fehler, negativ}
  ReadDir := fcount;                             {Filenr. od. neg. Fehler zurck}
END;


FUNCTION FileRequester : String;                 {Funktion f. d. Dateiauswahl}

VAR flist      : FListType;                      {Fileliste}
    pstr, hstr : String;                         {Pfadstring und Hilfsstring}
    s1         : DirStr;                         {Hilfsstrings fr die Fkt.}
    s2         : NameStr;                        {FSplit()}
    s3         : ExtStr;
    fpos, spos,                                  {File- u. Bildschirmposzhler}
    fcount, i  : Integer;                        {Anzahl der Files, und Schleifenv.}
    t          : Char;                           {Variable fr Tastaturabfr.}

PROCEDURE MScreen;                               {Funktion fr Bildschirmaufbau}
BEGIN
  CursorOff;                                     {Cursor abschalten}
  TextColor(YELLOW);                             {Farben einstellen}
  TextBackGround(BLUE);
  ClrScr;                                        {Bildschirm lschen}
  NewTextBox(1, 1, 80, 24, FDOUBLE);             {Kstchen aufbauen}
  NewTextBox(5, 2, 75, 4, FSINGLE);
  NewTextBox(3, 5, 78, 7, FSINGLE);
  NewTextBox(5, 21, 75, 23, FSINGLE);
  NewTextBox(27, 8, 53, 20, FSINGLE);
  NewTextBox(55, 8, 75, 12, FSINGLE);
  WriteXY(57, 9, 'F1 .. Change Name');           {infotexte ausgeben}
  WriteXY(57, 10, 'F2 ... Parent Dir');
  WriteXY(57, 11, 'F10 ... Main Menu');
  WriteXY(5, 6, pstr);
  TextColor(Cyan);
  WriteCenter(3, '-- Filerequester --');
  TextColor(GREEN);
  WriteCenter(22, 'Press F1 to change filename, F10 to exit to main menu !');
  TextColor(YELLOW);
END;


PROCEDURE WriteFile(fnum, sp : Integer);         {Funktion um einen Filenamen}
                                                 {auszugeben}
VAR i    : Integer;                              {Schleifenvariable}
    s1   : DirStr;                               {Hilfsvariablen fr Funktion}
    s2   : NameStr;                              {FSplit()}
    s3   : ExtStr;
    dt   : DateTime;                             {Struktur fr Zeit u. Datum}

BEGIN
  FSplit(flist[fnum].FName, s1, s2, s3);         {Name in Pfad, Name u. Ext. teilen}
  GotoXY(29, sp + 9);                            {Positionieren und Name ausg.}
  FOR i := Length(s3) TO 4 DO s3[Succ(i)] := #32;
  s3[0] := #4;
  Write(s2:8, s3:4);
  IF flist[fnum].Date = 0 THEN Write('      <DIR>'){Falls Dir., dann <DIR> ausgeben}
  ELSE                                           {Andernfalls Datum ausgeben}
  BEGIN
    UnPackTime(flist[fnum].Date, dt);            {Codiertes Datum entpacken}
    Str(dt.Day, s1);                             {Datum in String konv.}
    Str(dt.Month, s2);
    IF Length(s1) = 1 THEN s1 := '0' + s1;
    IF Length(s2) = 1 THEN s2 := '0' + s2;
    Write(' ', s1, '-', s2, '-', dt.Year:4);     {Datum ausgeben}
  END;
END;


PROCEDURE WriteLo(fn, s : Integer);              {Funktion um Filenamen mit}
BEGIN                                            {normaler Farbe ausg.}
  Color(YELLOW, BLUE);                           {Farbe festlegen}
  WriteFile(fn, s);                              {Name ausgeben}
END;


PROCEDURE WriteHi(fn, s : Integer);              {Funktion um Filenamen}
BEGIN                                            {markiert auszugeben}
  Color(WHITE, GREEN);                           {Farbe einstellen}
  WriteFile(fn, s);                              {Name ausgeben}
END;


PROCEDURE OutPutFiles(fp : Integer);             {Funktion um Filenamen am Bildsch.}
                                                 {im vorges. Fenster ausgeben}
VAR i, j : Integer;                              {Schleifenvariablen}

BEGIN
  i := fp;                                       {Variablen initialisieren}
  j := 0;
  WHILE (i < fcount) AND (j < 11) DO             {Solange nicht Bildschirm- od.}
  BEGIN                                          {Filelistenende erreicht}
    WriteLo(i, j);                               {File nichtmarkiert ausg.}
    Inc(i);                                      {Filezhler erhhen}
    Inc(j);                                      {Bildschirmzhler erhhen}
  END;
END;


PROCEDURE ParentDir(VAR pstr : String);          {Funktion um ins bergeordnete}
                                                 {Directory zu gelangen}
VAR i    : Integer;                              {Zhlvariable}

BEGIN
  i := Length(pstr);
  WHILE pstr[i] <> '\' DO Dec(i);                {Letzen Backslash suchen}
  Dec(i);
  IF pstr[i] <> ':' THEN                         {Falls vor `\` kein :, dann}
  BEGIN
    WHILE pstr[i] <> '\' DO Dec(i);              {Vorletzen `\` suchen}
    IF pstr[Pred(i)] <> ':' THEN Dec(i);
  END;
  pstr[0] := Chr(i);                             {Filenamenlnge verkrzen}
END;


FUNCTION GetStar(s : String) : Boolean;          {Funktion um `*` in Name zu finden}

VAR i : Integer;                                 {Zhlvariable}

BEGIN
  i := 1;                                        {Var. auf Pos. 1 setzen}
  WHILE (s[i] <> '*') AND (i <= Length(s)) DO Inc(i);{Solange kein `*` und nicht Ende}
  IF i > Length(s) THEN GetStar := FALSE         {Falls kein `*`, dann FALSE,}
  ELSE GetStar := TRUE;                          {sonst TRUE zurckliefen}
END;


BEGIN                                            {eigentl. Unterprg.}
  ChDir(DEF_DIR);                                {Direktory}
  pstr := DEF_EXT;
  pstr := FExpand(pstr);
  fcount := ReadDir(pstr, flist);                {Directory einlesen}
  MScreen;
  spos := 0;
  fpos := 0;
  OutPutFiles(fpos);                             {Files ausgeben}
  WriteHi(fpos, spos);
  REPEAT
    t := ReadKey;                                {Taste einlesen}
    CASE t OF
      #27 : t := #255;
      #13 :                                      {Falls RETURN}
      BEGIN
        IF flist[fpos].Date = 0 THEN             {Falls Datum 0 ist}
        BEGIN
          TextBackGround(BLUE);                  {Neues Directory lesen}
          NewClearBox(28, 9, 53, 19);
          ChDir(flist[fpos].FName);
          pstr := DEF_EXT;
          pstr := FExpand(pstr);
          fcount := ReadDir(pstr, flist);
          spos := 0;
          fpos := 0;
          OutPutFiles(fpos);                     {Files hinschreiben}
          WriteHi(fpos, spos);
          TextColor(YELLOW);
          TextBackGround(BLUE);
          WriteXY(5, 6, pstr);
          FOR i := Length(pstr) TO 71 DO Write(' ');
        END
        ELSE
        BEGIN
          pstr := flist[fpos].FName;
          pstr := FExpand(pstr);
          TextColor(YELLOW);
          TextBackGround(BLUE);
          WriteXY(5, 6, pstr);
          t := #254;
        END;
      END;
      #0 :
      BEGIN
        t := ReadKey;
        CASE t OF
          #68 : t := #255;
          #80 :
          BEGIN
            IF (spos < 10) AND (fpos < fcount - 1) THEN
            BEGIN
              WriteLo(fpos, spos);
              Inc(fpos);
              Inc(spos);
              WriteHi(fpos, spos);
            END
            ELSE IF (spos = 10) AND (fpos < fcount - 1) THEN
            BEGIN
              OutPutFiles(fpos - 9);
              Inc(fpos);
              WriteHi(fpos, spos);
            END;
          END;
          #72 :
          BEGIN
            IF spos > 0 THEN
            BEGIN
              WriteLo(fpos, spos);
              Dec(spos);
              Dec(fpos);
              WriteHi(fpos, spos);
            END
            ELSE IF (spos = 0) AND (fpos > 0) THEN
            BEGIN
              Dec(fpos);
              OutPutFiles(fpos);
              WriteHi(fpos, spos);
            END;
          END;
          #59 :
          BEGIN
            hstr := pstr;
            i := ReadXY(5, 6, 72, hstr);
            IF GetStar(hstr) THEN
            BEGIN
              IF i = KESC THEN hstr := pstr;
              FSplit(hstr, s1, s2, s3);
              {$I-}
              ChDir(s1);
              {$I+}
              IF IOResult = 0 THEN pstr := hstr;
              UpString(pstr);
              WriteXY(5, 6, pstr);
              FOR i := Length(pstr) TO 71 DO Write(' ');
              TextBackGround(BLUE);
              NewClearBox(28, 9, 53, 19);
              fcount := ReadDir(pstr, flist);
              spos := 0;
              fpos := 0;
              OutPutFiles(fpos);
              WriteHi(fpos, spos);
            END
            ELSE
            BEGIN
              t := #254;
              pstr := hstr;
            END;
          END;
          #60 :
          BEGIN
            TextBackGround(BLUE);
            NewClearBox(28, 9, 53, 19);
            ParentDir(pstr);
            ChDir(pstr);
            pstr := DEF_EXT;
            pstr := FExpand(pstr);
            fcount := ReadDir(pstr, flist);
            spos := 0;
            fpos := 0;
            OutPutFiles(fpos);
            WriteHi(fpos, spos);
            TextColor(YELLOW);
            TextBackGround(BLUE);
            WriteXY(5, 6, pstr);
            FOR i := Length(pstr) TO 71 DO Write(' ');
          END;
        END;
      END;
    END;
  UNTIL (t = #255) OR (t = #254);
  IF t = #255 THEN pstr := '';
  FileRequester := pstr;
END;


{$F+}
PROCEDURE Bist_Deppat;
INTERRUPT;
BEGIN
  Color(CYAN + BLINK, BLUE);
  NewTextBox(3, 14, 20, 17, FDOUBLE);
  WriteXY(5, 15, ' LEIDA NICHT!');
  WriteXY(5, 16, 'Press any key.');
  ReadLn;
  GotoXY(3, 15);
  NewClearBox(3, 14, 21, 17);
END;
{$F-}


PROCEDURE SetInt;
BEGIN
  GetIntVec(5, oldprt);
  GetIntVec(7, oldres);
  SetIntVec(5, @Bist_Deppat);
  SetIntVec(7, @Bist_Deppat);
END;


PROCEDURE ClrInt;
BEGIN
  SetIntVec(5, oldprt);
  SetIntVec(7, oldres);
END;


BEGIN
END.