
// Franz Esberger  3CNL03  TGM 1992 Projektarbeit in TINF


#include <bios.h>            // Einbinden der bios.h
#include <graphics.h>        // Einbinden der graphics.h
#include <conio.h>           // Einbinden der conio.h
#include <stdio.h>           // Einbinden der stdio.h

void Titelbild   (void);
void Bildmaske   (void);
void Auswahl     (void);
void Hering      (void);
void Mueller     (void);
void Oppel       (void);
void Poggendorff (void);


int  Maxx, Maxy;      //globale Integer
int  x, y;

void Titelbild(void)
{
  cleardevice();                                    // Graphikschirm lschen
  setcolor(14);                                     // Textfarbwahl
  settextstyle(2,HORIZ_DIR,10);                     // Textstilauswahl
  settextjustify(CENTER_TEXT,CENTER_TEXT);          // Textausrichtung
  outtextxy(Maxx/2, Maxy/3, "U N R E A L");            // Textposition, Text
  getch();                                          // Tastendruck abwarten
}



// Bild des Hauptmens
void Bildmaske (void)
{
  cleardevice();                                   // Grafikschirm lschen

  setcolor(14);                                    // Farbenwahl
  settextstyle(2, HORIZ_DIR, 10);                  // Textstilwahl
  settextjustify(CENTER_TEXT, CENTER_TEXT);        // Textausrichtungswahl
  outtextxy(Maxx/2, 2*y, "Optische Tuschungen");  // Textposition, Text

  setcolor(12);
  settextstyle(2, HORIZ_DIR, 6);
  outtextxy(Maxx/2, 4*y, "Die folgenden Beispiele sind Demonstrationen von");
  outtextxy(Maxx/2, 5*y, "optischen Tuschungen.");

  setcolor(10);
  settextstyle(2, HORIZ_DIR, 7);
  outtextxy(Maxx/2, 10*y, "h) Hering-Tuschung        m) Mller-Lyer-Tuschung");
  outtextxy(Maxx/2, 13*y, "o) Oppel-Tuschung         p) Poggendorff-Tuschung");
  setcolor(13);
  outtextxy(Maxx/2, 16*y, "ENDE = 'ESC'");

  setcolor(9);
  outtextxy(Maxx/2, Maxy-2*y, "Whlen knnen Sie mit einen der Anfangs-Buchstaben!");
  setcolor(7);
  settextstyle(2, HORIZ_DIR, 4);
  outtextxy(Maxx/2, Maxy-y, "by Franz Esberger '92");
}


void Auswahl (void)
{
  unsigned Auswahl;

  // constante Abstnde definieren
  x = Maxx/40;
  y = Maxy/20;

  Bildmaske ();                    // Ausfhrung der void Bildmaske

  do
  {
    Auswahl = bioskey(1);          // prft ob ein Zeichen anliegt=>ja=>lifert '1'
    if (Auswahl != 0)              // Vergleich des bioskeywertes
    {
      Auswahl = bioskey(0);        // Liefert den Wert des aktuellen Tastendrucks
      switch (Auswahl)             // schalten des Tasten-Hex_Wertes in den jeweiligen case
      {
	case 0x2368: case 0x2348:  // Hex 2368 = H       Hex 2348 = h
	  Hering ();               // Ausfhrung der void Hering
	  break;

	case 0x324d: case 0x326d:  // Hex 324d = D       Hex 326d = d
	  Mueller ();              // Ausfhrung der void Mueller
	  break;

	case 0x184f: case 0x186f:  // Hex 184f = O       Hex 186f = o
	  Oppel ();                // Ausfhrung der void Oppel
	  break;

	case 0x1950: case 0x1970:  // Hex 1950 = P       Hex 1970 = p
	  Poggendorff ();          // ausfhrung der void Poggendorf
	  break;
      }
      Bildmaske ();
    }
  }
  while (Auswahl != 0x11b);               // Beenden wenn gedrckte Taste ist 'ESC'

  cleardevice();                          // Grafikbildschirm lschen
  closegraph();                           // Grafikmode verlassen
}


void Hering (void)
{
  cleardevice();                          // Lschen des Graphikschirmes
  setcolor(5);
  settextstyle(2, HORIZ_DIR, 7);          // Textstil whlen
  outtextxy(Maxx/2, 2*y, "HERING-TUSCHUNG");          // Textausgabe

  // Textausgabe der Hering-Tuschung-Erluterung
  setcolor(3);
  settextstyle(2, HORIZ_DIR, 6);
  outtextxy(Maxx/2, 5*y, "Ein bekanntes Beispiel fr eine optische Tuschung");
  outtextxy(Maxx/2, 6*y, "ist die von Hering, die besagt, da zwei Parallele,");
  outtextxy(Maxx/2, 7*y, "die durch ein Strahlengitter gehen");
  outtextxy(Maxx/2, 8*y, "'KONKAV' gekrmmt erscheinen.");
  setcolor(6);
  outtextxy(Maxx/2, 15*y, "Weiter mit Taste!");

  getch();                                // Tastendruck abwarten
  cleardevice();                          // Lschen des Graphikschirms

  // Zeichnen der Hering-Graphik
  setcolor(6);
  line(Maxx/2-7*x,  0,   Maxx/2+7*x,  Maxy);
  line(Maxx/2+7*x,  0,   Maxx/2-7*x,  Maxy);
  line(Maxx/2-16*x, 2*y, Maxx/2+16*x, Maxy-2*y);
  line(Maxx/2+16*x, 2*y, Maxx/2-16*x, Maxy-2*y);
  line(Maxx/2-19*x, 5*y, Maxx/2+19*x, Maxy-5*y);
  line(Maxx/2+19*x, 5*y, Maxx/2-19*x, Maxy-5*y);
  line(0,           8*y, Maxx,        8*y);
  line(Maxx,        12*y, 0,          12*y);

  getch();                                // Tastendruck abwarten
}


void Mueller (void)
{
  cleardevice();                          // Lschen des Graphikschirms
  setcolor(5);
  settextstyle(2, HORIZ_DIR, 7);          // Textstil whlen
  outtextxy(Maxx/2, 2*y, "MLLER-TUSCHUNG");

  // Textausgabe der Mller-Lyr-Erklrung
  setcolor(3);
  settextstyle(2, HORIZ_DIR, 6);
  outtextxy(Maxx/2, 5*y, "Bei der Mller-Lyer-Tuschung wird eine mit nach");
  outtextxy(Maxx/2, 6*y, "auen weisenden Winkel abgeteilte Strecke fr grer");
  outtextxy(Maxx/2, 7*y, "gehalten als eine Strecke mit nach innen");
  outtextxy(Maxx/2, 8*y, "weisenden Winkel.");
  setcolor(6);
  outtextxy(Maxx/2, 15*y, "Weiter mit Taste!");

  getch();                                // Tastendruck abwarten
  cleardevice();                          // Lschen des Graphikschirms

  // Zeichnen der Mller-Lyer-Graphik
  setcolor(13);
  line(4*x,   10*y,  40*x,  10*y);
  line(0,     7*y,   4*x,   10*y);
  line(0,     13*y,  4*x,   10*y);
  line(26*x,  7*y,   22*x,  10*y);
  line(26*x,  13*y,  22*x,  10*y);
  line(36*x,  7*y,   40*x,  10*y);
  line(36*x,  13*y,  40*x,  10*y);

  getch();                                // Tastendruck abwarten
}


void Oppel (void)
{
  cleardevice();                          // Graphikschirm lschen
  setcolor(5);
  settextstyle(2, HORIZ_DIR, 7);          // Textstil whlen
  outtextxy(Maxx/2, 2*y, "OPPEL-TUSCHUNG");       // Textausgabe

  // Textausgabe der Oppel-Tuschung-Erklrung
  setcolor(3);
  settextstyle(2, HORIZ_DIR, 6);
  outtextxy(Maxx/2, 5*y, "Eine Variation der optischen Tuschung ist die Oppel-");
  outtextxy(Maxx/2, 6*y, "Tuschung, bei der eine UNTERTEILTE Linie");
  outtextxy(Maxx/2, 7*y, "fr lnger gehalten wird als eine gleich lange");
  outtextxy(Maxx/2, 8*y, "NICHT UNTERTEILTE Linie.");
  setcolor(6);
  outtextxy(Maxx/2, 15*y, "Weiter mit Taste!");

  getch();                                // Tastendruck abwarten
  cleardevice();                          // Lschen des Graphikschirms

  // Zeichnen der Oppel-Graphik
  setcolor(14);
  line(0,     10*y,   x*40,  10*y);
  line(0,     9.5*y,  0,     10.5*y);
  line(x,     9*y,    x,     11*y);
  line(2*x,   9.5*y,  2*x,   10.5*y);
  line(3*x,   9*y,    3*x,   11*y);
  line(4*x,   9.5*y,  4*x,   10.5*y);
  line(5*x,   9*y,    5*x,   11*y);
  line(6*x,   9.5*y,  6*x,   10.5*y);
  line(7*x,   9*y,    7*x,   11*y);
  line(8*x,   9.5*y,  8*x,   10.5*y);
  line(9*x,   9*y,    9*x,   11*y);
  line(10*x,  9.5*y,  10*x,  10.5*y);
  line(11*x,  9*y,    11*x,  11*y);
  line(12*x,  9.5*y,  12*x,  10.5*y);
  line(13*x,  9*y,    13*x,  11*y);
  line(14*x,  9.5*y,  14*x,  10.5*y);
  line(15*x,  9*y,    15*x,  11*y);
  line(16*x,  9.5*y,  16*x,  10.5*y);
  line(17*x,  9*y,    17*x,  11*y);
  line(18*x,  9.5*y,  18*x,  10.5*y);
  line(19*x,  9*y,    19*x,  11*y);
  line(20*x,  9.5*y,  20*x,  10.5*y);

  getch();                                // Tastendruck abwarten
}


void Poggendorff (void)
{
  cleardevice();                          // Lschen des Graphikschirms
  setcolor(5);
  settextstyle(2, HORIZ_DIR, 7);          // Textstil whlen
  outtextxy(Maxx/2, 2*y, "POGGENDORFF-TUSCHUNG");        // Textausgabe

  // Textausgabe der Poggendorff-Tuschung-Erklrung
  setcolor(3);
  settextstyle(2, HORIZ_DIR, 6);
  outtextxy(Maxx/2, 5*y, "Die Poggendorff-Tuschung tritt ein, wenn z.B. ein oder");
  outtextxy(Maxx/2, 6*y, "zwei Streifen mit parallel verlaufenden Kanten von einer");
  outtextxy(Maxx/2, 7*y, "LINIE im Winkel von weniger als 90 gekreuzt werden.");
  outtextxy(Maxx/2, 8*y, "Die schrge LINIE wird dann als seitlich verstezt");
  outtextxy(Maxx/2, 9*y, "wahrgenommen!");
  setcolor(6);
  outtextxy(Maxx/2, 15*y, "Weiter mit Taste!");

  getch();                               // Tastendruck abwarten
  cleardevice();                         // Lschen des Graphikschirms

  // Zeichnen der Poggendorff-Graphik
  setcolor(14);
  line(Maxx/2-x,    0,  Maxx/2-x,    Maxy);
  line(Maxx/2-3*x,  0,  Maxx/2-3*x,  Maxy);
  line(Maxx/2+x,    0,  Maxx/2+x,    Maxy);
  line(Maxx/2+3*x,  0,  Maxx/2+3*x,  Maxy);
  line(Maxx-4*x,    0,  Maxx/2+3*x,  8.6*y);
  line(Maxx/2-x,      11.1*y,  Maxx/2+x,    9.8*y);
  line(4*x,         Maxy,    Maxx/2-3*x,  12.3*y);

  getch();                               // Tastendruck abwarten
}


void main(void)
{
  int Treiber = DETECT;                  // fr autom. Auflsungsermittlung
  int Modus;
  char* Pfad = "a:\\bgi\\";          // Pfadangabe fr die BGI-Dateien

  initgraph (&Treiber, &Modus, Pfad);    // Treiber, Grafikmode einstellen

  // Auflsung ermitteln
  Maxx = getmaxx ();                     // max. horiz. Punktanzahl
  Maxy = getmaxy ();                     // max. vertik. Punktanzahl

  Titelbild ();

  Auswahl ();

  printf("Thank you for using  'U N R E A L', programmed by Franz Esberger");

}                                        // Programmende


