{ͻ
   Programm:    Maustestprogramm              Datei:   MAUSDEMO.PAS      
 Ķ
   Autor:       AV. DI. Wilh. Junker (u.a.)   Datum:   10. April 1992    
 Ķ
   Schule:      HTL Waidhofen/Ybbs            Sprache: Turbo-Pascal 6.0  
 ĺ
   Vorfhrung einer Mausprogrammierung mit Zeigermaske und Bildschirm-   
   maske fr drei verschiedene Zeigerformen (Kreuz, Hand, Uhr)           
   Einsatz einer Maus-Unit fr diesen  Anwendungsfall                    
   Dieses Programm dient zur Untersttzung des EDV-Unterrichtes          
                                                          194  Zeilen    
 ͼ}
{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V-}
{$M 16384,0,655360}

Program MOUSETEST;

USES  Crt, Graph, Mouse;

CONST
  BoxCount = 5;                                   { Zahl der Rechtecke }
  BoxMsg   : ARRAY [1..BoxCount] OF String =
    ('Ende', 'Standard', 'Kreuz', 'Hand', 'Uhr'); { Texte }
  y1=40;                                          { obere Rahmenposition  }
  y2=70;                                          { untere Rahmenposition }

  KreuzCursor : SCMaskType = (
    SMask: ($FEFF,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$8383,$0381,
            $8383,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$FEFF,$FFFF);
    CMask: ($0000,$0100,$0100,$0100,$0100,$0100,$0000,$7C7C,
            $0000,$0100,$0100,$0100,$0100,$0100,$0000,$0000));

  HandCursor  : SCMaskType = (
    SMask: ($87FF,$003F,$0007,$6003,$E001,$F001,$C000,$8000,
            $8000,$F000,$FC00,$FF00,$FFC0,$FFF0,$FFFF,$FFFF);
    CMask: ($2000,$5200,$9140,$0928,$08A4,$0494,$0414,$3202,
            $0E01,$0301,$00C0,$0030,$000C,$0000,$0000,$0000));

  UhrCursor   : SCMaskType = (
    SMask: ($E007,$C003,$8001,$0000,$0000,$0000,$0000,$0000,
            $0000,$0000,$0000,$0000,$0000,$8001,$C003,$E007);
    CMask: ($07E0,$1818,$2184,$4182,$4182,$8181,$8181,$8181,
            $81FD,$8001,$8001,$4002,$4002,$2004,$1818,$07E0));

VAR
  VideoMode :                       Byte ABSOLUTE $0040:$0049;
  graphdriver,graphmode,MaxX,MaxY : Integer;
  BoxSize   :                       Word;
  BoxPos    :                       ARRAY [1..BoxCount] OF WORD;
  Func,i    :                       Integer;
  Lx, Ly    :                       Word;



Procedure INITBOX;        { Koordinaten der Rechtecke berechnen }

VAR
   I:   Integer;
   X:   Word;

Begin
   BoxSize := MaxX DIV BoxCount;
   X := 0;
   FOR I:=1 TO BoxCount Do
   Begin
     BoxPos[i]:=x;
     x:=x+BoxSize;
   End;
End;


Procedure SHOWBOX;        { alle Rechtecke anzeigen }

VAR
   I:  Integer;

Begin
  SetTextJustify (LeftText,TopText);
  FOR I:=1 To BoxCount Do
  Begin
     RecTangle (BoxPos[I], Y1, BoxPos[I] + BoxSize, Y2);
     OutTextXY (BoxPos[I] + 5, Y1 + 5, BoxMsg[I]);
  End;
End;


Procedure ERRBEEP;

Begin
   NoSound;
   Sound (220);
   Delay (100);
   NoSound
End;


Procedure OKBEEP;

Begin
   NoSound;
   Sound (2200);
   Delay (70);
   NoSound
End;


PROCEDURE DisplayCoordinates;

Var
   X, Y:   Word;
   XS, YS: String;

Begin
   X := MouseXpos;
   Y := MouseYpos;           { aktuelle Mauskoordinaten lesen }
   IF (Lx <> X) OR (Ly <> Y) THEN
   Begin                     { nderung ? }
      Str (X:3, Xs);
      Str (Y:3, Ys);         { Koordinaten IN STRING wandeln }
      SetFillStyle (SolidFill, 0);
      MouseHide;             { Mauszeiger abschalten }
      Bar (0, 0, 87, 10);    { Letzten TEXT lschen }
      OutTextXY (1, 1, 'X:'+ XS + ' Y:' + YS); { und neuen TEXT anzeigen }
      MouseShow;             { Mauszeiger einschalten }
      Lx := X;
      Ly := Y;                { aktuelle Koordinaten merken }
  End;
End;

{ Hauptprogramm }
Begin
   Graphdriver := Detect;
   InitGraph (GraphDriver, GraphMode, '\tp6\bgi');
   ClearViewPort;
   DirectVideo := FALSE;
   { --- bei HGC den Maustreiber foppen! --- }
   IF VideoMode=7 THEN VideoMode:=6;
   { --- Maustreiber OK? --- }
   If NOT MouseInstalled THEN
   Begin
      CloseGraph;
      Writeln ('Maustreiber ist nicht installiert', #7);
      Halt (1)
   End;
   MaxX := GetMaxX;
   MaxY := GetMaxY;                         { Grafikauflsung ermitteln }
   SetTextStyle (DefaultFont, HorizDir, 1);         { Schrift auswhlen }
   SetTextJustify (CenterText, TopText);
   OutTextXY (MaxX DIV 2, 0, 'Waehlen Sie eine Cursorform:');
   OutTextXY (MaxX DIV 2, MaxY-8, 'Demoprogramm fuer Unit MOUSE.PAS');
   SetColor (GetMaxColor);
   InitBox;
   ShowBox;
   MouseInit;
   MouseShow;
   REPEAT
      REPEAT
         DisplayCoordinates;           { Koordinaten der Maus anzeigen }
      UNTIL (MouseButton=1) OR KeyPressed;    { Auf Tastendruck warten }
      Func := 0;
      FOR I := 1 TO BoxCount DO
      Begin                               { welche Box ist angewhlt ? }
         IF MouseInWindow (BoxPos[i], Y1, BoxPos[I] + BoxSize, Y2) THEN
                 Func := I;
      End;
      CASE Func OF
         1 : OkBeep;
         2 : Begin
                OkBeep;
                MouseInit;
                MouseShow;
             End;
         3 : Begin
                MouseSetGraphCursor (7, 7, KreuzCursor);
                OkBeep
             End;
         4 : Begin
                MouseSetGraphCursor (0, 2, HandCursor);
                OkBeep
             End;
         5 : Begin
                MouseSetGraphCursor (8, 7, UhrCursor);
                OkBeep
             End;
      ELSE ErrBeep
      End;
      REPEAT
      UNTIL MouseButton = 0;         { warten, bis Taste losgelassen }
   UNTIL (Func=1) OR (KeyPressed AND (ReadKey=#27));
   MouseHide;
   CloseGraph;
End.