{ͻ
   Programm:    Maus im Textmodus             Datei:   MAUSTEXT.PAS      
 Ķ
   Autor:       AV. DI. Wilh. Junker          Datum:   10. April 1992    
 Ķ
   Schule:      HTL Waidhofen/Ybbs            Sprache: Turbo-Pascal 6.0  
 ĺ
   Dieses Programm zeigt wie man die Microsoft Maus ansprechen kann, die 
   eine 2-Tasten-Maus ist (auch Treiber fr 3-Tasten-Muse verfgbar).   
   Der Maustreiber mu unbedingt geladen sein bevor dieses Programm luft
                                                                         
                                                                         
   Codierung der Mauseingabe (3 Gruppen  7 Bit) :                       
                                                                         
      1. Byte     1  Li  Re  Y7  Y6  X7  X6                              
      2. Byte     0  X5  X4  X3  X2  X1  X0                              
      3. Byte     0  Y5  Y4  Y3  Y2  Y1  Y0                              
                                                                         
                                                                         
   Parameter fr die serielle bertragung:                               
                                                                         
   Baudrate:   1200 Baud                                                 
   Wortlnge:     7 Bit                                                  
   Startbits:     1                                                      
   Stopbits:      1                                                      
   Paritt:    keine                                                     
   Paketlnge: 3 Worte (21 Bit)                                          
                                                                         
                                                                         
   Definitionen in disem Programm:                                       
                                                                         
      M1 entspricht  AH, AX                                              
      M2    ..       BX                                                  
      M3    ..       CX      zB.  Koordinate linker Rand                 
      M4    ..       DX           Koordinate oberer Rand                 
      M5    ..       SI           Koordinate rechter Rand                
      M6    ..       DI           Koordinate unterer Rand                
                                                                         
                                                                         
   Mausfunktionen (alles hexadezimal);                                   
                                                                         
      0 ... Initialisierung    ( siehe Punkt 1)                          
      1 ... Cursor zeigen      ( Sichtbarkeitszhler +1 addiert)         
      2 ... Cursor verstecken  ( Sichtbarkeitszhler -1 subtrahiert)     
      3 ... aktuelle Position abfragen (CX=waagr., DX=senkrecht          
                 BX=Zustand der Maus-Tasten:                             
                 Bit 0=links, Bit 1=rechts, Bit 2=Mitte)                 
      4 ... Zeiger positionieren                                         
      5 ... Gedrckte Tasten abfragen (wie oft seit letzt.Aufruf gedr.,  
                               CX=waagr., DX=senkr., AX=akt.Tastenzust.) 
      6 ... Losgelassene Tasten abfragen (wie oft losgel., sonst wie ob.)
      7 ... Waagrechte Grenze setzen (CX=links, DX=rechts)               
      8 ... Senkrechte Grenze setzen                                     
      9 ... GrafikCursor setzen (2 Masken definieren 16*16-Bit-Block)    
      A ... TextCursor setzen  (BX=0 f. Softw.zeiger, BX=1 f. Hardware-  
                 zeiger, bei Hardw. CX=obere Grenze, DX=untere Grenze,   
                 Softwarezeiger ber CRT-Maske und Zeigermaske definiert 
      B ... Mausbewegungen abfragen (nderungen; CX=waagr., DX=senkr.)   
      C ... Routine wird bei bestimmten Ereignissen aufgerufen (Handler  
                 wird vom Maustreiber gestartet; Adresse der Routine mu 
                 in ES:DX stehen; CX enthlt Tasten-Bedignungen; AX kann 
                 mehrere BIts d.h. Bedingungen enthalten; Storno mit     
                 dem Wert 0 im CX-Register)                              
      D ... Lichtgriffelemulation ein                                    
      E ... Lichtgriffelemulation aus                                    
      F ... Geschwindigkeit der Maus einstellen (CX=waagrechte Anz. vom  
                 Mickeys, DX=senkr. Anz. Mickeys pro 8 Bildpunkte)       
     10 ... Cursor in einem bestimmten Bildschirmbereich unsichtbar      
     13 ... Bewegungstempo-Wechsel einstellen (Grenze zw.langs.u.schnell 
                 im DX-Register, Standard bei 64 Mickeys)                
     14 ... Interruptroutine wechseln (Ergnzung zu Funktion C, Adresse  
                 alten Routine in ES:DX, alte Bitleiste in CX)           
     15 ... Speicherbereich fr den Zustand der Maus bei Rettung (im Reg.
                 BX Anzahl der erford. Bytes)                            
     16 ... Zustands-Rettung (Speicherbreich in ES:DX)                   
     17 ... Rckgngigmachen von Funktion 16                             
     18 ... Mausroutinen einrichten (bis zu 3; Ereignismaske in CX,      
                 Adresses der Routine in ES:DX)                          
     19 ... Adresse der vorherigen Routine abfragen (Wie vorher, nur     
                 Routine in BX und DX; CX auf 0 gesetzt wenn keine Rout. 
     1A ... Kombination von 0F und 13                                    
     1B ... Abfrage der eingestellten Werte                              
     1D ... Festlegung der Bildschirmseite des Mauszeigers (BL-Register) 
     1E ... Abfrage der Bildschirmseite des Mauszeigers (AL-Register)    
     1F ... Abschalten des Maustreibers (nicht der Maus, zB bei Messung  
                 und Restaurierung des Interrupt 10h, bei erfolgreicher  
                 Desaktivierung FFFFh in AX)                             
     20 ... Wieder-Aktivierung des Maustreibers (Umkehrung von 1Fh)      
     21 ... Maustreiber wird rckgesetzt (nicht die Maus; FFFF in AX     
                 wennn Maustreiber installiert; BX=Anz der Maustasten)   
     22 ... Sprache festlegen (Zahl im BX-Register)                      
     23 ... Abfrage der eingestellten Sprache (Umkehrung von 22)         
     24 ... Infos ber Maustreiber und Maus (BH=Hauptversion, BL=Unter-  
                 version, CH=Maustyp zB 2=seriell, CL=Int-Nummer)        
                                                                         
                                                                         
   Definition des HOT SPOT beim Graphikzeiger:                           
                                                                         
   Dieser Punkt, dessen Position fr die nachfolgende Verarbeitung we-   
       sentlich ist, wird relativ zum Graphikzeiger angegeben.           
                                                                         
   Koordinaten der oberen linken Ecke:   ( 0,  0)                        
   Koordinaten der unteren rechten Ecke: (15, 15)                        
                                                                         
   Mgliche Werte fr die Koordinaten: -16 (im Block) bis +16  (auer-   
        halb des Blocks.                                                 
                                                                         
                                                                         
   Attributwort fr den Textzeiger:                                      
                                                                         
   Bit  15 14  13  12 11 10   9   8   7   6   5   4   3   2   1   0  
       BliHintergrundHellVordergrund          ASCII - Code           
                                                                         
                                                                         
   Bitleiste fr Funktionen 0C und 14 (Tastendrcke):                    
                                                                         
    Bit    7    6    5    4    3    2    1    0                          
          ---  mit  mit  re   re   li   li   Maus                        
               los  ged  los  ged  los  ged  bewegt                      
                                                                         
                                                                         
   Bitleiste fr Funktionen 18 und 19 (Tastendrcke):                    
                                                                         
    Bit    9     8     7     6     5     4     3     2     1     0       
         mittl mittl  Maus linke linke recht recht  Shift  Ctrl  Alt     
          los   ged   bew   los   ged   los   ged   ged    ged   ged     
                                                                         
                                                                         
   Formel fr die Mausdarstellung:                                       
                                                                         
   Attribute = ((Zeichenattribut) AND (Bildschirmmaske)) XOR Zeigermaske)
                                                                         
   Beispiele: BS-Maske  ZG-Maske                                         
                FF00      0800   alle Attr. bernehmen, Intensitt hoch  
                FF00      7700   gleiche Attr., genderte Farben         
                1F00      E000   gleiche Attr., Hintergrund hellgrau     
                                                                         
                                                                         
   Virtueller Bildschirm:                                                
                                                                         
      CGA      640 * 200            8 * 8 Zeichengre manchmal 16*16    
      EGA      640 * 350                                                 
      VGA      640 * 480                                                 
      Hercules 720 * 348                                                 
                                                                         
                                                                         
   Bewegung der Maus wird in MICKEYs gemessen:  1/200 Zoll = 0.1 bis     
   0.2 mm                                                                
                                                                         
   Dieses Programm dient zur Untersttzung des EDV-Unterrichtes          
 ͼ}

Program MAUSTEXT;

Uses CRT, DOS;

Var
   OldX, OldY, X, Y, I:     Integer;   { Mauspositionen }
   M1, M2, M3, M4, M5, M6 : Integer;   { Maus-16-Bit-register zur bergabe }
   M2H, M2L, M3H, M3L :     ShortInt;  { Maus-8-Bit-Register zur bergabe }
   Regs :                   Registers; { DOS-Typ aufrufen }
   B, C:                    ShortInt;
   Ch:                      Char;


Procedure Header;

var Zahl:Integer;

begin
   Textbackground (1);
   Clrscr;
   Textcolor (14);
   Write ('');
   Writeln ('ͻ ');
   For Zahl:=2 to 22 do
   Begin
      Gotoxy (1,zahl); write ('');
      Gotoxy (79,zahl); writeln ('')
   End;
   Write ('');
   Writeln ('ͼ ');
   Gotoxy (1,5);
   Write ('');
   Writeln ('͹ ');
   Gotoxy (1,21);
   Write ('');
   Writeln ('͹ ');
   Textcolor (13);
   Gotoxy(3,2);
   Writeln ('           Hhere  Technische Bundes-Lehr- und Versuchsanstalt');
   Gotoxy (3,3);
   Writeln ('           Abteilung fr Maschinenbau-Autimatisierungstechnik ');
   Gotoxy (3,4);
   Writeln ('             Abteilungsvorstand:   Dipl.-Ing. Wilhelm Junker');
   TextBackGround (1);
   TextColor (14)
End;


Procedure TITEL;

Var I:Char;

Begin
   Gotoxy (13,8);
   Textbackground (0);
   Textcolor (14);
   Writeln ('   L E R N P R O G R A M M    f  r  d i e   M A U S   ');
   Gotoxy (18, 11);
   Textbackground (1);
   Textcolor (11);
   Writeln (' auf der Basis des Buches von Thomas Little ');
   Gotoxy (24, 13);
   Writeln ('   '' DAS   P C  -  B U C H ''   ');
   Gotoxy (35,16);
   Textcolor (13);
   Writeln ('verfat von');
   Gotoxy (23,18);
   Writeln ('AV. OStr. Dipl.-Ing. Wilhelm Junker');
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 22);
   Write (' Bitte eine beliebige Taste drcken ! ');
   Ch := Readkey;
End;


Procedure Rahmen;
Var I: Integer;
Begin
   TextBackground (1);
   TextColor (14);
   Writeln ('ͻ');
   For I := 2 to 23 Do
   Begin
      Gotoxy (1, I);
      Write (#186);
      Gotoxy (80, I);
      Write (#186)
   End;
   Write ('ͼ');
End;


Procedure Tastendruck;
Begin
   TextBackground (1);
   TextColor (14);
   Gotoxy (2, 24);
   Write ('');
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 24);
   Write (' Bitte eine beliebige Taste drcken ! ');
   Ch := Readkey;
End;


Procedure Mausbewegen;
Begin
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 24);
   Write (' Bitte versuchsweise Maus bewegen   ! ');
   Ch := Readkey;
 End;


Function StrNeu (Angabe: LongInt; Z: Integer): String;
Var
   Zahl: LongInt;
   StrAlt: String[6];
   ZwErg, Erg: LongInt;
   St: String[1];

Begin
   Zahl := Angabe;
   StrAlt := '$';
   Repeat
      Erg := Zahl Div 16;
      ZwErg := Zahl Mod 16;
      If ZwErg= 0 Then ST := '0';
      If ZwErg= 1 Then ST := '1';
      If ZwErg= 2 Then ST := '2';
      If ZwErg= 3 Then ST := '3';
      If ZwErg= 4 Then ST := '4';
      If ZwErg= 5 Then ST := '5';
      If ZwErg= 6 Then ST := '6';
      If ZwErg= 7 Then ST := '7';
      If ZwErg= 8 Then ST := '8';
      If ZwErg= 9 Then ST := '9';
      If ZwErg=10 Then ST := 'A';
      If ZwErg=11 Then ST := 'B';
      If ZwErg=12 Then ST := 'C';
      If ZwErg=13 Then ST := 'D';
      If ZwErg=14 Then ST := 'E';
      If ZwErg=15 Then ST := 'F';
      Zahl := Erg;
      StrAlt := St + StrAlt;
   Until Erg=0;
   StrNeu := StrAlt;
End;


Procedure Maus (M1, M2, M3, M4, M5, M6 : Integer);

Begin
   With Regs do     { bergabe von 6 Werten zur Verarbeitung durch den Int }
   begin
      AX := M1;    { AX, BX, CX, DX, SI, DI fr den Interrupt vorbereiten }
      BX := M2;
      CX := M3;
      DX := M4;
      SI := M5;
      DI := M6
   end;
   Intr ($33, Regs);
end;   { der Prozedur Maus }

Procedure THEORIE;
   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := Yellow;
      Gotoxy (6, 2);
      Writeln ('             -  T  -  H  -  E  -  O  -  R  -  I  -  E   -             ');
      TextColor (14);
      TextColor (11);
      Gotoxy (6, 4);
      Write (' ber ');
      Textcolor (12);
      Write ('Interrupt 33h ');
      Textcolor (11);
      Writeln ('werden alle Mausfunktionen ausgefhrt.            ');
      Gotoxy (6, 6);
      Textcolor (10);
      Writeln (' Im Rahmen dieses Programmes wurde eine Procedure definiert, welche   ');
      Gotoxy (6, 7);
      Writeln (' folgendermaen aufgerufen wird:                                      ');
      Gotoxy (6, 9);
      Textcolor (11);
      Writeln ('         MAUS  (M1, M2, M3, M4, M5, M6);                              ');
      Gotoxy (6, 11);
      Textcolor (10);
      Writeln (' Die einzelnen Parameter Mi haben folgende Bedeutung:                 ');
      Gotoxy (6, 13);
      Textcolor (13);
      Writeln ('     M1  ....  Register AX (enthlt die Funktions-Nummer)   ');
      Gotoxy (6, 14);
      Writeln ('     M2  ....  Register BX (zB Tastenabfragen)              ');
      Gotoxy (6, 15);
      Writeln ('     M3  ....  Register CX (zB Koordinate links oben)       ');
      Gotoxy (6, 16);
      Writeln ('     M4  ....  Register DX (zB Koordinate linker Rand)      ');
      Gotoxy (6, 17);
      Writeln ('     M5  ....  Register SI (zB Koordinate rechts auen)     ');
      Gotoxy (6, 18);
      Writeln ('     M6  ....  Register DI (zB Koordinate unterer Rand)     ');
      Gotoxy (6, 20);
      Textcolor (10);
      Writeln (' Diese Register mssen vor dem Aufruf jeweils vorbereitet werden resp.');
      Gotoxy (6, 21);
      Writeln (' knnen nach dem Aufruf ausgelesen werden.                            ');
      Tastendruck
   End;


{  1.
 Ŀ
   Wirkung der Funktion 0:                                             
      Position des Zeigers mittig am Bildschirm                        
      Sichtbarkeitszhler:-1 (sichtbar bei 0, gleichzeitig Maximalwert)
      Graphikzeiger: Pfeil schrg nach oben                            
      Textzeiger: Software mit invert. Farben                          
      Ereignismaske fr InterruptRoutinen: keine                       
      Lichtgriffelemulation: ein                                       
      Waagrechte Geschwindigkeit: 8 Mickey pro 8 Bildpunkte            
      Senkrechte Geschwindigkeit: 16 Mickey pro 8 Bildpunkte           
      Bildschirmseite 0                                                
      Ganzer Schirm                                                    
   Im Register AX wird ber den Code 0FFFFh das Vorhandensein eines    
   Maustreibers rckgemeldet.                                          
   Die Anzahl der bentzbaren Tasten wird in BX abgelegt.              
 }

Procedure INITIALISIERUNG;

   VAR
      P:      Pointer;
      Hilfe:  LongInt;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('            Anwendung 1:   I N I T I A L I S I E R U N G              ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                   Funktionen:   0, 1 und  2 hex                      ');
      TextColor (11);
      Gotoxy (6, 6);
      Write (' Nach dem Aufruf von ');
      Textcolor (12);
      Write ('Funktion 0h ');
      Textcolor (11);
      Write (' werden verschiedene Vorbereitungen  ');
      Gotoxy (6, 7);
      Write (' getroffen, der Zeiger bleibt zunchst unsichtbar.                    ');
      Gotoxy (6, 8);
      Textcolor (13);
      Writeln (' Der Sichtbarkeitszhler steht auf -1.                                ');

      M1 := 0;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;

      Textcolor (11);
      Gotoxy (6, 12);
      Write (' Nach Aufruf der ');
      Textcolor (12);
      Write ('Funktion 1h ');
      Textcolor (11);
      Writeln ('wird der Sichtbarkeitszhler um 1 auf 0  ');
      Gotoxy (6, 13);
      Writeln (' erhht und der Cursor wird standardmig in Bildmitte sichtbar.      ');

      M1 := 1;
      Maus (M1, M2, M3, M4, M5, M6);
      TextBackGround (0);
      Textcolor (15);
      Gotoxy (15, 24);
      Write (' Bitte versuchsweise Maus bewegen, dann Tastendruck  ! ');
      Ch := Readkey;
      Textcolor (11);
      Gotoxy (6, 17);
      Write (' Mit Hilfe der ');
      Textcolor (12);
      Write ('Funktion 2h ');
      Textcolor (11);
      Writeln ('wird der Sichtbarkeitszhler um 1 ernie-   ');
      Gotoxy (6, 18);
      Writeln (' drigt und der Cursor wird unsichtbar.                                ');

      M1 := 2;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck
   End;


{  2.
 Ŀ
   Die FUNKTION 21h                                                    
   setzt den Maustreiber (hnlich Funktion 0) zurck (nicht aber die   
   Maus-Hardware). Die Anzahl der Maustasten wird in BX gemeldet.      
   Ist ein Treiber installiert, wird 0FFFFh in AX bergeben.           
                                                                       
   Die FUNKTION 23h                                                    
   liefert im Register BX die eingestellt Sprache zurck.              
 }

Procedure SYSTEMDATEN;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('                  Anwendung 2:   S Y S T E M D A T E N                ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                       Funktionen:  21 und 23 hex                     ');
      TextColor (10);
      Gotoxy (6, 6);
      Writeln (' Zunchst wird nach verschiedenen Systemdaten gefragt.                ');
      Textcolor (11);
      Gotoxy (6, 8);
      Write (' ber ');
      Textcolor (12);
      Write ('Funktion 21h ');
      Textcolor (11);
      Writeln ('wird die Anzahl der Tasten abgefragt und das Vor-  ');
      Gotoxy (6, 9);
      Writeln (' handensein eines Maustreibers besttigt.                             ');

      M1 := $21;
      Maus (M1, M2, M3, M4, M5, M6);

      Textcolor (14);
      Gotoxy (6, 11);
      Writeln (' ', Regs.BX:1, ' Tasten sind vorhanden');
      If Regs.AX = $0FFFF Then
      Begin
         Gotoxy (6, 13);
         Writeln (' Maustreiber ist vorhanden !')
      End;

      M1 := 1;                            { MAUSZEIGER SICHTBAR MACHEN }
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;

      Textcolor (11);
      Gotoxy (6, 17);
      Write (' Nach Aufruf der ');
      Textcolor (12);
      Write ('Funktion 23h ');
      Textcolor (11);
      Writeln ('wird die eingestellte Sprache gemeldet: ');
      Gotoxy (6, 18);
      Writeln (' 0  ... Englisch,          3 ... Deutsch                              ');

      M1 := $23;               { Abfrage der eingestellten Sprache }
      Maus (M1, M2, M3, M4, M5, M6);

      Gotoxy (6, 20);
      Textcolor (14);
      If Regs.BX = 0 Then Writeln (' Sprache:  Englisch ')
      Else If Regs.BX = 3 Then Writeln (' Sprache:  Deutsch ');

      Tastendruck;

   End;


{  3.
 Ŀ
   Die FUNKTION 24h                                                    
   liefert Informationen ber den Maustreiber:                         
   Register BH:  Hauptversion des Maustreibers                         
            BL:  Unterversion des Maustreibers                         
            CH:  Typ der Maus (1: Bus, 2: seriell                      
            CL:  Interrupt-Nummer der Maus                             
 }

Procedure INFORMATION;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('       Anwendung 3:   I N F O  ber  den  M A U S T R E I B E R       ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                            Funktion:  24 hex                         ');
      TextColor (11);
      Gotoxy (6, 6);
      Write (' ber ');
      Textcolor (12);
      Write ('Funktion 24h ');
      Textcolor (11);
      Writeln ('werden Informationen ber den Maustreiber ange-    ');
      Gotoxy (6, 7);
      Writeln (' fordert.                                                             ');

      M1 := $24;
      Maus (M1, M2, M3, M4, M5, M6);

      TextColor (14);
      Gotoxy (6, 10);
      Write ('    Hauptversion des Maustreibers: ');
      TextColor (12);
      Write(Regs.BH:3, '  ');
      TextColor (14);
      Gotoxy (6, 12);
      Write ('    Unterversion des Maustreibers: ');
      TextColor (12);
      Writeln (Regs.BL:3, '  ');
      TextColor (14);
      Gotoxy (6, 14);
      Write ('    Typ der Maus:                  ');
      TextColor (12);
      Writeln (Regs.CH:3, '  ');
      Gotoxy (6, 16);
      TextColor (14);
      Write ('    Interrupt-Nummer der Maus:     ');
      Textcolor (12);
      Writeln (Regs.CL:3, '  ');
      Gotoxy (6, 19);
      Textcolor (10);
      Writeln (' Nhere Infomationen hierber sind im Begleittext zu Nr. 3            ');

      M1 := 0;
      Maus (M1, M2, M3, M4, M5, M6);
      M1 := 1;
      Maus (M1, M2, M3, M4, M5, M6);

      TextColor (13);
      Gotoxy (6, 20);
      Writeln (' Sichtbar ist zunchst der bliche Hardwarezeiger auf Pos. (300, 100).');
      Tastendruck
   End;


{  4.
 Ŀ
   Die FUNKTION 0Ah                                                    
   erlaubt es, die Art des Mauszeigers (Hard- oder Software) zu defi-  
   nieren.                                                             
   Register CX:  Obere Grenze des Zeigers                              
            DX:  Untere Grenze des Zeigers                             
            BX:  Hardwarezeiger BX = 1                                 
                 Softwarezeiger BX = 0                                 
   Gre des Mauszeigers:                                              
            Bildschirmmodi 4, 5, 13:                8 * 16 Pixels      
            Bildschirmmodi 6, Herc, E, F, 10, 11:  16 * 16 Pixels      
 }

Procedure ZEIGERFORM;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('     Anwendung 4:   H A R D W A R E Z E I G E R      S E T Z E N      ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                          Funktion:  0A hex                           ');
      TextColor (11);
      Gotoxy (6, 5);
      Write (' ber ');
      Textcolor (12);
      Write ('Funktion 0Ah ');
      Textcolor (11);
      Writeln ('wird die Form des Mauszeigers definiert.           ');
      Gotoxy (6, 7);
      Writeln (' Register BX whlt Hard- oder Softwarezeiger.                         ');
      Gotoxy (6, 8);
      Writeln (' BX = 1   ...    Hardwarezeiger                                       ');
      Gotoxy (6, 9);
      Writeln (' BX = 0   ...    Softwarezeiger                                       ');
      Gotoxy (6, 10);
      Writeln (' CX .........    Obere Grenze des Zeigers                             ');
      Gotoxy (6, 11);
      Writeln (' DX .........    Untere Grenze des Zeigers                            ');
      Gotoxy (6, 15);
      Textcolor (14);
      Writeln (' Bei dieser Methode wird auch der bliche Bildschirm-Cursor verndert ');
      Gotoxy (6, 16);
      Writeln (' und verschwindet vom Bildschirm, whrend der Maus-Cursor bleibt.     ');
      Gotoxy (6, 18);
      Textcolor (15);
      Writeln (' Der HARDWARE-CURSOR ndert in der Folge einigemale seine Gre von   ');
      Gotoxy (6, 19);
      Writeln (' von schmal auf normale Hhe nach Tastendruck.                        ');
      Gotoxy (14, 24);
      Textcolor (15);
      Write (' Bitte versuchsweise Maus bewegen und Tasten drcken ! ');

      M1 := $0A;
      M2 := 1;
      M3 := 7;       { schmaler Cursor: 2 Pixelzeilen }
      M4 := 8;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;

      M1 := $0A;
      M2 := 1;
      M3 := 5;       { breiterer Cursor: 4 Pixelzeilen }
      M4 := 8;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;

      M1 := $0A;
      M2 := 1;
      M3 := 3;       { mittelbreiter Cursor: 6 Pixelzeilen }
      M4 := 8;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;

      M1 := $0A;
      M2 := 1;
      M3 := 1;       { breiter DEFAULT-Cursor: 8 Pixelzeilen }
      M4 := 8;
      Maus (M1, M2, M3, M4, M5, M6);
      Tastendruck;
   End;


{  5.
 Ŀ
   Die FUNKTIONEN 03h und 04h                                          
   erlauben es, die Position des Mauszeigers abzufragen (03h) resp.    
   den Mauszeiger an eine bestimmte Position zu setzen (04h) sowie den 
   Zustand der Maustasten anzugeben.                                   
   Register CX: waagrechte Koordinate am virtuellen Bildschirm         
            DX: senkrechte Koordinate am virtuellen Bildschirm         
            BX: Zustand der Maustasten nach folgendem Schema           
                                                                       
            Bit    7     6     5     4     3     2      1      0       
                                               mittl  linke  rechte    
                                               Taste  Taste  Taste     
 }

Procedure CURSORPOS;
Var
   CX_Alt, DX_Alt: Integer;

    Procedure MELDUNG;
    Begin
       B := 6;
       C := 15;
       Window (B, C, B+30, C+6);
       B := 1;
       C := 0;
       Textcolor (14);
       Gotoxy (B, C+2);
       If (Regs.BX And 1) = 1 Then Writeln (' Taste links ');
       Gotoxy (B, C+3);
       If (Regs.BX And 2) = 2 Then Writeln (' Taste rechts ');
       Gotoxy (B, C+4);
       If (Regs.BX And 4) = 4 Then Writeln (' Taste Mitte');
       Gotoxy (B, C+5);
       Textcolor (13);
       Writeln (' X-Pos: ', Regs.CX:3, ' (waagrecht)  ');
       Gotoxy (B, C+6);
       Writeln (' Y-Pos: ', Regs.DX:3, ' (senkrecht)  ');
       Delay (900);
       ClrScr;
    End;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln (' Anwendung 5:   M A U S Z E I G E R   A B F R A G E N  /  S E T Z E N ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                      Funktionen:  03h  und 04h                       ');
      TextColor (11);
      Gotoxy (6, 6);
      Write (' ber ');
      Textcolor (12);
      Write ('Funktion 03h ');
      Textcolor (11);
      Writeln ('wird die Zeigerposition abgefragt. In den Registern');
      Gotoxy (6, 7);
      Writeln (' CX (waagrecht) und DX (senkrecht) werden die Positionen rckgemeldet.');
      Gotoxy (6, 8);
      Textcolor (13);
      Writeln (' Im Register BX werden die Tastenbettigungen angezeigt.              ');
      Gotoxy (6, 9);
      Textcolor (10);
      Writeln (' Der Bildschirmbereich wird in Koordinaten auf dem virtuellen  Schirm ');
      Gotoxy (6, 10);
      Writeln (' angegeben.                                                           ');
      Gotoxy (6, 12);
      Textcolor (15);
      Writeln (' Die Bewegungen der Maus und die Zustnde ihrer Tasten werden nach    ');
      Gotoxy (6, 13);
      Writeln (' jeder Tastenbettigung gemeldet.    ');

      Gotoxy (14, 24);
      Textcolor (15);
      Write (' Bitte versuchsweise Maus bewegen und Tasten drcken ! ');

      Repeat
         M1 := 3;
         Maus (M1, M2, M3, M4, M5, M6);
         If (Regs.BX<>0) Then Meldung;

         M1 := 3;        { Neue Mausposition abfragen  }
         Maus (M1, M2, M3, M4, M5, M6);

         M1 := 4;        { Maus neu positionieren }
         M3 := Regs.CX;
         M4 := Regs.DX;
         Maus (M1, M2, M3, M4, M5, M6)

      Until Keypressed;
      Window (1, 1, 80, 25);
      Tastendruck;
   End;


{  6.
 Ŀ
   Die FUNKTION                                                        
   erlaubt es, den Mauszeiger in einem bestimmten Bereich zu verstecken
   Register CX:  Koordinate des linken Randes                          
            DX:                 oberen Randes                          
            SI:                 rechten Randes                         
            DI:                 unteren Randes                         
 }

Procedure VERSTECKEN;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('   Anwendung 6:   Mauscursor in einem Bildschirmbereich verstecken    ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                          Funktion:  10 hex                           ');
      TextColor (11);
      Gotoxy (6, 6);
      Write (' ber ');
      Textcolor (12);
      Write ('Funktion 10h ');
      Textcolor (11);
      Writeln ('wird der Zeiger, wenn er in einen gewissen Bereich ');

      Gotoxy (6, 7);
      Writeln (' am Bildscirm wandert, ausgeblendet.                                  ');
      Gotoxy (6, 8);
      Textcolor (13);
      Writeln (' Die beteiligten Register sind CX, DX, SI und DI.                     ');
      Gotoxy (6, 9);
      Textcolor (10);
      Writeln (' Der Bildschirmbereich mu in Koordinaten auf dem virtuellen  Schirm  ');
      Gotoxy (6, 10);
      Writeln (' angegeben werden.                                                    ');
      Gotoxy (6, 12);
      Textcolor (14);
      Writeln (' Der Bereich soll sein: (300, 0, 600, 200) d.h. rechte Hlfte.');

      M1 := 0;
      Maus (M1, M2, M3, M4, M5, M6);

      M1 := 1;
      Maus (M1, M2, M3, M4, M5, M6);
      Gotoxy (6, 14);
      Textcolor (15);
      Writeln (' Bitte den Zeiger zunchst in der linken Hlfte positionieren !       ');
      Tastendruck;
      Gotoxy (6, 16);
      Textcolor (10);
      Writeln (' Wenn man den Cursor nach rechts bewegt verschwindet er pltzlich.    ');

      M1 := $10;
      M3 := 300;
      M4 := 0;
      M5 := 600;
      M6 := 200;
      Maus (M1, M2, M3, M4, M5, M6);
      Mausbewegen;

      Gotoxy (6, 18);
      Textcolor (10);
      Writeln (' Mittels Aufruf der Funktion 1 wird er wieder sichtbar.               ');
      M1 := 1;
      Maus (M1, M2, M3, M4, M5, M6);

      Gotoxy (6, 20);
      Textcolor (10);
      Writeln (' Auch whrend der Unsichtbarkeit wird die Mausposition kontrolliert ! ');

      Tastendruck;
   End;



{ Hauptprogramm von MausText }
Begin
   Header;
   Titel;
   Rahmen;
   Theorie;
   { 1 } Initialisierung;
   { 2 } Systemdaten;
   { 3 } Information;
   { 4 } Zeigerform;
   { 5 } Cursorpos;
   { 6 } Verstecken;
end.                  { des Programms MausText }