{ͻ
   Programm:    UNIT fr Mausbentzung        Datei:   MOUSE.PAS         
 Ķ
   Autor:       AV. DI. Wilh. Junker (u.a.)   Datum:   10. April 1992    
 Ķ
   Schule:      HTL Waidhofen/Ybbs            Sprache: Turbo-Pascal 6.0  
 ĺ
   Definition von Spezialroutinen fr die Mausbentzung unter Bentzung  
   des Maus-Interrupts $33.                                              
   Funktionen und Prozeduren:                                            
       MouseInstalled      ( Abfrage ob eine Maus vorhanden ist )        
       MouseInit           ( Initialisierung des Maustreibers )          
       MouseShow           ( Mauszeiger am Bildschirm sichtbar )         
       MouseHide           ( Muaszeiger wird unsichtbar )                
       MouseButton         ( Abfrage ob eine Taste gedrckt ist )        
       MouseXPos           ( Abfrage der X-Pos. am virt. Bildschirm )    
       MouseYPos           ( Abfrage der Y-Pos. am virt. Bildschirm )    
       MouseGotoXY         ( Maus posotionieren )                        
       MouseWindow         ( Fenster fr die Mausbentzung festlegen )   
       MouseInWindow       ( Prfung ob der Masuzeiger im Fenster ist )  
       MouseSetTextCursor  ( Def. des Mauscursors im Textmodus )         
       MouseSetGraphCursor ( Def. des Mauscursors im Graphikmodus )      
   Dieses Programm dient zur Untersttzung des EDV-Unterrichtes          
                                                            178  Zeilen  
 ͼ}

{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V-}

UNIT Mouse;

INTERFACE

CONST
  MouseButtonLeft = $0001;         { linke Maustaste    }
  MouseButtonRight= $0002;         { rechte Maustaste   }
  MouseButtonMid  = $0004;         { mittlere Maustaste }
  MouseHardCursor = 1;
  MouseSoftCursor = 0;

TYPE
  SCMaskType = RECORD
    Smask : ARRAY[0..15] OF WORD;
    Cmask : ARRAY[0..15] OF WORD;
  END;

FUNCTION  MouseInstalled:BOOLEAN;

PROCEDURE MouseInit;

PROCEDURE MouseShow;

PROCEDURE MouseHide;

FUNCTION MouseButton:BYTE;

FUNCTION MouseXpos:WORD;

FUNCTION MouseYpos:WORD;

PROCEDURE MouseGotoXY(x,y:WORD);

PROCEDURE MouseWindow(x1,y1,x2,y2:WORD);

FUNCTION  MouseInWindow(x1,y1,x2,y2:WORD):BOOLEAN;

PROCEDURE MouseSetTextCursor(Typ:BYTE;Smask,Cmask:WORD);

PROCEDURE MouseSetGraphCursor(HotX,HotY:WORD; VAR SCMask);


IMPLEMENTATION

USES
  Dos;

VAR
  Regs   : Registers;

Function  MOUSEINSTALLED: Boolean;
Begin
  Regs.AX := 0;
  Intr ($33, Regs);
  MouseInstalled := (Regs.AX <> 0)
End;

Procedure MOUSEINIT;
BEGIN
  Regs.AX := 0;
  Intr ($33, Regs);
  IF Regs.AX = 0 THEN
  BEGIN
    Writeln;
    Writeln('Maustreiber nicht geladen! Programm abgebrochen',#7);
    Halt(1)
  End
End;

Procedure MOUSESHOW;
Begin
  Regs.AX := 1;
  Intr ($33, Regs)
End;

Procedure MOUSEHIDE;
Begin
  Regs.AX := 2;
  Intr ($33, Regs)
End;

Function MOUSEBUTTON: Byte;
Begin
  Regs.AX := 3;
  Intr ($33, Regs);
  Mousebutton := Regs.BL
End;

Function MouseXpos: WORD;
Begin
  Regs.AX := 3;
  Intr($33, Regs);
  MouseXpos := Regs.CX
End;

Function MouseYpos: WORD;
Begin
  Regs.AX := 3;
  Intr ($33, Regs);
  MouseYpos := Regs.DX
End;

Procedure MouseGotoXY (X,Y: WORD);
Begin
  Regs.AX := 4;
  Regs.CX := X;
  Regs.DX := Y;
  Intr ($33, Regs)
End;

Procedure MouseWindow (X1, Y1, X2, Y2: WORD);
Begin
  Regs.AX := 7;
  Regs.CX := X1;
  Regs.DX := X2;
  Intr ($33, Regs);
  Regs.AX := 8;
  Regs.CX := Y1;
  Regs.DX := Y2;
  Intr ($33, Regs)
End;

Function  MouseInWindow (X1, Y1, X2, Y2: WORD): BOOLEAN;
BEGIN
  Regs.AX := 3;
  Intr ($33, Regs);
  MouseInWindow := (X1 <= Regs.CX) AND (Regs.CX <= X2) AND
                   (Y1 <= Regs.DX) AND (Regs.DX <= Y2)
End;

Procedure MouseSetTextCursor (Typ: BYTE; Smask, Cmask: WORD);
Begin
  Regs.AX := 10;
  Regs.BX := Typ;    { Software / Hardware }
  Regs.CX := Smask;
  Regs.DX := Cmask;
  Intr ($33, Regs)
End;

Procedure MouseSetGraphCursor (HotX, HotY: WORD; VAR SCMask);
Begin
  Regs.AX := 9;
  Regs.BX := HotX;
  Regs.CX := HotY;
  Regs.DX := Ofs (SCMask);
  Regs.ES := Seg(SCMask);
  Intr ($33, Regs)
End;

END.

