{ͻ
   Programm:    PASCALLERNEN   1. Teil          Datei:   PASCAL1.PAS     
 Ķ
   Autor:       AV. DI. Wilh. Junker            Datum:   10. Dez. 1992   
 Ķ
   Schule:      HTL Waidhofen/Ybbs              Sprache: TurboPascal 6.0 
 ĺ
   Besprechung der Befehle von Turbo-Pascal mit Beispielen  inklusive    
   weiterer Details aus dem Begleitbuch und von Angaben ber den Inhalt  
   des Units SYSTEM                                                      
   bersicht der DOS-Gerte             Pos. 1 bis 14       1627 Zeilen  
 ͼ}
{$M 16384, 0, 655360}

Program PascalLernen_1;                              { Sommmer 1991 }

Uses Crt, Printer, DOS;

Var
    S:       String [14];
    S1, S2:  String [5];
    Ch:      Char;


{ Inhalt des Units SYSTEM:


    AUSSTIEGS- UND FEHLERPROZEDUREN:
  Exit      Verlassen des momentanan Blocks zum bergeordneten Teil
  Halt      Rcksprung zum Betriebssystem
  RunError  Simulation eines Laufzeitfehlers und <HALT>; Austesthilfe
    HEAPVERWALTUNG:
  Dispose   Freigabe des Speicherplatzes einer dyn. Variablen
  FreeMem   Freigabe eines Speicherbereiches
  GetMem    Belegung eines Speicherbereiches und Zeigersetzung
  Mark      Festhalten des Zustandes des Heaps in einer Zeigervariablen
  MaxAvail  Grten freien Platz am Heap feststelln
  New       Erzeugen einer neuen dyn. Variablen und Zeigersetzung
  Release   Rcksetzen des Zustandes auf den mit MARK definierten Zustand
    TRANSFER:
  Chr       Zeichen der angegebenen Ordinalitt
  Ord       Ordinalzahl des angegebenen Wertes
  Round     Konvertierung REAL -> LONGINT mit Runden
  Trunc     Konvertierung REAL -> LONGINT mit Abschneiden
    ARITHMETIK:
  Abs       Absolutwert
  ArcTan    ArcusTangens (-90 bis +90 Aktgrad)
  Cos       Cosinus
  Exp       Exponentialfunktion (E hoch X)
  Frac      Nachkommastellen
  Int       Ganzzahliger Anteil
  Ln        natrl. Logarithmus
  Pi        Ludolffsche Zahl (3.14159265358979...)
  Sin       Sinus
  Sqr       Quadrat
  Sqrt      Qudratwurzel
    ORDINALIA:
  Dec       Variable erniedrigen um ...
  Inc       Variable erhhen um ...
  Odd       Prfung auf ungerade (True oder False)
  Pred      Vorgnger des Argumentes
  Succ      Nachfolger des Argumentes
    STRINGPROZEDUREN:
  Concat    Verknpfung (auch +)
  Copy      Teilstring
  Delete    Teillschung
  Insert    Einfgungen
  Length    Dyn. Lnge rckliefern
  Pos       Zeichenfogle suchen
  Str       Numerischer Wert -> String
  Val       String -> Numerischer Wert
    ZEIGER- UND ADRESSFUNKTIONEN:
  Addr      Objektadresse (auch @)
  CSeg      CodeSegmentRegister
  Dseg      DatenSegmentRegister
  Ofs       OffsetAdresse
  Ptr       Konvertierung von SEGMENT und OFFSET in einen Zeigerwert
  Seg       SegmenAdresse
  SPtr      StackPointer
  SSeg      StackSegmentRegister
    DATEIOPERATIONEN FR ALLE DATEIEN:
  Assign    Zurdnung Datei -> Dateivariable
  ChDir     VerzeichnisWechsel
  Close     Dateischlieung
  Eof       Prfung auf Dateiende
  Erase     DateiLschung
  GetDir    Gesetztes Laufwerk ermiteln
  IOResult  Status der letzen E/A-Operation
  MkDir     Verzeichnis anlegen
  Rename    Datei umbenennen
  Reset     Existierende Datei ffnen
  Rewrite   Datei erzeugen und erffnen
  RmDir     (Leeres) Verzeichnis lschen
    DATEIOPERATIONEN FR TEXTDATEIEN (VAR Text  oder  File of Char):
      Standarddateien Input und Output werden automatisch deklariert.
  Append    Anfgen neuer Daten
  Eoln      Prfung auf Zeilenende
  Flush     Erzwingen des Hinausschreibens des Dateipuffers
  Read      Lesen von 1 oder mehreren Werten aus einer Textdatei
  Readln    idem aber Sprung zur nchsten Zeile
  SeekEof   Prfung auf Dateiende
  SetTextBuf  Zuordnung eines E/A-Puffers
  Write     Schreiben eines oder mehrerer Werte in eine Textdatei
  Writeln   idem mit Zeilenendezeichen
    DATEIOPERATIONEN FR UNTYPISIERTE DATEIEN (VAR  File, sonst FILE OF):
      RESET und REWRITE erlauben einen weiteren Parameter zur Festlegung der
      Recordgre (Defaultwert: 128), optimal Gre 1.
      Definition:
      VAR
         DateiX: File;
  BlockRead:  Lesen von 1 oder mehreren Records
  BlockWrite: Schreiben von 1 oder mehreren Records
    DATEIOPERATIONEN FR ALLE DATEIEN AUSSER TEXTDATEIEN:
  FilePos   DateiPosition erfragen
  FileSize  Dateigre
  Seek      Position in einer Datei setzen
  Truncate  Abschneiden einer Datei
    DIVERSE:
  FillChar  Speicherbereich fllen
  Hi        Hherwertiges Byte
  Lo        Niederwertiges Byte
  Move      Bytes aus Speicherbereichen herauskopieren
  ParmCount Anzhal der Kommandozeilenparameter
  ParmStr   KommandozeilenParameter zurckliefern
  Random    Zufallszahl
  Randomize Neuinitialisierung des Zufallszahlengenerators
  SizeOf    Objektgre in Bytes
  Swap      Vertauschung des Hher- und niederwertigen Bytes des Argum.
  UpCase    Konvertierung in Grobuchstaben

  DOS-GERTEEINHEITEN:

  Peripheriegerte mit reservierten Namen werden wie Dateien behandelt
  CON:   Standardein- und ausgabe (INPUT und OUTPUT) ev. durch Nullstring
         immer automatisch deklariert (Taststur und Bildschirm)
  LPT1:  Schnittstelle zum angeschlossenen Drucker (nur Ausgabe), auch  LST
  LPT2:  weitere   ruckerschnittstelle
  COM1:  serielle Schnittstelle, auch AUX
  COM2:           DOS untersttzt nur 2 serielle Schnittstellen !!
                  BIOS untersttzt 4 serielle Schnittstellen
                  Nachteil: Com1 und Com3 ebenso wie Com2 und Com4 besitzen
                      einen gemeinsamen Interrupt !!!!
  NUL:   Name fr eine E/A-Datei ohne Inhalt

  TEXT-GERTEEINHEITEN:

  zur Implementierung von Gerten, welche von DOS nicht untersttzt werden;
  Unit CRT (statt CON) ist ein schneller Gertetreiber und wird zugeordnet
  ber ASSIGNCRT
}

Procedure PrintScreenNeu;
Interrupt;
Var I, J: ShortInt;
Begin
   Textcolor (12);
   Randomize;
   I := 2 + Random (39);
   J := 4 + Random (20);
   Gotoxy (I, J);
   Writeln ('So eine Frechheit ! Man leitet mich um !');
   { hier steht das neue Programm }
End;


Procedure Rahmen;
Var I: Integer;
Begin
   TextColor (14);
   Writeln ('ͻ');
   For I := 2 to 23 Do
   Begin
      Gotoxy (1, I);
      Write (#186);
      Gotoxy (80, I);
      Write (#186)
   End;
   Write ('ͼ');
End;


Procedure Tastendruck;
Begin
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 24);
   Writeln (' Bitte eine beliebige Taste drcken ! ');
   Ch := Readkey;
 End;


Function StrNeu (Angabe: LongInt; Z: Integer): String;
Var
   Zahl: LongInt;
   StrAlt: String[6];
   ZwErg, Erg: LongInt;
   St: String[1];

Begin
   Zahl := Angabe;
   StrAlt := '$';
   Repeat
      Erg := Zahl Div 16;
      ZwErg := Zahl Mod 16;
      If ZwErg= 0 Then ST := '0';
      If ZwErg= 1 Then ST := '1';
      If ZwErg= 2 Then ST := '2';
      If ZwErg= 3 Then ST := '3';
      If ZwErg= 4 Then ST := '4';
      If ZwErg= 5 Then ST := '5';
      If ZwErg= 6 Then ST := '6';
      If ZwErg= 7 Then ST := '7';
      If ZwErg= 8 Then ST := '8';
      If ZwErg= 9 Then ST := '9';
      If ZwErg=10 Then ST := 'A';
      If ZwErg=11 Then ST := 'B';
      If ZwErg=12 Then ST := 'C';
      If ZwErg=13 Then ST := 'D';
      If ZwErg=14 Then ST := 'E';
      If ZwErg=15 Then ST := 'F';
      Zahl := Erg;
      StrAlt := St + StrAlt;
   Until Erg=0;
   StrNeu := StrAlt;
End;


{  1.
 Ŀ
  Syntax:   ADDR (X)                                                   
  X ist eine beliebige Variable oder der Bezeichner einer Prozedur oder
  Funktion, die nicht als INLINE deklariert ist. Das Ergebnis ist ein  
  Zeiger, de auf X zeigt. Das Ergebnis von ADDR ist wie NIL zuweisungs-
  kompatibel zu allen Zeiger-Typen.                                    
  Der Adreoperator  @  hat dasselbe Ergebnis wie diese Funktion.      
 }

Procedure ADRESSENFUNKTION;

   VAR
      P:      Pointer;
      Hilfe:  LongInt;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('           Anwendung 1:   A D R E S S E N F U N K T I O N             ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                       Befehle:  ADDR, SEG, OFS                       ');
      TextColor (11);
      P := Addr(P);
      Gotoxy (6, 5);
      Writeln (' SYNTAX:     P := Addr (P)  ');
      TextColor (10);
      Gotoxy (6, 6);
      Writeln (' Bei diesem Beispiel zeigt der Zeiger auf sich selbst !               ');
      TextColor (11);
      Gotoxy (6, 8);
      Writeln (' SYNTAX:     Seg (P)        ');
      TextColor (14);
      Gotoxy (6, 9);
      Write (' Ergebnis:   ', Seg (P):6, ' dez.  ');
      TextColor (10);
      Writeln ('  ( Segment-Adresse in der dezimalen Form ) ');
      TextColor (11);
      Gotoxy (6, 11);
      Writeln (' SYNTAX:     Ofs (P)        ');
      TextColor (14);
      Gotoxy (6, 12);
      Write (' Ergebnis:   ', Ofs (P):6, ' dez.  ');
      TextColor (10);
      Writeln ('  ( Offset-Adresse in der dezimalen Form )  ');
      Gotoxy (6, 14);
      TextColor (14);
      Hilfe := Seg(P);
      Hilfe := Hilfe*16 + ofs(P);
      Write (' Absolutadresse:    ', Copy (StrNeu(Hilfe, 6), 1, 5), 'h  ');
      TextColor (10);
      Write ('    oder dezimal:     ');
      TextColor (14);
      Writeln ( Hilfe:8, ' dez        ');
      Gotoxy (6, 16);
      TextColor (12);
      Writeln (' blicherweise wird die Adresse folgendermaen zweiteilig angegeben:  ');
      Gotoxy (6, 18);
      Write (' Segment:Offset= ssss ' , ':', 'oooo ');
      TextColor (10);
      Writeln (' ( max. Bereich von je 64 kByte = FFFFh ) ');
      Gotoxy (6, 19);
      TextColor (14);
      Writeln (' Ergebnis:       ', Copy (StrNeu(Seg(P), 4), 1, 4),'h:',
                                    Copy (StrNeu(Ofs(P), 4), 1, 4), 'h ');
      TextColor (12);
      Gotoxy (6, 21);
      Writeln (' Im PC-Speicher werden alle Adreangaben vertauscht  !!!!  !!!!  !!!! ');
      Gotoxy (6, 22);
      TextColor (14);
      Write (' Ergebnis:       ');
      Textcolor (10);
      Writeln (Copy (StrNeu(Ofs(P), 4), 3, 2), Copy (StrNeu(Ofs(P), 4), 1, 2), 'h',
      ':', Copy (StrNeu(Seg(P), 4), 3, 2), Copy (StrNeu(Seg(P), 4), 1, 2), 'h ');

      Tastendruck;
   End;


Procedure Forts1;

Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('          Ergnzung zu 1:  A D R E S S E N F U N K T I O N            ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                    PARAGRAPH, BLOCK, SEGMENT                         ');
      TextColor (14);
      Gotoxy (6, 5);
      Writeln (' PARAGRAPHEN: ');
      Textcolor (10);
      Gotoxy (6, 6);
      Writeln ('    Paragraphen beginnen an jeder 16-Byte-Adresse im Hauptspeicher,   ');
      Gotoxy (6, 7);
      Writeln ('    welche restlos durch 16 (=Fh) teilbar ist. Ein Segment beginnt    ');
      Gotoxy (6, 8);
      Writeln ('    immer an einer Paragraphengrnze.                                  ');
      Textcolor (14);
      Gotoxy (6, 9);
      Writeln (' SEGMENTE: ');
      TextColor (10);
      Gotoxy (6, 10);
      Writeln ('    DOS beruht auf der Speicher-Segmentierung d.h. es werden vier     ');
      Gotoxy (6, 11);
      Writeln ('    Segmentadressen definiert, welche Bezugspunkt fr die Adressie-   ');
      Gotoxy (6, 12);
      Writeln ('    rung und maximal 64 kByte lang sind: ');
      TextColor (12);
      Gotoxy (6, 13);
      Writeln ('                  CODESEGMENT             DATENSEGMENT                ');
      Gotoxy (6, 14);
      Writeln ('                  STACKSEGMENT            EXTRASEGMENT                ');
      Gotoxy (6, 15);
      TextColor (10);
      Writeln ('    Da die Segmentadresse an der niedrigsten Hex-Stelle immer eine 0  ');
      Gotoxy (6, 16);
      Writeln ('    fhrt, kann diese fr die Adreangabe weggelassen weren. Bei der  ');
      Gotoxy (6, 17);
      Writeln ('    Adrerechnung mu sie aber wieder ergnzt werden !!!!             ');
      TextColor (14);
      Gotoxy (6, 18);
      Writeln (' BLCKE: ');
      TextColor (10);
      Gotoxy (6, 19);
      Writeln ('    Der DOS-Adrebereich von 1 MByte kann in 16 Blcke aufgeteilt     ');
      Gotoxy (6, 20);
      Writeln ('    werden, welche nach der hchsten Hex-Stelle benannt sind.         ');
      Gotoxy (6, 21);
      Writeln ('    zB  Block 15 enthlt das ROM-BIOS (ab Adresse F000:0000)          ');
      Gotoxy (6, 22);
      Writeln ('        Block 10 dient als erw. Videospeicher fr EGA/VGA (A000:0000) ');
      Tastendruck
End;


{  2.
 Ŀ
  Zugriff auf die Register:                                            
  Der Datentyp REGISTERS ist im Unit DOS folgendermarn definiert:     
  TYPE                                                                 
      Registers = Record                                               
         Case Integer Of                                               
              0: (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags: Word);    
              1: (AL, AH, BL, BH, CL, CH, DL, DH: Byte);               
         End;                                                          
 }

Procedure SEGMENTADRESSEN;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('             Anwendung 2:   S E G M E N T A D R E S S E N             ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                    Befehle:  DSEG,  CSEG,  SSEG                      ');

      TextColor (11);
      Gotoxy (6, 5);
      Writeln (' SYNTAX:       Writeln (  CSEG , '':0000 '')                            ');
      TextColor (14);
      Gotoxy (15, 7);
      Write (' Das Programm steht ab Adresse:                   ');
      TextColor (12);
      Writeln (Copy(Strneu(CSEG, 4), 1, 4), 'h:0000 ');
      Gotoxy (49, 8);
      Writeln (' oder absolut: ', Copy (Strneu(Cseg, 4), 1, 4), '0h      ');

      TextColor (11);
      Gotoxy (6, 10);
      Writeln (' SYNTAX:       Writeln (  DSEG , '':0000 '')                            ');
      TextColor (14);
      Gotoxy (15, 12);
      Write (' Die globalen Variablen stehen ab Adresse:        ');
      TextColor (12);
      Writeln (Copy(Strneu(DSEG, 4), 1, 4), 'h:0000 ');
      Gotoxy (49, 13);
      Writeln (' oder absolut: ', Copy (Strneu(Dseg, 4), 1, 4), '0h      ');

      TextColor (11);
      Gotoxy (6, 15);
      Writeln (' SYNTAX:       Writeln (  SSEG , '':0000 '')                            ');
      TextColor (14);
      Gotoxy (15, 17);
      Write (' Der STACK (=Stapelsegment) beginnt bei Adresse:  ');
      TextColor (12);
      Writeln (Copy(Strneu(SSEG, 4), 1, 4), 'h:0000 ');
      Gotoxy (49, 18);
      Writeln (' oder absolut: ', Copy (Strneu(Sseg, 4), 1, 4), '0h      ');
      Gotoxy (6, 20);
      Textcolor (10);
      Writeln (' Die Angabe oder Abfrage des Extra-Segmentes ESEG ist nicht vorgese-  ');
      Gotoxy (6, 21);
      Writeln (' hen, weil es selten zB bei String-Manipulation gebraucht wird.       ');
      Tastendruck
   End;


{  3.
 Ŀ
  ASSIGNCRT-Procedur:                                                  
  Diese ornet dem Bildschirm (=CRT) eine Textdatei zu.                 
  Vrteil: wesentlich hhere Geschwindigkeit der E/A zum Bildschirm     
          gegenber den DOS/BIOS-Funktionen.                           
 }

Procedure CRT_DEMO;

   Var
      F:   Text;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Write ('       Anwendung 3:    A U S G A B E B E S C H L ');
      Writeln ('E U N I G U N G      ');
      Gotoxy (6, 3);
      TextColor (14);
      Write ('                       Befehl:   ASSIGNCRT         ');
      Writeln ('                   ');
      TextColor (10);
      Gotoxy (6, 5);
      Write (' Dieses Verfahren umgeht die umstndlichen BIOS-Routinen,');
      Writeln (' indem es    ');
      Gotoxy (6, 6);
      Writeln (' den Bildschirm wie eine Datei behandelt.    ');
      TextColor (14);
      Gotoxy (6, 8);
      Writeln (' Soll die Ausgabe zum Bildschirm (B) oder zum Drucker (D) erfolgen ?  ');
      Gotoxy (6, 10);
      TextColor (15);
      Writeln (' B  oder  D  eingeben ! Bei <RETURN> gilt B als Eingabe !');
      TextColor (11);
      Gotoxy (6, 12);
      Writeln (' SYNTAX:     ASSIGN (F, ''PRN'')                                        ');
      Gotoxy (6, 13);
      Textcolor (12);
      Writeln (' oder ');
      Gotoxy (6, 14);
      Textcolor (11);
      Writeln (' SYNTAX:     ASSIGNCRT (F)                                            ');
      If Upcase(Readkey) = 'D' Then
         Assign (F, 'PRN')
      Else
         AssignCrt (F);
      Rewrite (F);
      TextColor (10);
      Gotoxy (6, 16);
      Writeln (F, ' Die folgende Ausgabezeile wird zum Bildschirm geschickt ...          ');

      Gotoxy (6, 18);
      Textcolor (11);
      Writeln (' SYNTAX:   WRITELN (F, Textstring )                                   ');
      Gotoxy (6, 20);
      TextColor (14);
      Writeln (F, ' ... und dies wegen des Dateicharakters wesentlich beschleunigt !!!   ');
      Tastendruck;
   End;


{  4.
 Ŀ
  Funktionen mit dem Directory:                                        
  Im Unit DOS sind die Konstanten fr die FILE-ATTRIBUTE und ein Re-   
  cord mit Namen SEARCHREC fr die Bearbeitung eines eigenen Direc-    
  tory bereits vordefiniert.                                           
  FINDFIRST sucht ein Directory nach dem ersten Vorkommen eines Datei- 
  namens ab.                                                           
     Syntax:  FINDFIRST (Path: String; Attr: Byte; Var S: SearchRec)   
  Path gehorcht den Regeln des DOS.                                    
  Mgliche Fehlercodes sind:                                           
      0          fehlerfrei                                            
      2          Directory nicht gefunden                              
     18          keine weiteren Eintrge                               
  Die Type SEARCHREC ist ebenfalls definiert auf folgende Art:         
     TYPE                                                              
        SearchRec = RECORD                                             
                  Fill:  Array[1..21] Of Byte;                         
                  Attr:  Byte;                                         
                  Time:  LongInt;                                      
                  Size:  LongInt;                                      
                  Name:  String[12];                                   
               End;                                                    
 }

Procedure DIRSUCHE;

Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('        Anwendung 4:   AUSGABE EINES SELBSTGESTALTETEN DIRECTORY      ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                    FINDFIRST, FINDNEXT, DIRINFO                      ');
      TextColor (14);
      Gotoxy (6, 5);
      Writeln (' FINDIRST: ');
      Textcolor (11);
      Gotoxy (6, 6);
      Writeln (' SYNTAX:        FINDFIRST (Path: String; Attr: Byte; VAR S:SearchRec) ');
      Gotoxy (6, 7);
      TextColor (15);
      Writeln ('       Befehl:  FindFirst (''C:\TP6\Ju'', AnyFile, DirInfo)             ');
      Textcolor (14);
      Gotoxy (6, 9);
      Writeln (' FINDNEXT: ');
      TextColor (11);
      Gotoxy (6, 10);
      Writeln (' SYNTAX:        FINDNEXT (VAR  S: SearchRec)                          ');
      Gotoxy (6, 11);
      Textcolor (15);
      Writeln ('       Befehl:  FindNext (DirInfo)                                    ');
      TextColor (14);
      Gotoxy (6, 13);
      Writeln (' DIRINFO: ');
      Gotoxy (6, 14);
      Textcolor (11);
      Writeln (' SYNTAX:        Writeln (SearchRec. Name)                             ');
      Gotoxy (6, 15);
      Writeln ('                Writeln (SearchRec. Size)                             ');
      Gotoxy (6, 16);
      Writeln ('                Writeln (SearchRec. Attr)                             ');
      Gotoxy (6, 17);
      Writeln ('                Writeln (SearchRec. Time)                             ');
      TextColor (15);
      Gotoxy (6, 18);
      Writeln ('       Befehl:  Writeln (DirInfo. Name:10,  usw. .. )                 ');
      Gotoxy (6, 20);
      Textcolor (10);
      Writeln (' Die Namen der Variablen und die Bezeichnung der Attribute gehor-     ');
      Gotoxy (6, 21);
      Writeln (' chen den im Unit DOS vorgegebenen Regeln.                            ');
      Tastendruck
   End;


Procedure Forts2;

   Var
      DirInfo:     SearchRec;
      I:           Integer;
      Zeit:        LongInt;
      DT:          DateTime;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Write ('       Beisp. zu 4:  AUSGABE EINES SELBSTGESTALTETEN DIRECTORY        ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('               Befehle:  FINDFIRST, FINDNEXT, DIRINFO                 ');
      TextColor (12);
      TextBackground (0);
      Gotoxy (6,5);
      Writeln ('Name         Attr  Datum(cod)        Jahr  Mo Tag  St Mi Se     Gre ');
      Textbackground (1);
      TextColor (14);
      I := 6;
      FindFirst ('C:\TP6\JU\*.*', AnyFile, DirInfo);      { entspricht DIR *.PAS }
      While (DOSERROR=0) And (I < 20) Do
      Begin
         Gotoxy (6, I);
         Write (DirInfo.Name);
         Gotoxy (20, I);
         Write (DirInfo.Attr);
         Gotoxy (25, I);
         Write (DirInfo.Time);
         UnpackTime (DirInfo.Time, DT);
         Gotoxy (40, I);
         Write (DT.Year:7, DT.Month:4, DT.Day:4, DT.Hour:4, DT.Min:3, DT.Sec:3);
         Gotoxy (70, I);
         Writeln (DirInfo.Size);
         FindNext (DirInfo);
         I := I + 1;
      End;
      Gotoxy (6, 21);
      TextBackGround (0);
      Writeln (' Kommantar:   Attribut 16  =  Directory         ');
      Gotoxy (6, 22);
      Writeln ('              Attribut 32  =  Archiv            ');
      Tastendruck
   End;


{  5.
 Ŀ
  FSEARCH sucht die ber den Stringausdruck PATH angegebene Datei in   
  den als DirList angegebenen Directories.                             
    Syntax:  FSEARCH (Path: PathStr;  DirList: String )                
  Die in der DIRLIST angefhrten Directories sind durch Beistriche     
  getrennt.                                                            
  Wenn die Datei in keinem der Directories gefunden werden kann        
  dann liefert die Funktion einen Nullstring, ansonsten wird der Name  
  der gesuchten Datei inkl. Suchweg rckgeliefert.                     
  Path gehorcht den Regeln des DOS.                                    
  Mit dem Aufruf zu GetEnv ('Path') und dem Parameter DirList sucht    
  smtlich Directories des Path ab. Das Ergebnis lt sich mittels     
  FEXPAND zu einem vollstndigen Namen erweitern.                      
  Die Typen sind im Unit DOS folgendermaen definiert:                 
          PathStr = String[79];                                        
          DirStr  = String[67];                                        
          NameStr = String[8];                                         
          ExtStr  = String[4];                                         
  FSPLIT zerlegt einen vollstndigen Dateinamen in seine drei Kompo-   
  nenten: Suchweg, Name und Extension je nach den Angaben in PATH.     
  GETCBREAK ermittel, bei welchen Operationen DOS aus Ctrl-Break prft.
  Dies kann nur bei Ein-/Ausgaben oder bei jedem Aufruf auf die Einga- 
  von Ctrl-Break mittels der Funktion $33 von DOS Geprft werden.      
  Im ersten Fall wird die Variable TRUE, ansonsten FALSE gesetzt.      
     Syntax:  GETCBREAK (VAR Break: Boolean)       im Unit DOS         
 }

Procedure VERZEICHNIS_INFO;

   Var
      S, FileName: PathStr;
      DStr:        DirStr;
      NSTr:        NameStr;
      EStr:        ExtStr;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Write ('      Anwendung 5:   V E R Z E I C H N I S I N F O R M A T I O N      ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                  Befehle:  FSEARCH, FSPLIT, FEXPAND                  ');
      TextColor (11);
      TextBackground (0);
      Gotoxy (6, 5);
      Writeln (' SYNTAX:       FSEARCH ( Path: PathStr; DirList: String )             ');
      Gotoxy (6, 6);
      TextColor (15);
      Writeln ('       Befehl: FSEARCH (''Command.Com'', GetEnv (''Path''))', '               ');
      S := FSearch ('Command.Com', GetEnv ('PATH'));
      Gotoxy (6, 8);
      Textcolor (13);
      IF S = '' Then Writeln ('Turbo.TPL nicht gefunden!')
      ELSE
      Begin
         Write (' Vollstndiger Suchweg zu Command.Com:  ');
         TextColor (14);
         Writeln (S, ' ')
      End;

      Textcolor (11);
      Gotoxy (6, 10);
      Writeln (' SYNTAX:       FEXPAND (Path: PathStr)                                ');
      Gotoxy (6, 11);
      TextColor (15);
      Writeln ('       Befehl: FEXPAND (''ABISH.PAS'')                                  ');
      Textcolor (12);
      Gotoxy (6, 13);
      TextColor (13);
      Write (' Erweiterung von ABISH           ');
      Textcolor (14);
      FileName := FExpand ('ABISH.PAS');
      Writeln (FileName, ' ');

      Gotoxy (6, 15);
      TextColor (11);
      Writeln (' SYNTAX:       FSPLIT (Path: PathStr; VAR Dir: DirStr; VAR Name:      ');
      Gotoxy (49, 16);
      Writeln (' NameStr; VAR Ext: ExtStr) ');
      Gotoxy (6, 17);
      Textcolor (15);
      Writeln ('       Befehl: FSPLIT (FExpand(ABISH.PAS), DStr, NStr, EStr);         ');
      FSplit (Filename, DStr, NStr, EStr);
      Gotoxy (6, 19);
      TextColor (13);
      Write (' ABISH.PAS ist im Directory ');
      TextColor (14);
      Write ( DStr:20);
      TextColor (13);
      Write ('      unter dem Namen ');
      Gotoxy (6, 20);
      TextColor (14);
      Write ( Nstr:8);
      TextColor (13);
      Write (' mit der Extension ');
      Textcolor (14);
      Write ( EStr:3);
      Textcolor (13);
      Writeln ('  gespeichert.');
      Tastendruck
   End;


{  6.
 Ŀ
  Funktionen fr die Zeit- und Datumsabfrage:                          
  Im Unit DOS ist der Datentyp DATETIME zum direkten Auslesen des      
  Datumbausteins (im PC-AT) vorgesehen.                                
  Die Sekunde ist bis zum Hundertstel auslesbar.                       
 }

Procedure GET_DATE_TIME_DEMO;

{  GETTIME und SETTIME sind reversible Prozeduren.

   Die Prozedur PACKTIME konvertiert einen Record des Type DATETIME
   in einen gepackten LongInt fr die Verwendung in SETFTIME: setzt
   Datum und Uhrzeit der letzten Vernderung einer Datei direkt.
   Deklaration:
      SetFTime (Var F; Time: LongInt)
      PackTime (VAR DT: DateTime;  VAR Time: LongInt)
   Umgekehrt ermittelt GETFTIME Datum und Uhrzeit der letzten Datei-
   vernderung.
          Syntax:     GetFTime (VAR f; VAR Time: LongInt)
   DOSError liefert im Fahlerfalle den Code 6 (ungltiger Handle/
   Datei nicht offen).

   Der DatenTyp DATETIME ist im Unit DOS folgendermaen deklariert:
      TYPE
        DateTime = Record
           Year, Month, Day, Hour, Min, Sec:  Word;
        End;

    Die Procedure GETDATE liefert Werte fr das Kalenderdatum zurck, die von
    DOS bentzt werden. Die Umkehrung ist SETDATE.
    YEAR        1980 .. 2099
    Month       1    ..   12
    Day         1    ..   31
    DayofWeek   0    ..    6   (0 steht fr Sonntag)   }

   VAR
      Stunde, Minute             : Word;
      Sekunde, Sek100stel        : Word;
      Jahr, Monat, Tag, Wochentag: Word;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('  Anwendung 6:  Z E I T - u n d  D A T U M S M A N I P U L A T I O N  ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                     Befehle:  GETTIME, GETDATE                       ');
      TextColor (11);
      TextBackground (0);
      Gotoxy (6, 5);
      Writeln (' SYNTAX:        GETTIME ( VAR Hour, Min, Second, Sec100: Word )       ' );
      Gotoxy (6, 7);
      Writeln (' SYNTAX:        GETDATE ( VAR Year, Month, Day, DayofWeek: Word )     ');
      Gotoxy (6, 9);
      TextColor (14);
      Writeln (' ZEIT: ');
      TextColor (10);
      Gotoxy (10, 10);
      GetTime (Stunde, Minute, Sekunde, Sek100stel);
      Gotoxy (10, 11);
      Writeln (' Stunde:    ', Stunde:2);
      Gotoxy (10, 12);
      Writeln (' Minute:    ', Minute:2);
      Gotoxy (10, 13);
      Writeln (' Sekunde:   ', Sekunde:2);
      Gotoxy (10, 14);
      Writeln (' Sek/100:   ', Sek100stel:2);
      TextColor (14);
      Gotoxy (6, 16);
      Writeln (' DATUM: ');
      TextColor (10);
      GetDate (Jahr, Monat, Tag, Wochentag);
      Gotoxy (10, 18);
      Writeln (' Jahr:      ', Jahr:4);
      Gotoxy (10, 19);
      Writeln (' Monat:     ', Monat:2);
      Gotoxy (10, 20);
      Writeln (' Tag:       ', Tag:2);
      Gotoxy (10, 21);
      Writeln (' Wochentag: ', Wochentag, '   0..Sonntag etc.');
      Tastendruck
   End;


{  7.
 Ŀ
  CHR-Funktion:                                                        
  Es wird ein Zeichen der angegebenen Ordinalitt zurckgeliefert.     
  Der Zeichensatz bis Code 31h wird - soweit mglich - ausgegeben.     
 }

Procedure CHARFUNKTION;

   Var I: ShortInt;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      Gotoxy (6, 2);
      TextAttr := White;
      Writeln ('         Anwendung 7:  C H A R A C T E R  -  F U N K T I O N          ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                             Befehle:  CHR                            ');
      TextAttr := White;
      Gotoxy (6, 5);
      Writeln ('Obere Zeile:  DEZIMALCODE');
      Gotoxy (6, 5);
      Writeln ('Untere Zeile: Entsprechendes Zeichen');
      TextColor (14);
      For I := 0 To 21 Do
      Begin
         Gotoxy (3+3*(I+1), 7);
         Write (I:3);
         Gotoxy (3+3*(I+1), 8);
         Write ('  ', Chr(I));
      End;
      For I := 22 To 31 Do
      Begin
         Gotoxy (6+3*(I-22), 10);
         Write (I:3);
         Gotoxy (6+3*(I-22), 11);
         Write ('  ', Chr(I));
      End;
      TextColor (10);
      Gotoxy (6, 13);
      Writeln (' Die Codes fr die Dezimalwerte');
      Gotoxy (9, 15);
      TextColor (11);
      Writeln ('   7  ...  Glocke = BELL                                    ');
      Gotoxy (9, 16);
      Writeln ('   8  ...  Rckwrtsschritt (BACKSPACE = BS)                ');
      Gotoxy (9, 17);
      Writeln ('  10  ...  Zeilenvorschub (LINE FEED = LF)                  ');
      Gotoxy (9, 18);
      Writeln ('  13  ...  Zeilenende,Wagenrcklauf (CARRIAGE RETURN = CR)  ');
      Gotoxy (6, 20);
      TextColor (10);
      Writeln (' werden von BIOS wie hier ersichtlich anders interpretiert !!');
      Gotoxy (6, 22);
      Textcolor (14);
      Writeln (' Daher sind in der Tabelle hiefr keine Codes angegeben.');
      Writeln (#10);      { Angabe eines Zeilenvorschubes }
      Textcolor (11);
      Gotoxy (50, 5);
      Writeln ('   SYNTAX:    CHR ( I )   ');
      Tastendruck;
   End;


{  8.
 Ŀ
  ENVIRONMENT:                                                         
  Das ENVORONMENT ist eine kleine Tabelle im PSP, in welcher einige    
  Eintragungen ber das System enthalten sind.                         
  Beispiele: PATH=C:\DOS; .....                                        
             COMSPEC=C:\DOS\Command.Com                                
  Der DOS-Befehl SET gestattet Einflunahme auf das Environment.       
  Ein Nullstring als Name entspricht der StandardAusgabe (DOS-Handle 1 
  Die allgemeine Formulierung lautet        Name=Zeichenfolge          
  GETENV liest einen Eintrag aus der Tabelle.                          
  ENVCOUNT zhlt die Anzahl der Eintrge (Typ Integer)                 
  ENVSTRING ist einer dieser Eintrge in der Tabelle  (Typ Integer)    
 }

Procedure ENVIRONMENT;

   Var
      I:    Integer;
      Line: String;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Write ('                 Anwendung 8:   E N V I R O N M E ');
      Writeln ('N T                 ');
      TextColor (14);
      Gotoxy (6, 3);
      Write ('                  Befehle:  GETENV, ENVCOUNT, ');
      Writeln ('ENVSTR                  ');
      Gotoxy (6, 5);
      TextColor (11);
      Writeln (' SYNTAX:    ENVCOUNT                                                  ');
      Gotoxy (6, 6);
      TextColor (13);
      Write (' Anzahl der Eintrge:  ');
      TextColor (11);
      Writeln (EnvCount:2);

      Gotoxy (6, 8);
      Writeln (' SYNTAX:    ENVSTR (Index: Integer)                                   ');
      Gotoxy (6, 9);
      TextColor (13);
      Writeln (' Art der Eintrge: ');
      TextColor (14);
      For I := 1 To EnvCount Do
      Begin
         Gotoxy (6, 9+I);
         Writeln ('   ', I:2, '. ', Copy (EnvStr(I), 1, 60));
      End;

      Gotoxy (6,17);
      TextColor (11);
      Writeln (' SYNTAX:    GETENV (EnvVar: String)                                   ');
      Line := GetEnv ('ComSpec');
      Writeln;
      TextColor (15);
      If Line='' Then Writeln ('Nanu?')
      Else
      Begin
         TextColor (13);
         Gotoxy (6, EnvCount+12);
         Writeln (' Suchweg zu Command.Com: ');
         TextColor (14);
         Gotoxy (6, EnvCount+13);
         Writeln ('   ', Line);
      End;

      Line := GetEnv ('Path');
      TextColor (15);
      If Line='' Then Writeln (' Kein Path gesetzt !')
      Else Begin
         Writeln;
         Gotoxy (6, EnvCount+14);
         TextColor (13);
         Writeln (' Path enthlt die folgenden Suchwege: ');
         TextColor (14);
         Gotoxy (6, EnvCount+15);
         Writeln ('   ', Copy (Line, 1, 67));
         If Length(Line)>70 Then
         Begin
            Gotoxy (6, EnvCount+16);
            Writeln ('   ', Copy (Line, 68, 70))
         End;
      End;
      Tastendruck;
   End;


{  9.
 Ŀ
  DOS-VERSION:                                                         
  Es wird ber diese Funktion ein Wort zurckgeliefert, dessen hher-  
  wertiges Byte die Nebenversiosnummer (zB fr DOS 3.20 die Zahl 20)   
  und dessen niederwertiges Byte die Hauptversionsnummer zurck-       
  liefert.                                                             
  zB. wird fr die DOS-Version 3.20 das Ergebnis $2003 bergeben.      
  Die Deklaration erfolgt ber die Angabe DOSVERSION.                  
 }

Procedure DOS_VERSION;

   Var Version: Word;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('      Anwendung 9:   A N G A B E   d e r   D O S - V E R S I O N      ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                      Befehl:    DOSVERSION                           ');
      Writeln;
      TextAttr := White;
      Writeln;
      Version := DosVersion;
      Gotoxy (6, 7);
      TextColor (11);
      Writeln ('  SYNTAX:      DOSVERSION         Word                                ');
      TextColor (15);
      Gotoxy (6, 8);
      Writeln ('        Befehl:    Writeln (LO(Version), ''.'', HI(Version))            ');
      Gotoxy (16, 14);
      TextColor (14);
      Write (' Dieses Programm luft unter der DOS-Version:  ');
      TextColor (12);
      Writeln (LO(Version), '.', HI(Version));

      {  Alternative zu obigem Programm ohne Pascal-Spezialbefehl:
         Var
         Regs    : Registers;
         AL, AH  : Byte;
         Begin
            Regs.AX := $3000;
            MSDos ( Regs );   resp.  INTR ($21, Regs);
            AL := Regs.AX and $FF;
            AH := ( Regs.AX and $FF00 ) shr 8;
            DosVer := AL + AH/100;
         End;  }

      Tastendruck;
   End;


{  10.
 Ŀ
  Befehle: DISKSIZE,  DISKFREE                                         
  Gre der freien Speicher- und Diskettenkapazitt ermitteln:         
  Parameter:                                                           
     Momentanes Laufwerk:     0                                        
     Laufwerk A:              1                                        
     Laufwerk B:              2                                        
  Bei einem ingltigen Wert wird -1 rckgeliefert.                     
                                                                       
 }

Procedure SPEICHERRAUM;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('   Anwendung 10:   K A P A Z I T  T   d e r   L A U F W E R K E      ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                     Befehle:  DISKFREE, DISKSIZE                     ');
      TextAttr := White;
      Gotoxy (6, 7);
      TextColor (11);
      Writeln ('  SYNTAX:        DISKFREE   (Drive: Byte)                             ');
      TextColor (15);
      Gotoxy (6, 8);
      Writeln ('        Befehl:  Diskfree (0) DIV 1014          fr kByte             ');
      TextColor (14);
      Gotoxy (6, 10);
      Write (' Auf dem momentan gesetzen Laufwerk sind  ');
      TextColor (12);
      Write (DiskFree(0) DIV 1024);
      TextColor (14);
      Writeln ('  kByte verfgbar.');
      Gotoxy (6, 15);
      TextColor (11);
      Writeln ('  SYNTAX:        DISKSIZE   (Drive: Byte)                             ');
      TextColor (15);
      Gotoxy (6, 16);
      Writeln ('        Befehl:  Disksize (0) DIV 1014          fr kByte             ');

      Gotoxy (6, 18);
      Textcolor (14);
      Write (' Das momentan gesetzte Laufwerk hat eine Kapazitt von  ');
      TextColor (12);
      Write (DiskSize(0) DIV 1024);
      TextColor (14);
      Writeln ('  kByte.');
      Tastendruck
   End;


{  11.
 Ŀ
  Befehle: HALT,  EXIT                                                 
  Der Befehl HALT bricht die Ausfhrung des Programmes ab und fhrt    
  einen Rcksprung zur DOS-Kommandoebene bzw. zu dem Proze, von dem   
  das laufende Programm gestartet wurde aus.                           
  Syntax:   HALT [(Exitcode: Word)]                                    
  Exitcode ist ein optionaler Ausdruck, welcher einen Code bergeben   
  kann, der sich als DOSEXITCODE innerhalb des aufrufenden Programmes  
  bzw. mit ERRORLEVEL in einer Batchdatei ermitteln lt.              
  Das niederwertige Byte des Ergebnisses ist der Exit-Code des Pro-    
  grammes:                                                             
     0         normales Ende                                           
     XX        Ende via Halt etc.                                      
                                                                       
  Das hherwertige Byte kann folgende Werte annehmen:                  
     0         normales Ende                                           
     1         Abbruch durch Ctrl-C oder Ctrl-Break                    
     2         Abbruch durch einen Gertefehler (Device-Error)         
     3         Beendigung durch die Prozedur KEEP                      
  HALT ohne Parameter entspricht dem Aufruf HALT (0).                  
  Der Befehl EXIT bewirkt einen Rcksprung zur aufrufenden Prozedur    
  ( Unterprog. > Hauptprog.,  Hauptprog. > DOS )                       
 }

Procedure ABBRUCH;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('            Anwendung 11:   P R O G R A M M A B B R U C H             ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                  Befehle: EXIT, HALT, DOSEXITCODE                    ');
      TextColor (12);
      Gotoxy (6, 5);
      Writeln (' HALT: ');
      TextColor (10);
      Gotoxy (6, 7);
      Writeln ('   Der Befehl HALT bricht die Ausfhrung des Programmes ab und fhrt  ');
      Gotoxy (6, 8);
      Writeln ('   einen Rcksprung zur DOS-Kommandoebene bzw. zu dem Proze, von dem ');
      Gotoxy (6, 9);
      Writeln ('   das laufende Programm gestartet wurde, aus.                        ');
      Gotoxy (6, 10);
      TextColor (11);
      Writeln ('          Syntax:     HALT [(Exitcode: Word)]                         ');
      Gotoxy (6, 11);
      TextColor (10);
      Writeln ('   Exitcode ist ein optionaler Ausdruck, welcher einen Code bergeben ');
      Gotoxy (6, 12);
      Writeln ('   kann, der sich mit DosExitCode innerhalb des aufrufenden Programmes');
      Gotoxy (6, 13);
      Writeln ('   bzw. mit ERRORLEVEL in einer Batchdatei ermitteln lt.            ');
      Gotoxy (6, 14);
      Writeln ('   HALT ohne Parameter entspricht dem Aufruf HALT (0).                ');
      Gotoxy (6, 16);
      TextColor (12);
      Writeln (' EXIT: ');
      TextColor (10);
      Gotoxy (6, 18);
      Writeln ('   Der Befehl EXIT bewirkt einen Rcksprung zur aufrufenden Prozedur  ');
      Gotoxy (6, 19);
      Writeln ('   ( Unterprog. > Hauptprog.,  Hauptprog. > DOS )                     ');
   {  B e i s p i e l :
      Repeat
         If KeyPressed Then Exit;
         Write ('XXX');
      Until False;
   }
      Tastendruck
   End;


{  12.
 Ŀ
  DIRECTORY - Befehle:                                                 
  CHDIR wechselt das Standarddiirectory (Regeln von DOS).              
     Syntax:     CHDIR (S: String)                                     
  MKDIR erzeugt ein Verzeichnis                                        
     Syntax:     MKDIR (S: String)                                     
  RMDIR entfernt das (leere) Directory                                 
     Syntax:     RMDIR (S: String)                                     
  GETDIR ermittelt das momentan gesetze Directory                      
     Syntax:     GETDIR (D: Byte; VAR S: String)                       
  Die Variable gibt das Laufwerk an !                                  
  Bei Mierfolg des Befehles kann mittels IORESULT berprft werden.   
 }

Procedure DIRECTORY;

   Var
     SuchString: String[15];
     S, SNeu:    String;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('     Anwendung 12:   D I R E C T O R Y  -  M A N I P U L A T I O N    ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('               Befehle:  CHDIR, MKDIR, RMDIR, GETDIR                  ');
      (*
      {$I-}
        ChDir (ParamStr(1));
      {$I+}
      If IORESULT <> 0 Then
      Begin
         Gotoxy (6, 5);
         Writeln (' Directory kann nicht gesetzt werden ! ')
      End;
      GetDir (3, SuchString);
      Gotoxy (6, 9);
      Writeln ('  ', SuchString);
      *)
      S := 'Wilhelm';
      Gotoxy (6, 5);
      TextColor (10);
      Writeln (' Zur bung wird ein Subdirectory mit dem Namen Wilhelm angelegt       ');
      Gotoxy (6, 6);
      Textcolor (11);
      Writeln (' SYNTAX:      MKDIR (S: String)                                       ');
      Gotoxy (19, 7);
      Textcolor (15);
      Writeln (' Befehl:     MKDIR (''C:\TP6\JU\''+S)                      ');
      MKDIR ('C:\TP6\JU\'+S);

      Gotoxy (6, 9);
      TExtcolor (10);
      Writeln (' In dieses Directory wird anschlieend verrzweigt.                    ');
      Gotoxy (6, 10);
      TextColor (11);
      Writeln (' SYNTAX:      CHDIR (S);                                              ');
      Gotoxy (19, 11);
      TextColor (15);
      Writeln (' Befehl:     CHDIR (S)                                   ');
      CHDIR ('C:\tp6\ju\'+S);

      Gotoxy (6, 13);
      Textcolor (10);
      Writeln (' Jetzt wird festgestellt, in welchem Directory wir uns befinden       ');
      Gotoxy (6, 14);
      TextColor (11);
      Writeln (' SYNTAX:      GETDIR (D: Byte; VAR S: String)                         ');
      Gotoxy (19, 15);
      Textcolor (15);
      Writeln (' Befehl:     GETDIR (0, S)          0 fr akt. Laufwerk  ');
      Gotoxy (6, 16);
      TextColor (13);
      Write (' Das aktuelle Directory ist  ');
      Textcolor (12);
      GetDir (0, SNeu);
      Write (SNeu:22, '  ');
      Textcolor (22);
      Writeln (' Taste drcken ! ');
      Ch := Readkey;

      Gotoxy (6, 18);
      Textcolor (10);
      Writeln (' Nun mu nach einem Rcksprung ins bergeordnete Directory das neue   ');
      Gotoxy (6, 19);
      Writeln (' Subdirectory wieder gelscht werden.                                 ');
      Gotoxy (6, 20);
      TextColor (11);
      Writeln (' SYNTAX:      RMDIR  (S: String)               ');
      Gotoxy (19, 21);
      Textcolor (15);
      Writeln (' Befehl:     RMDIR (''C:\TP6\JU\''+S)                      ');
      CHDIR ('\TP6\Ju');
      RMDIR (S);
      Tastendruck
   End;


{  13.  }
Procedure StringOperationen;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 13:   S T R I N G M A N I P U L A T I O N           ');
      Textcolor (14);
      Gotoxy (6, 3);
      Writeln ('      Befehle:  POS, CONCAT, ''+'', COPY, INSERT, LENGTH, DELETE        ');
      Gotoxy (6, 5);
      TextColor (10);
      Writeln (' Es werden zwei Strings definiert mit den Namen                       ');
      TextColor (14);
      Gotoxy (6, 6);
      Writeln ('     S1 := ''12345''   und  ');
      Gotoxy (6, 7);
      Writeln ('     S2 := ''67890''        ');
      Gotoxy (6, 8);
      Textcolor (10);
      Writeln (' Diese Angaben  werden nun auf verschiedene Arten manipuliert.        ');
      Gotoxy (6, 10);
      Writeln (' Zunchst werden die beiden Strings zu einem einzigen vereinigt.      ');
      Gotoxy (6, 12);
      Writeln (' Es stehen hiefr zwei Methoden zur Verfgung:                        ');
      Gotoxy (6, 14);
      Textcolor (13);
      Writeln ('     Verschmelzung mittels des Operators    +      ');
      Gotoxy (6, 15);
      Writeln ('        oder ');
      Gotoxy (6, 16);
      Writeln ('     Verschmelzung mittels der Funktion     CONCAT ');
      Gotoxy (6, 18);
      TextColor (11);
      Writeln (' SYNTAX:     S := S1 + S2    oder    S := CONCAT (S1, S2)             ');
      Gotoxy (6, 19);
      Writeln ('             auch S := Concat (''12345'', ''67890'') wre mglich         ');
      Gotoxy (6, 21);
      Textcolor (10);
      Write (' Der endgltige String lautet:    ');
      Textcolor (12);
      S1 := '12345';
      S2 := '67890';
      S := S1 + S2;
      Writeln (S:12, '     ');
      Tastendruck;
   End;


Procedure Forts3;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('       1. Ergnzung zu 13: S T R I N G M A N I P U L A T I O N        ');
      Textcolor (14);
      Gotoxy (6, 3);
      Writeln ('      Befehle:  POS, CONCAT, ''+'', COPY, INSERT, LENGTH, DELETE        ');

      Gotoxy (6, 5);
      Textcolor (12);
      Writeln (' C O P Y ');
      Gotoxy (6, 6);
      Textcolor (11);
      Writeln (' Heraustrennen von 5 Zeichen ab dem 2. Zeichen mittels <COPY>:        ');
      TextColor (14);
      Gotoxy (6, 7);
      Writeln ( '    Befehl:   COPY (S, 2, 5)           ');
      Gotoxy (6, 8);
      Textcolor (15);
      Writeln ('           Ergebnis:   ', Copy (S, 2, 5), '           ');

      Gotoxy (6, 11);
      TextColor (12);
      Writeln (' D E L E T E ');
      Textcolor (11);
      Gotoxy (6, 12);
      Writeln (' Lschen von 5 Zeichen ab dem 2. Zeichen mittels <DELETE>:            ');
      TextColor (14);
      Gotoxy (6, 13);
      Writeln ( '    Befehl:   DELETE (S, 2, 5)         ');
      Gotoxy (6, 14);
      Textcolor (15);
      Delete (S, 2, 5);
      Writeln ('           Ergebnis:   ', S, '           ');

      Gotoxy (6, 17);
      TextColor (12);
      Writeln (' I N S E R T ');
      Gotoxy (6, 18);
      Textcolor (11);
      Writeln (' Einfgen des Strings ''-AB-'' in den String S ab dem 4. Zeichen        ');
      Gotoxy (6, 19);
      Writeln (' mittels <INSERT>:                                                    ');
      TextColor (14);
      Gotoxy (6, 20);
      Writeln ( '    Befehl:   INSERT (''-AB-'', S, 4)    ');
      S := '1234567890';
      Insert ('-AB-', S, 4);
      Gotoxy (6, 21);
      Textcolor (15);
      Writeln ('           Ergebnis:   ', S, '  ');

      Tastendruck
   End;


Procedure Forts4;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        2. Ergnzung zu 13: S T R I N G M A N I P U L A T I O N       ');
      Textcolor (14);
      Gotoxy (6, 3);
      Writeln ('      Befehle:  POS, CONCAT, ''+'', COPY, INSERT, LENGTH, DELETE        ');

      Gotoxy (6, 6);
      TextColor (12);
      Writeln (' L E N G T H ');
      Gotoxy (6, 7);
      Textcolor (11);
      Writeln (' Feststellen der Lnge des neuen Strings S = ''123-AB-4567890''         ');
      TextColor (14);
      Gotoxy (6, 8);
      Writeln ( '    Befehl:   LENGTH ( S )    ');
      Gotoxy (6, 9);
      Textcolor (15);
      Writeln ('           Ergebnis:   ', Length (S), '     ');

      Gotoxy (6, 12);
      TextColor (12);
      Writeln (' P O S ');
      Gotoxy (6, 13);
      Textcolor (11);
      Writeln (' Feststellen des Vorkommens der Zeichenfolge ''678'' im String          ');
      Gotoxy (6, 14);
      Writeln (' ''123-AB-4567890''                                                     ');
      TextColor (14);
      Gotoxy (6, 15);
      Writeln ( '    Befehl:   POS ( ''678'', S )       ');
      Gotoxy (6, 16);
      Textcolor (15);
      Writeln ('           Ergebnis:   ', Pos ('678', S):2, '     ');
      Gotoxy (6, 18);
      Textcolor (10);
      Writeln (' Es wird die echte Position des 1. Zeichens zhlrichtig wiedergegeben.');
      Gotoxy (6, 19);
      Writeln (' Wenn der gefragte String nicht enthalten ist, wird 0 rckgeliefert.  ');

      Tastendruck
End;


{  14.
 Ŀ
  FARB-KONSTANTEN:                                                     
     Vorder-und Hintergrund :            Vordergrund :                 
     Black      =  0                     DarkGrey     =   8            
     Blue       =  1                     LightBlue    =   9            
     Green      =  2                     LightGreen   =  10            
     Cyan       =  3                     LightCyan    =  11            
     Red        =  4                     Lightred     =  12            
     Magenta    =  5                     LightMagenta =  13            
     Brown      =  6                     Yellow       =  14            
     Lightgrey  =  7                     White        =  15            
  Ein Aufruf von TEXTBACKGROUND setzt die Bits 4 bis 6 der Variablen   
  TEXTATTR mit der angegebenen Farbe.                                  
  TEXTCOLOR setzt die Bits 0 bis 3 dieser Variablen.                   
  Das Blinkattribut ist BLINK = 128. Fr alle Farben > 16 wird das     
  Blinkattribut ebenfalls gesetzt.                                     
  Das Unit CRT definiert eine globale Variable namens TextAttr, die    
  das jeweils verwendete Attribut fr Textausgaben enthlt.            
  HIGHVIDEO setzt das hchstwertige Bit fr die Vordergrundfarbe in    
  dieser Variablen und sorgt, da die Farbnummerm 8 bis 15 bentzt     
  werden.                                                              
  LOWVIDEO lscht das hchstwertige Bit, soda die Farben 0 bis 7 zur  
  Anwendung kommen.                                                    
  NORMVIDEO setzt das Textattribut fr nachfolgende Ausgaben, das beim 
  Start gesetzt war.                                                   
  TEXTCOLOR und TEXTBACKGROUND definieren Vorder- und Hintergrund.     
 }

Procedure BildschirmZeilen;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('      Anwendung 14:   B I L D S C H I R M G E S T A L T U N G         ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('    Befehle:  CLRSCR, TEXTBACKGROUND, CLREOL, DELLINE, TEXTCOLOR      ');
      Gotoxy (6, 6);
      Textcolor (10);
      Writeln (' Es wird ein Fenster mit einem roten Hintergrund gesetzt !');
      Gotoxy (6, 7);
      TextColor (15);
      Writeln ('    Befehl:    TEXTBACKGROUND (4)  ');
      Textcolor (10);
      Gotoxy (6, 8);
      Writeln (' Mittels TEXTCOLOR werden die Zeichenfarben festgelegt.    ');

      TextBackGround (4);
      Window (55, 10, 75, 18);
      ClrScr;
      TextColor (14);
      Writeln (' Hier findet alles');
      Writeln (' Folgende statt !');
      Writeln (' Bitte Texte lesen.');
      Writeln;
      Writeln (' Hier wird gebt.');
      Writeln;
      Writeln;
      TextColor (15);
      Writeln (' Taste drcken  !!!!');
      Ch := Readkey;

      Window (1, 1, 54, 25);
      Gotoxy (6, 11);
      TextColor (10);
      TextBackGround (0);
      Writeln (' Die 3. Zeile im Fenster wird jetzt gelscht.');
      TextColor (11);
      Gotoxy (6, 12);
      Writeln ('    SYNTAX:    DELLINE');
      Window (55, 10, 75, 18);
      Gotoxy (1, 3);
      TextColor (15);
      Ch := ReadKey;
      DelLine;

      Window (1, 1, 54, 25);
      Gotoxy (6, 15);
      TextColor (10);
      TextBackGround (0);
      Writeln (' In der 2. Zeile wird das Wort ''statt'' ge-   ');
      Gotoxy (6, 16);
      Writeln (' lscht. Der Zeilen-Hintergrund wird gem. der');
      Gotoxy (6, 17);
      Writeln (' letzten Vorschrift schwarz eingefrbt.      ');
      TextColor (11);
      Gotoxy (6, 18);
      Writeln ('    SYNTAX:    CLREOL  ');
      Ch := Readkey;
      Window (55, 10, 75, 18);
      Gotoxy (10, 2);
      ClrEol;

      Window (1, 1, 80, 25);
      TextColor (10);
      Gotoxy (6, 20);
      Writeln (' Der Vordergrund mit der Schrift verschwindet');
      Gotoxy (6, 21);
      Writeln (' Der Hintergrund wird jetzt grn eingefrbt. ');
      TextColor (11);
      Gotoxy (6, 22);
      Writeln ('    SYNTAX:    CLRSCR');
      Ch := Readkey;
      Window (55, 10, 75, 18);
      TextBackGround (2);
      ClrScr;

      Window (1, 1, 80, 25);
      Tastendruck
   End;


Procedure Forts5;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Ergnzung zu 14:  H I G H V I D E O , L O W V I D E O         ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('          Befehle:  NORMVIDEO, LOWVIDEO, HIGHVIDEO, TEXTATTR          ');
      TextAttr := White;
      Textcolor (10);
      Gotoxy (6, 6);
      Writeln ('     Jetzt wird auf LOWVIDEO geschaltet !   ');
      Gotoxy (6, 8);
      Textcolor (11);
      Writeln ('     SYNTAX:     LOWVIDEO                   ');
      Gotoxy (6, 11);
      TextColor (15);
      LowVideo;
      Writeln ('     Ergebnis:   Dunkler                    ');
      Gotoxy (6, 15);
      Textcolor (10);
      Writeln ('     Und nun kommt HIGHVIDEO !              ');
      Gotoxy (6, 17);
      Textcolor (11);
      Writeln ('     SYNTAX:     HIGHVIDEO                  ');
      TextColor (15);
      HighVideo;
      Gotoxy (6, 20);
      Writeln ('     Ergebnis:   Heller                     ');
      Tastendruck
   End;


{ Hauptprogramm }
Begin
   {  1: Zeile  226 }  AdressenFunktion;
   {     Zeile  311 }  Forts1;
   {  2. Zeile  371 }  SegmentAdressen;
   {  3: Zeile  478 }  Crt_Demo;
   {  4.        502 }  DirSuche;
              { 581 }  Forts2;
   {  5.        631 }  Verzeichnis_Info;
   {  6.        739 }  Get_Date_Time_Demo;
   {  7: Zeile  828 }  CharFunktion;
   {  8:        935 }  Environment;
   {  9.        988 }  DOS_Version;
   { 10.       1046 }  Speicherraum;
   { 11.       1103 }  Abbruch;
   { 12.       1181 }  Directory;
   { 13.       1285 }  StringOperationen;
             { 1338 }  Forts3;
             { 1400 }  Forts4;
   { 14.       1451 }  BildschirmZeilen;
             { 1568 }  Forts5;
 End.