{ͻ
   Programm:    PASCALLERNEN    2. Teil         Datei:   PASCAL2.PAS     
 Ķ
   Autor:       AV. DI. Wilh. Junker            Datum:    1. Jan. 1993   
 Ķ
   Schule:      HTL Waidhofen/Ybbs              Sprache: TurboPascal 6.0 
 ĺ
   Besprechung der Befehle von TurboPascal mit  Beispielen  inklusive    
   weiterer Details aus dem Begleitbuch und von Angaben ber die Ab-     
   wicklung von Interrupts                                               
                               Befehle 15 bis 26           953 Zeilen    
 ͼ}
{$M 16384, 0, 655360 }
(*
 Ŀ
  COMPILERSCHALTER:                                                    
                                                                       
  {$A+}   Ausrichtung von Variablen im Speicher (auer CHAR und BYTE)  
          Alle Variablen beginnen an einer ganzzahligen Adresse, so-   
          da Speicherzugriffe beschleunigt erfolgen.                  
          VAR- und CONST-Deklarationen werden jedenfalls so behandelt. 
  {$B+}   Auswertung boolescher Ausdrcke (Def: {$B-})                 
          Vollstndige Auswertung aller Ausdrcke mit AND, OR etc.     
  {$D+}   Zusatzinformationen zur Fehlersuche                          
          Wichtig fr die lokalisierung von Laufzeitfehlern und fr    
          den DEBUGGER.                                                
          Der Platzbedarf wird natrlich grer.                       
  {$E+}   Aufnahme des Emulators in die .EXE-Datei.                    
  {$F+}   Erzwingen von FAR-Aufrufen (Def: {$F-})                      
  {$I+}   Automatische Prfung von Ein- und Ausgabe                    
  {$L+}   Aufnahme von Informationen ber lokale Symbole in ein Modul  
  {$N+}   Voraussetzung eines num. Koprozessors mit mehreren neuen     
          Datentypen (Def: {$N-})                                      
  {$O+}   Festelgung ob Units OVERLAY-fhig sind oder nicht (Def:{$R-} 
  {$R+}   Erzeugung von zustzlichem Prfcode bei Indizierungen und bei
          Zuordnungen von skalaren Typen (Def: {$R-})                  
  {$S+}   Erzeugung von zustzlichem Prfcode fr die Verwaltung des   
          Stacks                                                       
  {$V+}   Formale und aktuelle String-Parameter werden auf identischen 
          Typ geprft                                                  
 
  PARAMETER:
 
  {$I Dateiname }  Aufnahme einer INCLUDE-Datei in das Programm, welche
                   1:1 bernommen wird                                 
  {$L Dateiname}   Aufnahme einer assemblierten Datei in das laufende  
                   Programm durch den Linker                           
  {$M Stack, HeapMin, HeapMax } Reservierung von Platz fr Stack und   
                   Heap                                                
  {$O UnitName }   Deklaration eines Units als Overlay                 
 
 *)
Program PascalLernen_3;

Uses Crt, Dos, Printer;

Var
    Ch:   Char;

Procedure Rahmen;
Var I: Integer;
Begin
   TextColor (14);
   Writeln ('ͻ');
   For I := 2 to 23 Do
   Begin
      Gotoxy (1, I);
      Write (#186);
      Gotoxy (80, I);
      Write (#186)
   End;
   Write ('ͼ');
End;

Procedure Tastendruck;
Begin
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 24);
   Write (' Bitte eine beliebige Taste drcken ! ');
   Ch := Readkey;
 End;

Function StrNeu (Angabe: LongInt; Z: Integer): String;
Var
   Zahl: LongInt;
   StrAlt: String[6];
   ZwErg, Erg: LongInt;
   St: String[1];
Begin
   Zahl := Angabe;
   StrAlt := '$';
   Repeat
      Erg := Zahl Div 16;
      ZwErg := Zahl Mod 16;
      If ZwErg= 0 Then ST := '0';
      If ZwErg= 1 Then ST := '1';
      If ZwErg= 2 Then ST := '2';
      If ZwErg= 3 Then ST := '3';
      If ZwErg= 4 Then ST := '4';
      If ZwErg= 5 Then ST := '5';
      If ZwErg= 6 Then ST := '6';
      If ZwErg= 7 Then ST := '7';
      If ZwErg= 8 Then ST := '8';
      If ZwErg= 9 Then ST := '9';
      If ZwErg=10 Then ST := 'A';
      If ZwErg=11 Then ST := 'B';
      If ZwErg=12 Then ST := 'C';
      If ZwErg=13 Then ST := 'D';
      If ZwErg=14 Then ST := 'E';
      If ZwErg=15 Then ST := 'F';
      Zahl := Erg;
      StrAlt := St + StrAlt;
   Until Erg=0;
   StrNeu := StrAlt;
End;


Procedure PrintScreenNeu;
Interrupt;
Var I, J: ShortInt;
Begin
   Textcolor (12);
   Randomize;
   I := 2 + Random (39);
   J := 4 + Random (20);
   Gotoxy (I, J);
   Writeln ('So eine Frechheit ! Man leitet mich um !');
   { hier steht das neue Programm }
End;


{  15.
 Ŀ
  ERASE lscht eine oder mehrere Dateien                               
  SYNTAX:      ERASE (VAR f)                                           
  Wenn ERASE fehlerfrei ausgefjrt wurde liefert ein nacgfolgender     
  Aufruf von IORESULT den Wert 0, ansonsten den entsprechenden Fehler- 
  code als Ergebnis.                                                   
  ERASE darf nie auf offenen Dateien angewendet werden.                
                                                                       
  Die Variable FILEMODE ist im Unit System deklariert und legt fest,   
  in welchem Modus Dateien durch RESET geffnet werden (bei Textdateien
  kein Einflu !)                                                      
  Werte:                                                               
      0    ffnen von untypis. Dateien nur fr Leseaktionen            
      1       nur fr Schreibaktionen                                  
      2       fr Lese- und Schreibaktionen gleichzeitig (Default)     
  Ab DOS 3 zustzliche Modi auch fr Netzwerke                         
  REWRITE arbeitet mit dem Filemode 2.                                 
 }

Procedure Decr_Incremente;

   Var
      IntVar:   Integer;
      LongVar:  LongInt;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('   Anwendung 15:   D E K R E M E N T E  u n d  I N K R E M E N T E    ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                         Befehle:  DEC, INC                           ');
      TextColor (10);
      Gotoxy (6, 6);
      Write (' Die 1. Variable (Integer) lautet:           ');
      IntVar := 10;
      LongVar := 90234;
      TextColor (14);
      Writeln (IntVar:10, '               ');
      TextColor (10);
      Gotoxy (6, 8);
      Write (' Die 2. Variable (LongInteger) lautet:       ');
      TextColor (14);
      Writeln ( LongVar:10, '               ');

      Gotoxy (6, 10);
      Textcolor (11);
      Writeln (' SYNTAX:         DEC  (Variable, N: LongInt)                          ');
      Gotoxy (6, 11);
      TextColor (15);
      Writeln ('       Befehl:   DEC (IntVar)           ');
      Dec (IntVar);
      Dec (LongVar,5);
      TextColor (10);
      Gotoxy (6, 12);
      Write (' Die dekrementierte 1. Variable lautet:      ');
      TextColor (12);
      Writeln (IntVar:10, '  ');

      Gotoxy (6, 14);
      TextColor (15);
      Writeln ('       Befehl:   DEC (LongVar, 5)       ');
      Textcolor (10);
      Gotoxy (6, 15);
      Write (' Die um 5 dekrementierte 2. Variable lautet: ');
      TextColor (12);
      Writeln(LongVar:10, '  ');

      Gotoxy (6, 17);
      Textcolor (11);
      Writeln (' SYNTAX:         INC  (Variable, N: LongInt)                          ');
      Gotoxy (6, 18);
      TextColor (15);
      Writeln ('       Befehl:   INC (LongVar, 2)       ');
      Inc (LongVar,2);
      TextColor (10);
      Gotoxy (6, 19);
      Write (' Die um 2 inkremtierte 2. Variable lautet:   ');
      TextColor (12);
      Writeln (LongVar:10, '  ');

      Tastendruck
   End;


{  16.
 Ŀ
  ERASE lscht eine oder mehrere Dateien                               
  SYNTAX:      ERASE (VAR f)                                           
  Wenn ERASE fehlerfrei ausgefjrt wurde liefert ein nacgfolgender     
  Aufruf von IORESULT den Wert 0, ansonsten den entsprechenden Fehler- 
  code als Ergebnis.                                                   
  ERASE darf nie auf offenen Dateien angewendet werden.                
                                                                       
  Die Variable FILEMODE ist im Unit System deklariert und legt fest,   
  in welchem Modus Dateien durch RESET geffnet werden (bei Textdateien
  kein Einflu !)                                                      
  Werte:                                                               
      0    ffnen von untypis. Dateien nur fr Leseaktionen            
      1       nur fr Schreibaktionen                                  
      2       fr Lese- und Schreibaktionen gleichzeitig (Default)     
  Ab DOS 3 zustzliche Modi auch fr Netzwerke                         
  REWRITE arbeitet mit dem Filemode 2.                                 
 }

Procedure EraseDemo;

   Var F:       File;
       Merker:  ShortInt;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Writeln ('             Anwendung 16:   D A T E I L  S C H U N G                ');
      TextColor (14);
      Gotoxy (6, 3);
      Writeln ('                     Befehl:  ERASE, $I+, $I-                         ');
      Gotoxy (6, 6);
      Textcolor (11);
      Writeln (' SYNTAX:         ERASE  (Variable F)                                  ');
      Textcolor (15);
      Gotoxy (6, 7);
      Writeln ('       Befehl:   Erase  (''C:\TP6\JU\*.BAK'')                           ');
      TextColor (10);
      Gotoxy (6, 9);
      Writeln (' ERASE lscht die mit F via ASSIGN verbundene externe Datei.          ');

      Assign (F, 'C:\TP6\JU\*.bak');
      {$I-}
         Reset (F);
         Merker := IOResult;
      {$I+}
      If Merker <> 0 Then
      Begin
         Gotoxy (6, 11);
         Textcolor (12);
         Writeln (' Nicht gefunden: ', ' *.BAK ');
         TextColor (13);
         Gotoxy (16, 13);
         Writeln (' Die FehlerVariable IOResult = ', Merker:2, ' ')
      End
      Else
      Begin
         {
         Close (F);
         }
         Erase (F)
      End;
      TextColor (10);
      Gotoxy (6, 16);
      Writeln (' Die Fehlervariable IORESULT kann bei vielen Ein- und Ausgabeoperati- ');
      Gotoxy (6, 17);
      Writeln (' onen abgefragt werden. IORESULT ist bei Auftreten eines Fehlers > 0. ');
      Gotoxy (6, 18);
      Writeln (' Sie wird aber bei jeder Operation aktualisiert, soda sie in einer   ');
      Gotoxy (6, 19);
      Writeln (' Hilfsvariablen (hier heit diese HilfsVariable ''Merker'') gespeichert ');
      Gotoxy (6, 20);
      Writeln (' werden mu.                                                          ');
      Gotoxy (6, 21);
      Textcolor (11);
      Writeln (' SYNTAX:         {$I-} RESET (F) {I+}                                 ');
      Tastendruck
   End;


{  17.
 Ŀ
  APPEND-Prozedur, ASSIGN-Prozedur:                                    
  ffnung einer <existierenden!> Datei fr das Anhngen weiterer Daten.
  F ist eine Textdateivariable, die zuvor mit ASSIGN mit einer externen
  Datei verbunden worden sein mu. Der Dateizeiger wird ans Ende ge-   
  setzt. Wenn die Datei ein Dateiende-Zeichen CONTROL-Z besitzt, wird  
  dieses berschrieben und neu gesetzt.                                
  Ein Nullstring als Name entspricht der StandardAusgabe (DOS-Handle 1 
  = OUTPUT).                                                           
  EOF (F) liefert immer TRUE als Ergebnis.                             
  Eine Kontrolle ist ber die Funktion IORESULT mglich.               
 }

Procedure DateihandlingMitAppend;

   Var
      F:      Text;
      Name:   String[18];

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextBackGround (0);
      TextColor (15);
      Gotoxy (6, 2);
      Write ('               Anwendung 17:   D A T E I H A N D L I N G              ');
      TextColor (14);
      Gotoxy (6, 3);
      Write ('                Befehle:  APPEND, ASSIGN, RESET, CLOSE                ');
      TextColor (10);
      Gotoxy (6, 5);
      Write (' Es erfolgt hier die Darstellung der Ausgabe ber Drucker');
      Writeln (' oder Bild-  ');
      Gotoxy (6, 6);
      Writeln (' schirm ber Dateifunktionen !');
      Gotoxy (6, 7);
      Write (' Wenn nur <RETURN> gedrckt wird, geht die Ausgabe zum ');
      Writeln ('Bildschirm,    ');
      Gotoxy (6, 8);
      Write (' weil mit der Angabe  ASSIGN (F, '''') wird die Standarddatei ');
      Writeln (' zuge-    ');
      Gotoxy (6, 9);
      Writeln (' ordnet! ');
      Gotoxy (6, 11);
      TextColor (10);
      Writeln (' Jeder Dateiname inklusive  Prn, LptX, Nul, ComX, etc  ist mglich !  ');
      Gotoxy (6, 13);
      TextAttr := White;
      Write (' Dateiname angeben ! ACHTUNG auf vorhandene Namen !  ');
      Readln (Name);

      { Fr die Bezeichnung NAME gelten die Regeln von DOS, max. 79
        Zeichen inkl. PATH }

      Assign (F, Name);          { Namenszuordnung }
      Rewrite (F);                     { Erzeugung einer leeren Datei }
      Gotoxy (6, 15);
      If (Name='PRN') or (Name='prn') Then
      Begin
         Writeln (' Die Daten gehen zum Drucker ! ');
         Writeln (F, 'Der Drucker wurde angesprochen ! ')
      End
      Else If (Name='NUL') or (Name='nul') Then Writeln (' Die Daten sind verloren !')
      Else If (Name='') Then
      Begin
         Writeln (F, ' Eine alte Zeile');
         Close (F);
         Append (F);                      { Neuerliche Dateiffnung }
         Gotoxy (16, 16);
         Writeln (F, ' ... diese Zeile wird angehngt ! ')
         { Diue Datei enthlt nun zwei Textzeilen }
      End;
      Close (F);

      Textcolor (13);
      Gotoxy (6, 18);
      Writeln (' MUSTERDATEIBEFEHLE zur Ergnzung einer vorhandenen Datei:            ');
      TextColor (11);
      Gotoxy (6, 19);
      Writeln ('                    Assign (F, Dateiname)                             ');
      Gotoxy (6, 20);
      Writeln ('                    Reset (F)                                         ');
      Gotoxy (6, 21);
      Writeln ('                    Append (String oder Record                        ');
      Gotoxy (6, 22);
      Writeln ('                    Close (F)                                         ');
      Tastendruck;
   End;


{  18.
 Ŀ
  Prfung auf FILE-Ende:                                               
  Wenn F nicht angegeben ist, prft Turbo-Pascal die Standard-         
  Eingabe.                                                             
  Die Prfung auf Fehlerfreiheit kann mittels IOResult erfolgen.       
  Deklaration:                                                         
     EOF (Var F)    ... fr typisierte und untyp. Dateien, Typ Boolean 
     EOF (Var F: Text)  fr Textdateien                                
     EOF            ... Prfung der Standardeingabe (INPUT)            
  EOF (F) liefert TRUE oder FALSE als Ergebnis.                        
  Eine Kontrolle ist ber die Funktion IORESULT mglich.               
 }

Procedure FileEndePr;

   Var
      F:  Text;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('    Anwendung 18:   A B F R A G E   d e s   F I L E - E N D E S     ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                          Befehl: EOF                               ');
      Textcolor (10);
      Gotoxy (6, 6);
      Writeln (' Die Funktion EOF prft, ob das Ende einer Datei erreicht ist.      ');
      TextColor (11);
      Gotoxy (6, 8);
      Writeln (' SYNTAX:     EOF (VAR F)        fr typisierte und unty. Dateien    ');
      Gotoxy (6, 9);
      Writeln ('             EOF (VAR F:Text)   fr Textdateien                     ');
      Gotoxy (6, 11);
      TextColor (14);
      Writeln (' Der Typ dieser Variablen ist BOOLEAN d.h.                          ');
      Gotoxy (6, 12);
      Writeln ('         TRUE   oder  FALSE                                         ');
      Gotoxy (6, 14);
      Textcolor (13);
      Writeln (' Mgliche Konstrukte in TurboPascal lauten:                         ');
      Gotoxy (6, 15);
      Writeln ('         WHILE NOT EOF (F) DO ....                                  ');
      Gotoxy (6, 16);
      Writeln ('         REPEAT  ....  UNTIL EOF                                    ');
      {
         Dateiname ist erster Kommandozeilenparameter
      Writeln (ParamCount);
      Assign (F, Paramstr(1));
      Reset (F);
      While Not EOF(F) Do
      Begin
         Read (F,Ch);
         Write (Ch)
      End;
      Close (F);
      }
      Tastendruck
   End;


{  19.
 Ŀ
  Es werden mittels des Befehls BLOCK....  ein oder mehrere Records    
  einer Datei in eine Puffervariable/aus einer Puffervariablen in eine 
  Datei geschrieben.                                                   
  Deklaration:                                                         
      BLOCKREAD (Var F:File; VAR Buf; Count: Eord [;Result: Word])     
      BLOCKWRITE ( ... )                                               
  Formate:                                                             
      F  ..... untypisierte Datei-Variable                             
      Buf  ... Variable beliebigen Typs (meist Byte oder Char-Array)   
      Count .. Word                                                    
      Result . Word-Variable                                           
  BLOCKREAD liest COUNT Records der durch F angegebenen Datei und      
  speichert sie ab der Startadresse von Buf.  Gelsen wird ab der mo-   
  mentanen Position innerhalb von F.  Wenn Result bergeben wurde,     
  dann beendet BLOCKREAD den Lesevorgang bei Erreichen des Dateiendes  
  ohne Fehlermeldung und setzt RESULT auf die Anzahl der gelesenen     
  Records. Die momentane Position innerhalb der Datei wird um RESULT   
  Records in Richtung Dateiende verschoben.                            
  RECSIZE ist die bei der Erffnung festgelegte Recordgre (Default-  
  wert 128 Byte); maximal knnen bei einem Aufruf 64 kBte gelesen wer- 
  den.   Gesamtzahl der bertragenen Bytes: COUNT * RECSIZE.           
  BLOCKWRITE liest COUNT Records ab der Startadresse von BUF aus dem   
  Speicher und schreibt sie in die durch F angegebene Datei.           
  RESULT gibt die Anzahl der komplett geschriebenen Records wieder.    
  Bei fehlerfreier Ausfhrung liefert IORESULT den Wert Null.          
 }

Procedure BlockBearbeitung;

   Var
      Quelle, Ziel: File;
      Gel, Geschr: Word;
      Puffer: ARRAY[1..2048] of Byte;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      Gotoxy (6, 2);
      Write ('            Anwendung 19:   B L O C K B E H A N D L U N G             ');
      Gotoxy (6, 3);
      TextColor (14);
      Write ('                   Befehle:  BLOCKREAD, BLOCKWRITE                    ');
      Gotoxy (26, 12);
      Writeln (' Ein Beispiel steht im Text !  ');
      (*
      { Einfaches Kopierprogramm ohne Fehlerprfung }
      Program COPY;
      Var
         Quelle, Ziel: FILE;
         R_Gelesen, R_geschrieben: Word;
         Puffer: Array [1..2048] of Byte;
      Begin
         Assign  (Quelle, Paramstr(1));  { Zuordnung und ffnen der Quelldatei }
         Reset   (Quelle, 1);            { Recordlnge 1 Byte }
         Assign  (Ziel, Paramstr(2));    { Zuordnung und ffnen der Zieldatei }
         Rewrite (Ziel,1);               { Neue Datei erffnen }
         Writeln (Filesize(Quelle), 'Bytes werden kopiert ...');
         Repeat
            Blockread  (Quelle, Puffer, SizeOf(Puffer), Gel);
            BlockWrite (Ziel, Puffer, Gel, Geschr);
         Until (Gel = 0) or (Gel <> Geschr);
         Close(Quelle);                 { Dateipuffer leeren, ber einen Aufruf
                                       von FLUSH werden alle Daten hinausge-
                                       schrieben und der DOS-Handle freige-
                                       geben; die Verbindung durch ASSIGN
                                       wird nicht aufgehoben; ber IOResult
                                       ist die Fehlerbehandlung mglich }
         Close (Ziel)
      End;
      *)
      Tastendruck;
   End;


{  20.
 Ŀ
  SYNTAX:     EXEC (Path, CmdLine: String)                             
  EXEC fhrt ein Programm als Subproze aus und bergibt Kommandozei-  
  lenparameter.                                                        
  Beim Aufruf mu jedenfalls ene Heap-Begrenzung vorgenommen werden,   
  sonst meldet DOS den Code 8                                          
  Damit ein via EXEC aufgerufenes Programm die Vektoren, welche teil-  
  weise von TurboPascal verndert werden, nicht benutzt, soll folgendes
  programmiert werden:                                                 
      SwapVectors;                                                     
      EXEC (....);                                                     
      SwapVectors;                                                     
  Das Suffix (Extension) .EXE, .BAT, .COM mu explizit angegeben werden
  Der DOSExitCode eines als Unterproze gestarteten Programmes hat fol-
  gende Werte:                                                         
  Das niederwertige Byte des Ergebnisses ist der EXIT-Code des Program-
  mes:                                                                 
    normales Ende       ...  0                                         
    Abbruch durch CTRL-C ..  1                                         
    Device-Error        ...  2                                         
    Ende durch KEEP     ...  3                                         
  Mgliche Fehlercodes der Variablen DOSERROR (=Integer) sind hier:    
     fehlerfrei              ...  0                                    
     Dir nicht gefunden      ...  2                                    
     Ungltiger Suchweg      ...  3                                    
     Dateizugriff verweigert ...  5                                    
     ungltiger Handle/Datei ...  6                                    
     kein Platz im Hauptspeicher  8                                    
     Environment ungltig    ... 10                                    
     Befehlsformat ungltig  ... 11                                    
     Keine weiteren Eintrge ... 18                                    
 }

Procedure ExecDemo;

{$M $4000, 0, 0}    {16 kByte Stack, 0 kByte Heap    !!!!! ! ! ! !  }

   Var
      Programmname, Kommandozeile: String;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 20:   P R O G R A M M A U F R U F                ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                   Befehle: EXEC, SWAPVECTORS                         ');
      Gotoxy (6, 5);
      Textcolor (14);
      Writeln (' SYNTAX:     EXEC (Path, CmdLine: String)                             ');
      Gotoxy (6, 6);
      Writeln (' SYNTAX:     SWAPVECTORS                                              ');
      Gotoxy (6, 8);
      TextColor (15);
      Write (' Name des  auszufhrenden Programmes: ');
      Readln (Programmname);
      Gotoxy (6, 9);
      Write (' Kommandozeilen-Parameter fr ', Programmname, ': ');
      Readln (Kommandozeile);
      Gotoxy (6, 11);
      TextColor (12);
      Writeln (' Tochter-Programm wird ausgefhrt ...  ');
      SwapVectors;
      Exec (Programmname, Kommandozeile);

      Swapvectors;
      Gotoxy (6, 13);
      TextColor (10);
      Writeln ('Wieder im Programm EXECDEMO !');
      Gotoxy (6, 15);
      Textcolor (13);
      If DOSERROR <> 0 Then
      Begin
         Writeln ( ' DOS-Fehler: ', DosError:2, ' ');
         Textcolor (12);
         Gotoxy (16, 17);
         Writeln ( ' Directory/File nicht gefunden !  ')
      End
      Else
         Writeln (' Fehlerfreie Ausfhrung mit Exit-Code: ', DosExitCode, '  ');

      TextColor (10);
      Gotoxy (6, 19);
      Writeln (' Da TurboPascal viele Vektoren verndert, ist es angezeigt, beim Aus- ');
      Gotoxy (6, 20);
      Writeln (' stieg mittels SWAPVECTORS die Originalverktoren von DOS wieder ein-  ');
      Gotoxy (6, 21);
      Writeln (' zusetzen und nach der Rckkehr den Umkehrschritt zu tun.             ');
      Gotoxy (6, 22);
      Textcolor (12);
      Writeln (' Wichtig ist, den HEAP mittels Compilerdirektive $M auf 0 zu setzen.  ');

      Tastendruck
   End;


{  21.
 Ŀ
  Die Funktion FILESIZE liefert die Gre einer Datei in Byte zurck.  
  Es wird die Anzahl Komponenten angegeben, die in der genannten Datei 
  gespeichert sind.                                                    
  SYNTAX:             FILESIZE (Var F)                                 
  F steht fr eine typisierte oder untypisierte Datei-Variable.        
  Wenn die Datei leer ist liefert FILESIZE das Ergebnis 0.             
  Bei fehlerfreier Ausfhrung liefert IORESULT im modus IO- den Wert 0 
  ansonsten den entsprechenden Fehlercode.                             
  Eine Anwendung auf Textdateien ist nicht mglich.                    
  Die angsprochene Datei mu geffnet sein.                            
 }
Procedure FileSizeDemo;

   Var
      F: File of Byte;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('       Anwendung 21:   D A T E I G R  S S E N B E S T I M M U N G    ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                          Befehle: FILESIZE                           ');
      Gotoxy (6, 6);
      Textcolor (11);
      Writeln (' SYNTAX:        FILESIZE (F)                                          ');
      Gotoxy (6, 9);
      Textcolor (10);
      Writeln (' Beispiel fr eine  Befehlsfolge:      ');
      Textcolor (13);
      Gotoxy (6, 12);
      Writeln ('                    Assign (F, Dateiname)    ');
      Gotoxy (6, 13);
      Writeln ('                    Reset (F)                ');
      Gotoxy (6, 14);
      Writeln ('                    Writeln (FileSize (F):8) ');
      Gotoxy (6, 15);
      Writeln ('                    Close (F)                ');
      {
      Assign (F, Paramstr (1);
      Reset (F);
      Writeln ('Gre von ', ParamStr(1), ' in Bytes: ', FileSize(F));
      Close (F);
      }
      Tastendruck
   End;



{  22.
 Ŀ
  Die Prozedur FILLCHAR fllt einen Speicherbereich mit einem be-      
  stimmten Wert.                                                       
  Syntax:          FILLCHAR (VAR X; Count: Word; Value )               
  X steht fr einen Variablenbezug beliebigen Typs, de von FillChar    
  als Startadresse des zu fllenden Bereiches interpretiert wird.      
  Count gibt die Anzahl der mit Value zu fllenden Speicherzellen an.  
  Value ist ein Ausdruck des Typs Char oder Byte.                      
  Der Parameter Count sollte ber SizeOs angegeben werden, weil FILL-  
  CHAR keine Bereichsprfungen vornimmt und ev. versehentlich andere   
  Speicherbereiche berschreibt.                                       
  Beim Fllen von Strings mu das Lngenbyte gesetzt werden !          
 }

Procedure SpeicherFuellen;

   Var
      S: String[80];

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 22:   S P E I C H E R    F  L L E N             ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                         Befehle: FILLCHAR                            ');

      Gotoxy (6, 8);
      Textcolor (10);
      Writeln (' Beispiel fr das Setzen eines Strings von 80 Sternchen ');
      Gotoxy (6, 10);
      TextColor (11);
      Writeln (' SYNTAX:         FillChar (VAR x; Count: Word; Value)                 ');
      Gotoxy (6, 12);
      TextColor (15);
      Writeln ('       Befehl:   FillChar (S, SizeOf (S), ''*'')          ');
      Gotoxy (6, 14);
      Textcolor (10);
      Writeln (' Turbo-Pascal verlangt das Lngenbyte am 1. Platz (Pos. 0) des String ');
      Gotoxy (6, 16);
      TextColor (15);
      Writeln ('       Befehl:   S[0] := #80                            ');

      FillChar (S, SizeOf(S), '*');     { S wird als Startadresse angesehen }
      S[0] := #80;

      Tastendruck
   End;


{  23.
 Ŀ
  Die Procedure GETCBREAK ermittelt, bei welchen Operationen DOS auf   
  CTRL-BRK prft. Dies kann nur bei E/A oder bei jedem Aufruf auf die  
  Eingabe geschehen. Dazu wird die Funktion $33 von DOS verwendet.     
  Im ersten Fall wird die als BREAK bergebene Variable auf TRUE       
  gesetzt.                                                             
  Gegenteil:  SETCBREAK                                                
 }

   Procedure GetCBreakDemo;
   Var Break: Boolean;
   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('       Anwendung 23:   P R  F U N G   a u f  C T R L - B R E A K     ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                    Befehl: GETCBREAK, SETCBREAK                      ');
      Gotoxy (6, 6);
      TextColor (10);
      Writeln (' Die Procedure GETCBREAK ermittelt, ob DOS bei jeder Operation auf    ');
      Gotoxy (6, 7);
      Writeln (' die Eingabe von Ctrl-Break prft.                                    ');
      Gotoxy (6, 8);
      Writeln (' Mittels SETCBREAK kann die berprfung gezielt gesetzt/gelscht wer- ');
      Gotoxy (6, 9);
      Writeln (' den. ');
      Gotoxy (6, 12);
      TextColor (11);
      Writeln (' SYNTAX:         GETCBREAK (VAR Break: Boolean)                       ');
      Gotoxy (6, 13);
      Textcolor (15);
      Writeln ('       Befehl:   GETCBREAK (Break)        ');

      GetCBreak (Break);
      Textcolor (14);
      Gotoxy (6, 16);
      Writeln (' Antwort: ');
      Gotoxy (10, 18);
      TextColor (12);
      If Break=True Then Writeln (' Es wird nur bei E/A geprft !')
      Else If Break=False Then Writeln (' Es wird bei jedem Aufruf geprft !');

      Tastendruck
   End;



{  24.
 Ŀ
  Im Unit DOS sind fr die FileAttribute folgende Konstanten fest-     
  gelegt:  CONST                                                       
      ReadOnly  =  $01;   d.h. Bit 0                                   
      Hidden    =  $02;        Bit 1                                   
      SysFile   =  $04;        Bit 2                                   
      VolumeID  =  $08;        Bit 3                                   
      Directory =  $10;        Bit 4     'Directory' nicht mglich     
      Archive   =  $20;        Bit 5                                   
      AnyFile   =  $3F;        alle Bits                               
 }

Procedure GetFAttrDemo;

   Var
      F:    File;
      Attr: Word;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 24:   D A T E I A T T R I B U T E                ');
      Gotoxy (6, 3);
      TextColor (14);
      Writeln ('                        Befehle: GETFATTR                             ');
      Assign (F, 'C:\MSDOS.SYS');
      GetFAttr (F, Attr);
      { Writeln ('Datei: ', ParamStr(1));
        dies glte bei einem Aufruf, wo in der Kommandozeile ein Parameter
        bergeben werden kann zB Copy A:*.* B:, hier sind es zwei Parameter,
        getrennt durch mindestens 1 Zeichen BLANK }
      Gotoxy (6, 6);
      Textcolor (15);
      Writeln ('       Befehl: Assign (F, ''C:\MSDOS.SYS '')    ');
      Gotoxy (6, 7);
      Textcolor (11);
      Writeln (' SYNTAX:        GETFATTR (F, Attr)                                    ');

      If DosError<>0 Then
      Begin
         TextColor (12);
         Gotoxy (6, 9);
         Write ('  DOS-Fehler: ', DosError:3);
         Gotoxy (6, 11);
         If DosError=2 Then Writeln (' Datei nicht gefunden !');
         If DosError=3 Then Writeln (' Ungltiger Suchweg !');
         If DosError=5 Then Writeln ('Dateizugriff verweigert !');
      End
      Else
      Begin
         Writeln;
         TextColor (14);
         Gotoxy (6, 10);
         Write (' Ergebnis:  ');
         TextColor (10);
         Gotoxy (16, 12);
         Write (' Attribute: ');
         Textcolor (12);
         If Attr AND Hidden    <>0 Then Write ('  Hidden');
         If Attr AND SysFile   <>0 Then Write ('  SystemFile');
         If Attr AND VolumeID  <>0 Then Write ('  Volume-Identifyer');
         If Attr AND $10       <>0 Then Write ('  (Sub)Directory');
         If Attr AND Archive   <>0 Then Write ('  Archiv (Normale Datei)');
         Writeln
      End;
      Tastendruck
   End;


{  25.     GETINTVEC ermittelt den Inhalt eines Interrupt-Vektors.
 Ŀ
  Diese Prozedur ermittelt den Inhalt eines Interrupt-Vektors.         
  SYNTAX:       GETINTVEC (IntNo: Byte; VAR Vector: Pointer)           
  IntNo ist ein Ausdruck des Typs Byte und gibt die Nummer des zu      
  ermittelnden Vektors (0 .. 255) an, dessen Inhalt von GETINTVEC in   
  der als Vector bergebenen Zeigervariablen gespeichert wird.         
  Nach einem Aufruf wie                                                
      GETINTVEC (0, Zeiger_Var);                                       
  zeigt die Variable Zeiger_Var also auf die Startadresse der Routine, 
  die durch den Prozessorbefehl INT 0 aktiviert wird.                  
  Mit den Funktionen GETINTVEC und SETINTVEC kann ein Interrupt-Vektor 
  zeitweilig umgeleitet werden.                                        
  VORSICHT ! Die meisten Interrupt-Vektoren werden nach dem Ende des   
  Programmes nicht automatisch rckgesetzt ! Der Programmierer mu fr 
  die Originalwerte der Adressen sorgen !                              
  Das folgende Programm zeigt die Umleitung des Shift-PrtScr-Interrupts
  auf eine eigene Routine mit abschlieender Korrektur.                
  Es wird gezeigt, wie eine Interrupt-Procedure aufgebaut ist.         
 }

Procedure SetIntVectorDemo;

   Var
      PrintScreenVec: Pointer;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln (' Anwendung 25:  I N T E R R U P T V E K T O R M A N I P U L A T I O N ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                       Befehle: GETINTVEC                             ');

      GetIntVec (5, PrintScreenVec);
      SetIntVec (5, @PrintScreenNeu); { dies bedeutet Adresse der Ersatz-
                                        Interrupt-Procedure, welche am
                                        Programmbeginn steht }
      Textcolor (10);
      Gotoxy (6, 5);
      Writeln (' Print-Screen-Interrupt ungeleitet !');
      Gotoxy (6, 6);
      Writeln (' Bitte ausprobieren !');
      Gotoxy (6, 9);
      TextColor (15);
      Writeln (' Taste PRINT_SCREEN mehrmals drcken ! Die Schrift erscheint irgendwo !');
      Gotoxy (6, 12);
      TextColor (22);
      Writeln (' Nach diesen Mehrfachtests <RETURN>-Taste drcken !');
      Tastendruck;
      SetIntVec (5, PrintScreenVec);
   End;


{ 26.
 Ŀ
  Das VERIFY-Flag legt fest, ob DOS Diskettensektoren nach dem Schrei- 
  ben (durch eine reine Leseaktion ohne direkten Datenvergleich) noch  
  einmal prft oder nicht.                                             
  Die Prozedur SETVERIFY setzt dieses Flag mit dem als Verify ber-    
  gebenen Ausdruck:                                                    
  TRUE:    DOS fhrt eine zustzliche berprfung aus                  
  FALSE:   keine zustzliche berprfung                               
  Mit der Prozedur GETVERIFY lt sich der momentane Wert dieses Flags 
  ermitteln.                                                           
  Die Prfung kostet natrlich etwas Zeit !                            
 }

Procedure VerifyDemo;

   VAR
      Verify   : Boolean;
      Ch       : Char;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln (' Anwendung 26:  S E T Z E N / L  S C H E N     V E R I F Y - F L A G ');
      Gotoxy (6, 3);
      Textcolor (14);
      Writeln ('                  Befehle:  GETVERIFY  und SETVERIFY                  ');
      Gotoxy (6, 6);
      TextColor (10);
      Writeln (' Die Abfrage des Standes des DOS-Verify-Prfflags geschieht mittels   ');
      Gotoxy (6, 8);
      TextColor (11);
      Writeln (' SYNTAX:          GETVERIFY (VAR Verify: Boolean)                     ');
      GetVerify(Verify);
      Gotoxy (6, 10);
      TextColor (12);
      If Verify=True Then Writeln ('VerifyFlag Gesetzt !');
      If Verify=False Then Writeln ('VerifyFlag Nicht Gesetzt !');

      Textcolor (10);
      Gotoxy (6, 14);
      Writeln (' Das Setzen des DOS-Verify-Flags geschieht mittels                    ');
      Gotoxy (6, 16);
      TextColor (11);
      Writeln (' SYNTAX:          SETVERIFY (VAR Verify: Boolean)                     ');
      TextColor (12);
      Gotoxy (6, 18);
      Verify := True;
      SetVerify (Verify);
      If Verify=True Then Writeln ('VerifyFlag Gesetzt !');
      If Verify=False Then Writeln ('VerifyFlag Nicht Gesetzt !');
      Tastendruck
   End;


{ Hauptprogramm }
Begin
   { 15.       1606 }  Decr_Incremente;
   { 16.       1677 }  EraseDemo;
   { 17.       1761 }  DateiHandlingMitAppend;
   { 18.       1853 }  FileEndePr;
   { 19.       1919 }  Blockbearbeitung;
   { 20.       1997 }  ExecDemo;
   { 21.       2098 }  FileSizeDemo;
   { 22.       2153 }  SpeicherFuellen;
   { 23.       2208 }  GetCBreakDemo;
   { 24.       2261 }  GetFAttrDemo;
   { 25.       2335 }  SetIntVectorDemo;
   { 26.       2393 }  VerifyDemo
End.