{ͻ
   Programm:    PASCALLERNEN    3. Teil         Datei:   PASCAL3.PAS     
 Ķ
   Autor:       AV. DI. Wilh. Junker            Datum:    1. Jan. 1993   
 Ķ
   Schule:      HTL Waidhofen/Ybbs              Sprache: TurboPascal 6.0 
 ĺ
   Besprechung der Befehle von TurboPascal mit  Beispielen  inklusive    
   weiterer Details aus dem Begleitbuch und von Angaben ber die Ab-     
   wicklung von Interrupts sowie ber den HEAP                           
                                  Befehle 27 bis 44       1056 Zeilen    
 ͼ}
{$M 16384, 0, 655360 }

Program PascalLernen_3;

Uses Crt, Dos, Printer;

Var
    Ch:   Char;

Procedure Rahmen;
Var I: Integer;
Begin
   TextColor (14);
   Writeln ('ͻ');
   For I := 2 to 23 Do
   Begin
      Gotoxy (1, I);
      Write (#186);
      Gotoxy (80, I);
      Write (#186)
   End;
   Write ('ͼ');
End;

Procedure Tastendruck;
Begin
   TextBackGround (0);
   Textcolor (15);
   Gotoxy (22, 24);
   Write (' Bitte eine beliebige Taste drcken ! ');
   Ch := Readkey;
 End;

Function StrNeu (Angabe: LongInt; Z: Integer): String;
Var
   Zahl: LongInt;
   StrAlt: String[6];
   ZwErg, Erg: LongInt;
   St: String[1];
Begin
   Zahl := Angabe;
   StrAlt := '$';
   Repeat
      Erg := Zahl Div 16;
      ZwErg := Zahl Mod 16;
      If ZwErg= 0 Then ST := '0';
      If ZwErg= 1 Then ST := '1';
      If ZwErg= 2 Then ST := '2';
      If ZwErg= 3 Then ST := '3';
      If ZwErg= 4 Then ST := '4';
      If ZwErg= 5 Then ST := '5';
      If ZwErg= 6 Then ST := '6';
      If ZwErg= 7 Then ST := '7';
      If ZwErg= 8 Then ST := '8';
      If ZwErg= 9 Then ST := '9';
      If ZwErg=10 Then ST := 'A';
      If ZwErg=11 Then ST := 'B';
      If ZwErg=12 Then ST := 'C';
      If ZwErg=13 Then ST := 'D';
      If ZwErg=14 Then ST := 'E';
      If ZwErg=15 Then ST := 'F';
      Zahl := Erg;
      StrAlt := St + StrAlt;
   Until Erg=0;
   StrNeu := StrAlt;
End;


{  27.
 Ŀ
  HEAP-BEHANDLUNG:                                                     
  NEW belegt auf dem HEAP eine neue Zeiger-Variable, wobei zunchst    
  ein Zeiger (=Pointer) auf die eigentliche Variable hinweist.         
  Die Verwaltung der Freigabe geschieht entweder ber                  
      MARK und RELEASE                                                 
  oder ber                                                            
      MARK und DISPOSE.                                                
  Der Beginn des HEAP wird durch die Variable HEAPORG angegeben, das   
  Ende des Heap markiert die Variable HEAPPTR.                         
  Der Zeiger FREEPTR gibt Aufschlu ber den Bereich der Lcher im     
  Heap, welche in der Fragmentliste festgehalten werden.               
  Die Variable FREEMIN gibt den verbleibenden Speicherrest an.         
  MEMAVAIL berichtet ber den gesamten verbleibenden Speicherrest.     
  MAXAVAIL liefert den Umfang des grten freien Blocks im HEAP        
  GETMEM belegt einen Bereich von SIZE Bytes auf dem Heap und weist der
  als P bergebenen Zeigervariablen die Startadresse dieses Bereiches  
  zu, erzeugt also eine dyn. Variable, auf die ber P^ zugegriffen wer-
  den kann.                                                            
  Typen:                                                               
      P   ... Zeigervariable bel. Typs                                 
      Size .. Word                                                     
  Laufzeitfehler bei ungengend Platz knnen ber die Funktion HEAPFUNC
  behandelt werden.                                                    
  Maximal knnen 64 kBytes mit einem Aufruf belegt werden.             
  GETMEM und FREEMEM sowie anderseits MARK und RELEASE sollen i.a.     
  nicht durcheinander gemischt werden.                                 
 }

Procedure HeapBehandlung;

   {$F+}
   Function HeapFunc (Size: Word): Integer;
   {$F-}

   Begin
      HeapFunc := 1
   End;


   Procedure Freemem (X: Pointer; Size: Word);
   Begin
      Size := (Size DIV 16 + 1) * 16;
      System.Freemem (X, Size)
   End;


   Type Str22= String[22];
        { Aufbau der Fragmentliste: }
        FreeRec   = Record
                    OrgPtr, EndPtr: Pointer;
                  End;
        FreeList  = Array [0..8190] Of FreeRec;
        FreeListP = ^FreeList;
        { In die Felder OrgPtr und EndPtr werden die Start- und Endadressen
          jedes Lochs auf dem Heap eingetragen
          FREECOUNT :=(8192 - Ofs(Freeprt^) DIV 8) MOD 8192
          Dies ist die Anzahl besetzter Eintrge in der Fragmentliste }

   Var  P:          ^Str22;
        Ad:         Pointer;
        FreePtr:    Pointer;
        FreeMin:    Integer;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      TextBackGround (0);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 27:   H E A P M A N I P U L A T I O N            ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                      Befehle:  NEW, GETMEM                           ');

      TextColor (10);
      Gotoxy (6, 6);
      Writeln (' NEW erzeugt eine dynamische Variable und setzt einen Zeiger darauf.  ');
      Textcolor (11);
      Gotoxy (6, 7);
      Writeln (' SYNTAX:      NEW (P)    ');
      Textcolor (10);
      Gotoxy (6, 9);
      Write (' Die Variable lautet hier: ');
      Textcolor (14);
      Writeln (' P^ := ''Hier ist ein Text...''  ');
      Gotoxy (6, 11);
      Textcolor (10);
      Writeln (' Der Heap beginnt bei der Startadresse  mit dem Namen  < HEAPORG > :  ');
      Gotoxy (6, 12);
      TextColor (12);
      Writeln ('      Segment : Offset  =  ', StrNeu(Seg(HeapOrg), 4):4, ' : ', StrNeu(Ofs(Heaporg), 4):4, ' ');
      Textcolor (10);
      Gotoxy (6, 13);
      Writeln (' Das momentane Ende des Heaps bestimmt die Variable    < HEAPPTR > :  ');
      Gotoxy (6, 14);
      TextColor (12);
      Writeln ('      Segment : Offset  =  ', StrNeu(Seg(HeapPtr), 4):4, ' : ', StrNeu(Ofs(HeapPtr), 4):4, ' ');
      Gotoxy (6, 15);
      TextColor (10);
      Writeln (' Die Gesamtmenge des noch freien Speicherplatzes auf dem HEAP kann mit');
      Gotoxy (6, 16);
      Writeln (' der Funktion MEMAVAIL ermittelt werden:                              ');
      Gotoxy (6, 17);
      TextColor (12);
      Writeln ('    ', MEMAVAIL:8, ' Bytes sind noch verfgbar. ');

      P^ := 'Hier ist ein Text...';
      Gotoxy (6, 19);
      TextColor (10);
      Write (' Die Fragmentliste beginnt an der Stelle:     ');
      TextColor (12);
      Writeln (StrNeu(Seg(FreePtr)+4096, 4):4, ':', StrNeu(Ofs(FreePtr), 4):4, '     ');

      Gotoxy (6, 21);
      TextColor (10);
      Write (' Die Variable FREEMIN gibt den Speicherrest an: ');
      TextColor (12);
      Writeln (FreeMin:6, ' Bytes  ');
      {
      GetMem (P, Sizeof (P));
      New (P);
      HeapFunc (Sizeof(^P));
      Gotoxy (6, 16);
      Writeln (' Unsere abzuspeichernde Variable lautet: ''Hier  ist ein Text...'' ');
      Gotoxy (6, 17);
      Writeln (' Die neue Lage des HeapPointers ist jetzt:  ');
      Gotoxy (6, 18);
      Writeln ('  Segment : Offset  =  ', StrNeu(Seg(HeapPtr), 4):4, ' : ', StrNeu(Ofs(HeapPtr), 4):4 );
      {
      Textcolor (10);
      Writeln (' Es wird jetzt die Adresse dieser Variablen gesucht.                  ');
      Gotoxy (6, 21);
      Ad := Addr(P);
      Writeln (' Adresse:     Segment: ', StrNeu(Seg(FreePtr), 4):4, ' Offset: ', StrNeu(Ofs(FreePtr), 4):4, '       ');
      Dispose (P);
      }
      Tastendruck
   End;


Procedure Forts1;
   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      TextBackGround (0);
      Gotoxy (6, 2);
      Writeln ('          Ergnzung zu 27: H E A P M A N I P U L A T I O N            ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('           Befehle: GETMEM, MARK, RELEASE, DISPOSE, FREEMEM           ');
      Textcolor (10);
      Gotoxy (6, 5);
      Writeln (' Der Heap-Bereich wird wie eine Art Stack behandelt; allerdings wchst');
      Gotoxy (6, 6);
      Writeln (' er in Richtung aufsteigender Adressen. Seine Startadresse ist in der ');
      Gotoxy (6, 7);
      Writeln (' globalen Variablen HEAPORG gespeichert; seine momentane Spitze wird  ');
      Gotoxy (6, 8);
      Writeln (' in der Variablen HEAPPTR abgelegt. Dir dynamische Verwaltung des     ');
      Gotoxy (6, 9);
      Writeln (' Speicherplatzes besteht aus drei Schritten:                          ');
      Gotoxy (6, 11);
      Writeln ('     ** Prfung ob noch Speicherplatz vorhanden ist                   ');
      Gotoxy (6, 12);
      Writeln ('     ** Erhhung von HEAPPTR um die Gre der neuen Variablen         ');
      Gotoxy (6, 13);
      Writeln ('     ** Alter Wert von HEAPPTR zeigt auf die neue Variable            ');
      Gotoxy (6, 15);
      Writeln (' HEAPPTR wird nach jeder Vernderung automatisch normalisiert d.h.    ');
      Gotoxy (6, 16);
      Writeln (' der Offset ist im Bereich von $0000 bis $000F.                       ');
      Gotoxy (6, 18);
      Writeln (' Mit  NEW  wird Speicherplatz angefordert und je nach Methode mittels ');
      Gotoxy (6, 19);
      Writeln (' DISPOSE / FREEMEM oder aber  MARK / RELEASE / DISPOSE wieder frei-   ');
      Gotoxy (6, 20);
      Writeln (' gegeben.                                                             ');
      Gotoxy (6, 21);
      Writeln (' Allfllige Lcher im HEAP werden in der Fragmentliste festgehalten.  ');

      Tastendruck
   End;


Procedure Forts2;

   TYPE
      Eintrag = Record
         Name:  String[30];
         Alter: Byte;
      End;

   VAR
      P:   Pointer;
      Ch:  Char;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('       Ergnzung zu 27:  Verwaltung des Speicherplatzes auf dem HEAP    ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                    Befehl: MEMAVAIL, MAXAVAIL                          ');

      If MaxAvail < SizeOf(Eintrag) Then
      Begin
         Gotoxy (6, 6);
         Textcolor (12);
         Writeln ('Nicht genug Speicherplatz ')
      End
      Else
      Begin
         GetMem (P, SizeOf(Eintrag));
         { ... }
      End;
      Gotoxy (6, 6);
      TextColor (11);
      Writeln ('     SYNTAX:      MEMAVAIL      Ergebnistyp: LongInt                    ');
      Gotoxy (6, 7);
      Textcolor (10);
      Writeln (' Der gesamte freie Speicherplatz auf dem HEAP inklusive aller Fragmente ');
      Gotoxy (6, 8);
      Writeln (' wird geliefert.                                                        ');
      Gotoxy (6, 11);
      Textcolor (14);
      Write (' Ergebnis: Insgesamt ');
      Textcolor (12);
      Write (MemAvail:8);
      Textcolor (14);
      Writeln ('  Bytes sind verfgbar.');
      Gotoxy (6, 14);
      TextColor (11);
      Writeln ('     SYNTAX:      MAXAVAIL      Ergebnistyp: LongInt                    ');
      Gotoxy (6, 15);
      Textcolor (10);
      Writeln (' Der grte freie Block auf dem HEAP wird angegeben.                    ');
      Gotoxy (6, 18);
      Textcolor (14);
      Write (' Ergebnis: Der grte Block umfat ');
      Textcolor (12);
      Write (MaxAvail:8);
      Textcolor (14);
      Writeln ('  Bytes .');

      Tastendruck
   End;


{  28.
 Ŀ
  Die Prozedur DELAY wartet die angegebene Zahl von Millisekunden.     
      SYNTAX:       DELAY (MS: Word)                                   
  Es arbeitet weitgehend unabhngig vom Computermodell, indem die      
  Uhrzeit auf dem C-MOS-Chip am Anfang und am Ende ausgewertet wird.   
  Ein kleiner Fehler (bei 60 Sekunden + - 1 Sekunde) tritt auf.        
 }

Procedure DelayDemo;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      TextBackGround (0);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 28:   Z E I T V E R Z  G E R U N G E N          ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                         Befehl:   DELAY                              ');
      Gotoxy (6, 9);
      Textcolor (11);
      Writeln (' SYNTAX:          DELAY (MS:  Word)                                   ');
      Gotoxy (6, 12);
      Textcolor (10);
      Writeln (' Der Befehl DELAY wartet die angegebene Anzahl von Millisekunden ab.  ');
      Gotoxy (6, 15);
      Textcolor (13);
      Writeln (' Der Fehler ist unabhngig vom Computermodell sehr gering (1 bis 2 %).');
      Tastendruck
   End;


{  29.
 Ŀ
  Im Unit DOS ist eine Datentype REGISTERS folgendermaen definiert:   
     REGISTERS = Record                                                
         Case Integer of                                               
           0: (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags: Word);       
           1: (Al, AH, BL, BH, CL, CH, DL, DH:            Byte);       
         End;                                                          
  Die Prozedur MSDOS bentzt den DOS-Interrupt 21. Der Aufruf hat      
  dieselbe Wirkung wie ein Aufruf der Prozedur INTR mit IntNo = $21.   
 }

Procedure INTERRUPTDEMO;

   Var
      Regs : Registers;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 29:   I N T E R R U P T D E K L A R A T I O N       ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                      Befehle:  INTR, MSDOS                           ');

      Gotoxy (6, 6);
      Delay (1000);
      TextColor (13);
      Writeln ('O <<< Hier stand der Cursor ! ');
      Gotoxy (6, 6);
      Delay (1500);

      Gotoxy (6, 12);
      Textcolor (12);
      Writeln (' Der Aufruf fr die Cursor-Positionierung lautet:                     ');
      Gotoxy (6, 14);
      TextColor (11);
      Writeln ('      Regs.AH := 2;           d.h. Cursor-Pos. Setzen      ');
      Gotoxy (6, 15);
      Writeln ('      Regs.BH := 0;                auf Bildschirmseite 0   ');
      Gotoxy (6, 16);
      Writeln ('      Regs.DL := 10;               in Spalte 10            ');
      Gotoxy (6, 17);
      Writeln ('      Regs.DH := 8;                in Zeile 8              ');
      Gotoxy (6, 19);
      Writeln ('      INTR ($10, Regs);            Aufruf von Int. 10h     ');
      Gotoxy (6, 21);
      TextColor (14);
      Write (' Der DOS-Interrupt 21h kann auch mittels  ');
      Textcolor (11);
      Write (' '' MSDOS (Regs) '' ');
      Textcolor (14);
      Writeln (' aufgerufen ');
      Gotoxy (6, 22);
      Writeln (' werden.  ');

      Regs.AH := 2;    { BIOS: Cursor-Position setzen }
      Regs.BH := 0;    { Bildschirmseite }
      Regs.DL := 10;   { Spalte }
      Regs.DH := 8;    { Zeile }
      INTR ($10, Regs);

      Write ('O <<< Hier steht er jetzt ! (Spalte 10, Zeile 8) ');
      Regs.AH := 2;    { BIOS: Cursor-Position setzen }
      Regs.BH := 0;    { Bildschirmseite }
      Regs.DL := 10;   { Spalte }
      Regs.DH := 8;    { Zeile }
      INTR ($10, Regs);
      Delay (3000);

      Tastendruck
   End;


{ 30.
 Ŀ
  KEEP beendet ein Programm und macht es speicherresident.             
  SYNTAX:              KEEP (EXitCode: Word)                           
  Der ExitCode wird an DOS zurckgeliefert und sorgt dafr, da das    
  gesamte Programm im Speicher bleibt. Auch der Daten-, Stack- und     
  Heapbereich bleiben im Speicher. Daher mu vorher eine Obergrenze    
  des Heap festgelegt werden !                                         
 }

  Procedure KEEP;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('            Anwendung 30:  T  S  R  -  R O U T I N E N                ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                       Befehl:    KEEP                                ');
      Gotoxy (6, 6);
      TextColor (11);
      Writeln ('     SYNTAX:      KEEP (ExitCode: Word)                               ');
      Gotoxy (6, 8);
      Textcolor (10);
      Writeln (' Das gesamte Programm wird im Speicher resident gemacht.              ');
      Gotoxy (6, 12);
      Textcolor (13);
      Writeln (' ACHTUNG! Bei der Compilierung mu jedenfalls eine Obergrenze des     ');
      Gotoxy (6, 13);
      Writeln (' HEAP festgelegt werden, sonst betrachtet DOS den Hauptspeicher als   ');
      Gotoxy (6, 14);
      Writeln (' komplett belegt.                                                     ');
      Textcolor (14);
      Gotoxy (6, 17);
      Writeln (' Der EXIT-CODE wird als Word-Ausdruck an DOS zurckgeliefert.         ');

      Tastendruck
   End;


{ 31.
 Ŀ
  KEYPRESSED  als Booleche Variable prft, ob eine Taste mit einem     
  lesbaren Zeichen gedrckt wurde. Es wird nur geprft, die Zeichen    
  werden nicht abgeholt.                                               
  Das Lesen knnte zB. mit Readkey erfolgen.                           
 }

  Procedure KeyPressedDemo;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('          Anwendung 31:   Abfrage nach einem Tastendruck              ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                      Befehl: KEYPRESSED                              ');
      Gotoxy (6, 6);
      TextColor (11);
      Writeln ('     SYNTAX:      KEYPRESSED                                          ');
      Gotoxy (6, 10);
      Textcolor (10);
      Writeln (' Es wird geprft, ob der Tastaturpuffer noch nicht abgefragte Zeichen ');
      Gotoxy (6, 11);
      Writeln (' enthlt. Es werden nur lesbare Zeichen geprft, aber nicht abgeholt. ');
      Gotoxy (6, 14);
      Textcolor (14);
      Writeln (' Beispiel:    REPEAT  UNTIL  KEYPRESSED                               ');
      Gotoxy (6, 18);
      Textcolor (13);
      Writeln (' Voraussetzung: Unit CRT                                              ');

      Tastendruck
   End;


{  32.
 Ŀ
  Die Funkiton UPCASE verwandelt Klein- in Grobuchstaben.             
  Alle Zeichen auerhalb des Buchstabenbereiches bleiben unverndert.  
  Die deutschen Umlaute werden nicht bercksichtigt.                   
  LENGTH stellt die Lnge eines Strings fest.                          
 }

 Procedure LengthDemo;

   Var
      S:  String;
      I:  Integer;
      Ch: Char;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('           Anwendung 32:    G R O S S B U C H S T A B E N             ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl: UPCASE                              ');
      Gotoxy (6, 6);
      TextColor (11);
      Writeln ('     SYNTAX:      UPCASE (Ch: CHAR)                                   ');
      Gotoxy (6, 9);
      Textcolor (10);
      Writeln (' CH ist ein Ausdruck des Typs CHAR. Wenn CH einen Kleinbuchstaben     ');
      Gotoxy (6, 10);
      Writeln (' im Bereich von ''a'' bis ''z'' darstellt, liefert Upcase den ent-        ');
      Gotoxy (6, 11);
      Writeln (' sprechenden Grobuchstaben zurck.                                   ');
      Gotoxy (6, 14);
      Textcolor (13);
      Writeln (' BEISPIEL: ');
      Gotoxy (16, 16);
      Textcolor (15);
      S := 'abc';
      Writeln ('    Alter String: ', S, '  ');
      For I := 1 To Length(S) Do
         S[I] := Upcase(S[I]);
      Gotoxy (16, 18);
      Textcolor (14);
      Writeln ('    Neuer String: ', S, '  ');

      Tastendruck
   End;


{  33.
 Ŀ
  Die Prozedur MOVE kopiert Bytes von einem Speicherbereich in einen   
  anderen.                                                             
      SYNTAX:       MOVE  (VAR Source, Dest;  Count:Word)              
  Source und Dest sind Vraiablenbezge beliebigen Typs und werden von  
  MOVE als Startadressendes Quellbereiches resp. Zielbereiches inter-  
  pretiert. COUNT ist vom Typ WORD und gibt an, wieviele Bytes bewegt  
  werden sollen.                                                       
  ACHTUNG!  MOVE macht keine Bereichsprfung, daher sorgfltig mit     
            SIZEOF vorgehen.                                           
 }

  Procedure MOVEDEMO;

  VAR
     A:  Array[1..4] Of Byte;
     B:  LongInt;
     X:  Integer;

  Begin
     TextBackGround (1);
     ClrScr;
     Rahmen;
     TextAttr := White;
     TextColor (15);
     Gotoxy (6, 2);
     Writeln ('        Anwendung 33: S P E I C H E R V E R S C H I E B U N G         ');
     TextColor( 14);
     Gotoxy (6, 3);
     Writeln ('                       Befehl:  MOVE                                  ');

     B := $23847699;
     Move (B, A, SizeOf(B));
     Gotoxy (6, 6);
     Textcolor (10);
     Writeln ('Die einzelnen Bytes der Variablen $23847699 haben folgende Werte: ');
     For X := 4 DownTo 1 Do
     Begin
        Gotoxy (6, 14-X);
        Textcolor (13);
        Write (' ',5-X, '-tes Byte: ', A[X]:4, ' ');
        If ODD(A[X]) Then
        Begin
           Textcolor (14);
           Gotoxy (26, 14-X);
           Writeln ('    Ungerade Zahl ! ')
        End
        Else
        Begin
           Textcolor (10);
           Gotoxy (26, 14-X);
           Writeln ('      Gerade Zahl ! ')
        End
     End;

     Tastendruck
  End;


{  34.
 Ŀ
  Die Prozedur SOUND aktiviert den eingabauten Lautsprecher.           
      SYNTAX:      SOUND  (Hz: Word)                                   
  Hz gibt die Frequenz des Tones in der Einheit HERTZ an.              
  Erst der Aufruf NOSOUND schaltet den Ton wieder ab.                  
 }

   Procedure SOUNDDEMO;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('             Anwendung 34:   K L A N G E R Z E U G U N G              ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                      Befehle: SOUND, NOSOUND                         ');

      Gotoxy (6, 6);
      TextColor (11);
      Writeln ('     SYNTAX:      SOUND  (Hz: Word)                                   ');
      Gotoxy (6, 8);
      TextColor (11);
      Writeln ('     SYNTAX:      NOSOUND                                             ');
      Gotoxy (6, 11);
      Textcolor (10);
      Writeln (' Die Frequenz des Tones wird in HERTZ angegeben. Erst der Aufruf von  ');
      Gotoxy (6, 12);
      Writeln (' NOSOUND   lt den Ton verklingen. Die Tondauer mu mittels   DELAY  ');
      Gotoxy (6, 13);
      Writeln (' vorgegeben werden.                                                   ');

      Sound (302);
      Delay (900);
      Sound (390);
      Delay (900);
      Sound (460);
      Delay (900);
      Nosound;
      Delay (200);
      Sound (460);
      Delay (1800);
      Sound (920);
      Delay (900);
      Nosound;
      Delay (200);
      Sound (920);
      Delay (1800);
      Sound (790);
      Delay (900);
      Nosound;
      Delay (200);
      Sound (790);
      Delay (1800);

      Nosound;
      Tastendruck
   End;


{  35.
 Ŀ
  Die Prozedur FLUSH erzwingt das Schreiben des Dateipufferinhaltes    
  einer Textdatei.                                                     
      SYNTAX:       FLUSH  (VAR F: Text)                               
  Normalerweise wird der Puffer mittels CLOSE geleert. Aber auch       
  auf diese Weise kann eine PufferLeerung erzwungen werden.            
  Eine berprfung ist mittels IORESULT im Modus $I- mglich.          
  Die Datei mu vorher geffnet worden sein.                           
 }

   Procedure FLUSHDEMO;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 35:   D A T E I P U F F E R    E N T L E E R E N    ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl:    FLUSH                            ');
      Gotoxy (6, 7);
      TextColor (11);
      Writeln ('     SYNTAX:      FLUSH (VAR F: Text)                                 ');
      Gotoxy (6, 11);
      Textcolor (10);
      Writeln (' CLOSE ruft diese Prozedur auf. Es wird der Inhalt eines Dateipuffers ');
      Gotoxy (6, 12);
      Writeln (' ber eine physikalische Schreibaktion auf das Speichermedium ge-     ');
      Gotoxy (6, 13);
      Writeln (' schrieben. Bei Dateien, welche  mit RESET geffnet wurden, hat FLUSH ');
      Gotoxy (6, 14);
      Writeln (' keine Wirkung.                                                       ');

      Tastendruck
   End;


{  36.
 Ŀ
  Die Funktion  ORD  liefert die Ordinalzahl des Argumentes zurck.    
      SYNTAX:       ORD (X)                                            
  Ergesbnistyp:  LONGINT                                               
 }

   Procedure ORDDEMO;

   VAR
      Essen: (Kohl, Birne);
      Ch :   Char;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('             Anwendung 36:   O R D I N A L Z A H L E N                ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl: ORD                                 ');

      Gotoxy (6, 6);
      Textcolor (13);
      Writeln (' BEISPIEL:  ');
      Gotoxy (6, 8);
      TextColor (10);
      Writeln (' Es wird eine Variable ESSEN mit den Elementen KOHL und Birne defi-   ');
      Gotoxy (6, 9);
      Write (' finiert: ');
      Textcolor (11);
      Writeln ('      VAR   Essen: (Kohl, Birne)                            ');
      Gotoxy (6, 11);
      Textcolor (14);
      Writeln (' Befehl:    Writeln ( ORD (Kohl) )                                    ');
      Textcolor (10);
      Gotoxy (6, 12);
      Write (' Ergebnis:  Die Ordinalzahl von <Kohl> ist:           ');
      Textcolor (12);
      Writeln (Ord(Kohl):3, ' ');
      Gotoxy (6, 14);
      Textcolor (10);
      Write ('            Die Ordinalzahl von <Birne> ist:          ');
      Textcolor (12);
      Writeln (Ord(Birne):3, ' ');
      Gotoxy (6, 16);
      Textcolor (14);
      Writeln (' Befehl:    Writeln ( ORD (''A'') )                                     ');
      Textcolor (10);
      Gotoxy (6, 17);
      Write (' Ergebnis:  Die Ordinalzahl des Buchstabens <A> ist:  ');
      Textcolor (12);
      Writeln (Ord('A'):3, ' ');

      Tastendruck
   End;


{  37.
 Ŀ
  Die Prozed         wartet die angegebene Zahl von Millisekunden.     
      SYNTAX:             (MS: Word)                                   
  Es arbeitet weitgehend unabhngig vom Computermodell, indem die      
  Uhrzeit auf dem C-MOS-Chip am Anfang und am Ende ausgewertet wird.   
  Ein kleiner Fehler (bei 60 Sekunden +- 1 Sekunde) tritt auf.         
 }

Procedure SeekDemo;

{ Die Prozedur SEEK setzt den Positionszeiger in einer Datei auf eine
  bestimmte Komponente.
  Deklaration:   SEEK (Var F; n: LongInt)
  n ist die Nummer der Komponente, auf die der Positionszeiger gesetzt
              werden soll. Die Zhlung beginnt mit 0.
  Fr Dateivergrerungen mu SEEK (f, FileSize(F)) aufgerufen werden.
  Kontrolle mittels IOResult.

  Die Prozedur SEEKEOF prft, ob zwischen der momentanen Position und
  dem Ende der Datei noch lesbare Daten sich befinden.
  Deklaration:   SEEKEOF (Var f: Text)
  EOF liefert dann TRUE,  wenn das Dateiende schon vor dem Aufruf
  der Funktion erreicht wurde.
  SEEKEOF liest solange Zeichen, bis entweder ein lesbares Zeichen
  oder das Dateiende erreicht ist. Erst dann wird die Prfung durchgefhrt.
  Dies ist sinnvoll beim Lesen von numerischen Daten.

  SEEKEOLN prft, ob sich zwichen der momentanen Position und dem nchsten
  Zeilenende einer Datei noch lesbare Daten befinden.
  Deklaration: SEEKEOLN (VAr F:Text);
  Text und Empfehlung wie vorher.
}

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 37:   D A T E I V E R A R B E I T U N G             ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl:  SEEK                               ');
      Tastendruck
   End;


{  38.
 Ŀ
  Die Funktion POINTER konvertiert zwei Angaben fr Segment und Offset 
  in einen Wert des Typs POINTER.                                      
      SYNTAX:         PTR (Seg, Ofs: Word);                            
  Das Funktionsergebnis ist ein Zeiger, der auf die angegebene Adresse 
  zeigt. Das Eregbnis vom Typ POINTER kann zusammen mit dem Operator ^ 
  fr den direkten Zugriff auf Speicherzellen verwendet werden.        
 }

  Procedure PTRDEMO;

  VAR
     P: ^Byte;

  Begin
     TextBackGround (1);
     ClrScr;
     Rahmen;
     TextAttr := White;
     TextColor (15);
     Gotoxy (6, 2);
     Writeln ('          Anwendung 38:   ERSTELLUNG EINER ZEIGERVARIABLEN            ');
     TextColor( 14);
     Gotoxy (6, 3);
     Writeln ('                           Befehl:   PTR                              ');

     Gotoxy (6, 6);
     Textcolor (10);
     Writeln (' Die Funktion PTR konvertiert zwei Angaben fr SEGMENT und OFFSET in  ');
     Gotoxy (6, 7);
     Writeln (' einen Wert des Typs POINTER. Das Ergebnis ist ein Zeiger, der auf    ');
     Gotoxy (6, 8);
     Writeln (' die angegebene Adresse zeigt.                                        ');
     Gotoxy (6, 12);
     Textcolor (14);
     Writeln (' Es gibt zwei mgliche Anwednungen:                                   ');
     Gotoxy (6, 13);
     Textcolor (11);
     Writeln ('   1. zusammen mit dem Operator ^; Bsp: Writeln (Byte (Ptr($40, $49)^)');
     Gotoxy (6, 14);
     Writeln ('   2. implizite Konvertierung;      Bsp:  P := Ptr ($40, $49);        ');
     Gotoxy (6, 15);
     Writeln ('                                          Writeln ( ...,  P^);        ');

     P := Ptr ($40, $49);  { implizite Konvertierung }

     Gotoxy (6, 18);
     Textcolor (14);
     Write (' Momentaner Videomodus:  ');
     Textcolor (12);
     Writeln (P^:2, ' ');

     Tastendruck
  End;


{ 39.
 Ŀ
  Die Prozedur       wartet die angegebene Zahl von Millisekunden.     
      SYNTAX:             (MS: Word)                                   
  Es arbeitet weitgehend unabhngig vom Computermodell, indem die      
  Uhrzeit auf dem C-MOS-Chip am Anfang und am Ende ausgewertet wird.   
  Ein kleiner Fehler (bei 60 Sekunden +- 1 Sekunde) tritt auf.         
 }
{ READ liest eine oder mehrere Komponenten aus einer typisierten Datei bzw.
  einen oder mehrere Werte aus einer Textdatei in die angegebenen Variablen.
  READLN fhrt einen Aufruf von READ aus und springt dann zum Anfang der
  nchsten Zeile innerhalb der angegebenen Datei; nur fr Textdateien !

  Beispiel:
  123 <Tab> 4 <Tab> 9999 <Zeilenende>
  Readln (f,x1)  .... liest den 1. Wert, berspringt den Rest
  Readln (f,x1,x2)... liest 2 Werte, berspringt den dritten
  Readln (f,x1,x2,x3) liest alle drei Werte
  Readln (StrVar1, StrVar2) ... ganze Zeile als StrVar1 gelesen, StrVar2 = ''



  READ fr typisierte Dateien:
      READ (VAR f,v1[,v2,...,vn])
      F steht fr eine Dateivariable beliebigen Typs (auer Text !); jede
      der angegebenen Variablen hat denselben Typ wie die Komponenten der
      Datei. Der Positionszeiger innerhalb der Datei wird durch jede Lese-
      aktion un eine Komponente in Richtung Dateiende bewegt. Kontrolle
      mittels IOResult.
  READ fr Textdateien:
      READ ([VAR F:Text;[,v2,...,vn]);        READLN( ... );
      Ohne Angabe von F liest READ von der Standardeingabe (Input).
      Es wird bis zum nchsten Zeilenende gelesen.
      Als Typen sind Char, String sowie Int. und Real zulssig.

  CHAR:
      Eine Datei wird Zeichen fr Zeic7hen gelesen; AmDateiende erscheint
      Chr(26)=Ctrl-Z, am Zeilenende Chr(13)=Zeilenvorschub.
  INTEGER:
      Fhrende Leerzeichen, Tabs und Zeilenvorschbe werden bersprungen,
      das erste nicht-num. Zeichen bricht den Lesevorgang ab.
      Am Dateiende wird der Gel. Variablen der Wert 0 zugewiesen.
  REAL:
      Gltige Zeichen sind der Dezimalpunkt und das <E>, nicht aber HEX-
      Ziffern. Sonst wie vorher.
  STRING:
      Der StringVariablen werden Zeichen von der momentanen Position bis
      zum EOLN(f) zugeordnet. Bei mehr als 255 Zeichen gehen die letzen
      verloren.
      Aufeinandefolgende Textzeilen mssen mit READLN gelesen werden. }

  Procedure READDEMO;

  TYPE
     Datensatz = RECORD
         Name  : String[20];
         Alter : Byte;
                 End;
  VAR
     FTyp      : FILE of Datensatz;
     ByteDatei : FILE of Byte;
     EinSatz   : Datensatz;
     B         : Byte;
     X, Y      : Integer;
     Z         : Real;
     S         : String;

  Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 39:   D A T E I L E S E O P E R A T I O N           ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                        Befehle: READ, READLN                         ');
     { ...
     While NOT EOF(FTyp) Do
     Begin
        Read (FTyp, EinSatz);
        Writeln ('Name: ', Einsatz.Name, 'Alter: ', Einsatz.Alter);
     End;
      ...
     While NOT EOF(ByteDatei) Do
     Begin
        Read (ByteDatei, B);
        Write (Chr(B));
     End;
     Readln (Input, S);
     Writeln (S);
     Read (X);
     Read (Y);
     Read (Z);
     Writeln (X:5, Y:5, Z:8);
     }
     Tastendruck
  End;



{  40.
 Ŀ
  Die Prozedur       wartet die angegebene Zahl von Millisekunden.     
      SYNTAX:             (MS: Word)                                   
  Es arbeitet weitgehend unabhngig vom Computermodell, indem die      
  Uhrzeit auf dem C-MOS-Chip am Anfang und am Ende ausgewertet wird.   
  Ein kleiner Fehler (bei 60 Sekunden +- 1 Sekunde) tritt auf.         
 }
{ READ liest eine oder mehrere Komponenten aus einer typisierten Datei bzw.
  einen oder mehrere Werte aus einer Textdatei in die angegebenen Variablen.
  READLN fhrt einen Aufruf von READ aus und springt dann zum Anfang der
  nchsten Zeile innerhalb der angegebenen Datei; nur fr Textdateien !

  Beispiel:
  123 <Tab> 4 <Tab> 9999 <Zeilenende>
  Readln (f,x1)  .... liest den 1. Wert, berspringt den Rest
  Readln (f,x1,x2)... liest 2 Werte, berspringt den dritten
  Readln (f,x1,x2,x3) liest alle drei Werte
  Readln (StrVar1, StrVar2) ... ganze Zeile als StrVar1 gelesen, StrVar2 = ''



  READ fr typisierte Dateien:
      READ (VAR f,v1[,v2,...,vn])
      F steht fr eine Dateivariable beliebigen Typs (auer Text !); jede
      der angegebenen Variablen hat denselben Typ wie die Komponenten der
      Datei. Der Positionszeiger innerhalb der Datei wird durch jede Lese-
      aktion un eine Komponente in Richtung Dateiende bewegt. Kontrolle
      mittels IOResult.
  READ fr Textdateien:
      READ ([VAR F:Text;[,v2,...,vn]);        READLN( ... );
      Ohne Angabe von F liest READ von der Standardeingabe (Input).
      Es wird bis zum nchsten Zeilenende gelesen.
      Als Typen sind Char, String sowie Int. und Real zulssig.

  CHAR:
      Eine Datei wird Zeichen fr Zeic7hen gelesen; AmDateiende erscheint
      Chr(26)=Ctrl-Z, am Zeilenende Chr(13)=Zeilenvorschub.
  INTEGER:
      Fhrende Leerzeichen, Tabs und Zeilenvorschbe werden bersprungen,
      das erste nicht-num. Zeichen bricht den Lesevorgang ab.
      Am Dateiende wird der Gel. Variablen der Wert 0 zugewiesen.
  REAL:
      Gltige Zeichen sind der Dezimalpunkt und das <E>, nicht aber HEX-
      Ziffern. Sonst wie vorher.
  STRING:
      Der StringVariablen werden Zeichen von der momentanen Position bis
      zum EOLN(f) zugeordnet. Bei mehr als 255 Zeichen gehen die letzen
      verloren.
      Aufeinandefolgende Textzeilen mssen mit READLN gelesen werden. }

  Procedure WRITEDEMO;

  TYPE
     Datensatz = RECORD
         Name  : String[20];
         Alter : Byte;
                 End;
  VAR
     FTyp      : FILE of Datensatz;
     ByteDatei : FILE of Byte;
     EinSatz   : Datensatz;
     B         : Byte;
     X, Y      : Integer;
     Z         : Real;
     S         : String;

  Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 40:  D A T E I S C H R E I B O P E R A T I O N      ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                        Befehle: WRITE, WRITELN                       ');
     { ...
     While NOT EOF(FTyp) Do
     Begin
        Read (FTyp, EinSatz);
        Writeln ('Name: ', Einsatz.Name, 'Alter: ', Einsatz.Alter);
     End;
      ...
     While NOT EOF(ByteDatei) Do
     Begin
        Read (ByteDatei, B);
        Write (Chr(B));
     End;
     Readln (Input, S);
     Writeln (S);
     Read (X);
     Read (Y);
     Read (Z);
     Writeln (X:5, Y:5, Z:8);
     }
     Tastendruck
  End;


{ 41.
 Ŀ
  Die Prozedur       wartet die angegebene Zahl von Millisekunden.     
      SYNTAX:             (MS: Word)                                   
  Es arbeitet weitgehend unabhngig vom Computermodell, indem die      
  Uhrzeit auf dem C-MOS-Chip am Anfang und am Ende ausgewertet wird.   
  Ein kleiner Fehler (bei 60 Sekunden +- 1 Sekunde) tritt auf.         
 }

{ Diese Funktion beobachtet ob KeyPressed den Werte TRUE hat. Da Spezial-
  tasten als erstes Zeichen 0 leifern, mu nach einem zweiten Zeichen
  gefragt werden }

   Procedure READKEYDEMO;

   Var
      Ch:  Char;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 41:   Z E I C H E N     E I N L E S E N             ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                         Befehl:  READKEY                             ');
      CH := Readkey;
      If Ch = #0 Then
      Begin
         Write ('Funktionstaste mit ScanCode: ');
         Writeln (Ord(ReadKey));   { Zweiter ReadKey-Aufruf }
      End
      Else
         Writeln ('Normale Taste gedrckt: ', Ch);
      Tastendruck
   End;


{ 42.
 Ŀ
  Die Prozedur RENAME gibt einer externen Diskettendatei einen neuen   
  Namen.                                                               
      SYNTAX:     RENAME  (VAR F; Newname: String)                     
  Die Datei darf whrend des Aufrufes nicht offen sein.                
  Es kann die Datei auch zwischen verschiedenen Directories bewegt     
  werden.                                                              
  Eine Fehlerbestimmung kann mittels IOResult erfolgen.                
 }

  Procedure RenameDemo;

   Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 42:   D A T E I E N    U M B E N E N N E N          ');
      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl:  RENAME                             ');

      Gotoxy (6, 7);
      Textcolor (13);
      Writeln (' Beispiel dazu: ');
      Gotoxy (6, 9);
      Textcolor (14);
      Writeln ('   Assign (f, ''\TP\Grafik\RENTEST.PAS'')                               ');
      Gotoxy (6, 10);
      Writeln ('   Rename (f, ''\TP\RENAME.PAS'')                                       ');
      Gotoxy (6, 13);
      Textcolor (10);
      Writeln (' Hier erfolgt eine Dateiversetzung und die Neuzuweisung eines Namens. ');
      Gotoxy (6, 14);
      Writeln (' Es wird lediglich ein Dateieintrag verndert, kein Dateiinhalt !     ');

      Tastendruck
   End;


{ 43.
 Ŀ
  Die Prozedur RUNERROR erzeugt einen Laufzeitfehler, der das Programm 
  definiert abbricht.                                                  
      SYNTAX:      RUNERROR [( ErrorCode: Word)]                       
  RUNERROR entspricht in seiner Wirkungsweise der Standardprozedur HALT
  abgesehen davon, da diese <routine zustzlich die Ausgabe einer     
  Laufzeitfehlermeldung veranlat.                                     
  Der Ausdurck ERRORCODE (Integer) ist optional und legt die auszuge-  
  bende Fehlermeldung fest (ev. 0).                                    
  Diese Routine ist vor allem fr das Austesten von Exit-Prozeduren ge-
  dacht, um einen ordentlichen Abschlu zu gewhrleisten.              
  Wenn das Modul, welches den Aufruf von RunError enthlt, mit DEBUG   
  INFOREMATION .. ON compiliert wurde, reagiert die integrierte Ent-   
  wicklungsumgebung als ob ein Laufzeitfehler stattgefunden htte mit  
  Fehlermeldung.                                                       
 }

Procedure RunErrorDemo;

  (*
         {$IFDEF Debug }    Symbol, welches fr den Test des Programmes
                                     definiert wurde
         If P = NIL Then RunError (204);
         {ENDIF}  *)

     Begin
      TextBackGround (1);
      ClrScr;
      Rahmen;
      TextAttr := White;
      TextColor (15);
      Gotoxy (6, 2);
      Writeln ('        Anwendung 43:   D A T E I F E H L E R B E H A N D L U N G     ');

      TextColor( 14);
      Gotoxy (6, 3);
      Writeln ('                          Befehl:  RUNERROR                           ');
      Gotoxy (6, 6);
      Textcolor (10);
      Writeln (' Die Prozedur RUNERROR erzeugt einen Laufzeitfehler, der das Programm ');
      Gotoxy (6, 7);
      Writeln (' definiert abbricht.                                                  ');
      Gotoxy (6, 10);
      Textcolor (13);
      Writeln (' Programmbeispiel :  ');
      Gotoxy (6, 13);
      Textcolor (14);
      Writeln (' ......                              ');
      Gotoxy (6, 14);
      Writeln (' {IFDEF DEBUG}                       ');
      Gotoxy (6, 15);
      Writeln (' If P = NIL Then RunError (204);     ');
      Gotoxy (6, 16);
      Writeln (' {$ENDIF}                            ');

      Tastendruck
     End;


{ Hauptprogramm }
Begin
   Clrscr;
   { 27.: Zeile   81 }  HeapBehandlung;
              {  225 }  Forts1;
              {  272 }  Forts2;
   { 28.         338 }  DelayDemo;
   { 29.         374 }  InterruptDemo;
   { 30.         448 }  Keep;
   { 31.         492 }  KeyPressedDemo;
   { 32.         532 }  LengthDemo;
   { 33.         585 }  MoveDemo;
   { 34.         645 }  SoundDemo;
   { 35.         709 }  FlushDemo;
   { 36.         756 }  OrdDemo;
   { 37.         817 }  SeekDemo;  { inkl. FilePos }
   { 38.             }  PtrDemo;
   { 39.             }  ReadDemo;
   { 40.             }  WriteDemo;
   { 41.             }  ReadKeyDemo;
   { 42.             }  RenameDemo;
   { 43.             }  RunErrorDemo;
End.