# CKOKER.MAK, Version 3.02
# See CKOMAK.HLP for further information.
# Last update: Mon Jul  5 14:20:40 1993
#
# -- Makefile to build C-Kermit 5A(189) for OS/2 --
#
# The result is a runnable program called CKOKER.EXE in the current directory.
#
# The 32-bit versions run only on OS/2 2.00 or higher.

#---------- Compiler targets:
#
# To build: "[dn]make -f ckoker.mak <target>"

unknown:
	@echo Please specify target: "msc ibmc gcc"

# Microsoft C 6.00 (16-bit):
#
# When (if) the LINK step doesn't work: (a) make sure the MSC directories are
# ahead of the OS/2 directories in your PATH; (b) if LINK complains about not
# finding LLIBCEP.LIB (because NMAKE inserted "/NOD:LLIBCE.LIB LLIBCEP.LIB"
# into the LINK options), just tell it to use LLIBCE.LIB.
# 
# LINK might also ask you about TCPIPDLL.LIB.  If you don't have one,
# just hit Enter.
#
# Warning: If the compiler complains about "Unrecoverable heap overflow", add
# the -B3C3L option after -W2, within the quotes.  This requires C3L.EXE on
# disk.  (This problem has been observed with MSC 6.00A, but not 6.00.)
#
#    IMPORTANT: When building with TCP/IP support, edit the IBM-supplied
#    TCPIP\INCLUDE\NETLIB.H to remove the spurious #define for SIGALRM!

# release version
msc:
	$(MAKE) -f ckoker.mak all \
	CC="cl -nologo -W2 -Od -FPc -AL" OUT="-o" O=".obj" \
	OPT="-Ot -B3C3L" DEBUG="-Gs" DLL="-Alfw -Gs -Zl" \
	CFLAGS="-Au -J -Zap -G2 -Gt8 -UMSDOS" \
	LDFLAGS="-F 9A00 -Lp -link /noe /packc /packd /exep" \
	DEF="ckoker.def"

# debugging version
mscd:
	$(MAKE) -f ckoker.mak all \
	CC="cl -nologo -W2 -Od -FPc -AL" OUT="-o" O=".obj" \
	OPT="" DEBUG="-Zi" DLL="-Alfw -Gs -Zl" \
	CFLAGS="-Au -J -Zap -G2 -Gt8 -UMSDOS" \
	LDFLAGS="-F 9A00 -Lp -link /noe /packc /packd /exep" \
	DEF="ckoker.def"

# IBM C Set/2 (32-bit) with static linking -- no DLL's required.
# Which is good, because otherwise users would need to have the IBM
# OS/2 development system C libraries on their PCs.
#
# Except the TCP/IP support is linked dynamically.  A dummy TCP/IP DLL is
# produced for those who do not have TCP/IP installed.  TCP/IP is not linked
# statically because IBM keeps issuing CSDs for it, so this way C-Kermit gets
# the TCP/IP fixes automatically without having to be rebuilt.  Also, dynamic
# linking keeps the size of the .EXE down.
#
# -G4 optimizes for the i486 pipeline.  It might make the program run a bit
# faster on 486 and above, but it also increases the size of .EXE by about
# 30K.  The result still runs OK on i386 processors.
# Add -G4 to the CC= line below if you want i486 optimization.
#
# msgbind does not use any environment variables to find DDE4.MSG.  Therefore,
# its path (on the system where you are building C-Kermit) must be edited into
# CKOKER.MSB, or the DDE4.MSG file must be copied into the current directory.
# It is normally found in IBMCPP\HELP.

# release version
ibmc:
	$(MAKE) -f ckoker.mak all \
	CC="icc -q -Sm -Gm -Gt" OUT="-Fe" O=".obj" \
	OPT="-O" DEBUG="-Gs" DLL="-Gs" \
	CFLAGS="-Sp1 -D__STDC__" LDFLAGS="" \
	DEF="ckoker32.def"
	msgbind ckoker.msb

# profiling version
ibmcp:
	$(MAKE) -f ckoker.mak all \
	CC="icc -q -Sm -Gm -Gt" OUT="-Fe" O=".obj" \
	OPT="-O" DEBUG="-Gs -Gh -Ti" DLL="-Gs" \
	CFLAGS="-Sp1 -D__STDC__" LDFLAGS="dde4xtra.obj" \
	DEF="ckoker32.def"

# debugging version
ibmcd:
	$(MAKE) -f ckoker.mak all \
	CC="icc -q -Sm -Gm -Gt" OUT="-Fe" O=".obj" \
	OPT="" DEBUG="-Ti -D__DEBUG" DLL="-Gs" \
	CFLAGS="-Sp1 -D__STDC__" LDFLAGS="" \
	DEF="ckoker32.def"

# emx 0.8f + gcc 2.3.3 (32-bit)

# release version
gcc:
	$(MAKE) -f ckoker.mak all \
	CC="gcc -Zomf" OUT="-o" O=".obj" \
	OPT="-O" DEBUG="-s" DLL="-Zdll" \
	CFLAGS="" LDFLAGS="" \
	DEF="ckoker32.def"

# debugging version
gccd:
	$(MAKE) -f ckoker.mak all \
	CC="gcc" OUT="-o" O=".o" \
	OPT="" DEBUG="-g" DLL="-Zdll" \
	CFLAGS="" LDFLAGS="" \
	DEF="ckoker32.def"

#---------- Macros:

# To build with TCP/IP support, if you have the TCP/IP libraries and
# and header files, comment out the following DEFINES line and then uncomment
# two commented lines after it:
DEFINES = -DOS2 -DDYNAMIC -DNETCONN -DDECNET
# DEFINES = -DOS2 -DDYNAMIC -DNETCONN -DDECNET -DTCPSOCKET -DTCPIBM
# LIBS = tcpipdll.lib

#---------- Inference rules:

.SUFFIXES: .w .c $(O)

.c$(O):
	$(CC) $(CFLAGS) $(DEBUG) $(OPT) $(DEFINES) -c $*.c

#---------- Targets:

OBJS =	ckcmai$(O) ckcfns$(O) ckcfn2$(O) ckcfn3$(O) ckcpro$(O) \
        ckuxla$(O) ckucmd$(O) ckuusr$(O) ckuus2$(O) ckuus3$(O) \
        ckuus4$(O) ckuus5$(O) ckuus6$(O) ckuus7$(O) ckuusx$(O) \
	ckuusy$(O) ckudia$(O) ckuscr$(O) ckufio$(O) ckocon$(O) \
        ckotio$(O) ckonet$(O) ckcnet$(O)

all: ckoker.exe ckotcp.dll

ckoker.exe: $(OBJS) $(DEF)
	$(CC) $(DEBUG) $(OBJS) $(DEF) $(OUT) $@ $(LIBS) $(LDFLAGS)

ckotcp.dll: ckotcp.c ckotcp.def
	$(CC) $(DLL) $(OUT) $@ ckotcp.c ckotcp.def

ckwart.exe: ckwart$(O) $(DEF)
	$(CC) $(DEBUG) ckwart$(O) $(DEF) $(OUT) $@ $(LIBS) $(LDFLAGS)

#---------- Dependencies:

ckcmai$(O):	ckcmai.c ckcker.h ckcdeb.h ckcasc.h ckcsym.h ckcnet.h
ckcfns$(O):	ckcfns.c ckcker.h ckcdeb.h ckcasc.h ckcsym.h ckcxla.h ckuxla.h
ckcfn2$(O):	ckcfn2.c ckcker.h ckcdeb.h ckcasc.h ckcsym.h ckcxla.h ckuxla.h
ckcfn3$(O):	ckcfn3.c ckcker.h ckcdeb.h ckcasc.h ckcsym.h ckcxla.h ckuxla.h
ckcpro$(O):	ckcpro.c ckcker.h ckcdeb.h ckcasc.h
ckuxla$(O):	ckuxla.c ckcker.h ckcdeb.h ckcxla.h ckuxla.h
ckucmd$(O):	ckucmd.c ckcker.h ckcdeb.h ckcasc.h ckucmd.h
	$(CC) $(CFLAGS) $(DEBUG) $(DEFINES) -c $*.c
ckudia$(O):	ckudia.c ckcker.h ckcdeb.h ckcasc.h ckucmd.h
	$(CC) $(CFLAGS) $(DEBUG) $(DEFINES) -c $*.c
ckuscr$(O):	ckuscr.c ckcker.h ckcdeb.h ckcasc.h
ckuusr$(O):	ckuusr.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h \
		  ckcxla.h ckuxla.h ckcnet.h
ckuus2$(O):	ckuus2.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h \
		  ckcxla.h ckuxla.h
ckuus3$(O):	ckuus3.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h \
		  ckcxla.h ckuxla.h ckcnet.h
ckuus4$(O):	ckuus4.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h \
		  ckcxla.h ckuxla.h ckuver.h ckcnet.h
ckuus5$(O):	ckuus5.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h
ckuus6$(O):	ckuus6.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h
ckuus7$(O):	ckuus7.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h ckucmd.h \
		  ckcxla.h ckuxla.h ckcnet.h
ckuusx$(O):	ckuusx.c ckcker.h ckcdeb.h ckcasc.h ckuusr.h
ckuusy$(O):	ckuusy.c ckcker.h ckcdeb.h ckcasc.h
ckufio$(O):	ckufio.c ckcker.h ckcdeb.h ckuver.h ckodir.h ckoker.h
ckocon$(O):	ckocon.c ckcker.h ckcdeb.h ckcasc.h ckoker.h
ckotio$(O):	ckotio.c ckcker.h ckcdeb.h ckuver.h ckodir.h ckoker.h
ckonet$(O):	ckonet.c ckcker.h ckcdeb.h ckoker.h ckcnet.h ckonet.h
	$(CC) $(CFLAGS) $(DEBUG) $(DEFINES) -c $*.c
ckcnet$(O):	ckcnet.c ckcker.h ckcdeb.h ckcnet.h ckonet.h

ckcpro.c:	ckcpro.w
		$(MAKE) -f ckoker.mak ckwart.exe \
		  CC="$(CC)" OUT="$(OUT)" O="$(O)" OPT="$(OPT)" \
		  DEBUG="$(DEBUG)" CFLAGS="$(CFLAGS)" LDFLAGS="$(LDFLAGS)"
		ckwart ckcpro.w ckcpro.c
