char *ckonetv = "OS/2 Network support, 5A(009) 06 May 93";

/*  C K O N E T  --  Network support  */
/*
  Copyright (C) 1985, 1992, Trustees of Columbia University in the City of New
  York.  Permission is granted to any individual or institution to use this
  software as long as it is not sold for profit.  This copyright notice must be
  retained.  This software may not be included in commercial products without
  written permission of Columbia University.
*/

/* Currently supported network services:

 - DECnet LAT
 - TCP/IP Telnet

 */

#include "ckcdeb.h"
#include "ckcker.h"
#include "ckcnet.h"
#include "ckuusr.h"

#include <io.h>
#include <fcntl.h>
#include <string.h>

extern int ttnproto, tt_type;
extern char *tn_term;

#ifndef NETCONN
/*
  Network support not defined.
  Dummy functions here in case #ifdef's forgotten elsewhere.
*/
int					/* Open network connection */
os2_netopen(name, lcl, nett) char *name; int *lcl, nett; {
    return(-1);
}
int					/* Close network connection */
os2_netclos() {
    return(-1);
}
int					/* Check network input buffer */
os2_nettchk() {
    return(-1);
}
int					/* Flush network input buffer */
os2_netflui() {
    return(-1);
}
int					/* Send network BREAK */
os2_netbreak() {
    return(-1);
}
int					/* Input character from network */
os2_netinc(timo) int timo; {
}
int					/* Output character to network */
os2_nettoc(c) int c; {
    return(-1);
}
int
os2_nettol(s,n) char *s; int n; {
    return(-1);
}

#else /* NETCONN is defined (rest of this module...) */

#ifndef __32BIT__
#define far _far
#define near _near
#define pascal _pascal
#endif
#define	INCL_NOPM
#define	INCL_DOSPROCESS
#define	INCL_DOSMODULEMGR
#include <os2.h>

#ifdef DECNET
#ifndef __32BIT__
#define _Far16 _far
#define _Pascal _pascal
#define _Seg16
#endif
#include "ckolat.h"
typedef short (* _Far16 _Pascal LATTYPE)(struct lat_cb * _Seg16);
LATTYPE LATENTRY;
static struct lat_cb lcb;
#endif

extern int duplex, debses, seslog, ttyfd, quiet; /* External variables */
extern int nettype;

/*  N E T O P E N  --  Open a network connection.  */
/*  Returns 0 on success, -1 on failure.  */

/*
  Calling conventions same as ttopen(), except third argument is network
  type rather than modem type.  Designed to be called from within ttopen.
*/

int
os2_netopen(name, lcl, nett) char *name; int *lcl, nett; {

    int rc = -1;

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return netopen(name, lcl, nett);
#endif

#ifdef DECNET
    if ( LATENTRY == NULL )
      return -1;

    ttnproto = NP_LAT;

    printf("Trying connection to %s ... ", name);

    lcb.LatFunction = START_SESSION;
    lcb.BufferSize = strlen(name);
    lcb.BufferPtr = (void * _Seg16) name;

    LATENTRY(&lcb);

    ttyfd = lcb.SessionHandle;
    printf(lcb.LatStatus ? "failed.\n" : "OK.\n");

    rc = (lcb.LatStatus == 0) ? 0 : -1;
#endif

    return rc;
}

/*  N E T C L O S  --  Close current network connection.  */

int
os2_netclos() {
    int x = 0;

    if (ttyfd < 0)			/* Was open? */
      return(0);			/* Wasn't. */

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return netclos();
#endif
    
#ifdef DECNET
    if (ttyfd > -1)			/* Was. */
    {
      lcb.LatFunction = STOP_SESSION;
      lcb.SessionHandle = ttyfd;

      LATENTRY(&lcb);

      x = (lcb.LatStatus == 0) ? 0 : -1;
    }
#endif

    ttyfd = -1;				/* Mark it as closed. */

    return(x);
}

/*  N E T T C H K  --  Check if network up, and how many bytes can be read */
/*
  Returns number of bytes waiting, or -1 if connection has been dropped.
*/
int					/* Check how many bytes are ready */
os2_nettchk() {				/* for reading from network */
#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return nettchk();
#endif
    return(0);
}

/*  N E T T I N C --  Input character from network */

int
os2_netinc(timo) int timo; {

    static char buffer[256];
    static int size = 0, pos = 0;
    int chr = -1;

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) {
      if ( (chr = netinc(timo)) != -1 )
	return chr;
      else
	return (nettchk() == -1) ? -2 : -1;
    }
#endif
    
#ifdef DECNET
    if ( pos < size )
      return buffer[pos++];

    lcb.LatFunction = GET_CHAR_BLK;
    lcb.SessionHandle = ttyfd;
    lcb.BufferSize = sizeof(buffer);
    lcb.BufferPtr = (void * _Seg16) buffer;
    lcb.WaitTime = timo < 0 ? 10L * -timo : 1000L * timo;

    LATENTRY(&lcb);

    if ( (lcb.SessionStatus & 0xFF) == SS_Stopped )
      return -2;
    if ( lcb.LatStatus )
      return -1;

    pos = 0;
    size = lcb.BufferSize;

    chr = buffer[pos++];
#endif

    return chr;
}

/*  N E T T O C  --   Output character to network */
/*
  Call with character to be transmitted.
  Returns 0 if transmission was successful, or
  -1 upon i/o error, or -2 if called improperly.
*/
int
os2_nettoc(c) int c; {

    int rc = -1;

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return nettoc((char) c);
#endif
    
#ifdef DECNET
    lcb.LatFunction = SEND_CHAR;
    lcb.SessionHandle = ttyfd;
    lcb.CharByte = c;

    LATENTRY(&lcb);

    rc = (lcb.LatStatus == 0) ? 0 : -1;
#endif

    return rc;
}

/*  N E T T O L  --  Output a string of bytes to the network  */
/*
  Call with s = pointer to string, n = length.
  Returns number of bytes actuall written on success, or
  -1 on i/o error, -2 if called improperly.
*/
int
os2_nettol(s,n) char *s; int n; {

    int b;

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return nettol(s, n);
#endif
    
    for ( b = 0; b < n; b++, s++ )
      if ( nettoc(*s) )
        break;

    return(b);
}

/*  N E T F L U I  --  Flush network input buffer  */

int
os2_netflui() {
#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return netflui();
#endif
    return(0);
}

/* Send network BREAK */
/*
  Returns -1 on error, 0 if nothing happens, 1 if BREAK sent successfully.
*/
int
os2_netbreak() {

    int rc = -1;

#ifdef TCPSOCKET
    if ( nettype == NET_TCPB ) return netbreak();
#endif
    
#ifdef DECNET
    lcb.LatFunction = SEND_BREAK;
    lcb.SessionHandle = ttyfd;

    LATENTRY(&lcb);

    rc = (lcb.LatStatus == 0) ? 0 : -1;
#endif

    return rc;
}

/*
 * what follows is all dynamic link stuff to let the same executable
 * run on machines with and without networking software
 */

typedef (*function)();

static function LoadProcedure(HMODULE module, char *procedure)
{
    PFN entry;

#ifdef __32BIT__
    if ( DosQueryProcAddr(module, 0, procedure, (PFN *) &entry) )
#else
    if ( DosGetProcAddr(module, procedure, &entry) )
#endif
        return NULL;
    else
        return (function) entry;
}

netinit() {

    char fail[256];
    HMODULE library;

#ifdef DECNET
    if ( DosLoadModule(fail, sizeof(fail), "LATCALLS", &library) == 0 )
      LATENTRY = (LATTYPE) LoadProcedure(library, "LATENTRY");
#endif

#ifdef TCPSOCKET
#ifdef TCPIBM
    sock_init();
#endif

    if (tn_term == NULL)
      if (tt_type == TT_VT52)
	tn_term = strdup("vt52");
      else if (tt_type == TT_VT102)
	tn_term = strdup("vt102");
#endif

    return 1;
}

#endif /* NETCONN */
