! MAKEFILE for VMS C-Kermit 5A (WERMIT) and labeled file decoder (CKVCVT)
!
! Written by Terry Kennedy (tmk), TERRY@SPCVXA.SPC.EDU,
! Saint Peters College, Jersey City, NJ, USA,
! 13-Apr-1991
!
! To be used with the "make" program for VAX/VMS written by Todd Aven, the
! Software Sweatshop, 564 Laurelton Blvd, Long Beach, NY 11561.
! Rename this file to "MAKEFILE." and then simply type "make" to build
! C-Kermit.  The result will be a file, WERMIT.EXE, which you can run by
! typing "run wermit", and which you can rename to KERMIT.EXE or CKERMIT.EXE
! and install in SYS:.  See CKVINS.DOC for further instructions.
!
! Revision history:
!
! 13-Apr-1991 - tmk - Original version
! 21-Jun-1991 - tmk - Make sure executables are properly accessible
! 05-Nov-1991 - fdc - Add ckuus7.c source module
! 19-Jun-1992 - jrs - (James Sturdevant <STURDJ@a1.medtronic.COM>) Add WIN/TCP
! 29-Jun-1992 - fdc - Add CURSES (SMG) support
! 02-Jul-1992 - jrs - Fix WIN/TCP support
! 04-Jul-1992 - tmk - Don't need VAXCCURSE library any more.
! 12-Jul-1992 - tmk - Add localopts.
! 23-Aug-1992 - fdc - Add KANJI support.
! 13-Oct-1992 - jrs - Add changes from Lee Tibbert for Alpha and DEC TCP/IP
! 13-Oct-1992 - fdc - Add ckvioc.[ch] to DEC TCP/IP build
! 07-Dec-1992 - fdc - Remove /list compiler switch
! 26-May-1993 - jrs - Add GCC and TCPware support
!
! Read CKVINS.DOC for instructions.
!
! SITE DEPENDENCIES -
!
! Some site options you might want to add:
!  NOPUSH    - Disallow access to DCL from within Kermit.
!  NODEBUG   - Remove all debugging code to make C-Kermit smaller and faster.
!
! The following site options are used in this file as distributed:
!  DYNAMIC   - Allocate packet and other buffers dynamically.
!  NOJC      - Omit Job-Control related code.
!  NOSETBUF  - Don't make console i/o unbuffered.
!  CK_CURSES - Include fullscreen file transfer display.
!  KANJI     - Include Kanji file transfer translation.
!  IFDEBUG   - Avoid calls to debug() if debugging not on: faster execution
!              but bigger .EXE file.  If you don't need debugging, replace
!              this by NODEBUG.
!
wermit.olb(*):	*.c
	call 'hw_arch'_cc $*

siteopts = /define=("DYNAMIC", "NOJC", "NOSETBUF", "CK_CURSES", "KANJI", \
  "IFDEBUG", "''net_option'", "''cc_ver'", "''vms_ver'")
!
! Compiler and linker options
!
link_switches = /map/full/sym
library_switches = /replace
!cc_switches = /nodebug/optimize
cc_switches = /debug/optimize
!
unconditional_relink = makefile.
!
! Uncomment the next line to force unconditional relinking
!
! unconditional_relink = dummy_target
!
! Define the master target list - these can be rebuilt on any system that
! has VAX C.
!
all :		wermit \
		ckvcvt
!
gkermit :	check_stuff \
		wermit_start \
		gnu_setup \
		gkermit.exe
  write sys$output "Done rebuilding GKERMIT"
!
wermit :	check_stuff \
		wermit_start \
		wermit.exe
  write sys$output "Done rebuilding WERMIT"
!
ckvcvt :	check_stuff \
		ckvcvt_start \
		ckvcvt.exe
  write sys$output "Done rebuilding CKVCVT"
!
gnu_setup :
  hw_arch := "GNU"
!
! And here are the individual targets
!
check_stuff :
  hw_arch := "VAX" ! Assume VAX
  if (f$getsyi("CPU") .eq. 128) ! 128 means "not a VAX"
   then
    hw_arch := "''f$getsyi("Arch_Name")'"
    if ("''hw_arch'" .nes. "Alpha")
     then
     if (f$locate("ALPHA", f$edit("''hw_arch'","UPCASE")) -
	    .lt. f$length("''hw_arch'"))
      then
       hw_arch := "Alpha" ! Treat as Alpha AXP
      else
       write sys$output "Unknown hardware architecture ''hw_arch'"
       exit %x10000004
      endif ! Unknown
    endif ! String not "Alpha"
   endif ! Not VAX

  cc_ver = "VAXC023"
  if f$search("sys$library:fscndef.h") .nes. "" then cc_ver = "VAXC024"
  if f$search("sys$library:ppl$routines.h") .nes. "" then cc_ver = "VAXC030"
  if f$search("sys$library:xabrudef.h") .nes. "" then cc_ver = "VAXC031"
  sys_ver = f$edit(f$getsyi("version"),"compress")
  if f$extract(0,1,sys_ver) .nes. "V"
  then
    type sys$input
    You appear to be running a Field Test version of VMS. This script will $
    assume that the operating system version is at least V5.0. $
    $
    sys_ver = "V5.0"
  endif
  sys_maj = 0+f$extract(1,1,sys_ver)
  sys_min = 0+f$extract(3,1,sys_ver)
  if sys_maj .lt. 5 then if (sys_min/2)*2 .ne. sys_min then \
    sys_min = sys_min - 1
  vms_ver = "VMS_V''sys_maj'''sys_min'"
  if ("''net_option'" .eqs. "")
  then
    net_option = "NONET"
    library_dir = "SYS$LIBRARY"
    if f$search("SYS$LIBRARY:UCX$IPC.OLB") .nes. ""
    then
      net_option = "DEC_TCPIP"
    endif
    if f$search("TCPWARE:UCX$IPC.OLB") .nes. ""
    then
      net_option = "TCPWARE"
      library_dir = "TCPWARE"
    endif
    if f$search("multinet:multinet_socket_library.exe") .nes. "" then \
      net_option = "MULTINET"
    if f$search("TWG$COMMON:[NETDIST.LIB]TWGLIB.OLB") .nes. ""
    then
      net_option = "WINTCP"
      define /nolog vaxc$include twg$tcp:[netdist.include],sys$library
      define /nolog sys twg$tcp:[netdist.include.sys]
    endif
    if f$search("multinet:multinet_socket_library.exe") .nes. "" then \
      net_option = "MULTINET"
  endif  !net_option
  if net_option .eqs. "NONET" then net_name = "no"
  if net_option .eqs. "MULTINET" then net_name = "MultiNet"
  if net_option .eqs. "WINTCP" then net_name = "WIN/TCP"
  if net_option .eqs. "DEC_TCPIP" then \
    net_name = "DEC TCP/IP Services for OpenVMS(tm)"
  if net_option .eqs. "TCPWARE"
  then
    net_name = "Process Software TCPware"
    net_option = "DEC_TCPIP"
  endif
  if sys_maj .lt. 5
  then
    write sys$output "You are running VMS V''sys_ver'."
    type sys$input
    VMS C-Kermit has not been verified to build properly under this version, $
    although pre-built versions will run properly. Please exercise caution $
    until you have verified proper operation. $
    $
  endif
  if cc_ver .nes. "VAXC031"
  then
    type sys$input
    Your system has an older version of the VAX C compiler. VMS C-Kermit was $
    designed to be compiled under VAX C V3.1 or newer. It has not been ver- $
    ified to build properly under this version, although pre-built versions $
    will run properly. Please exercise caution until you have verified proper $
    operation. $
    $
  endif
  VAX_CC: Subroutine
   On Control_Y Then $exit %x10000004
   On Warning Then   $exit $status
   write sys$output "  Compiling ''P1' at ''f$time()"
   cc$(cc_switches)$(siteopts)/obj='P1'.obj 'localopts' 'P1'.c
   library$(library_switches) wermit.olb 'P1'.obj
   delete 'P1'.obj.*
   exit
  EndSubroutine !VAX_CC
  GNU_CC: Subroutine
   On Control_Y Then $exit %x10000004
   On Warning Then   $exit $status
   write sys$output "  Compiling ''P1' at ''f$time()"
   gcc/optimize$(siteopts)/obj='P1'.obj 'P1'.c
   library$(library_switches) wermit.olb 'P1'.obj
   delete 'P1'.obj.*
   exit
  EndSubroutine !VAX_CC
  AXP_CC: Subroutine
   On Control_Y Then $exit %x10000004
   On Warning Then   $exit $status

   write sys$output "  Compiling ''P1' at ''f$time()"
   cc/'debug'/standard='lint_standard'/'optimize' -
	/define=("DEBUG", "TLOG", "DYNAMIC", "CK_CURSES", "IFDEBUG", "KANJI", -
	"''net_option'", "''cc_ver'", "''vms_ver'") 'P1'
   exit
  EndSubroutine !AXP_CC
  axp_cc := "DECC_AXP"	! LT personal value, not DEC value
  if (hw_arch .eqs. "Alpha") then cc_ver = "''axp_cc'"
  !debug  := nodebug
  debug  := debug
  Link_Debug  := nodebug
  ! optimize := optimize=level=0 ! level=0 means NoOptimize
  optimize := optimize=level=4   ! level=4 means greatest optimization
  !lint_standard := ANSI89
  lint_standard := VAXC ! Evil living is its own retribution....
!
wermit_start :
  write sys$output "Rebuilding WERMIT with ''net_name' network support"
  if f$type(localopts) .eqs. "" then localopts = ""
!
ckvcvt_start :
  write sys$output "Rebuilding CKVCVT"
!
dummy_target :
  write sys$output ""
!
germit.olb :	
  if f$search("germit.olb") .eqs. "" then libr/create/object germit.olb
!
wermit.olb :	
  if f$search("wermit.olb") .eqs. "" then libr/create/object wermit.olb
!
wermit.exe : 	wermit.olb(ckvioc) wermit.olb(ckcfn2) \
		wermit.olb(ckcfn3) wermit.olb(ckcfns) wermit.olb(ckcmai) \
		wermit.olb(ckcpro) wermit.olb(ckucmd) wermit.olb(ckudia) \
		wermit.olb(ckuscr) wermit.olb(ckuus2) wermit.olb(ckuus3) \
		wermit.olb(ckuus4) wermit.olb(ckuus5) wermit.olb(ckuus6) \
		wermit.olb(ckuus7) wermit.olb(ckuusr) wermit.olb(ckuusx) \
		wermit.olb(ckuusy) wermit.olb(ckcnet) wermit.olb(ckvfio) \
		wermit.olb(ckvtio) wermit.olb(ckuxla) wermit.olb(ckvcon) \
		$(unconditional_relink)
  write sys$output "  Linking WERMIT at ''f$time()"
  if (hw_arch .eqs. "Alpha")
  then
   link/'link_debug' /exec=wermit.exe -
 	ckcmai, ckcfn2, ckcfn3, ckcfns, ckcpro, ckucmd, ckudia, -
	ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, ckuus6, ckuus7, -
	ckuusr, ckuusx, ckuusy, ckuxla, ckvcon, ckcnet, ckvfio, -
	ckvtio, ckvioc
  else
  if net_option .eqs. "MULTINET"
  then
    link$(link_switches) wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    sys$share:vaxcrtl.olb/library/exec=wermit.exe, sys$input:/options
    multinet:multinet_socket_library.exe/share $
  else
  if net_option .eqs. "WINTCP"
  then
  link/sym wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    twg$common:[netdist.lib]twglib.olb/library, \
    sys$share:vaxcrtl.olb/library/exec=wermit.exe
  else
  if net_option .eqs. "DEC_TCPIP"
  then
  ! No symbol table     -lt.  1992-08-14
  link wermit.olb/exec=wermit.exe/library -
    /include=(ckcfn2, ckcfn3, ckcfns,-
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5,-
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio, ckvioc),-
    'library_dir':ucx$ipc.olb/library, -
    sys$share:vaxcrtl.olb/library
  else
    link$(link_switches) wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    sys$share:vaxcrtl.olb/library/exec=wermit.exe
  endif !DEC TCP or none
  endif !WIN/TCP
  endif !MultiNet
  endif	!Alpha
  set file/protection=(g:re,w:re) wermit.exe
!
gkermit.exe : 	wermit.olb(ckvioc) wermit.olb(ckcfn2) \
		wermit.olb(ckcfn3) wermit.olb(ckcfns) wermit.olb(ckcmai) \
		wermit.olb(ckcpro) wermit.olb(ckucmd) wermit.olb(ckudia) \
		wermit.olb(ckuscr) wermit.olb(ckuus2) wermit.olb(ckuus3) \
		wermit.olb(ckuus4) wermit.olb(ckuus5) wermit.olb(ckuus6) \
		wermit.olb(ckuus7) wermit.olb(ckuusr) wermit.olb(ckuusx) \
		wermit.olb(ckuusy) wermit.olb(ckcnet) wermit.olb(ckvfio) \
		wermit.olb(ckvtio) wermit.olb(ckuxla) wermit.olb(ckvcon) \
		$(unconditional_relink)
  write sys$output "  Linking GKERMIT at ''f$time()"
  if (hw_arch .eqs. "Alpha")
  then
   link/'link_debug' /exec=gkermit.exe -
 	ckcmai, ckcfn2, ckcfn3, ckcfns, ckcpro, ckucmd, ckudia, -
	ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, ckuus6, ckuus7, -
	ckuusr, ckuusx, ckuusy, ckuxla, ckvcon, ckcnet, ckvfio, -
	ckvtio, ckvioc, gnu_cc:[000000]gcclib/lib
  else
  if net_option .eqs. "MULTINET"
  then
    link$(link_switches) wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    gnu_cc:[000000]gcclib/lib, \
    sys$share:vaxcrtl.olb/library/exec=gkermit.exe, sys$input:/options
    multinet:multinet_socket_library.exe/share $
  else
  if net_option .eqs. "WINTCP"
  then
  link/sym wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    twg$common:[netdist.lib]twglib.olb/library, \
    gnu_cc:[000000]gcclib/lib /exec=gkermit.exe
  else
  if net_option .eqs. "DEC_TCPIP"
  then
  ! No symbol table     -lt.  1992-08-14
  link wermit.olb/exec=gkermit.exe/library -
    /include=(ckcfn2, ckcfn3, ckcfns,-
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5,-
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio, ckvioc),-
    'library_dir':ucx$ipc.olb/library, -
    gnu_cc:[000000]gcclib/lib
  else
    link$(link_switches) wermit.olb/library/include=(ckcfn2, ckcfn3, ckcfns, \
    ckcmai, ckcpro, ckucmd, ckudia, ckuscr, ckuus2, ckuus3, ckuus4, ckuus5, \
    ckuus6, ckuus7, ckuusr, ckuxla, ckvcon, ckcnet, ckvfio, ckvtio), \
    gnu_cc:[000000]gcclib/lib/exec=gkermit.exe
  endif !DEC TCP or none
  endif !WIN/TCP
  endif !MultiNet
  endif	!Alpha
  set file/protection=(g:re,w:re) gkermit.exe
!
! First, make sure we have a current CKWART
!
ckwart.exe :		ckwart.c
  write sys$output "  Compiling CKWART at ''f$time()"
  cc$(cc_switches)$(siteopts)/obj=ckwart.obj 'localopts' ckwart.c
  write sys$output "  Linking CKWART at ''f$time()"
  link$(link_switches)/exec=ckwart ckwart.obj, sys$share:vaxcrtl.olb/library
  purge ckwart.obj
!
! Next, see if CKCPRO.C is current
!
ckcpro.c :		ckcpro.w \
			ckwart.exe ckcdeb.h ckcasc.h ckcker.h
  write sys$output "Running CKWART at ''f$time()"
  ckwart = "$" +f$parse("CKWART.EXE",,,"DEVICE") + \
    f$parse("CKWART.EXE",,,"DIRECTORY") + "CKWART"
  ckwart ckcpro.w ckcpro.c
  purge ckcpro.c

wermit.old(ckvioc) :	ckvioc.c ckvioc.h ckcdeb.h

wermit.olb(ckcfn2) :	ckcfn2.c \
			ckcker.h ckcdeb.h ckcsym.h ckcasc.h ckcxla.h ckuxla.h

wermit.olb(ckcfn3) :	ckcfn3.c \
			ckcker.h ckcdeb.h ckcsym.h ckcasc.h ckcxla.h ckuxla.h

wermit.olb(ckcfns) :	ckcfns.c \
			ckcker.h ckcdeb.h ckcsym.h ckcasc.h ckcxla.h ckuxla.h

wermit.olb(ckcmai) :	ckcmai.c \
			ckcker.h ckcdeb.h ckcsym.h ckcasc.h ckcnet.h

wermit.olb(ckcpro) :	ckcpro.c \
			ckcker.h ckcdeb.h ckcasc.h

wermit.olb(ckucmd) :	ckucmd.c \
			ckcasc.h ckucmd.h ckcdeb.h

wermit.olb(ckudia) :	ckudia.c \
			ckcker.h ckcdeb.h ckucmd.h ckcasc.h

wermit.olb(ckuscr) :	ckuscr.c \
			ckcker.h ckcdeb.h ckcasc.h

wermit.olb(ckuus2) :	ckuus2.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcxla.h ckuxla.h \
			ckcasc.h

wermit.olb(ckuus3) :	ckuus3.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcxla.h ckuxla.h \
			ckcasc.h ckcnet.h

wermit.olb(ckuus4) :	ckuus4.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcxla.h ckuxla.h \
			ckcasc.h ckcnet.h

wermit.olb(ckuus5) :	ckuus5.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcasc.h

wermit.olb(ckuus6) :	ckuus6.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcasc.h

wermit.olb(ckuus7) :	ckuus7.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcxla.h ckuxla.h \
			ckcasc.h ckcnet.h

wermit.olb(ckuusr) :	ckuusr.c \
			ckucmd.h ckcker.h ckuusr.h ckcdeb.h ckcxla.h ckuxla.h \
			ckcasc.h ckcnet.h

wermit.olb(ckuusx) :	ckuusx.c \
			ckcker.h ckuusr.h ckcdeb.h ckcasc.h

wermit.olb(ckuusy) :	ckuusy.c \
			ckcker.h ckcdeb.h ckcasc.h

wermit.olb(ckuxla) :	ckuxla.c \
			ckcker.h ckcdeb.h ckcxla.h ckuxla.h

wermit.olb(ckvcon) :	ckvcon.c \
			ckcdeb.h ckcasc.h ckcker.h ckcnet.h ckvvms.h ckcxla.h

wermit.olb(ckcnet) :	ckcnet.c \
			ckcdeb.h ckcker.h ckcnet.h

wermit.olb(ckvfio) :	ckvfio.c \
			ckcdeb.h ckcasc.h ckcker.h ckvvms.h

wermit.olb(ckvtio) :	ckvtio.c \
			ckcdeb.h ckcasc.h ckcker.h ckvvms.h

ckvcvt.exe :		ckvcvt.c
  write sys$output "  Compiling CKVCVT at ''f$time()"
  cc$(cc_switches)$(siteopts)/obj=ckvcvt.obj 'localopts' ckvcvt.c
  write sys$output "  Linking CKVCVT at ''f$time()"
  link$(link_switches)/exec=ckvcvt ckvcvt.obj, sys$share:vaxcrtl.olb/library
  set file/protection=(g:re,w:re) ckvcvt.exe
  purge ckvcvt.obj
!
! All done...
