$! CKVOLD.COM - Build C-Kermit 5A on VMS 4.5.
$! 
$! This is DCL procedure builds C-Kermit on VMS systems that have TGV
$! MultiNet TCP/IP support.  It also works on systems that do not have TGV
$! MultiNet.  However, if you have a system with MultiNet installed, but
$! you want to build C-Kermit without MultiNet support, you must define
$! NET_OPT to be NONET before running this procedure.  See additional comments
$! at the bottom.
$!
$! Meanwhile, this procedure needs a lot of work:
$!
$! 1. Remove dependencies on disk and directory names like $DUA0: and
$!    [C-KERMIT] (why are they there anyway?).
$! 2. Make all lines less than 80 characters long.
$! 3. Find some better way to link with the MultiNet shared library.
$! 4. Make better use of DCL to eliminate redundant sections.
$! 5. The system() call can no longer be used as an excuse for having
$!    a separate section for pre-2.4 versions of VAX C (C-Kermit no longer
$!    calls the system() function).
$! 6. Surprises when you change options and run this program again but the
$!    options don't change because CC_OPTIONS is left behind from last time...
$! etc etc etc.
$! 
$	SAVE_VERIFY = F$VERIFY(0'CKVKER_VERIFY')
$!	ON CONTROL_Y THEN GOTO ABNORMAL_EXIT
$	ON WARNING THEN GOTO ABNORMAL_EXIT
$!
$	delete = "delete"
$       define = "define"
$	define/nolog c$include sys$disk:[],dua0:[c-kermit]
$	tmp = f$envirement("procedure")
$	ckv_proc_loc = "c$include:"
$	define/nolog 'ckv_proc_loc' 'f$parse(tmp,,,"DEVICE")' + -
			 'f$parse(tmp,,,"DIRECTORY")' + -
			"dua0:[c-kermit]"
$	if p1 .nes. "BATCH" then goto interactive
$	f = f$search("''ckv_proc_loc'CKVKER.COM")
$	if f .eqs. "" then goto interactive
$	name = 	f$parse(f,,,"name")
$	log_file = F$PARSE(name + ".LOG")
$	com_file = ckv_proc_loc + name + ".COM"
$	submit/keep/noprint/log='log_file' 'com_file'-
		/para=("''f$environment("default")'",-
		"''p2'","''p3'","''p4'","''p5'","''p6'","''p7'","''p8'")
$	write sys$output "Submitting file ''com_file'"
$	exit
$interactive:
$	if f$mode() .nes. "BATCH" then goto no_batch
$! running in batch
$	if p1 .eqs. "" then goto no_batch	! 25Oct90 - wb
$	if p1 .eqs. "" then exit
$	set def 'p1'
$no_batch:
$!
$	define/nolog cms$lib dua0:[c-kermit]
$	ckv_build_class == "V5A"
$	vms_version = f$edit(f$getsyi("version"),"COMPRESS")
$	vms_version = "VMS_V" + f$extract(1,1,vms_version) -
		+ f$extract(3,1,vms_version)
$	objlib = "wermit"
$	alternate = ""
$	vckd_disk = "dua1:"
$	vckd_library = "''vckd_disk'[sys0.syslib]"
$	vckd_vaxc = "''vckd_disk'[sys0.sysexe]vaxc.exe"
$	vckd_linker = "''vckd_disk'[sys0.sysexe]linker.exe"
$!
$	if p3 .nes. "ALTERNATE" then goto no_alternate_build
$	alternate = "_v4"
$	vms_version = "VMS_V46"
$	define vaxc 'vckd_vaxc'
$	define linker 'vckd_linker'
$	define sys$library 'vckd_library'
$	objlib = objlib + alternate
$no_alternate_build:
$	if vms_version .eqs. "VMS_V41" then vms_version = "VMS_V40"
$	if vms_version .eqs. "VMS_V43" then vms_version = "VMS_V42"
$	if vms_version .eqs. "VMS_V45" then vms_version = "VMS_V44"
$	if vms_version .eqs. "VMS_V47" then vms_version = "VMS_V46"
$	if vms_version .eqs. "VMS_V51" then vms_version = "VMS_V50"
$!
$! Define command to be used in conditionally compiling C sources.
$!
$	IF "''CCMAKE'" .EQS. "" THEN CCMAKE = "@''ckv_proc_loc'CKVMAK.COM"
$!
$! Look for MultiNet runtime library.
$!
$!	IF "''NET_OPT'" .NES. "" THEN GOTO GET_CC_VER
$	NET_OPT = "NONET"
$	IF F$SEARCH("MULTINET:MULTINET_SOCKET_LIBRARY.EXE") .NES. "" THEN -
		NET_OPT = "MULTINET"
$GET_CC_VER:
$WRITE SYS$OUTPUT "Building C-Kermit 5A, ",NET_OPT," version."
$!
$! Determine which version of the C compiler is being used,
$! and define version-specific stuff.
$!
$	CC_VER_OPTS = "/DEFINE=(""DEBUG"",""TLOG"",""DYNAMIC"",""VAXC030"",""''NET_OPT'"",""''VMS_VERSION'"",""CK_CURSES"")"
$!	WRITE SYS$OUTPUT "CC_VER_OPTS = ",CC_VER_OPTS
$	C_LIBRARY = "SYS$LIBRARY:VAXCRTL.OLB"		!V3 lib
$	IF F$SEARCH("SYS$LIBRARY:VAXCPAR.OLB") .NES. "" THEN GOTO FOUND_LIB
$!
$! For V2.0 - V2.3 we will create a symbol VAXC023.  For V2.4 the symbol
$! is VAXC024.  This seperation is needed as between V2.3 and V2.4 of VAXC,
$! the function system() was added.  (NOTE: it was added to V4.6 in CRTL but
$! uVMS systems would not get that so we are putting all V2.3 versions of C
$! under the same hat - no system() call.
$!
$	VAXC_VERSION = "VAXC023"
$	IF F$SEARCH("SYS$LIBRARY:FSCNDEF.H") .NES. "" THEN -
		VAXC_VERSION = "VAXC024"
$	CC_VER_OPTS = "/DEFINE=(""DEBUG"",""TLOG"",""DYNAMIC"",""''NET_OPT'"",""''VAXC_VERSION'"",""''VMS_VERSION'"",""CK_CURSES"")"
$	WRITE SYS$OUTPUT "CC_VER_OPTS = ",CC_VER_OPTS
$	C_LIBRARY = "SYS$LIBRARY:VAXCRTL.OLB"		!V2 lib
$	IF F$SEARCH(C_LIBRARY) .NES. "" THEN GOTO FOUND_LIB
$!
$	CC_VER_OPTS = ""				!V1 options
$	WRITE SYS$OUTPUT "CC_VER_OPTS = ",CC_VER_OPTS
$	C_LIBRARY = "SYS$LIBRARY:CRTLIB.OLB"		!V1 lib
$	IF F$SEARCH(C_LIBRARY) .NES. "" THEN GOTO FOUND_LIB
$!
$	WRITE SYS$OUTPUT "Unable to locate C Run-Time Library."
$	GOTO ABNORMAL_EXIT
$FOUND_LIB:
$	WRITE SYS$OUTPUT "Using ",C_LIBRARY," as the C Run-Time Library."
$!
$! Define CC options to be used, if not explicitly supplied.
$!
$	IF f$type(CC_OPTIONS) .EQS. "" -
	  THEN CC_OPTIONS == "/DEBUG=TRACE/OPTIMIZE/NOLIST" + CC_VER_OPTS ! 4/10/91 wb changed to /nolist
$	if f$type(cc_options) .nes. "" -
	  then cc_options == f$edit(cc_options,"upcase")
$	WRITE SYS$OUTPUT "Using CC options: ",CC_OPTIONS,"."
$!
$! VMS specific files first
$!
$	CCMAKE CKVCON.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKCNET.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKVTIO.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKVOLD.C "" 'CC_OPTIONS' 'objlib' ! 4/10/91 wb
$	CCMAKE CKVFIO.C "" 'CC_OPTIONS' 'objlib'
$!
$	CCMAKE CKCFN2.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKCFN3.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKCFNS.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKCMAI.C "" 'CC_OPTIONS' 'objlib'
$!
$	ckv_wart_present = (f$search("ckcpro.w") .nes. "")
$	if .not. ckv_wart_present then -
		cms fet/nohist/nolog ckcpro.w/gen='ckv_build_class' ""
$	IF F$SEARCH("CKWART''alternate'.EXE") .EQS. ""	THEN GOTO DO_WART
$!	IF F$SEARCH("CKCPRO.C") .EQS. ""	THEN GOTO DO_WART
$!	IF F$SEARCH("CKCPRO.OBJ") .EQS. ""	THEN GOTO DO_WART
$	if f$search("ckwart''alternate'.olb") .eqs. "" then -
		libr/cre/obj ckwart'alternate'.olb
$!	library/ext=ckcpro/output=ckcpro.obj ckwart'alternate'
$!	SRC_TIME = F$FILE_ATTRIBUTES("CKCPRO.W", "CDT") ! get creation time
$!	OUT_TIME = F$FILE_ATTRIBUTES("CKCPRO.OBJ", "CDT") ! for both files.
$!	IF F$CVTIME(SRC_TIME) .GES. F$CVTIME(OUT_TIME) THEN GOTO DO_WART
$	@'ckv_proc_loc'ckvcdt ckcpro.w 'objlib' ckv$flag
$	if ckv$flag then goto do_wart
$!	delete ckcpro.obj;
$	WRITE SYS$OUTPUT "CKCPRO.OBJ", " is up to date."
$	GOTO DONE_WART
$DO_WART:
$	IF F$SEARCH("CKWART''alternate'.EXE") .NES. "" THEN GOTO GOT_WART
$	CCMAKE CKWART.C "" 'CC_OPTIONS' ckwart'alternate'
$	WRITE SYS$OUTPUT "Linking WART..."
$	LINK/EXECUTABLE=CKWART'alternate'/MAP=ckwart'alternate' -
	  ckwart'alternate'/lib/include=(CKWART),'C_LIBRARY'/LIBRARY
$GOT_WART:
$	WRITE SYS$OUTPUT "Executing WART..."
$	WART = "$SYS$DISK:[]CKWART''alternate'"
$	WART CKCPRO.W CKCPRO.C
$	CCMAKE CKCPRO.C "" 'CC_OPTIONS' 'objlib'
$	if .NOT. ckv_wart_present .and. f$search("ckcpro.w") .nes. "" then -
		delete ckcpro.w;*
$!	delete ckcpro.c;*
$DONE_WART:
$!
$	CCMAKE CKUCMD.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUDIA.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUSCR.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS2.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS3.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS4.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS5.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS6.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUS7.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUSR.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUSX.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUUSY.C "" 'CC_OPTIONS' 'objlib'
$	CCMAKE CKUXLA.C "" 'CC_OPTIONS' 'objlib'
$	IF "''NET_OPT'" .EQS. "MULTINET" THEN GOTO LINK_TGV
$	WRITE SYS$OUTPUT "Linking WERMIT..."
$	LINK'p2'/MAP=wermit'alternate'/sym/EXECUTABLE=WERMIT'alternate' -
	  'objlib'/library -
		/include=( -
			CKCFN2,-
			CKCFN3,-
			CKCFNS,-
			CKCMAI,-
			CKCPRO,-
			CKUCMD,-
			CKUDIA,-
	  		CKUSCR,-
			CKUUS2,-
			CKUUS3,-
			CKUUS4,-
			CKUUS5,-
			CKUUS6,-
			CKUUS7,-
			CKUUSR,-
			CKUXLA,-
			CKVCON,-
			CKCNET,-
			CKVFIO,-
			CKVOLD,- ! 4/10/91 wb
			CKVTIO), -
- !	  SYS$LIBRARY:VAXCCURSES/LIBRARY, - ! 7/2/92 wb
	  'C_LIBRARY'/LIBRARY
$	GOTO NORMAL_EXIT
$LINK_TGV:
$! Somebody who knows something about VMS please improve this.
$! In order to link Kermit with the MultiNet runtime library,
$! the /SHARE qualifier must be used.  But /SHARE cannot be specified
$! on the LINK command line, so it must be put into an options file.
$! So here we call upon CKVKER.OPT to do the linking.  However, when
$! LINK is invoked in this way, it refuses to do the linking because
$! "%LINK-F-FIRSTMOD, first input file being a library requires module
$! extraction".  So here we yank CKCMAI.OBJ back out of the library
$! and then call LINK with the options file.
$!
$! The options file looks like this:
$!
$! CKCMAI
$! WERMIT.OLB/LIBRARY/INCLUDE=(CKCFN2,CKCFN3,CKCFNS,CKCPRO,-
$! CKUCMD,CKUDIA,CKUSCR,CKUUS2,CKUUS3,CKUUSR,CKUXLA,CKVCON,CKCNET,CKVFIO,-
$! CKVTIO)
$! SYS$LIBRARY:VAXCRTL.OLB /LIBRARY
$! MULTINET:MULTINET_SOCKET_LIBRARY.EXE /SHARE
$! 
$	WRITE SYS$OUTPUT "Linking with MultiNet"
$	IF F$SEARCH("CKCMAI.OBJ") .NES. "" THEN GOTO DO_LINK_TGV
$! Borrow CKCMAI.OBJ from the library...
$	LIBRARY /EXTRACT=CKCMAI /OUTPUT=CKCMAI.OBJ WERMIT.OLB
$	LIBRARY /DELETE=CKCMAI WERMIT.OLB
$DO_LINK_TGV:
$	LINK /EXECUTABLE=WERMIT.EXE CKVKER /OPT
$! Now return CKCMAI.OBJ to the library.
$!	LIBRARY /INSERT=CKCMAI.OBJ;0 WERMIT.OLB
$!	DELETE CKCMAI.OBJ;*
$	GOTO NORMAL_EXIT
$!
$! Abnormal exit.
$!
$ABNORMAL_EXIT:
$	STATUS = $STATUS			!save failure status
$	IF STATUS THEN STATUS = "%X08000002"	!force error if neccessary
$	GOTO EXIT
$!
$! Normal exit.
$!
$NORMAL_EXIT:
$	STATUS = $STATUS			!save success status
$!
$! Exit.
$!
$EXIT:
$	if f$trnlnm("cms$lib","lnm$process") then deassign cms$lib
$	if f$trnlnm("sys$library","lnm$process") .nes. "" then -
		deassign sys$library
$	if f$trnlnm("linker","lnm$process") .nes. "" then deassign linker
$	if f$trnlnm("vaxc","lnm$process") .nes. "" then deassign vaxc
$	EXIT ('STATUS' .OR. %X10000000) + F$VERIFY(SAVE_VERIFY) * 0
$!
$! CKVKER.COM	2.0 (004) 9-Apr-1991
$!
$! Build C-Kermit 5A.
$!
$! Note: this command file implements a very limited "make" capability.
$! If you change CKWART.C, you must delete CKWART.EXE.
$! If you change any header files, you must delete all .OBJ files.
$!
$! IF YOU HAVE TROUBLE COMPILING OR RUNNING SOME OF THE GENERATED CODE,
$! TRY COMPILING WITHOUT OPTIMIZATION.
$!
$! input:
$!	CKVKER_VERIFY	If defined and positive, causes verification
$!			of this command file.
$!	CC_OPTIONS	Optional list of qualifiers for use when compiling
$!			(e.g., "/list/debug=all", "/define=xxx", etc.).
$!			Remember to enclose symbol names, etc. in quotes
$!			so that DCL won't convert them to uppercase.
$!	NET_OPT		If defined, overrides this file's automatic selection
$!			selection of network support.
$!
$!	@ckvker	[batch] [link_qual] [alternate]
$!
$!	@ckvker	"BATCH" "/DEBUG" "ALTERNATE"
$!		Will build wermit in batch, with the image linked
$!		with the debugger for V4
$!
$!	@ckvker	"BATCH"
$!		Will build wermit in batch without the debugger
$!		for current version.
$!
$! Modifications:
$!
$!	12-Feb-89	Add C V3 support.
$!				MAB
$!
$!	25-Jun-85	Allow external specification of CC options, and
$!			provide some defaults.
$!							-- Dan Schullman
$!
$!	24-Jun-85	Automatically determine C Run-Time library to use.
$!			Save and restore verification, and exit on errors.
$!			Display additional "progress" information.
$!			Avoid use of LNK$LIBRARY in case user had it defined.
$!			Use CCMAKE to compile CKCPRO and CKWART.
$!							-- Dan Schullman
$!  DEC/CMS REPLACEMENT HISTORY, Element CKVKER.COM
$!  *14    8-APR-1991 19:48:00 fdc  "Add CKCNET and MultiNet support"
$!  *13   10-MAY-1990 09:11:25 BUDA "Add CKUXLA to link command"
$!  *12    9-MAY-1990 22:20:31 BUDA "Add V5A support"
$!  *11   29-AUG-1989 00:35:35 BUDA "Add version code"
$!  *10   23-APR-1989 20:41:46 BUDA "Do not delete CKCPRO.C"
$!  *9    23-APR-1989 17:23:10 BUDA "Dont compile CKCPRO.W unless date change"
$!  *8    17-APR-1989 00:46:19 BUDA "Fix where output files go"
$!  *7    17-APR-1989 00:32:52 BUDA "Fix where log file is placed"
$!  *6    16-APR-1989 22:59:36 BUDA "Find alternate location"
$!  *5    16-APR-1989 17:55:23 BUDA "General clean up"
$!  *4    11-APR-1989 23:40:08 BUDA "Fix build class"
$!  *3    11-APR-1989 23:32:32 BUDA "Automatically find called procedures"
$!  *2    11-APR-1989 23:25:07 BUDA "Add CMS support"
$!  *1    11-APR-1989 22:56:11 BUDA "Initial creation"
$!  DEC/CMS REPLACEMENT HISTORY, Element CKVKER.COM
