# CKIKER.MAK, Version 5A(165), Tue Jan 21 20:52:00 1991
#
# This is a makefile for C Kermit using Amiga Aztec C V5.n.  The lint
# line is for Gimpel FlexeLint, a commercial product.
#
# -wo here makes pointer-int conversions a warning instead of an error,
# and is needed if you use prototypes for the Kermit functions.  In
# particular, the last argument of debug() is specified as an int, but
# actual calls often put a pointer there.  (Is there an ANSI-approved
# way to find the numerical equivalent of a pointer value?)
#
# The optimization is set to so, which turns on full optimization.
# As of 5A(157), the data had finally become too big for the small
# data model, so we are forced to large, but only if DYNAMIC is
# not defined.  The DYNAMIC #define causes C Kermit's send and
# receive values to be allocated at run time, and is recommended.
# If DYNAMIC is used, small model can also be used.
#
# There is a bit of code now in which is specific to Version 2.0
# of the AmigaOS, (Kickstart version 37.nnn), and more will undoubtedly
# be added.  To use this code, add "-DV37=1" to the CFLAGS line.
# Doing this WILL result in a version of Kermit which will CRASH YOUR
# SYSTEM if run under 1.3 or earlier.

CC = cc

OPTS = -DAMIGA -DDYNAMIC -DCK_ANSILIBS -DCK_ANSIC -DNODIAL -DMYCURSES

CFLAGS = $(OPTS) -so -wo

LFLAGS =

#
#  All the object files needed to compile C Kermit.
#

OBJS = ckcmai.o ckucmd.o ckuusr.o ckuus2.o ckuus3.o ckuus4.o ckuus5.o \
                 ckuus6.o ckuus7.o ckuusx.o ckuusy.o \
		 ckcpro.o ckcfns.o ckcfn2.o ckcfn3.o ckuxla.o ckicon.o \
		 ckitio.o ckifio.o ckistu.o ckiutl.o \
		 ckcmdb.o

#
# The corresponding sources, used mainly to run lint.
#

SRCS = ckcmai.c ckucmd.c ckuusr.c ckuus2.c ckuus3.c ckuus4.c ckuus5.c \
		 ckuus6.c ckuus7.c ckuusx.c ckuusy.c \
		 ckcpro.c ckcfns.c ckcfn2.c ckcfn3.c ckuxla.c ckicon.c \
		 ckitio.c ckifio.c ckistu.c ckiutl.c

#
# These are prototype files.  You can generate them by saying "make ckipro.h"
#

PROS = ckcmai.pro ckucmd.pro ckuusr.pro ckuus2.pro ckuus3.pro ckuus4.pro ckuus5.pro \
		 ckcpro.pro ckcfns.pro ckcfn2.pro ckcfn3.pro ckuxla.pro ckicon.pro \
		 ckitio.pro ckifio.pro ckistu.pro ckiutl.pro

#
# Aztec C rule for generating a prototype file from a C source file.
#

.c.pro:
	cc $(CFLAGS) -qp $*.c


kermit:    $(OBJS)
	ln $(LFLAGS) -o kermit $(OBJS) -lm -lc

ckcpro.o: ckcpro.w wart
	wart ckcpro.w ckcpro.c
	cc $(CFLAGS) -o ckcpro.o ckcpro.c

wart: ckwart.o
	ln -o wart ckwart.o -lc

lint: $(SRCS)
	lint $(OPTS) $(SRCS)

ckipro.h: $(PROS)
	join $(PROS) as ckipro.h


TAGS: $(SRCS)
	-delete TAGS
	ctags $(SRCS)

clean:
	-delete $(OBJS) kermit wermit wart

#
# Special rules for the Amiga-specific files
#
ckifio.o:	ckifio.c
	cc $(CFLAGS) -hi functions.pre ckifio.c

ckitio.o:	ckitio.c
	cc $(CFLAGS) -hi functions.pre ckitio.c

ckiutl.o:	ckiutl.c
	cc $(CFLAGS) -hi functions.pre ckiutl.c

ckicon.o:	ckicon.c
	cc $(CFLAGS) -hi functions.pre ckicon.c
