/* B.CPP */

#include <conio.h>
#include <dos.h>
#include <stdlib.h>

class OB
{
private:

  int dx;
  int dy;

  int sx;
  int sy;

protected:

  int x;
  int y;

  virtual void set(int x, int y)=0;
  virtual void clr(int x, int y)=0;

public:

  void mov(const int XMAX, const int YMAX);

  OB(int obx, int oby, int obdx, int obdy, int sizex, int sizey)
  {
    x=obx; y=oby;
    dx=obdx; dy=obdy;
    sx=sizex; sy=sizey;
  }
};

void OB::mov(const int XMAX, const int YMAX)
{
  clr(x,y);
  x+=dx;
  y+=dy;
  if ((dx>0) && ((x+sx)>XMAX))
  {
    x-=dx;
    x-=dx;
    dx *= -1;
  }
  if ((dx<0) && ((x-sx)<=0))
  {
    x-=dx;
    x-=dx;
    dx *= -1;
  }
  if ((dy>0) && ((y+sx)>YMAX))
  {
    y-=dy;
    y-=dy;
    dy *= -1;
  }
  if ((dy<0) && ((y-sy)<=0))
  {
    y-=dy;
    y-=dy;
    dy *= -1;
  }
  set(x,y);
}

class BALL : public OB
{
private:

  int col;
  int chr;

protected:

  virtual void set(int x, int y);
  virtual void clr(int x, int y);

public:

  BALL(int x1, int y1, int dx, int dy, int color, int character)
  : OB(x1,y1,dx,dy,0,0)
    { col=color; chr=character; }
  BALL(const int xmax, const int ymax, int character)
  : OB(random(xmax)+1,random(ymax)+1,random(1)?1:-1,random(1)?1:-1,0,0)
    { col=random(16); chr='#'; }
};

void BALL::set(int x,int y)
{
  gotoxy(x,y);
  textcolor(col);
  cprintf("%c",chr);
}

void BALL::clr(int x,int y)
{
  gotoxy(x,y);
  cprintf("%c",' ');
}

class BOX : public OB
{
private:

  int col;
  int chr;

protected:

  virtual void set(int x, int y);
  virtual void clr(int x, int y);

public:

  BOX(int x1, int y1, int dx, int dy, int color, int character)
  : OB(x1,y1,dx,dy,1,1)
    { col=color; chr=character; }
  BOX(const int xmax, const int ymax, int character)
  : OB(random(xmax-2)+1,random(ymax-2)+1,random(1)?1:-1,random(1)?1:-1,1,1)
    { col=random(16); chr=character; }
};

void BOX::set(int x, int y)
{
  gotoxy(x-1,y-1);
  textcolor(col);
  cprintf("%c%c%c",chr,chr,chr);
  gotoxy(x-1,y);
  cprintf("%c",chr);
  gotoxy(x+1,y);
  cprintf("%c",chr);
  gotoxy(x-1,y+1);
  cprintf("%c%c%c",chr,chr,chr);
}

void BOX::clr(int x,int y)
{
  gotoxy(x-1,y-1);
  cprintf("   ");
  gotoxy(x-1,y);
  cprintf(" ");
  gotoxy(x+1,y);
  cprintf(" ");
  gotoxy(x-1,y+1);
  cprintf("   ");
}

const int XMAX=30;
const int YMAX=17;

void main(void)
{
  clrscr();

  randomize();
  BALL* b1=new BALL(XMAX,YMAX,'+');
  BALL* b2= new BALL(XMAX,YMAX,'+');
  BOX* b3= new BOX(XMAX,YMAX,'#');

  OB* ob[3] = {b1,b2,b3};
  do
  {
    for (int i=0; i<3; i++)
      ob[i]->mov(XMAX,YMAX);
    delay(100);
  }
  while (!kbhit());
}