/* B3.CPP */

#include <time.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <mem.h>

enum OBtyp
{
  BALLtyp=1,
  BOXtyp=2
};

struct PT
{
  int x;
  int y;
  PT() {x=0; y=0; }
  PT(int x, int y) {PT::x=x; PT::y=y; }
};

struct AR
{
  PT ul;
  PT lr;
  AR(int xmin, int ymin, int xmax, int ymax)
    {ul.x=xmin;ul.y=ymin;lr.x=xmax;lr.y=ymax;}
  AR(PT ul, PT lr) {AR::ul=ul;AR::lr=lr;}
  AR() {ul.x=0;ul.y=0;lr.x=0;lr.y=0;}
};

class OB
{
private:

  int dx;
  int dy;

  int sx;
  int sy;

protected:

  OBtyp typ;

  int x;
  int y;

  virtual void set(PT p)=0;
  virtual void clr(PT p)=0;

public:

  int who() { return typ; }
  PT where() { return PT(x,y); }

  void play(AR a);

  OB(PT ob, PT obd, PT size)
  {
    x=ob.x; y=ob.y;
    dx=obd.x; dy=obd.y;
    sx=size.x; sy=size.y;
  }
};

void OB::play(AR a)
{
  clr(PT(x,y));
  x+=dx;
  y+=dy;
  if ((dx>0) && ((x+sx)>a.lr.x))
  {
    x-=dx;
    x-=dx;
    dx *= -1;
  }
  if ((dx<0) && ((x-sx)<a.ul.x))
  {
    x-=dx;
    x-=dx;
    dx *= -1;
  }
  if ((dy>0) && ((y+sx)>a.lr.y))
  {
    y-=dy;
    y-=dy;
    dy *= -1;
  }
  if ((dy<0) && ((y-sy)<a.ul.y))
  {
    y-=dy;
    y-=dy;
    dy *= -1;
  }
  set(PT(x,y));
}

class BALL : public OB
{
private:

  int col;
  int chr;

protected:

  virtual void set(PT p);
  virtual void clr(PT p);

public:

  BALL(PT p, PT d, int character)
  : OB(p,d,PT(0,0))
    { col=random(15)+1; chr=character; typ=BALLtyp; }
};

void BALL::set(PT p)
{
  gotoxy(p.x,p.y);
  textcolor(col);
  cprintf("%c",chr);
}

void BALL::clr(PT p)
{
  gotoxy(p.x,p.y);
  cprintf("%c",' ');
}

class BOX : public OB
{
private:

  int col;
  int chr;

protected:

  virtual void set(PT p);
  virtual void clr(PT p);

public:

  BOX(PT p, PT d, int character)
  : OB(p, d, PT(1,1))
    { col=random(15)+1; chr=character; typ=BOXtyp; }
};

void BOX::set(PT p)
{
  gotoxy(p.x-1,p.y-1);
  textcolor(col);
  cprintf("%c%c%c",chr,chr,chr);
  gotoxy(p.x-1,p.y);
  cprintf("%c",chr);
  gotoxy(p.x+1,p.y);
  cprintf("%c",chr);
  gotoxy(p.x-1,p.y+1);
  cprintf("%c%c%c",chr,chr,chr);
}

void BOX::clr(PT p)
{
  gotoxy(p.x-1,p.y-1);
  cprintf("   ");
  gotoxy(p.x-1,p.y);
  cprintf(" ");
  gotoxy(p.x+1,p.y);
  cprintf(" ");
  gotoxy(p.x-1,p.y+1);
  cprintf("   ");
}

const int MAX=20;

class GAME
{
  OB *ob[MAX+1];
  AR a;
  int size;
  char *w;

public:

  GAME(AR a);
  void ins(OB *ob);
  int play();
  PT getranpos()
    { return
      PT(random(a.lr.x-a.ul.x)+a.ul.x+1,random(a.lr.y-a.ul.y)+a.ul.y+1);
    }
  PT getrandir()
    {
      return PT(random(2)?1:-1,random(2)?1:-1);
    }
};

GAME::GAME(AR a)
{
  for (int i=0; i<=MAX; i++)
    ob[i]=NULL;
  GAME::a=a;
  w=new char[80*25];
}

void GAME::ins(OB *o)
{
  int i=0;
  while (ob[i])
    i++;
  ob[i]=o;
}

int GAME::play()
{
  int i=0;
  memset(w,0,80*25);
  while (ob[i])
  {
    ob[i]->play(a);
    PT p=ob[i]->where();
    int ind=(p.y-1)*80+p.x-1;
    switch (*(w+ind))
    {
    case BOXtyp:
      if (ob[i]->who()==BALLtyp)
        return 1;
      break;
    case BALLtyp:
      if (ob[i]->who()==BOXtyp)
        return 0;
      break;
    default:
      *(w+ind)=ob[i]->who();
    }
    i++;
  }
  delay(50);
  return 0;
}

void main(void)
{
  clrscr();

  randomize();

  GAME g(AR(PT(1,1),PT(20,20)));
  for (int i=0; i<5; i++)
  {
    OB* b;
    if (i%2)
      b=new BALL(g.getranpos(),g.getrandir(),'+');
    else
      b=new BOX(g.getranpos(),g.getrandir(),'#');
    g.ins(b);
  }

  do
  {
    if (g.play()) return;
  }
  while (!kbhit());
}
