#include "fig.h"

void rechteck(int x0, int y0, int x1, int y1)
{
  linie(x0,y0,x1,y0);
  linie(x1,y0,x1,y1);
  linie(x1,y1,x0,y1);
  linie(x0,y1,x0,y0);
}

void dreieck(int x0, int y0, int x1, int y1, int x2, int y2)
{
  linie(x0,y0,x1,y1);
  linie(x1,y1,x2,y2);
  linie(x2,y2,x0,y0);
}

void figur(struct FIG f)
{
  switch (f.typ)
  {
  case RECHTECK:
    rechteck(f.x0,f.y0,f.x1,f.y1);
    break;
  case DREIECK:
    dreieck(f.x0,f.y0,f.x1,f.y1,f.x2,f.y2);
    break;
  case LINIE:
    linie(f.x0,f.y0,f.x1,f.y1);
    break;
  }
}

