#include "scr1.h"
#include "lst8.h"

class FIGUR;
extern tLIST<FIGUR> fLIST;

class FIGUR
{
public:

  FIGUR() { fLIST.ins_tail(this); }
  virtual PUNKT nord() { return PUNKT(0,0); }
  virtual PUNKT sued() { return PUNKT(0,0); }
  virtual PUNKT ost() { return PUNKT(0,0); }
  virtual PUNKT west() { return PUNKT(0,0); }
  virtual PUNKT nost() { return PUNKT(0,0); }
  virtual PUNKT sost() { return PUNKT(0,0); }
  virtual void draw() {};
  virtual void move (int,int) {}
};

class LINIE : public FIGUR
{
  PUNKT w,o;

public:

  PUNKT nord()
    { return PUNKT((w.x+o.x)/2,o.y<w.y?w.y:o.y); }
  PUNKT sued()
    { return PUNKT((w.x+o.x)/2,o.y<w.y?o.y:w.y); }
  void move(int a, int b)
    { w.x += a; w.y += b; o.x += a; o.y += b; }
  void draw()
    { linie(w,o); }
  LINIE(PUNKT a, PUNKT b)
    { w=a; o=b; }
  LINIE(PUNKT a, int l)
    { w = PUNKT(a.x+l-1,a.y); o=a; }
};

class RECHTECK : public FIGUR
{
  PUNKT sw, no;

public:

  PUNKT nord()
    { return PUNKT((sw.x+no.x)/2,no.y); }
  PUNKT sued()
    { return PUNKT((sw.x+no.x)/2,sw.y); }
  PUNKT nost()
    { return no; }
  PUNKT swest() { return sw; }
  void move(int a, int b)
    { sw.x+=a; sw.y+=b; no.x+=a; no.y+=b; }
  void draw();
  RECHTECK(PUNKT,PUNKT);
};
