/*
 * LSTF.C
 * ======
 * Eine Figurenliste
 */

#include <malloc.h>
#include <stdio.h>
#include "fig.h"

typedef struct FIG OBJ;

struct ELEM
{
  OBJ o;
  struct ELEM *nxt;
};

struct ELEM *list = NULL;

void lst_ins_head(OBJ o)
{
  if (list)
  {
    struct ELEM *pold = list->nxt;
    list->nxt = (struct ELEM *)malloc(sizeof(struct ELEM));
    list->nxt->o = o;
    list->nxt->nxt = pold;
  }
  else
  {
    list = (struct ELEM *)malloc(sizeof(struct ELEM));
    list->o = o;
    list->nxt = list;
  }
}

void lst_ins_tail(OBJ o)
{
  if (list)
  {
    struct ELEM *pold = list->nxt;
    list->nxt = (struct ELEM *)malloc(sizeof(struct ELEM));
    list->nxt->o = o;
    list->nxt->nxt = pold;
    list=list->nxt;
  }
  else
  {
    list = (struct ELEM *)malloc(sizeof(struct ELEM));
    list->o = o;
    list->nxt = list;
  }
}

OBJ lst_get_head(void)
{
  OBJ o;

  if (list)
  {
    if (list->nxt == list)
    {
      o=list->o;
      free(list);
      list = NULL;
    }
    else
    {
      struct ELEM *second = list->nxt->nxt;
      o = list->nxt->o;
      free(list->nxt);
      list->nxt = second;
    }
  }
  else
  {
    printf("Leere Liste\n");
  }
  return o;
}

void lst_clear(void)
{
  struct ELEM *e = list->nxt;

  while (e!=list)
  {
    struct ELEM *ee = e;
    e = e->nxt;
    free(ee);
  }
  free(list);
  list = NULL;
}

