#include "scr.h"

enum FARBE
{
  C_BLACK = '*',
  C_WHITE = ' '
};

char screen[XMAX][YMAX];

void screen_init(void)
{
  int x,y;

  for (y=0; y<YMAX; y++)
    for (x=0; x<XMAX; x++)
      screen[x][y] = C_WHITE;
}

int on_screen(int x, int y)
{
  return 0<=x && x<XMAX && 0<=y && y<YMAX;
}

void punkt(int x, int y)
{
  if (on_screen(x,y))
    screen[x][y] = C_BLACK;
}

void linie(int x0, int y0, int x1, int y1)
{
  int zwei_a;
  int zwei_b;
  int xkrit;

  register dx = 1;
  register dy = 1;
  int a = x1-x0;
  int b = y1-y0;
  register eps = 0;

  if (a<0)
    dx=-1, a= -a;
  if (b<0)
    dy=-1, b= -b;
  zwei_a = 2*a;
  zwei_b = 2*b;
  xkrit = -b+zwei_a;

  for (;;)
  {
    punkt(x0,y0);
    if (x0==x1 && y0==y1) break;
    if (eps <= xkrit) x0+=dx, eps+=zwei_b;
    if (eps>=a || a<=b) y0+=dy, eps-=zwei_a;
  }
}

void screen_refresh(void)
{
  int x,y;

  for (y=0; y<YMAX; y++)
  {
    for (x=0; x<XMAX; x++)
      cprintf("%c",screen[x][y]);
    cprintf("\n\r");
  }
}

