// CONOBJ.CPP

#include <object.h>
#include <iostream.h>

#define MYOBJECT 256

class _CLASSTYPE intObject : public Object 
{
private:

  int val;

protected:

  int           get() 
                { return (val); }

public:

  int           Object(int v)
                { val=v; }

  int           Object(intObject& o)
                { val=o.get(); }


  virtual
  hashValueType hashValue() const
                { return (val); }
  virtual
  classType     isA() const
                { return (classType)(MYOBJECT); }
  virtual
  int           isEqual(const Object _FAR & testObject) const
                { return val == ((intObject&)testObject).get(); }
  virtual
  char _FAR *   nameOf() const
                { return ("myObject"); }
  virtual
  void          printOn(ostream _FAR & outputStream) const
                { outputStream << val; }
};

void main(void)
{
  intObject m1(5);
  intObject m2(6);
  intObject m3(5);
  cout << m1 << endl;
  cout << m1.isA() << endl;
  cout << m1.nameOf() << endl;
  cout << "m1==m2 "  << m1.isEqual(m2) << endl;
  cout << "m1==m3 "  << m1.isEqual(m3) << endl;
}
