// LSTC_1.CPP

#include <list.h>
#include <string.h>
#include <object.h>
#include <iostream.h>

#define MYOBJECT 256

typedef struct
{
  char name[20];
  char tele[20];
} PERSON;

class _CLASSTYPE Person : public Object
{
private:

  PERSON p;

protected:

  PERSON&         get()
                  { return p; }
public:

                  Person(PERSON& o)
                  { memcpy((void*)(&this->p),(void*)(&p),sizeof(PERSON)); }

                  Person(char *name, char *tele)
                  { strcpy(p.name,name); strcpy(p.tele,tele); }

  virtual
  hashValueType   hashValue() const
                  { return p.name[0]; }
  virtual
  classType       isA() const
                  { return (classType)(MYOBJECT); }
  virtual
  int             isEqual(const Object _FAR & testObject) const
                  { return strcmp(((Person&)testObject).get().name,p.name) +
                           strcmp(((Person&)testObject).get().tele,p.tele); }
  virtual
  char _FAR *     nameOf() const
                  { return ("Person"); }
  virtual
  void            printOn(ostream _FAR & outputStream) const
                  { outputStream << p.name << " " << p.tele; }
};

void main(void)
{
  Person franz("FRANZ","0222-67-67-2");
  Person julius("JULIUS","022-37-12-23-34");

  cout << franz << endl;
  cout << julius << endl;

  cout << franz.isA() << endl;
  cout << franz.nameOf() << endl;
  switch (franz.isEqual(julius))
  {
  case -1:
    cout << "franz < julius" << endl;
    break;
  case 0:
    cout << "franz==julius" << endl;
    break;
  case 1:
    cout << "franz > julius" << endl;
    break;
  }
  cin.get();

  List slist;

  slist.add(franz);
  slist.add(julius);

  ListIterator it(slist);

  while (it.operator int())
  {
    Person s = (Person&)it.current();
    cout << s << endl;
    it++;
  }
  cout << "\n";
  cin.get();
}

