// OW03.CPP

#include <stdio.h>   WMPaint
#include <string.h>

#define WIN31
#include <owl.h>

class TMyWindow : public TWindow
{
public:
  TMyWindow
  (
    PTWindowsObject AParent,
    LPSTR ATitle
  ) : TWindow (AParent, ATitle)
  {
  }

  virtual void WMLButtonDown(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONDOWN]
  {
    HDC DC;
    char S[100];

    sprintf(S,"(%d,%d)",Msg.LP.Lo,Msg.LP.Hi);
    DC = GetDC(HWindow);
    TextOut(DC,Msg.LP.Lo,Msg.LP.Hi,S,strlen(S));
    ReleaseDC(HWindow,DC);
  }

  virtual void Paint(HDC DC, PAINTSTRUCT& Paintinfo)
  {
    char S[100];

    sprintf(S,"Begrungstext");
    DC = GetDC(HWindow);
    TextOut(DC,50,50,S,strlen(S));
    ReleaseDC(HWindow,DC);
  }

};


class MyApp : public TApplication
{
public:
  MyApp
  (
    LPSTR AName,
    HANDLE hInstance,
    HANDLE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow
  ) : TApplication
      (
        AName,
        hInstance,
        hPrevInstance,
        lpCmdLine,
        nCmdShow
      )
  {}

  virtual void InitMainWindow()
  {
    MainWindow = new TMyWindow (NULL,Name);
  }

  BOOL CanClose()
  {
    return MessageBox
    (
      MainWindow->HWindow,
      "Wollen Sie wirklich aufhren?",
      "Verabschiedung",
      MB_YESNO | MB_ICONQUESTION
    ) == IDYES;
  }
  
  virtual void InitInstance()
  {
    TApplication::InitInstance();

    HDC DC;
    char S[100];

    sprintf(S,"Begrungstext");
    DC = GetDC(MainWindow->HWindow);
    TextOut(DC,100,100,S,strlen(S));
    ReleaseDC(MainWindow->HWindow,DC);
  }

};


int PASCAL WinMain
(
  HANDLE hInstance,
  HANDLE hPrevInstance,
  LPSTR lpCmdLine,
  int nCmdShow)
{
  MyApp *a= new MyApp
  (
    "Hello",
    hInstance,
    hPrevInstance,
    lpCmdLine,
    nCmdShow
  );
  a->Run();
  return a->Status;
}
