//OW04.CPP

#include <stdio.h>   WMPaint
#include <string.h>

#define WIN31
#include <owl.h>

#include <listimp.h>

class TMyWindow : public TWindow
{

  struct Pt
  {
    int x;
    int y;
    Pt(int x1, int y1) {x=x1; y=y1;}
    Pt() {x=0; y=0;}
    int operator!=(Pt p) { return !(p.x==x && p.y==y); }
    int operator==(Pt p) { return (p.x==x && p.y==y); }
  };

  BI_ListImp<Pt> Points;

public:
  TMyWindow
  (
    PTWindowsObject AParent,
    LPSTR ATitle
  )
  : TWindow (AParent, ATitle)
  {
    Points.add(Pt(0,0));
  }

  virtual void WMLButtonDown(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONDOWN]
  {
    HDC DC;
    char S[10];

    sprintf(S,"(%d,%d)",Msg.LP.Lo,Msg.LP.Hi);
    DC = GetDC(HWindow);
    TextOut(DC,Msg.LP.Lo,Msg.LP.Hi,S,strlen(S));
    Points.add(Pt(Msg.LP.Lo,Msg.LP.Hi));
    ReleaseDC(HWindow,DC);
  }

  virtual void Paint(HDC DC, PAINTSTRUCT& Paintinfo)
  {
    char S[20];

    sprintf(S,"Begrungstext");
    DC = GetDC(HWindow);
    TextOut(DC,50,50,S,strlen(S));

    BI_ListIteratorImp<Pt> i(Points);
    Pt p, p0;
    while ((p=i++) != p0)
    {
      sprintf(S,"(%d,%d)",p.x,p.y);
      TextOut(DC,p.x,p.y,S,strlen(S));
    }
    ReleaseDC(HWindow,DC);
  }
};


class MyApp : public TApplication
{
public:
  MyApp
  (
    LPSTR AName,
    HANDLE hInstance,
    HANDLE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow
  ) : TApplication
      (
        AName,
        hInstance,
        hPrevInstance,
        lpCmdLine,
        nCmdShow
      )
  {}

  virtual void InitMainWindow()
  {
    MainWindow = new TMyWindow (NULL,Name);
  }

  BOOL CanClose()
  {
    return MessageBox
    (
      MainWindow->HWindow,
      "Wollen Sie wirklich aufhren?",
      "Verabschiedung",
      MB_YESNO | MB_ICONQUESTION
    ) == IDYES;
  }
  
  virtual void InitInstance()
  {
    TApplication::InitInstance();

    HDC DC;
    char S[20];

    sprintf(S,"Erste Meldung");
    DC = GetDC(MainWindow->HWindow);
    TextOut(DC,100,100,S,strlen(S));
    ReleaseDC(MainWindow->HWindow,DC);
  }

};


int PASCAL WinMain
(
  HANDLE hInstance,
  HANDLE hPrevInstance,
  LPSTR lpCmdLine,
  int nCmdShow)
{
  MyApp *a= new MyApp
  (
    "Hello",
    hInstance,
    hPrevInstance,
    lpCmdLine,
    nCmdShow
  );
  a->Run();
  return a->Status;
}
