// OW2.CPP

#define WIN31
#include <owl.h>
#include <stdio.h>
#include <string.h>   WNDCLASS
#include <listimp.h>
#include <filedial.h>

class TMyWindow : public TWindow
{

  HDC DragDC;
  BOOL ButtonDown;

  struct Pt
  {
    int x;
    int y;
    Pt(int x1, int y1) {x=x1; y=y1;}
    Pt() {x=0; y=0;}
    int operator!=(Pt p) { return !(p.x==x && p.y==y); }
    int operator==(Pt p) { return (p.x==x && p.y==y); }
  };

  BI_ListImp<Pt> Points;

public:
  TMyWindow
  (
    PTWindowsObject AParent,
    LPSTR ATitle
  )
  : TWindow (AParent, ATitle)
  {
    AssignMenu("HAUPTMENU");
    Points.add(Pt(0,0));
    ButtonDown = FALSE;
  }

  virtual void CMFileOpen(RTMessage Msg)
   = [CM_FIRST+101]
  {
     char DateiName[128];
     _fstrcpy(DateiName,"*.*");
     /*
     if (
          GetApplication()->ExecDialog
          (
            new TFileDialog
                (
                  this,
                  SD_FILEOPEN,
                  DateiName
                )
          ) == IDOK
        )
     {}
     */
    MessageBox(HWindow,"Nicht implementiert","File Open",MB_OK);

  }

  virtual void CMFileClose(RTMessage Msg)
   = [CM_FIRST+102]
  {
    MessageBox(HWindow,"Nicht implementiert","File Close",MB_OK);
  }

  virtual void WMMouseMove(RTMessage Msg)
   = [WM_FIRST + WM_MOUSEMOVE]
  {
    if (ButtonDown)
    {
      LineTo(DragDC,Msg.LP.Lo,Msg.LP.Hi);
      Points.add(Pt(Msg.LP.Lo,Msg.LP.Hi));
    }
  }

  virtual void WMLButtonDown(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONDOWN]
  {
    if (!ButtonDown)
    {
      ButtonDown = TRUE;
      DragDC = GetDC(HWindow);
      MoveTo(DragDC,Msg.LP.Lo,Msg.LP.Hi);
      Points.add(Pt(Msg.LP.Lo,Msg.LP.Hi));
    }
  }

  virtual void WMLButtonUp(RTMessage Msg)
   = [WM_FIRST + WM_LBUTTONUP]
  {
    if (ButtonDown)
    {
      ButtonDown = FALSE;
      ReleaseDC(HWindow,DragDC);
    }
  }
  
  virtual void Paint(HDC DC, PAINTSTRUCT& Paintinfo)
  {
    char S[20];

    sprintf(S,"Begrungs Text");
    DC = GetDC(HWindow);
    TextOut(DC,50,50,S,strlen(S));

    BI_ListIteratorImp<Pt> i(Points);
    Pt p, p0;
    while ((p=i++) != p0)
    {
      LineTo(DC,p.x,p.y);
    }
    ReleaseDC(HWindow,DC);
  }

  void GetWindowClass(WNDCLASS& NewWin)
  {
    TWindow::GetWindowClass(NewWin);
    NewWin.hCursor=LoadCursor(0,IDC_CROSS);
    NewWin.hIcon = LoadIcon( 0, IDI_HAND );
//    NewWin.hCursor=LoadCursor(GetApplication()->hInstance,"MEINCURSOR");
//    NewWin.hIcon = LoadIcon( GetApplication()->hInstance, "MEINICON" );

  }
};


class MyApp : public TApplication
{
public:
  MyApp
  (
    LPSTR AName,
    HANDLE hInstance,
    HANDLE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow
  ) : TApplication
      (
        AName,
        hInstance,
        hPrevInstance,
        lpCmdLine,
        nCmdShow
      )
  {
  }

  virtual void InitMainWindow()
  {
    MainWindow = new TMyWindow (NULL,Name);
  }

  BOOL CanClose()
  {
    return MessageBox
    (
      MainWindow->HWindow,
      "Wollen Sie wirklich aufhren?",
      "Verabschiedung",
      MB_YESNO | MB_ICONQUESTION
    ) == IDYES;
  }
};


int PASCAL WinMain
(
  HANDLE hInstance,
  HANDLE hPrevInstance,
  LPSTR lpCmdLine,
  int nCmdShow)
{
  MyApp *a= new MyApp
  (
    "Hello",
    hInstance,
    hPrevInstance,
    lpCmdLine,
    nCmdShow
  );
  a->Run();
  return a->Status;
}
