// TV34.CPP

#include <stdlib.h>
#include <string.h>

#define  Uses_TFileDialog
#define  Uses_TWindow
#define  Uses_TStaticText
#define  Uses_TKeys  // Tastenkodes kbxxx
#define  Uses_TDeskTop
#define  Uses_TStatusDef
#define  Uses_TSubMenu
#define  Uses_TStatusItem
#define  Uses_TMenuBar
#define  Uses_TStatusLine
#define  Uses_TApplication
#include <tv.h>

#define cmOpen       100
#define cmDOS        101
#define cmNewWindow  102

class Hello : public TApplication
{
  char  filename[80];
static  TStatusLine* initStatusLine(TRect r);
static  TMenuBar*    initMenuBar(TRect r);
static  TDeskTop*    initDeskTop(TRect r);

void handleEvent(TEvent& event);

public:
                     Hello();
};

Hello::Hello() :
 TProgInit(Hello::initStatusLine,
	   Hello::initMenuBar,
	   Hello::initDeskTop
	  )
{
  strcpy(filename,"*.*");
}

TDeskTop *Hello::initDeskTop(TRect r)
{
  r.a.y++;
  r.b.y--;
  return new TDeskTop(r);
}

TStatusLine *Hello::initStatusLine(TRect r)
{
  r.a.y = r.b.y - 1;     // move top to 1 line above bottom
  return
  new TStatusLine
     ( r,
      *new TStatusDef( 0, 0xFFFF ) +
      *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
      *new TStatusItem( "~F5~ Zoom", kbF5, cmZoom ) +
      *new TStatusItem( "~Alt-F3~ Close", kbAltF3, cmClose )
     );
}

TMenuBar *Hello::initMenuBar(TRect r)
{
  r.b.y = r.a.y + 1;
  return
  new TMenuBar
  ( r,
    *new TSubMenu("~F~ile",kbAltF) +
    *new TMenuItem( "~O~pen", cmOpen, kbAltO, hcNoContext, "Alt-O" ) +
    newLine() +
    *new TMenuItem( "~D~OS shell", cmDOS, kbAltD, hcNoContext, "Alt-D" ) +
    newLine() +
    *new TMenuItem( "~Q~uit", cmQuit, kbAltQ, hcNoContext, "Alt-Q" ) +

    *new TSubMenu("~W~indow",kbAltW) +
    *new TMenuItem( "~N~ew", cmNewWindow, kbAltN, hcNoContext, "Alt-N" )
  );
}

const char txt[80]="Aktueller Dateiname : ";

void Hello::handleEvent(TEvent& event)
{
  TApplication::handleEvent(event);
  if (event.what == evCommand)
  {
    switch (event.message.command)
    {
    case cmNewWindow:

      TWindow *helloWin = new TWindow(TRect(4,4,20,10),"PGM-NAME",1);
      TRect r = helloWin->getClipRect();
      r.grow(-1,-1);
      char text[200];
      strcpy(text,txt);
      strcat(text,filename);
      TStaticText *i = new TStaticText(r,text);
      deskTop->insert(helloWin);
      helloWin->insert((TStaticText*)i);
      break;

    case cmDOS:

      TApplication::suspend();
      system("cls");
      cout << "Type EXIT to return...";
      system( getenv("COMSPEC") );
      TApplication::resume();
      TGroup::redraw();
      break;

    case cmOpen:

      TFileDialog *file = new TFileDialog
                          (
                            filename,
                            "Open a File",
                            "~N~ame",
                            fdOpenButton,
                            100);
//      file->setData( filename );
      TProgram::deskTop->execView( file );
      file->getData( filename );
      TObject::destroy( file );
      break;

    }
    clearEvent(event);
  }
}

void main(void)
{
  Hello *h = new Hello;
  h->run();
}

