// TV42.CPP

#include <stdio.h>
#include <string.h>

#define  Uses_TCheckBoxes
#define  Uses_TSItem
#define  Uses_TRadioButtons
#define  Uses_TLabel
#define  Uses_TInputLine
#define  Uses_TDialog
#define  Uses_TButton
#define  Uses_TKeys
#define  Uses_TApplication
#include <tv.h>

#define LINE 20

class Generator : public TApplication
{
  struct EinstellDaten
  {
    char Frequenz[LINE];
    char Amplitude[LINE];
    char Offset[LINE];
    ushort Kurve;
    uchar dc;
    uchar mod;
  } *e;

public:
  Generator();

private:
  virtual void handleEvent(TEvent& event);
};

Generator::Generator() :
    TProgInit(Generator::initStatusLine,
              Generator::initMenuBar,
              Generator::initDeskTop
	     )
{
  e = new EinstellDaten;
  strcpy(e->Frequenz,"1000.0");
  strcpy(e->Amplitude,"1.0");
  strcpy(e->Offset,"0.0");
  e->Kurve = 0; // Sinus
  e->dc = 0; // keine Gleichspannung
  e->mod = 0; // keine Modulation
}

void Generator::handleEvent(TEvent& event)
{
  TProgram::handleEvent(event);
  if (event.what == evKeyboard)
  {
    switch (event.keyDown.keyCode)
    {
    case kbAltE:
      TDialog *einstell = new TDialog(TRect(20,6,60,19),"Einstellungen");
      if (einstell)
      {
        TView *p, *q;

        p=new TButton(TRect(15,10,25,12),"~O~K",cmOK,bfDefault);
        einstell->insert(p);
        p = new TButton(TRect(28,10,38,12),"Cancel",cmCancel,bfNormal);
        einstell->insert(p);

        p = new TInputLine(TRect(13,3,22,4),LINE);
        einstell->insert(p);
        q=new TLabel(TRect(2,3,12,4),"~F~requenz",p);
        einstell->insert(q);

        p = new TInputLine(TRect(13,4,22,5),LINE);
        einstell->insert(p);
        q=new TLabel(TRect(2,4,12,5),"~A~mplitude",p);
        einstell->insert(q);

        p = new TInputLine(TRect(13,5,22,6),LINE);
        einstell->insert(p);
        q=new TLabel(TRect(2,5,12,6),"~O~ffset",p);
        einstell->insert(q);

        p = new TRadioButtons(TRect(23,3,38,6),
            new TSItem("~S~inus",
            new TSItem("~D~reieck",
            new TSItem("~R~echteck",0) )));
        einstell->insert(p);
        q=new TLabel(TRect(23,2,38,3),"Kurvenform",p);
        einstell->insert(q);

        p = new TCheckBoxes(TRect(2,7,20,9),
            new TSItem("Offset ~E~in",
            new TSItem("~M~odulator", 0) ));
        einstell->insert(p);

        einstell->setData(e);
        TGroup::execView(einstell);
        einstell->getData(e);
      }
      TObject::destroy(einstell);
      break;
    default:
      return;
    }
    clearEvent(event);
  }
}

void main(void)
{
  Generator *g = new Generator;
  g->run();
}
