// TV5.CPP
/*
  Wenn ein Fenster mit Text zu fllen ist mu die Fenster-
  zeichenfunktion draw() wissen, wie sie den Text in das Fenster
  einzusetzen hat.
  Eine neue Fensterklasse wird geschaffen, die die eingebaute
  draw()-Funktion berldt und in den Innenraum des Fensters
  ein View-Objekt gefllt mit Text einfgt.

  Dieses Programm hat bei Ausfhrung zwei sichtbare Fehler,
  beheben Sie diese.
*/

#define  Uses_TProgram
#define  Uses_TWindow
#define  Uses_TMenuBar
#define  Uses_TMenuItem
#define  Uses_TDeskTop
#define  Uses_TSubMenu
#define  Uses_TStatusLine
#define  Uses_TStatusItem
#define  Uses_TStatusDef
#define  Uses_TKeys
#include <tv.h>
#include <string.h>

const int cmMyWin = 200;

const char *txt[] = {
"Herzliche Gre bei TURBO-VISION!\n",
"Leider ist 'objektorientiert' leichter gesagt als getan;\n",
"insbesondere eine so komplexe Bibliothek ist alles andere\n",
"als leicht zu durchschauen. Beschrnkt man sich auf die\n",
"wichtigsten Funktionen, kann man in etwa 1-2 Arbeitstagen\n",
"BORLAND-kompatible Fenster generieren." };

/* Die Klasse myText ist der Innenraum in einem Fenster
   Wenn man will, da bei einer Fenstervernderung durch den
   Benutzer das Innenleben des Fensters nicht verschwindet,
   mu man zumindest draw() berladen, damit die das Fenster
   beherbergende group wei, wie man das Innenleben neu aufbaut
*/

class myText : public TView
{
public :
   myText( const TRect& Grenzen);
   virtual void draw();
};

/*
   Bei der Konstruktion der Fensters wird growMode wird so
   gesetzt, da der Inhalt einen festen Abstand zu den rechten
   bzw. unteren Rndern des Fensters hat.
   ofFramed ist nicht zwingend, da ohnehin ein default-Wert,
   ofFramed besagt, da immer ein Rahmen zu ziehen ist.
*/
myText::myText( const TRect& Grenzen) : TView(Grenzen)
{
  growMode = gfGrowHiX | gfGrowHiY;   //make size follow that of the window
  options = options | ofFramed;
}

/* draw fllt die Flche von myText mit txt aus
 */
void myText::draw()
{
  ushort color = getColor(0x0301);
  for( int i = 0; i < size.y; i++ )
  {
     TDrawBuffer b;
     b.moveChar( 0, ' ', color, size.x );
     if( txt[i] )
     {
       char s[80];
       strncpy( s, txt[i], size.x );
       s[size.x] = EOS;
       b.moveStr( 0, s, color );
     }
     writeLine( 0, i, size.x, 1, b);
  }
}

/* Die ursprngliche Fensterklasse TWindow
   gengt eigentlich nie.
   Hier wird myWindow von TWindow abgeleitet.
   Der Unterschied zu TWindow ist die Art der Konstruktion.
   Der TWindow-Kontruktor sorgt fr den richtigen Aufbau
   des Fensters mit Rahmen und dem sonstigen Eigenschaften,
   es kommt noch etwas Kode dazu, um das Fenster mit Text zu fllen.
*/

class myWindow : public TWindow
{
public:

  myWindow( const TRect& bounds, const char *aTitle, short aNumber)
  : TWindow( bounds, aTitle, aNumber),
    TWindowInit( myWindow::initFrame )
  {
    TRect r = getClipRect();    // r ist die Fensterflche
    r.grow(-1, -1);             // r wird um die Rnder verkleinert
    insert( new myText(r) );    // der View myText wird in das
                                // Fenster eingesetzt
  }
};

class HELLO : public TProgram
{
public:
                     HELLO();
static  TStatusLine* initStatusLine(TRect r);
static  TMenuBar*    initMenuBar(TRect r);

private:
        void         openHelloWin();
virtual void         handleEvent(TEvent& event);
};

HELLO::HELLO() :
 TProgInit(HELLO::initStatusLine,
	   HELLO::initMenuBar,
	   HELLO::initDeskTop
	  )
{
}

TStatusLine *HELLO::initStatusLine(TRect r)
{
  r.a.y = r.b.y - 1;     // move top to 1 line above bottom
  return
  new TStatusLine
     ( r,
      *new TStatusDef( 0, 0xFFFF ) +
      *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
      *new TStatusItem( "~Alt-F3~ Close", kbAltF3, cmClose )
      );
}

TMenuBar *HELLO::initMenuBar(TRect r)
{
  r.b.y = r.a.y + 1;
  return
  new TMenuBar
     ( r,
      *new TSubMenu("~A~ufgaben",kbAltA) +
      *new TMenuItem( "~H~ello", cmMyWin, kbAltH, hcNoContext, "Alt-H" )
      );
}

void HELLO::handleEvent(TEvent& event)
{
  TProgram::handleEvent(event);
  if (event.what == evCommand)
  {
    switch (event.message.command)
    {
    case cmMyWin:
      openHelloWin();
      break;
    default:
      return;
    }
    clearEvent(event);
  }
}

void HELLO::openHelloWin(void)
{
  TRect r(4,4,20,10);
  myWindow *helloWin = new myWindow(r,"HELLO",1);
  deskTop->insert(helloWin);
}

int main(void)
{
  HELLO *hello = new HELLO;
  hello->run();
  return 0;
}
